/*
 * Decompiled with CFR 0.152.
 */
package play.db;

import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.sql.Connection;
import java.util.Map;
import javax.sql.DataSource;
import play.Configuration;
import play.api.db.PooledDatabase;
import play.db.ConnectionCallable;
import play.db.ConnectionRunnable;
import play.db.DB;
import play.db.Database;

public class DefaultDatabase
implements Database {
    private final play.api.db.Database db;

    public DefaultDatabase(play.api.db.Database database) {
        this.db = database;
    }

    public DefaultDatabase(String string, Configuration configuration) {
        this((play.api.db.Database)new PooledDatabase(string, new play.api.Configuration(configuration.underlying().withFallback((ConfigMergeable)ConfigFactory.defaultReference().getConfig("play.db.prototype")))));
    }

    public DefaultDatabase(String string, Map<String, ? extends Object> map) {
        this((play.api.db.Database)new PooledDatabase(string, new play.api.Configuration(ConfigFactory.parseMap(map).withFallback((ConfigMergeable)ConfigFactory.defaultReference().getConfig("play.db.prototype")))));
    }

    public String getName() {
        return this.db.name();
    }

    public DataSource getDataSource() {
        return this.db.dataSource();
    }

    public String getUrl() {
        return this.db.url();
    }

    public Connection getConnection() {
        return this.db.getConnection();
    }

    public Connection getConnection(boolean bl) {
        return this.db.getConnection(bl);
    }

    public void withConnection(ConnectionRunnable connectionRunnable) {
        this.db.withConnection(DB.connectionFunction(connectionRunnable));
    }

    public <A> A withConnection(ConnectionCallable<A> connectionCallable) {
        return (A)this.db.withConnection(DB.connectionFunction(connectionCallable));
    }

    public void withConnection(boolean bl, ConnectionRunnable connectionRunnable) {
        this.db.withConnection(bl, DB.connectionFunction(connectionRunnable));
    }

    public <A> A withConnection(boolean bl, ConnectionCallable<A> connectionCallable) {
        return (A)this.db.withConnection(bl, DB.connectionFunction(connectionCallable));
    }

    public void withTransaction(ConnectionRunnable connectionRunnable) {
        this.db.withTransaction(DB.connectionFunction(connectionRunnable));
    }

    public <A> A withTransaction(ConnectionCallable<A> connectionCallable) {
        return (A)this.db.withTransaction(DB.connectionFunction(connectionCallable));
    }

    public void shutdown() {
        this.db.shutdown();
    }

    public play.api.db.Database toScala() {
        return this.db;
    }
}

