/*
 * Decompiled with CFR 0.152.
 */
package play.db;

import com.google.common.collect.ImmutableList;
import com.typesafe.config.ConfigException;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import play.api.Configuration;
import play.api.Environment;
import play.api.inject.Binding;
import play.api.inject.Module;
import play.db.ConnectionPool;
import play.db.DBApi;
import play.db.Database;
import play.db.DefaultConnectionPool;
import play.db.DefaultDBApi;
import play.db.NamedDatabase;
import play.db.NamedDatabaseImpl;
import play.libs.Scala;
import scala.collection.Seq;

public final class DBModule
extends Module {
    public Seq<Binding<?>> bindings(Environment environment, Configuration configuration) {
        String string = configuration.underlying().getString("play.db.config");
        String string2 = configuration.underlying().getString("play.db.default");
        ImmutableList.Builder builder = new ImmutableList.Builder();
        builder.add((Object)this.bind(ConnectionPool.class).to(DefaultConnectionPool.class));
        builder.add((Object)this.bind(DBApi.class).to(DefaultDBApi.class));
        try {
            Set set = configuration.underlying().getConfig(string).root().keySet();
            for (String string3 : set) {
                builder.add((Object)this.bind(Database.class).qualifiedWith((Annotation)this.named(string3)).to((Provider)new NamedDatabaseProvider(string3)));
            }
            if (set.contains(string2)) {
                builder.add((Object)this.bind(Database.class).to(this.bind(Database.class).qualifiedWith((Annotation)this.named(string2))));
            }
        }
        catch (ConfigException.Missing missing) {
            // empty catch block
        }
        return Scala.toSeq((List)builder.build());
    }

    private NamedDatabase named(String string) {
        return new NamedDatabaseImpl(string);
    }

    public static class NamedDatabaseProvider
    implements Provider<Database> {
        @Inject
        private DBApi dbApi = null;
        private final String name;

        public NamedDatabaseProvider(String string) {
            this.name = string;
        }

        public Database get() {
            return this.dbApi.getDatabase(this.name);
        }
    }
}

