/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.awt.Frame;
import sbt.ExitCode;
import sbt.Logger;
import sbt.TrapExit;
import sbt.TrapExitSecurityException;
import sbt.TrapExitSecurityManager;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.JavaConversions$;
import scala.collection.Set;
import scala.collection.mutable.StringBuilder;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

public final class TrapExit$ {
    public static final TrapExit$ MODULE$;

    static {
        new TrapExit$();
    }

    public int apply(Function0<BoxedUnit> execute, Logger log) {
        int n;
        log.debug((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting sandboxed run...";
            }
        });
        Set<Thread> originalThreads = this.allThreads();
        ExitCode code = new ExitCode();
        TrapExit.ExitThreadGroup customThreadGroup = new TrapExit.ExitThreadGroup(new TrapExit.ExitHandler(originalThreads, code, log));
        Thread executionThread = new Thread(execute, code, customThreadGroup){
            private final Function0 execute$1;
            private final ExitCode code$1;

            public void run() {
                TrapExit$.MODULE$.sbt$TrapExit$$executeMain$1(this.execute$1, this.code$1);
            }
            {
                this.execute$1 = execute$1;
                this.code$1 = code$1;
                super((ThreadGroup)customThreadGroup$1, "run-main");
            }
        };
        SecurityManager originalSecurityManager = System.getSecurityManager();
        try {
            TrapExitSecurityManager newSecurityManager = new TrapExitSecurityManager(originalSecurityManager, customThreadGroup);
            System.setSecurityManager(newSecurityManager);
            executionThread.start();
            log.debug((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Waiting for threads to exit or System.exit to be called.";
                }
            });
            this.waitForExit(originalThreads, log);
            log.debug((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Interrupting remaining threads (should be all daemons).";
                }
            });
            this.interruptAll(originalThreads);
            log.debug((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Sandboxed run complete..";
                }
            });
            n = BoxesRunTime.unboxToInt((Object)code.value().getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply() {
                    return this.apply$mcI$sp();
                }

                public int apply$mcI$sp() {
                    return 0;
                }
            }));
        }
        catch (InterruptedException interruptedException) {
            n = this.cancel(executionThread, this.allThreads(), log);
        }
        finally {
            System.setSecurityManager(originalSecurityManager);
        }
        return n;
    }

    private int cancel(Thread executionThread, Set<Thread> originalThreads, Logger log) {
        log.warn((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Run canceled.";
            }
        });
        executionThread.interrupt();
        this.sbt$TrapExit$$stopAll(originalThreads);
        return 1;
    }

    private void waitForExit(Set<Thread> originalThreads, Logger log) {
        while (true) {
            BooleanRef daemonsOnly = new BooleanRef(true);
            this.processThreads(originalThreads, (Function1<Thread, BoxedUnit>)new Serializable(log, daemonsOnly){
                public static final long serialVersionUID = 0L;
                private final Logger log$1;
                private final BooleanRef daemonsOnly$1;

                public final void apply(Thread thread) {
                    if (!thread.isDaemon()) {
                        this.daemonsOnly$1.elem = false;
                        TrapExit$.MODULE$.sbt$TrapExit$$waitOnThread(thread, this.log$1);
                    }
                }
                {
                    this.log$1 = log$1;
                    this.daemonsOnly$1 = daemonsOnly$1;
                }
            });
            if (!daemonsOnly.elem) continue;
            return;
        }
    }

    public void sbt$TrapExit$$waitOnThread(Thread thread, Logger log) {
        log.debug((Function0)new Serializable(thread){
            public static final long serialVersionUID = 0L;
            private final Thread thread$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Waiting for thread ").append((Object)this.thread$1.getName()).append((Object)" to exit").toString();
            }
            {
                this.thread$1 = thread$1;
            }
        });
        thread.join();
        log.debug((Function0)new Serializable(thread){
            public static final long serialVersionUID = 0L;
            private final Thread thread$1;

            public final String apply() {
                return new StringBuilder().append((Object)"\tThread ").append((Object)this.thread$1.getName()).append((Object)" exited.").toString();
            }
            {
                this.thread$1 = thread$1;
            }
        });
    }

    public int sbt$TrapExit$$exitCode(Throwable e) {
        return BoxesRunTime.unboxToInt(this.sbt$TrapExit$$withCause(e, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(TrapExitSecurityException exited) {
                return exited.exitCode();
            }
        }, (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Nothing$ apply(Throwable other) {
                throw other;
            }
        }, (Manifest)ManifestFactory$.MODULE$.classType(TrapExitSecurityException.class)));
    }

    public <CauseType extends Throwable, T> T sbt$TrapExit$$withCause(Throwable e, Function1<CauseType, T> withType, Function1<Throwable, T> notType, Manifest<CauseType> mf) {
        while (true) {
            Throwable cause;
            block5: {
                Object object;
                block4: {
                    block3: {
                        Class clazz;
                        if (!(clazz = mf.runtimeClass()).isInstance(e)) break block3;
                        object = withType.apply((Object)e);
                        break block4;
                    }
                    cause = e.getCause();
                    if (cause != null) break block5;
                    object = notType.apply((Object)e);
                }
                return (T)object;
            }
            e = cause;
        }
    }

    private Set<Thread> allThreads() {
        return (Set)JavaConversions$.MODULE$.asScalaSet(Thread.getAllStackTraces().keySet()).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Thread thread) {
                return !TrapExit$.MODULE$.sbt$TrapExit$$isSystemThread(thread);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean sbt$TrapExit$$isSystemThread(Thread t) {
        String name = t.getName();
        if (name.startsWith("AWT-")) {
            if (name.startsWith("AWT-EventQueue")) return false;
            if (!name.startsWith("AWT-Shutdown")) return true;
            return false;
        }
        ThreadGroup group = t.getThreadGroup();
        if (group == null) return false;
        String string = group.getName();
        String string2 = "system";
        if (string != null) {
            if (!string.equals(string2)) return false;
            return true;
        }
        if (string2 == null) return true;
        return false;
    }

    private void processThreads(Set<Thread> ignoreThreads, Function1<Thread, BoxedUnit> process) {
        ((IterableLike)this.allThreads().filter((Function1)new Serializable(ignoreThreads){
            public static final long serialVersionUID = 0L;
            private final Set ignoreThreads$1;

            public final boolean apply(Thread thread) {
                return !this.ignoreThreads$1.contains((Object)thread);
            }
            {
                this.ignoreThreads$1 = ignoreThreads$1;
            }
        })).foreach(process);
    }

    public void sbt$TrapExit$$stopAll(Set<Thread> originalThreads) {
        this.disposeAllFrames();
        this.interruptAll(originalThreads);
    }

    private void disposeAllFrames() {
        Frame[] allFrames = Frame.getFrames();
        if (allFrames.length > 0) {
            Predef$.MODULE$.refArrayOps((Object[])allFrames).foreach((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Frame x$1) {
                    x$1.dispose();
                }
            });
            Thread.sleep(2000L);
        }
    }

    private void interruptAll(Set<Thread> originalThreads) {
        this.processThreads(originalThreads, (Function1<Thread, BoxedUnit>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(Thread thread) {
                TrapExit$.MODULE$.sbt$TrapExit$$safeInterrupt(thread);
            }
        });
    }

    public void sbt$TrapExit$$safeInterrupt(Thread thread) {
        if (!thread.getName().startsWith("AWT-")) {
            thread.setUncaughtExceptionHandler(new TrapExit.TrapInterrupt(thread.getUncaughtExceptionHandler()));
            thread.interrupt();
        }
    }

    public final void sbt$TrapExit$$executeMain$1(Function0 execute$1, ExitCode code$1) {
        try {
            execute$1.apply$mcV$sp();
            return;
        }
        catch (Throwable throwable) {
            code$1.set(1);
            throw throwable;
        }
        catch (TrapExitSecurityException trapExitSecurityException) {
            throw trapExitSecurityException;
        }
    }

    private TrapExit$() {
        MODULE$ = this;
    }
}

