/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.EWMA$;
import akka.cluster.Metric;
import akka.cluster.Metric$;
import akka.cluster.MetricsCollector;
import akka.cluster.NodeMetrics;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\u0001\u0003\u0001\u001d\u00111CS7y\u001b\u0016$(/[2t\u0007>dG.Z2u_JT!a\u0001\u0003\u0002\u000f\rdWo\u001d;fe*\tQ!\u0001\u0003bW.\f7\u0001A\n\u0004\u0001!\u0001\u0002CA\u0005\u000f\u001b\u0005Q!BA\u0006\r\u0003\u0011a\u0017M\\4\u000b\u00035\tAA[1wC&\u0011qB\u0003\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005E\u0011R\"\u0001\u0002\n\u0005M\u0011!\u0001E'fiJL7m]\"pY2,7\r^8s\u0011!)\u0002A!A!\u0002\u00131\u0012aB1eIJ,7o\u001d\t\u0003/ii\u0011\u0001\u0007\u0006\u00033\u0011\tQ!Y2u_JL!a\u0007\r\u0003\u000f\u0005#GM]3tg\"AQ\u0004\u0001B\u0001B\u0003%a$A\u0006eK\u000e\f\u0017PR1di>\u0014\bCA\u0010#\u001b\u0005\u0001#\"A\u0011\u0002\u000bM\u001c\u0017\r\\1\n\u0005\r\u0002#A\u0002#pk\ndW\rC\u0003&\u0001\u0011\u0005a%\u0001\u0004=S:LGO\u0010\u000b\u0004O!J\u0003CA\t\u0001\u0011\u0015)B\u00051\u0001\u0017\u0011\u0015iB\u00051\u0001\u001f\u0011\u0015)\u0003\u0001\"\u0003,)\t9C\u0006C\u0003\u0004U\u0001\u0007Q\u0006\u0005\u0002\u0012]%\u0011qF\u0001\u0002\b\u00072,8\u000f^3s\u0011\u0015)\u0003\u0001\"\u00012)\t9#\u0007C\u00034a\u0001\u0007A'\u0001\u0004tsN$X-\u001c\t\u0003/UJ!A\u000e\r\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\bq\u0001\u0011\r\u0011\"\u0003:\u0003E!WmY1z\r\u0006\u001cGo\u001c:PaRLwN\\\u000b\u0002uA\u0019qd\u000f\u0010\n\u0005q\u0002#\u0001B*p[\u0016DaA\u0010\u0001!\u0002\u0013Q\u0014A\u00053fG\u0006Lh)Y2u_J|\u0005\u000f^5p]\u0002Bq\u0001\u0011\u0001C\u0002\u0013%\u0011)A\u0006nK6|'/_'CK\u0006tW#\u0001\"\u0011\u0005\r3U\"\u0001#\u000b\u0005\u0015S\u0011AC7b]\u0006<W-\\3oi&\u0011q\t\u0012\u0002\r\u001b\u0016lwN]=N1\n+\u0017M\u001c\u0005\u0007\u0013\u0002\u0001\u000b\u0011\u0002\"\u0002\u00195,Wn\u001c:z\u001b\n+\u0017M\u001c\u0011\t\u000f-\u0003!\u0019!C\u0005\u0019\u00069qn]'CK\u0006tW#A'\u0011\u0005\rs\u0015BA(E\u0005Uy\u0005/\u001a:bi&twmU=ti\u0016lW\n\u0017\"fC:Da!\u0015\u0001!\u0002\u0013i\u0015\u0001C8t\u001b\n+\u0017M\u001c\u0011\t\u000bM\u0003A\u0011\u0001+\u0002\rM\fW\u000e\u001d7f)\u0005)\u0006CA\tW\u0013\t9&AA\u0006O_\u0012,W*\u001a;sS\u000e\u001c\b\"B-\u0001\t\u0003Q\u0016aB7fiJL7m]\u000b\u00027B\u0019Al\u00182\u000f\u0005}i\u0016B\u00010!\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001-\u0019\u0002\u0004'\u0016$(B\u00010!!\t\t2-\u0003\u0002e\u0005\t1Q*\u001a;sS\u000eDQA\u001a\u0001\u0005\u0002\u001d\f\u0011c]=ti\u0016lGj\\1e\u0003Z,'/Y4f+\u0005A\u0007cA\u0010jE&\u0011!\u000e\t\u0002\u0007\u001fB$\u0018n\u001c8\t\u000b1\u0004A\u0011A4\u0002\u0015A\u0014xnY3tg>\u00148\u000fC\u0003o\u0001\u0011\u0005q.A\biK\u0006\u0004X*Z7pef,6/Y4f+\u0005\u0001\bCA\"r\u0013\t\u0011HIA\u0006NK6|'/_+tC\u001e,\u0007\"\u0002;\u0001\t\u0003)\u0018\u0001\u00035fCB,6/\u001a3\u0015\u0005!4\b\"B<t\u0001\u0004\u0001\u0018\u0001\u00025fCBDQ!\u001f\u0001\u0005\u0002i\fQ\u0002[3ba\u000e{W.\\5ui\u0016$GC\u00015|\u0011\u00159\b\u00101\u0001q\u0011\u0015i\b\u0001\"\u0001\u007f\u0003\u001dAW-\u00199NCb$\"\u0001[@\t\u000b]d\b\u0019\u00019\t\u000f\u0005\r\u0001\u0001\"\u0011\u0002\u0006\u0005)1\r\\8tKR\u0011\u0011q\u0001\t\u0004?\u0005%\u0011bAA\u0006A\t!QK\\5u\u0001")
public class JmxMetricsCollector
implements MetricsCollector {
    private final Address address;
    private final Some<Object> decayFactorOption;
    private final MemoryMXBean memoryMBean;
    private final OperatingSystemMXBean osMBean;

    private Some<Object> decayFactorOption() {
        return this.decayFactorOption;
    }

    private MemoryMXBean memoryMBean() {
        return this.memoryMBean;
    }

    private OperatingSystemMXBean osMBean() {
        return this.osMBean;
    }

    @Override
    public NodeMetrics sample() {
        return new NodeMetrics(this.address, System.currentTimeMillis(), this.metrics());
    }

    public Set<Metric> metrics() {
        MemoryUsage heap = this.heapMemoryUsage();
        return (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Option[]{this.systemLoadAverage(), this.heapUsed(heap), this.heapCommitted(heap), this.heapMax(heap), this.processors()})).flatten((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Metric> apply(Option<Metric> xo) {
                return Option$.MODULE$.option2Iterable(xo);
            }
        });
    }

    public Option<Metric> systemLoadAverage() {
        return Metric$.MODULE$.create("system-load-average", Predef$.MODULE$.double2Double(this.osMBean().getSystemLoadAverage()), (Option<Object>)None$.MODULE$);
    }

    public Option<Metric> processors() {
        return Metric$.MODULE$.create("processors", Predef$.MODULE$.int2Integer(this.osMBean().getAvailableProcessors()), (Option<Object>)None$.MODULE$);
    }

    public MemoryUsage heapMemoryUsage() {
        return this.memoryMBean().getHeapMemoryUsage();
    }

    public Option<Metric> heapUsed(MemoryUsage heap) {
        return Metric$.MODULE$.create("heap-memory-used", Predef$.MODULE$.long2Long(heap.getUsed()), (Option<Object>)this.decayFactorOption());
    }

    public Option<Metric> heapCommitted(MemoryUsage heap) {
        return Metric$.MODULE$.create("heap-memory-committed", Predef$.MODULE$.long2Long(heap.getCommitted()), (Option<Object>)this.decayFactorOption());
    }

    public Option<Metric> heapMax(MemoryUsage heap) {
        return Metric$.MODULE$.create("heap-memory-max", Predef$.MODULE$.long2Long(heap.getMax()), (Option<Object>)None$.MODULE$);
    }

    @Override
    public void close() {
    }

    public JmxMetricsCollector(Address address, double decayFactor) {
        this.address = address;
        this.decayFactorOption = new Some((Object)BoxesRunTime.boxToDouble((double)decayFactor));
        this.memoryMBean = ManagementFactory.getMemoryMXBean();
        this.osMBean = ManagementFactory.getOperatingSystemMXBean();
    }

    private JmxMetricsCollector(Cluster cluster) {
        this(cluster.selfAddress(), EWMA$.MODULE$.alpha(cluster.settings().MetricsMovingAverageHalfLife(), cluster.settings().MetricsInterval()));
    }

    public JmxMetricsCollector(ActorSystem system) {
        this((Cluster)Cluster$.MODULE$.apply(system));
    }
}

