/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.ConfigurationException;
import akka.actor.ActorRef;
import akka.actor.ActorRefProvider;
import akka.actor.ActorSystem;
import akka.actor.Address;
import akka.actor.Deploy$;
import akka.actor.ExtendedActorSystem;
import akka.actor.Extension;
import akka.actor.Props$;
import akka.actor.ScalaActorRef;
import akka.actor.Scheduler;
import akka.actor.package$;
import akka.cluster.Cluster$;
import akka.cluster.Cluster$InfoLogger$;
import akka.cluster.ClusterActorRefProvider;
import akka.cluster.ClusterDaemon;
import akka.cluster.ClusterEvent;
import akka.cluster.ClusterEvent$InitialStateAsSnapshot$;
import akka.cluster.ClusterJmx;
import akka.cluster.ClusterReadView;
import akka.cluster.ClusterSettings;
import akka.cluster.ClusterUserAction;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GetClusterCoreRef$;
import akka.cluster.UniqueAddress;
import akka.dispatch.MonitorableThreadFactory;
import akka.event.LogSource$;
import akka.event.Logging$;
import akka.event.LoggingAdapter;
import akka.pattern.AskableActorRef$;
import akka.remote.AddressUidExtension;
import akka.remote.AddressUidExtension$;
import akka.remote.DefaultFailureDetectorRegistry;
import akka.remote.FailureDetector;
import akka.remote.FailureDetectorLoader$;
import akka.remote.FailureDetectorRegistry;
import akka.util.Timeout;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.io.Closeable;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\tew!B\u0001\u0003\u0011\u00039\u0011aB\"mkN$XM\u001d\u0006\u0003\u0007\u0011\tqa\u00197vgR,'OC\u0001\u0006\u0003\u0011\t7n[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\t91\t\\;ti\u0016\u00148#B\u0005\r%\t%\u0006CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\rE\u0002\u0014-ai\u0011\u0001\u0006\u0006\u0003+\u0011\tQ!Y2u_JL!a\u0006\u000b\u0003\u0017\u0015CH/\u001a8tS>t\u0017\n\u001a\t\u0003\u0011e1AA\u0003\u0002\u00015M\u0019\u0011\u0004D\u000e\u0011\u0005Ma\u0012BA\u000f\u0015\u0005%)\u0005\u0010^3og&|g\u000e\u0003\u0005 3\t\u0015\r\u0011\"\u0001!\u0003\u0019\u0019\u0018p\u001d;f[V\t\u0011\u0005\u0005\u0002\u0014E%\u00111\u0005\u0006\u0002\u0014\u000bb$XM\u001c3fI\u0006\u001bGo\u001c:TsN$X-\u001c\u0005\tKe\u0011\t\u0011)A\u0005C\u000591/_:uK6\u0004\u0003\"B\u0014\u001a\t\u0003A\u0013A\u0002\u001fj]&$h\b\u0006\u0002\u0019S!)qD\na\u0001C!91&\u0007b\u0001\n\u0003a\u0013\u0001C:fiRLgnZ:\u0016\u00035\u0002\"\u0001\u0003\u0018\n\u0005=\u0012!aD\"mkN$XM]*fiRLgnZ:\t\rEJ\u0002\u0015!\u0003.\u0003%\u0019X\r\u001e;j]\u001e\u001c\b\u0005\u0003\u000543\t\u0007I\u0011\u0001\u00025\u0003E\u0019X\r\u001c4V]&\fX/Z!eIJ,7o]\u000b\u0002kA\u0011\u0001BN\u0005\u0003o\t\u0011Q\"\u00168jcV,\u0017\t\u001a3sKN\u001c\bBB\u001d\u001aA\u0003%Q'\u0001\ntK24WK\\5rk\u0016\fE\r\u001a:fgN\u0004\u0003\"B\u001e\u001a\t\u0003a\u0014aC:fY\u001a\fE\r\u001a:fgN,\u0012!\u0010\t\u0003'yJ!a\u0010\u000b\u0003\u000f\u0005#GM]3tg\")\u0011)\u0007C\u0001\u0005\u0006I1/\u001a7g%>dWm]\u000b\u0002\u0007B\u0019Ai\u0012&\u000f\u00055)\u0015B\u0001$\u000f\u0003\u0019\u0001&/\u001a3fM&\u0011\u0001*\u0013\u0002\u0004'\u0016$(B\u0001$\u000f!\t!5*\u0003\u0002M\u0013\n11\u000b\u001e:j]\u001eDQAT\r\u0005\u0002=\u000bAbZ3u'\u0016dgMU8mKN,\u0012\u0001\u0015\t\u0004#ZSU\"\u0001*\u000b\u0005M#\u0016\u0001B;uS2T\u0011!V\u0001\u0005U\u00064\u0018-\u0003\u0002I%\"9\u0001,\u0007b\u0001\n\u0013I\u0016!D0jgR+'/\\5oCR,G-F\u0001[!\tY\u0006-D\u0001]\u0015\tif,\u0001\u0004bi>l\u0017n\u0019\u0006\u0003?J\u000b!bY8oGV\u0014(/\u001a8u\u0013\t\tGLA\u0007Bi>l\u0017n\u0019\"p_2,\u0017M\u001c\u0005\u0007Gf\u0001\u000b\u0011\u0002.\u0002\u001d}K7\u000fV3s[&t\u0017\r^3eA!9Q-\u0007b\u0001\n\u00131\u0017a\u00017pOV\tq\r\u0005\u0002iW6\t\u0011N\u0003\u0002k\t\u0005)QM^3oi&\u0011A.\u001b\u0002\u000f\u0019><w-\u001b8h\u0003\u0012\f\u0007\u000f^3s\u0011\u0019q\u0017\u0004)A\u0005O\u0006!An\\4!\u0011\u001d\u0001\u0018\u00041A\u0005\nE\f!b\u00197vgR,'OS7y+\u0005\u0011\bcA\u0007tk&\u0011AO\u0004\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005!1\u0018BA<\u0003\u0005)\u0019E.^:uKJTU\u000e\u001f\u0005\bsf\u0001\r\u0011\"\u0003{\u00039\u0019G.^:uKJTU\u000e_0%KF$\"a\u001f@\u0011\u00055a\u0018BA?\u000f\u0005\u0011)f.\u001b;\t\u000f}D\u0018\u0011!a\u0001e\u0006\u0019\u0001\u0010J\u0019\t\u000f\u0005\r\u0011\u0004)Q\u0005e\u0006Y1\r\\;ti\u0016\u0014(*\u001c=!\u0011%\t9!\u0007b\u0001\n\u0003\tI!A\bgC&dWO]3EKR,7\r^8s+\t\tY\u0001E\u0003\u0002\u000e\u0005MQ(\u0004\u0002\u0002\u0010)\u0019\u0011\u0011\u0003\u0003\u0002\rI,Wn\u001c;f\u0013\u0011\t)\"a\u0004\u0003/\u0019\u000b\u0017\u000e\\;sK\u0012+G/Z2u_J\u0014VmZ5tiJL\b\u0002CA\r3\u0001\u0006I!a\u0003\u0002!\u0019\f\u0017\u000e\\;sK\u0012+G/Z2u_J\u0004\u0003BCA\u000f3\t\u0007I\u0011\u0001\u0002\u0002 \u0005I1o\u00195fIVdWM]\u000b\u0003\u0003C\u00012aEA\u0012\u0013\r\t)\u0003\u0006\u0002\n'\u000eDW\rZ;mKJD\u0001\"!\u000b\u001aA\u0003%\u0011\u0011E\u0001\u000bg\u000eDW\rZ;mKJ\u0004\u0003\"CA\u00173\t\u0007I\u0011BA\u0018\u00039\u0019G.^:uKJ$\u0015-Z7p]N,\"!!\r\u0011\u0007M\t\u0019$C\u0002\u00026Q\u0011\u0001\"Q2u_J\u0014VM\u001a\u0005\t\u0003sI\u0002\u0015!\u0003\u00022\u0005y1\r\\;ti\u0016\u0014H)Y3n_:\u001c\b\u0005\u0003\u0006\u0002>e\u0011\r\u0011\"\u0001\u0003\u0003_\t1b\u00197vgR,'oQ8sK\"A\u0011\u0011I\r!\u0002\u0013\t\t$\u0001\u0007dYV\u001cH/\u001a:D_J,\u0007\u0005\u0003\u0006\u0002Fe\u0011\r\u0011\"\u0001\u0003\u0003\u000f\n\u0001B]3bIZKWm^\u000b\u0003\u0003\u0013\u00022\u0001CA&\u0013\r\tiE\u0001\u0002\u0010\u00072,8\u000f^3s%\u0016\fGMV5fo\"A\u0011\u0011K\r!\u0002\u0013\tI%A\u0005sK\u0006$g+[3xA!9\u0011QK\r\u0005\u0002\u0005]\u0013\u0001D5t)\u0016\u0014X.\u001b8bi\u0016$WCAA-!\ri\u00111L\u0005\u0004\u0003;r!a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003CJB\u0011AA2\u0003\u0015\u0019H/\u0019;f+\t\t)\u0007\u0005\u0003\u0002h\u00055db\u0001\u0005\u0002j%\u0019\u00111\u000e\u0002\u0002\u0019\rcWo\u001d;fe\u00163XM\u001c;\n\t\u0005=\u0014\u0011\u000f\u0002\u0014\u0007V\u0014(/\u001a8u\u00072,8\u000f^3s'R\fG/\u001a\u0006\u0004\u0003W\u0012\u0001bBA;3\u0011\u0005\u0011qO\u0001\ngV\u00147o\u0019:jE\u0016$Ra_A=\u0003{B\u0001\"a\u001f\u0002t\u0001\u0007\u0011\u0011G\u0001\u000bgV\u00147o\u0019:jE\u0016\u0014\b\u0002CA@\u0003g\u0002\r!!!\u0002\u0005Q|\u0007#B\u0007\u0002\u0004\u0006\u001d\u0015bAAC\u001d\tQAH]3qK\u0006$X\r\u001a 1\t\u0005%\u00151\u0013\t\u0006\t\u0006-\u0015qR\u0005\u0004\u0003\u001bK%!B\"mCN\u001c\b\u0003BAI\u0003'c\u0001\u0001\u0002\u0007\u0002\u0016\u0006u\u0014\u0011!A\u0001\u0006\u0003\t9JA\u0002`IE\nB!!'\u0002 B\u0019Q\"a'\n\u0007\u0005ueBA\u0004O_RD\u0017N\\4\u0011\u00075\t\t+C\u0002\u0002$:\u00111!\u00118zQ\u0011\t\u0019(a*\u0011\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,\u000f\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003c\u000bYKA\u0004wCJ\f'oZ:\t\u000f\u0005U\u0014\u0004\"\u0001\u00026R910a.\u0002:\u0006\r\u0007\u0002CA>\u0003g\u0003\r!!\r\t\u0011\u0005m\u00161\u0017a\u0001\u0003{\u000b\u0001#\u001b8ji&\fGn\u0015;bi\u0016lu\u000eZ3\u0011\t\u0005\u001d\u0014qX\u0005\u0005\u0003\u0003\f\tH\u0001\u000fTk\n\u001c8M]5qi&|g.\u00138ji&\fGn\u0015;bi\u0016lu\u000eZ3\t\u0011\u0005}\u00141\u0017a\u0001\u0003\u000b\u0004R!DAB\u0003\u000f\u0004D!!3\u0002NB)A)a#\u0002LB!\u0011\u0011SAg\t1\ty-a1\u0002\u0002\u0003\u0005)\u0011AAL\u0005\ryFE\r\u0015\u0005\u0003g\u000b9\u000bC\u0004\u0002Vf!\t!a6\u0002\u0017Ut7/\u001e2tGJL'-\u001a\u000b\u0004w\u0006e\u0007\u0002CA>\u0003'\u0004\r!!\r\t\u000f\u0005U\u0017\u0004\"\u0001\u0002^R)10a8\u0002b\"A\u00111PAn\u0001\u0004\t\t\u0004\u0003\u0005\u0002\u0000\u0005m\u0007\u0019AAra\u0011\t)/!;\u0011\u000b\u0011\u000bY)a:\u0011\t\u0005E\u0015\u0011\u001e\u0003\r\u0003W\f\t/!A\u0001\u0002\u000b\u0005\u0011q\u0013\u0002\u0004?\u0012\u001a\u0004bBAx3\u0011\u0005\u0011\u0011_\u0001\u001baV\u0014G.[:i\u0007V\u0014(/\u001a8u\u00072,8\u000f^3s'R\fG/\u001a\u000b\u0002w\"B\u0011Q^A{\u0003w\fy\u0010E\u0002\u000e\u0003oL1!!?\u000f\u0005)!W\r\u001d:fG\u0006$X\rZ\u0011\u0003\u0003{\f\u0011)V:fAM,g\u000eZ\"veJ,g\u000e^\"mkN$XM]*uCR,\u0007%\u001b8ti\u0016\fG\rI8gAA,(\r\\5tQ\u000e+(O]3oi\u000ecWo\u001d;feN#\u0018\r^3\"\u0005\t\u0005\u0011a\u0001\u001a/g!9!QA\r\u0005\u0002\t\u001d\u0011aF:f]\u0012\u001cUO\u001d:f]R\u001cE.^:uKJ\u001cF/\u0019;f)\rY(\u0011\u0002\u0005\t\u0005\u0017\u0011\u0019\u00011\u0001\u00022\u0005A!/Z2fSZ,'\u000fC\u0004\u0003\u0010e!\tA!\u0005\u0002\t)|\u0017N\u001c\u000b\u0004w\nM\u0001b\u0002B\u000b\u0005\u001b\u0001\r!P\u0001\bC\u0012$'/Z:t\u0011\u001d\u0011I\"\u0007C\u0001\u00057\tQB[8j]N+W\r\u001a(pI\u0016\u001cHcA>\u0003\u001e!A!q\u0004B\f\u0001\u0004\u0011\t#A\u0005tK\u0016$gj\u001c3fgB)!1\u0005B\u0017{5\u0011!Q\u0005\u0006\u0005\u0005O\u0011I#A\u0005j[6,H/\u00192mK*\u0019!1\u0006\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u00030\t\u0015\"aA*fc\"9!1G\r\u0005\u0002\tU\u0012!\u00027fCZ,GcA>\u00038!9!Q\u0003B\u0019\u0001\u0004i\u0004b\u0002B\u001e3\u0011\u0005!QH\u0001\u0005I><h\u000eF\u0002|\u0005\u007fAqA!\u0006\u0003:\u0001\u0007Q\bC\u0004\u0003De!\tA!\u0012\u0002%I,w-[:uKJ|e.T3nE\u0016\u0014X\u000b]\u000b\u0005\u0005\u000f\u0012)\u0006F\u0002|\u0005\u0013B\u0011Ba\u0013\u0003B\u0011\u0005\rA!\u0014\u0002\t\r|G-\u001a\t\u0006\u001b\t=#1K\u0005\u0004\u0005#r!\u0001\u0003\u001fcs:\fW.\u001a \u0011\t\u0005E%Q\u000b\u0003\t\u0005/\u0012\tE1\u0001\u0002\u0018\n\tA\u000bC\u0004\u0003De!\tAa\u0017\u0015\u0007m\u0014i\u0006\u0003\u0005\u0003`\te\u0003\u0019\u0001B1\u0003!\u0019\u0017\r\u001c7cC\u000e\\\u0007\u0003\u0002B2\u0005Sj!A!\u001a\u000b\u0007\t\u001dD+\u0001\u0003mC:<\u0017\u0002\u0002B6\u0005K\u0012\u0001BU;o]\u0006\u0014G.\u001a\u0005\t\u0005_JB\u0011\u0001\u0002\u0002r\u0006A1\u000f[;uI><h\u000eC\u0004\u0003te!I!!=\u0002\u001d\rdwn]3TG\",G-\u001e7fe\u001eA!qO\r\t\u0002\t\u0011I(\u0001\u0006J]\u001a|Gj\\4hKJ\u0004BAa\u001f\u0003~5\t\u0011D\u0002\u0005\u0003\u0000eA\tA\u0001BA\u0005)IeNZ8M_\u001e<WM]\n\u0004\u0005{b\u0001bB\u0014\u0003~\u0011\u0005!Q\u0011\u000b\u0003\u0005sB\u0001B!#\u0003~\u0011\u0005!1R\u0001\bY><\u0017J\u001c4p)\rY(Q\u0012\u0005\b\u0005\u001f\u00139\t1\u0001K\u0003\u001diWm]:bO\u0016D\u0001B!#\u0003~\u0011\u0005!1\u0013\u000b\u0006w\nU%\u0011\u0014\u0005\b\u0005/\u0013\t\n1\u0001K\u0003!!X-\u001c9mCR,\u0007\u0002\u0003BN\u0005#\u0003\r!a(\u0002\t\u0005\u0014x-\r\u0005\t\u0005\u0013\u0013i\b\"\u0001\u0003 R91P!)\u0003$\n\u0015\u0006b\u0002BL\u0005;\u0003\rA\u0013\u0005\t\u00057\u0013i\n1\u0001\u0002 \"A!q\u0015BO\u0001\u0004\ty*\u0001\u0003be\u001e\u0014\u0004cA\n\u0003,&\u0019!Q\u0016\u000b\u0003'\u0015CH/\u001a8tS>t\u0017\n\u001a)s_ZLG-\u001a:\t\r\u001dJA\u0011\u0001BY)\u00059\u0001b\u0002B[\u0013\u0011\u0005#qW\u0001\u0004O\u0016$Hc\u0001\r\u0003:\"9qDa-A\u0002\tm\u0006cA\n\u0003>&\u0019!q\u0018\u000b\u0003\u0017\u0005\u001bGo\u001c:TsN$X-\u001c\u0005\b\u0005\u0007LA\u0011\tBc\u0003\u0019awn\\6vaR\u0011!q\u0019\b\u0003\u0011\u0001AqAa3\n\t\u0003\u0012i-A\bde\u0016\fG/Z#yi\u0016t7/[8o)\rA\"q\u001a\u0005\u0007?\t%\u0007\u0019A\u0011\t\u0015\tM\u0017B1A\u0005\u0006\t\t9&A\rjg\u0006\u001b8/\u001a:u\u0013:4\u0018M]5b]R\u001cXI\\1cY\u0016$\u0007\u0002\u0003Bl\u0013\u0001\u0006i!!\u0017\u00025%\u001c\u0018i]:feRLeN^1sS\u0006tGo]#oC\ndW\r\u001a\u0011")
public class Cluster
implements Extension {
    private final ExtendedActorSystem system;
    private final ClusterSettings settings;
    private final UniqueAddress selfUniqueAddress;
    private final AtomicBoolean _isTerminated;
    private final LoggingAdapter akka$cluster$Cluster$$log;
    private Option<ClusterJmx> clusterJmx;
    private final FailureDetectorRegistry<Address> failureDetector;
    private final Scheduler scheduler;
    private final ActorRef clusterDaemons;
    private final ActorRef clusterCore;
    private final ClusterReadView readView;
    private volatile Cluster$InfoLogger$ InfoLogger$module;

    public static Extension apply(ActorSystem actorSystem) {
        return Cluster$.MODULE$.apply(actorSystem);
    }

    public static Cluster createExtension(ExtendedActorSystem extendedActorSystem) {
        return Cluster$.MODULE$.createExtension(extendedActorSystem);
    }

    public static Cluster$ lookup() {
        return Cluster$.MODULE$.lookup();
    }

    public static Cluster get(ActorSystem actorSystem) {
        return Cluster$.MODULE$.get(actorSystem);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Cluster$InfoLogger$ InfoLogger$lzycompute() {
        Cluster cluster = this;
        synchronized (cluster) {
            if (this.InfoLogger$module != null) return this.InfoLogger$module;
            this.InfoLogger$module = new Cluster$InfoLogger$(this);
            return this.InfoLogger$module;
        }
    }

    public void subscribe(ActorRef subscriber, Class<?> ... to) {
        this.subscribe(subscriber, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Class<?> ... to) {
        this.subscribe(subscriber, initialStateMode, (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])to));
    }

    public ExtendedActorSystem system() {
        return this.system;
    }

    public ClusterSettings settings() {
        return this.settings;
    }

    public UniqueAddress selfUniqueAddress() {
        return this.selfUniqueAddress;
    }

    public Address selfAddress() {
        return this.selfUniqueAddress().address();
    }

    public scala.collection.immutable.Set<String> selfRoles() {
        return this.settings().Roles();
    }

    public Set<String> getSelfRoles() {
        return (Set)JavaConverters$.MODULE$.setAsJavaSetConverter(this.selfRoles()).asJava();
    }

    private AtomicBoolean _isTerminated() {
        return this._isTerminated;
    }

    public LoggingAdapter akka$cluster$Cluster$$log() {
        return this.akka$cluster$Cluster$$log;
    }

    private Option<ClusterJmx> clusterJmx() {
        return this.clusterJmx;
    }

    private void clusterJmx_$eq(Option<ClusterJmx> x$1) {
        this.clusterJmx = x$1;
    }

    public FailureDetectorRegistry<Address> failureDetector() {
        return this.failureDetector;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    private ActorRef clusterDaemons() {
        return this.clusterDaemons;
    }

    public ActorRef clusterCore() {
        return this.clusterCore;
    }

    public ClusterReadView readView() {
        return this.readView;
    }

    public boolean isTerminated() {
        return this._isTerminated().get();
    }

    public ClusterEvent.CurrentClusterState state() {
        return this.readView().state();
    }

    public void subscribe(ActorRef subscriber, Seq<Class<?>> to) {
        ScalaActorRef qual$1 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$2 = new InternalClusterAction.Subscribe(subscriber, ClusterEvent$InitialStateAsSnapshot$.MODULE$, to.toSet());
        ActorRef x$3 = qual$1.$bang$default$2((Object)x$2);
        qual$1.$bang((Object)x$2, x$3);
    }

    public void subscribe(ActorRef subscriber, ClusterEvent.SubscriptionInitialStateMode initialStateMode, Seq<Class<?>> to) {
        ScalaActorRef qual$2 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Subscribe x$4 = new InternalClusterAction.Subscribe(subscriber, initialStateMode, to.toSet());
        ActorRef x$5 = qual$2.$bang$default$2((Object)x$4);
        qual$2.$bang((Object)x$4, x$5);
    }

    public void unsubscribe(ActorRef subscriber) {
        ScalaActorRef qual$3 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$6 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)None$.MODULE$);
        ActorRef x$7 = qual$3.$bang$default$2((Object)x$6);
        qual$3.$bang((Object)x$6, x$7);
    }

    public void unsubscribe(ActorRef subscriber, Class<?> to) {
        ScalaActorRef qual$4 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.Unsubscribe x$8 = new InternalClusterAction.Unsubscribe(subscriber, (Option<Class<?>>)new Some(to));
        ActorRef x$9 = qual$4.$bang$default$2((Object)x$8);
        qual$4.$bang((Object)x$8, x$9);
    }

    public void publishCurrentClusterState() {
        ScalaActorRef qual$5 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.PublishCurrentClusterState x$10 = new InternalClusterAction.PublishCurrentClusterState((Option<ActorRef>)None$.MODULE$);
        ActorRef x$11 = qual$5.$bang$default$2((Object)x$10);
        qual$5.$bang((Object)x$10, x$11);
    }

    public void sendCurrentClusterState(ActorRef receiver) {
        ScalaActorRef qual$6 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.PublishCurrentClusterState x$12 = new InternalClusterAction.PublishCurrentClusterState((Option<ActorRef>)new Some((Object)receiver));
        ActorRef x$13 = qual$6.$bang$default$2((Object)x$12);
        qual$6.$bang((Object)x$12, x$13);
    }

    public void join(Address address) {
        ScalaActorRef qual$7 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.JoinTo x$14 = new ClusterUserAction.JoinTo(address);
        ActorRef x$15 = qual$7.$bang$default$2((Object)x$14);
        qual$7.$bang((Object)x$14, x$15);
    }

    public void joinSeedNodes(scala.collection.immutable.Seq<Address> seedNodes) {
        ScalaActorRef qual$8 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        InternalClusterAction.JoinSeedNodes x$16 = new InternalClusterAction.JoinSeedNodes((IndexedSeq<Address>)seedNodes.toVector());
        ActorRef x$17 = qual$8.$bang$default$2((Object)x$16);
        qual$8.$bang((Object)x$16, x$17);
    }

    public void leave(Address address) {
        ScalaActorRef qual$9 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Leave x$18 = new ClusterUserAction.Leave(address);
        ActorRef x$19 = qual$9.$bang$default$2((Object)x$18);
        qual$9.$bang((Object)x$18, x$19);
    }

    public void down(Address address) {
        ScalaActorRef qual$10 = package$.MODULE$.actorRef2Scala(this.clusterCore());
        ClusterUserAction.Down x$20 = new ClusterUserAction.Down(address);
        ActorRef x$21 = qual$10.$bang$default$2((Object)x$20);
        qual$10.$bang((Object)x$20, x$21);
    }

    public <T> void registerOnMemberUp(Function0<T> code) {
        this.registerOnMemberUp(new Runnable(this, code){
            private final Function0 code$1;

            public void run() {
                this.code$1.apply();
            }
            {
                this.code$1 = code$1;
            }
        });
    }

    public void registerOnMemberUp(Runnable callback) {
        ScalaActorRef qual$11 = package$.MODULE$.actorRef2Scala(this.clusterDaemons());
        InternalClusterAction.AddOnMemberUpListener x$22 = new InternalClusterAction.AddOnMemberUpListener(callback);
        ActorRef x$23 = qual$11.$bang$default$2((Object)x$22);
        qual$11.$bang((Object)x$22, x$23);
    }

    public void shutdown() {
        if (this._isTerminated().compareAndSet(false, true)) {
            this.InfoLogger().logInfo("Shutting down...");
            this.system().stop(this.clusterDaemons());
            this.readView().close();
            this.closeScheduler();
            this.clusterJmx().foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(ClusterJmx x$1) {
                    x$1.unregisterMBean();
                }
            });
            this.InfoLogger().logInfo("Successfully shut down");
        }
    }

    private void closeScheduler() {
        Scheduler scheduler = this.scheduler();
        if (scheduler instanceof Closeable) {
            Scheduler scheduler2 = scheduler;
            ((Closeable)scheduler2).close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public Cluster$InfoLogger$ InfoLogger() {
        return this.InfoLogger$module == null ? this.InfoLogger$lzycompute() : this.InfoLogger$module;
    }

    public final FailureDetector akka$cluster$Cluster$$createFailureDetector$1() {
        return FailureDetectorLoader$.MODULE$.load(this.settings().FailureDetectorImplementationClass(), this.settings().FailureDetectorConfig(), (ActorSystem)this.system());
    }

    private final ActorRef liftedTree1$1(Timeout timeout$1) {
        ActorRef actorRef;
        try {
            actorRef = (ActorRef)Await$.MODULE$.result((Awaitable)AskableActorRef$.MODULE$.$qmark$extension(akka.pattern.package$.MODULE$.ask(this.clusterDaemons()), (Object)InternalClusterAction$GetClusterCoreRef$.MODULE$, timeout$1).mapTo(ClassTag$.MODULE$.apply(ActorRef.class)), (Duration)timeout$1.duration());
        }
        catch (Throwable throwable) {
            ActorRef actorRef2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.akka$cluster$Cluster$$log().error(e, "Failed to startup Cluster. You can try to increase 'akka.actor.creation-timeout'.");
            this.shutdown();
            actorRef = actorRef2 = this.system().deadLetters();
        }
        return actorRef;
    }

    public Cluster(ExtendedActorSystem system) {
        this.system = system;
        this.settings = new ClusterSettings(system.settings().config(), system.name());
        ActorRefProvider actorRefProvider = system.provider();
        if (actorRefProvider instanceof ClusterActorRefProvider) {
            $anon$1 v1;
            UniqueAddress uniqueAddress;
            ClusterActorRefProvider clusterActorRefProvider = (ClusterActorRefProvider)actorRefProvider;
            this.selfUniqueAddress = uniqueAddress = new UniqueAddress(clusterActorRefProvider.transport().defaultAddress(), ((AddressUidExtension)AddressUidExtension$.MODULE$.apply((ActorSystem)system)).addressUid());
            this._isTerminated = new AtomicBoolean(false);
            this.akka$cluster$Cluster$$log = Logging$.MODULE$.apply((ActorSystem)system, (Object)"Cluster", LogSource$.MODULE$.fromString());
            this.clusterJmx = None$.MODULE$;
            this.InfoLogger().logInfo("Starting up...");
            if (this.settings().AutoDown()) {
                this.akka$cluster$Cluster$$log().warning("[akka.cluster.auto-down] setting is replaced by [akka.cluster.auto-down-unreachable-after]");
            }
            this.failureDetector = new DefaultFailureDetectorRegistry((Function0)new $anonfun$2(this));
            package.DurationInt durationInt = new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(1));
            if (system.scheduler().maxFrequency() < durationInt.second().$div((Duration)this.settings().SchedulerTickDuration())) {
                ThreadFactory threadFactory;
                this.InfoLogger().logInfo("Using a dedicated scheduler for cluster. Default scheduler can be used if configured with 'akka.scheduler.tick-duration' [{} ms] <=  'akka.cluster.scheduler.tick-duration' [{} ms].", BoxesRunTime.boxToInteger((int)((int)((double)1000 / system.scheduler().maxFrequency()))), BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis()));
                Config cfg = ConfigFactory.parseString((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"akka.scheduler.tick-duration=", "ms"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.settings().SchedulerTickDuration().toMillis())}))).withFallback((ConfigMergeable)system.settings().config());
                ThreadFactory threadFactory2 = system.threadFactory();
                if (threadFactory2 instanceof MonitorableThreadFactory) {
                    MonitorableThreadFactory monitorableThreadFactory = (MonitorableThreadFactory)threadFactory2;
                    threadFactory = monitorableThreadFactory.withName(new StringBuilder().append((Object)monitorableThreadFactory.name()).append((Object)"-cluster-scheduler").toString());
                } else {
                    threadFactory = threadFactory2;
                }
                ThreadFactory threadFactory3 = threadFactory;
                v1 = (Scheduler)system.dynamicAccess().createInstanceFor(system.settings().SchedulerClass(), (scala.collection.immutable.Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(Config.class), (Object)cfg), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(LoggingAdapter.class), (Object)this.akka$cluster$Cluster$$log()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(ThreadFactory.class), (Object)threadFactory3)})), ClassTag$.MODULE$.apply(Scheduler.class)).get();
            } else {
                Scheduler systemScheduler = system.scheduler();
                v1 = new $anon$1(this, systemScheduler);
            }
            this.scheduler = v1;
            this.clusterDaemons = system.systemActorOf(Props$.MODULE$.apply(ClusterDaemon.class, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.settings()})).withDispatcher(this.settings().UseDispatcher()).withDeploy(Deploy$.MODULE$.local()), "cluster");
            Timeout timeout = system.settings().CreationTimeout();
            this.clusterCore = this.liftedTree1$1(timeout);
            this.readView = new ClusterReadView(this);
            system.registerOnTermination((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Cluster $outer;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.shutdown();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            });
            if (this.settings().JmxEnabled()) {
                ClusterJmx jmx = new ClusterJmx(this, this.akka$cluster$Cluster$$log());
                jmx.createMBean();
                this.clusterJmx_$eq((Option<ClusterJmx>)new Some((Object)jmx));
            }
            this.InfoLogger().logInfo("Started up successfully");
            return;
        }
        throw new ConfigurationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ActorSystem [", "] needs to have a 'ClusterActorRefProvider' enabled in the configuration, currently uses [", "]"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{system, actorRefProvider.getClass().getName()})));
    }
}

