/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Address;
import akka.cluster.NodeMetrics;
import akka.cluster.StandardMetrics;
import akka.cluster.StandardMetrics$Cpu$;
import akka.cluster.StandardMetrics$HeapMemory$;
import scala.Option;
import scala.Tuple5;
import scala.runtime.BoxesRunTime;

public final class StandardMetrics$ {
    public static final StandardMetrics$ MODULE$;
    private final String HeapMemoryUsed;
    private final String HeapMemoryCommitted;
    private final String HeapMemoryMax;
    private final String SystemLoadAverage;
    private final String Processors;
    private final String CpuCombined;

    static {
        new StandardMetrics$();
    }

    public final String HeapMemoryUsed() {
        return "heap-memory-used";
    }

    public final String HeapMemoryCommitted() {
        return "heap-memory-committed";
    }

    public final String HeapMemoryMax() {
        return "heap-memory-max";
    }

    public final String SystemLoadAverage() {
        return "system-load-average";
    }

    public final String Processors() {
        return "processors";
    }

    public final String CpuCombined() {
        return "cpu-combined";
    }

    public StandardMetrics.HeapMemory extractHeapMemory(NodeMetrics nodeMetrics) {
        StandardMetrics.HeapMemory heapMemory;
        NodeMetrics nodeMetrics2 = nodeMetrics;
        Option<Tuple5<Address, Object, Object, Object, Option<Object>>> option = StandardMetrics$HeapMemory$.MODULE$.unapply(nodeMetrics2);
        if (option.isEmpty()) {
            heapMemory = null;
        } else {
            Address address = (Address)((Tuple5)option.get())._1();
            long timestamp = BoxesRunTime.unboxToLong((Object)((Tuple5)option.get())._2());
            long used = BoxesRunTime.unboxToLong((Object)((Tuple5)option.get())._3());
            long committed = BoxesRunTime.unboxToLong((Object)((Tuple5)option.get())._4());
            Option max = (Option)((Tuple5)option.get())._5();
            heapMemory = new StandardMetrics.HeapMemory(address, timestamp, used, committed, (Option<Object>)max);
        }
        return heapMemory;
    }

    public StandardMetrics.Cpu extractCpu(NodeMetrics nodeMetrics) {
        StandardMetrics.Cpu cpu;
        NodeMetrics nodeMetrics2 = nodeMetrics;
        Option<Tuple5<Address, Object, Option<Object>, Option<Object>, Object>> option = StandardMetrics$Cpu$.MODULE$.unapply(nodeMetrics2);
        if (option.isEmpty()) {
            cpu = null;
        } else {
            Address address = (Address)((Tuple5)option.get())._1();
            long timestamp = BoxesRunTime.unboxToLong((Object)((Tuple5)option.get())._2());
            Option systemLoadAverage2 = (Option)((Tuple5)option.get())._3();
            Option cpuCombined2 = (Option)((Tuple5)option.get())._4();
            int processors = BoxesRunTime.unboxToInt((Object)((Tuple5)option.get())._5());
            cpu = new StandardMetrics.Cpu(address, timestamp, (Option<Object>)systemLoadAverage2, (Option<Object>)cpuCombined2, processors);
        }
        return cpu;
    }

    private StandardMetrics$() {
        MODULE$ = this;
    }
}

