/*
 * Decompiled with CFR 0.152.
 */
package spray.can.parsing;

import akka.util.ByteString;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichChar;
import spray.can.parsing.NotEnoughDataException$;

public final class CharUtils$ {
    public static final CharUtils$ MODULE$;
    private final int LOWER_ALPHA;
    private final int UPPER_ALPHA;
    private final int ALPHA;
    private final int DIGIT;
    private final int HEX_LETTER;
    private final int HEX_DIGIT;
    private final int TOKEN_SPECIALS;
    private final int TOKEN;
    private final int WSP;
    private final int NEWLINE;
    public final byte[] spray$can$parsing$CharUtils$$props;

    static {
        new CharUtils$();
    }

    private final int LOWER_ALPHA() {
        return 1;
    }

    private final int UPPER_ALPHA() {
        return 2;
    }

    private final int ALPHA() {
        return 3;
    }

    private final int DIGIT() {
        return 4;
    }

    private final int HEX_LETTER() {
        return 8;
    }

    private final int HEX_DIGIT() {
        return 12;
    }

    private final int TOKEN_SPECIALS() {
        return 16;
    }

    private final int TOKEN() {
        return 23;
    }

    private final int WSP() {
        return 32;
    }

    private final int NEWLINE() {
        return 64;
    }

    private boolean is(int c, int mask) {
        return (this.spray$can$parsing$CharUtils$$props[this.spray$can$parsing$CharUtils$$index(c)] & mask) != 0;
    }

    public int spray$can$parsing$CharUtils$$index(int c) {
        return c & c - 127 >> 31;
    }

    private void mark(int mask, Seq<Object> chars) {
        chars.foreach((Function1)new Serializable(mask){
            private final int mask$1;

            public final void apply(char c) {
                CharUtils$.MODULE$.spray$can$parsing$CharUtils$$props[CharUtils$.MODULE$.spray$can$parsing$CharUtils$$index((int)c)] = (byte)(CharUtils$.MODULE$.spray$can$parsing$CharUtils$$props[CharUtils$.MODULE$.spray$can$parsing$CharUtils$$index(c)] | this.mask$1);
            }
            {
                this.mask$1 = mask$1;
            }
        });
    }

    private void mark(int mask, NumericRange<Object> range) {
        this.mark(mask, (Seq<Object>)range.toSeq());
    }

    public boolean isTokenChar(char c) {
        return this.is(c, 23);
    }

    public boolean isDigit(char c) {
        return this.is(c, 4);
    }

    public boolean isWhitespace(char c) {
        return this.is(c, 32);
    }

    public boolean isWhitespaceOrNewline(char c) {
        return this.is(c, 96);
    }

    public boolean isHexDigit(char c) {
        return this.is(c, 12);
    }

    public int hexValue(char c) {
        return (c & 0x1F) + (c >> 6) * 25 - 16;
    }

    public char toLowerCase(char c) {
        return this.is(c, 2) ? (char)(c + 32) : c;
    }

    public int abs(int i) {
        int j = i >> 31;
        return (i ^ j) - j;
    }

    public String escape(char c) {
        String string;
        char c2 = c;
        switch (c2) {
            default: {
                if (Character.isISOControl(c2)) {
                    string = new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c)}));
                    break;
                }
                string = ((Object)BoxesRunTime.boxToCharacter((char)c2)).toString();
                break;
            }
            case '\n': {
                string = "\\n";
                break;
            }
            case '\r': {
                string = "\\r";
                break;
            }
            case '\t': {
                string = "\\t";
            }
        }
        return string;
    }

    public char byteChar(ByteString input, int ix) {
        if (ix < input.length()) {
            return (char)input.apply(ix);
        }
        throw NotEnoughDataException$.MODULE$;
    }

    public String asciiString(ByteString input, int start, int end) {
        return start == end ? "" : this.build$1(this.build$default$1$1(start), this.build$default$2$1(start, end), input, end);
    }

    private final String build$1(int ix, StringBuilder sb, ByteString input$1, int end$1) {
        while (ix != end$1) {
            sb = sb.append((char)input$1.apply(ix));
            ++ix;
        }
        return sb.toString();
    }

    private final int build$default$1$1(int start$1) {
        return start$1;
    }

    private final StringBuilder build$default$2$1(int start$1, int end$1) {
        return new StringBuilder(end$1 - start$1);
    }

    private CharUtils$() {
        MODULE$ = this;
        this.spray$can$parsing$CharUtils$$props = new byte[128];
        this.mark(1, (NumericRange<Object>)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'z')));
        this.mark(2, (NumericRange<Object>)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'Z')));
        this.mark(4, (NumericRange<Object>)new RichChar(Predef$.MODULE$.charWrapper('0')).to((Object)BoxesRunTime.boxToCharacter((char)'9')));
        this.mark(8, (NumericRange<Object>)new RichChar(Predef$.MODULE$.charWrapper('a')).to((Object)BoxesRunTime.boxToCharacter((char)'f')));
        this.mark(8, (NumericRange<Object>)new RichChar(Predef$.MODULE$.charWrapper('A')).to((Object)BoxesRunTime.boxToCharacter((char)'F')));
        this.mark(16, (Seq<Object>)Predef$.MODULE$.wrapCharArray(new char[]{'!', '#', '$', '%', '&', '\'', '*', '+', '-', '.', '^', '_', '`', '|', '~'}));
        this.mark(32, (Seq<Object>)Predef$.MODULE$.wrapCharArray(new char[]{' ', '\t'}));
        this.mark(64, (Seq<Object>)Predef$.MODULE$.wrapCharArray(new char[]{'\r', '\t'}));
    }
}

