/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.util.ByteString;
import akka.util.ByteString$;
import akka.util.ByteStringBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.ContinuationWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.ReferenceCountUtil;
import java.nio.ByteBuffer;
import org.reactivestreams.Processor;
import play.api.http.websocket.BinaryMessage;
import play.api.http.websocket.CloseMessage;
import play.api.http.websocket.Message;
import play.api.http.websocket.PingMessage;
import play.api.http.websocket.PongMessage;
import play.api.http.websocket.TextMessage;
import play.core.server.common.WebSocketFlowHandler;
import play.core.server.common.WebSocketFlowHandler$;
import play.core.server.netty.SynchronousMappedStreams$;
import scala.Enumeration;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.runtime.BoxesRunTime;

public final class WebSocketHandler$ {
    public static final WebSocketHandler$ MODULE$;

    static {
        new WebSocketHandler$();
    }

    public Processor<WebSocketFrame, WebSocketFrame> messageFlowToFrameProcessor(Flow<Message, Message, ?> flow, int bufferLimit, Materializer mat) {
        return SynchronousMappedStreams$.MODULE$.transform((Processor)WebSocketFlowHandler$.MODULE$.webSocketProtocol(bufferLimit).join(flow).toProcessor().run(mat), new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WebSocketFlowHandler.RawMessage apply(WebSocketFrame frame) {
                return WebSocketHandler$.MODULE$.play$core$server$netty$WebSocketHandler$$frameToMessage(frame);
            }
        }, new Serializable(){
            public static final long serialVersionUID = 0L;

            public final WebSocketFrame apply(Message message) {
                return WebSocketHandler$.MODULE$.play$core$server$netty$WebSocketHandler$$messageToFrame(message);
            }
        });
    }

    public WebSocketFlowHandler.RawMessage play$core$server$netty$WebSocketHandler$$frameToMessage(WebSocketFrame frame) {
        WebSocketFrame webSocketFrame;
        block8: {
            Enumeration.Value value;
            ByteString bytes;
            block3: {
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    ByteStringBuilder builder = ByteString$.MODULE$.newBuilder();
                                    frame.content().readBytes(builder.asOutputStream(), frame.content().readableBytes());
                                    bytes = builder.result();
                                    ReferenceCountUtil.release((Object)frame);
                                    webSocketFrame = frame;
                                    if (!(webSocketFrame instanceof TextWebSocketFrame)) break block2;
                                    value = WebSocketFlowHandler.MessageType$.MODULE$.Text();
                                    break block3;
                                }
                                if (!(webSocketFrame instanceof BinaryWebSocketFrame)) break block4;
                                value = WebSocketFlowHandler.MessageType$.MODULE$.Binary();
                                break block3;
                            }
                            if (!(webSocketFrame instanceof CloseWebSocketFrame)) break block5;
                            value = WebSocketFlowHandler.MessageType$.MODULE$.Close();
                            break block3;
                        }
                        if (!(webSocketFrame instanceof PingWebSocketFrame)) break block6;
                        value = WebSocketFlowHandler.MessageType$.MODULE$.Ping();
                        break block3;
                    }
                    if (!(webSocketFrame instanceof PongWebSocketFrame)) break block7;
                    value = WebSocketFlowHandler.MessageType$.MODULE$.Pong();
                    break block3;
                }
                if (!(webSocketFrame instanceof ContinuationWebSocketFrame)) break block8;
                value = WebSocketFlowHandler.MessageType$.MODULE$.Continuation();
            }
            Enumeration.Value messageType = value;
            return new WebSocketFlowHandler.RawMessage(messageType, bytes, frame.isFinalFragment());
        }
        throw new MatchError((Object)webSocketFrame);
    }

    public WebSocketFrame play$core$server$netty$WebSocketHandler$$messageToFrame(Message message) {
        Message message2;
        block8: {
            TextWebSocketFrame textWebSocketFrame;
            block3: {
                Option option;
                CloseMessage closeMessage;
                boolean bl;
                block7: {
                    block6: {
                        block5: {
                            block4: {
                                block2: {
                                    bl = false;
                                    closeMessage = null;
                                    message2 = message;
                                    if (!(message2 instanceof TextMessage)) break block2;
                                    TextMessage textMessage = (TextMessage)message2;
                                    String data = textMessage.data();
                                    textWebSocketFrame = new TextWebSocketFrame(data);
                                    break block3;
                                }
                                if (!(message2 instanceof BinaryMessage)) break block4;
                                BinaryMessage binaryMessage = (BinaryMessage)message2;
                                ByteString data = binaryMessage.data();
                                textWebSocketFrame = new BinaryWebSocketFrame(this.byteStringToByteBuf$1(data));
                                break block3;
                            }
                            if (!(message2 instanceof PingMessage)) break block5;
                            PingMessage pingMessage = (PingMessage)message2;
                            ByteString data = pingMessage.data();
                            textWebSocketFrame = new PingWebSocketFrame(this.byteStringToByteBuf$1(data));
                            break block3;
                        }
                        if (!(message2 instanceof PongMessage)) break block6;
                        PongMessage pongMessage = (PongMessage)message2;
                        ByteString data = pongMessage.data();
                        textWebSocketFrame = new PongWebSocketFrame(this.byteStringToByteBuf$1(data));
                        break block3;
                    }
                    if (!(message2 instanceof CloseMessage)) break block7;
                    bl = true;
                    closeMessage = (CloseMessage)message2;
                    Option option2 = closeMessage.statusCode();
                    String reason = closeMessage.reason();
                    if (!(option2 instanceof Some)) break block7;
                    Some some = (Some)option2;
                    int statusCode = BoxesRunTime.unboxToInt((Object)some.x());
                    textWebSocketFrame = new CloseWebSocketFrame(statusCode, reason);
                    break block3;
                }
                if (!bl || !None$.MODULE$.equals(option = closeMessage.statusCode())) break block8;
                textWebSocketFrame = new CloseWebSocketFrame();
            }
            return textWebSocketFrame;
        }
        throw new MatchError((Object)message2);
    }

    private final ByteBuf byteStringToByteBuf$1(ByteString bytes) {
        return bytes.isEmpty() ? Unpooled.EMPTY_BUFFER : Unpooled.wrappedBuffer((ByteBuffer)bytes.asByteBuffer());
    }

    private WebSocketHandler$() {
        MODULE$ = this;
    }
}

