/*
 * Decompiled with CFR 0.152.
 */
package play.core.server.netty;

import akka.stream.Materializer;
import akka.stream.scaladsl.Flow;
import akka.stream.scaladsl.Source;
import akka.util.ByteString;
import com.typesafe.netty.http.DefaultWebSocketHttpResponse;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Processor;
import play.api.Application;
import play.api.Configuration;
import play.api.http.DefaultHttpErrorHandler$;
import play.api.http.HeaderNames$;
import play.api.http.HttpErrorHandler;
import play.api.http.Status$;
import play.api.http.Writeable$;
import play.api.http.websocket.Message;
import play.api.libs.concurrent.Execution$;
import play.api.libs.iteratee.Execution;
import play.api.libs.streams.Accumulator;
import play.api.libs.streams.Accumulator$;
import play.api.mvc.Codec$;
import play.api.mvc.EssentialAction;
import play.api.mvc.EssentialAction$;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.mvc.Results$;
import play.api.mvc.WebSocket;
import play.core.server.NettyServer;
import play.core.server.common.ForwardedHeaderHandler;
import play.core.server.common.ServerResultUtils$;
import play.core.server.netty.NettyModelConversion;
import play.core.server.netty.PlayRequestHandler$;
import play.core.server.netty.WebSocketHandler$;
import play.core.system.RequestIdProvider$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Either;
import scala.util.Failure;
import scala.util.Left;
import scala.util.Right;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0001\u0005-v!B\u0001\u0003\u0011\u0013Y\u0011A\u0005)mCf\u0014V-];fgRD\u0015M\u001c3mKJT!a\u0001\u0003\u0002\u000b9,G\u000f^=\u000b\u0005\u00151\u0011AB:feZ,'O\u0003\u0002\b\u0011\u0005!1m\u001c:f\u0015\u0005I\u0011\u0001\u00029mCf\u001c\u0001\u0001\u0005\u0002\r\u001b5\t!AB\u0003\u000f\u0005!%qB\u0001\nQY\u0006L(+Z9vKN$\b*\u00198eY\u0016\u00148CA\u0007\u0011!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fM\")q#\u0004C\u00011\u00051A(\u001b8jiz\"\u0012a\u0003\u0005\b55\u0011\r\u0011\"\u0003\u001c\u0003\u0019awnZ4feV\tA\u0004\u0005\u0002\u001eA5\taD\u0003\u0002 \u0011\u0005\u0019\u0011\r]5\n\u0005\u0005r\"A\u0002'pO\u001e,'\u000f\u0003\u0004$\u001b\u0001\u0006I\u0001H\u0001\bY><w-\u001a:!\r\u0015q!\u0001\u0001\u0005&'\t!c\u0005\u0005\u0002([5\t\u0001F\u0003\u0002*U\u000591\r[1o]\u0016d'BA\u0002,\u0015\u0005a\u0013AA5p\u0013\tq\u0003F\u0001\u000fDQ\u0006tg.\u001a7J]\n|WO\u001c3IC:$G.\u001a:BI\u0006\u0004H/\u001a:\t\u0011\u0015!#Q1A\u0005\u0002A*\u0012!\r\t\u0003eMj\u0011\u0001B\u0005\u0003i\u0011\u00111BT3uif\u001cVM\u001d<fe\"Aa\u0007\nB\u0001B\u0003%\u0011'A\u0004tKJ4XM\u001d\u0011\t\u000b]!C\u0011\u0001\u001d\u0015\u0005eR\u0004C\u0001\u0007%\u0011\u0015)q\u00071\u00012\u0011\u001daDE1A\u0005\nu\n\u0001C]3rk\u0016\u001cHo]%o\r2Lw\r\u001b;\u0016\u0003y\u0002\"a\u0010%\u000e\u0003\u0001S!!\u0011\"\u0002\r\u0005$x.\\5d\u0015\t\u0019E)\u0001\u0006d_:\u001cWO\u001d:f]RT!!\u0012$\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tI\u0005I\u0001\u0006Bi>l\u0017n\u0019'p]\u001eDaa\u0013\u0013!\u0002\u0013q\u0014!\u0005:fcV,7\u000f^:J]\u001ac\u0017n\u001a5uA!9Q\n\na\u0001\n\u0013q\u0015\u0001\u00057bgR\u0014Vm\u001d9p]N,7+\u001a8u+\u0005y\u0005c\u0001)S)6\t\u0011K\u0003\u0002D%%\u00111+\u0015\u0002\u0007\rV$XO]3\u0011\u0005E)\u0016B\u0001,\u0013\u0005\u0011)f.\u001b;\t\u000fa#\u0003\u0019!C\u00053\u0006!B.Y:u%\u0016\u001c\bo\u001c8tKN+g\u000e^0%KF$\"\u0001\u0016.\t\u000fm;\u0016\u0011!a\u0001\u001f\u0006\u0019\u0001\u0010J\u0019\t\ru#\u0003\u0015)\u0003P\u0003Ea\u0017m\u001d;SKN\u0004xN\\:f'\u0016tG\u000f\t\u0005\t?\u0012B)\u0019!C\u0005A\u0006yQn\u001c3fY\u000e{gN^3sg&|g.F\u0001b!\ta!-\u0003\u0002d\u0005\t!b*\u001a;us6{G-\u001a7D_:4XM]:j_:D\u0001\"\u001a\u0013\t\u0002\u0003\u0006K!Y\u0001\u0011[>$W\r\\\"p]Z,'o]5p]\u0002BQa\u001a\u0013\u0005\u0002!\fa\u0001[1oI2,GcA5uqB\u0019\u0001K\u00156\u0011\u0005-\u0014X\"\u00017\u000b\u00055t\u0017\u0001\u00025uiBT!a\u001c9\u0002\u000b\r|G-Z2\u000b\u0005ET\u0013a\u00025b]\u0012dWM]\u0005\u0003g2\u0014A\u0002\u0013;uaJ+7\u000f]8og\u0016DQ!\u000b4A\u0002U\u0004\"a\n<\n\u0005]D#aB\"iC:tW\r\u001c\u0005\u0006s\u001a\u0004\rA_\u0001\be\u0016\fX/Z:u!\tY70\u0003\u0002}Y\nY\u0001\n\u001e;q%\u0016\fX/Z:u\u0011\u0015qH\u0005\"\u0011\u0000\u0003-\u0019\u0007.\u00198oK2\u0014V-\u00193\u0015\u000bQ\u000b\t!a\u0003\t\u000f\u0005\rQ\u00101\u0001\u0002\u0006\u0005\u00191\r\u001e=\u0011\u0007\u001d\n9!C\u0002\u0002\n!\u0012Qc\u00115b]:,G\u000eS1oI2,'oQ8oi\u0016DH\u000fC\u0004\u0002\u000eu\u0004\r!a\u0004\u0002\u00075\u001cx\r\u0005\u0003\u0002\u0012\u0005]QBAA\n\u0015\r\t)BR\u0001\u0005Y\u0006tw-\u0003\u0003\u0002\u001a\u0005M!AB(cU\u0016\u001cG\u000fC\u0004\u0002\u001e\u0011\"\t%a\b\u0002'\rD\u0017M\u001c8fYJ+\u0017\rZ\"p[BdW\r^3\u0015\u0007Q\u000b\t\u0003\u0003\u0005\u0002\u0004\u0005m\u0001\u0019AA\u0003\u0011\u001d\t)\u0003\nC!\u0003O\tq\"\u001a=dKB$\u0018n\u001c8DCV<\u0007\u000e\u001e\u000b\u0006)\u0006%\u00121\u0006\u0005\t\u0003\u0007\t\u0019\u00031\u0001\u0002\u0006!A\u0011QFA\u0012\u0001\u0004\ty#A\u0003dCV\u001cX\r\u0005\u0003\u00022\u0005\u0005c\u0002BA\u001a\u0003{qA!!\u000e\u0002<5\u0011\u0011q\u0007\u0006\u0004\u0003sQ\u0011A\u0002\u001fs_>$h(C\u0001\u0014\u0013\r\tyDE\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t\u0019%!\u0012\u0003\u0013QC'o\\<bE2,'bAA %!9\u0011\u0011\n\u0013\u0005B\u0005-\u0013!D2iC:tW\r\\!di&4X\rF\u0002U\u0003\u001bB\u0001\"a\u0001\u0002H\u0001\u0007\u0011Q\u0001\u0005\b\u0003#\"C\u0011BA*\u00031A\u0017M\u001c3mK\u0006\u001bG/[8o)%I\u0017QKA3\u0003_\n\t\b\u0003\u0005\u0002X\u0005=\u0003\u0019AA-\u0003\u0019\t7\r^5p]B!\u00111LA1\u001b\t\tiFC\u0002\u0002`y\t1!\u001c<d\u0013\u0011\t\u0019'!\u0018\u0003\u001f\u0015\u001b8/\u001a8uS\u0006d\u0017i\u0019;j_:D\u0001\"a\u001a\u0002P\u0001\u0007\u0011\u0011N\u0001\u000ee\u0016\fX/Z:u\u0011\u0016\fG-\u001a:\u0011\t\u0005m\u00131N\u0005\u0005\u0003[\niFA\u0007SKF,Xm\u001d;IK\u0006$WM\u001d\u0005\u0007s\u0006=\u0003\u0019\u0001>\t\u0011\u0005M\u0014q\na\u0001\u0003k\n1!\u00199q!\u0015\t\u0012qOA>\u0013\r\tIH\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007u\ti(C\u0002\u0002\u0000y\u00111\"\u00119qY&\u001c\u0017\r^5p]\"9\u00111\u0011\u0013\u0005\n\u0005\u0015\u0015\u0001D3se>\u0014\b*\u00198eY\u0016\u0014H\u0003BAD\u0003#\u0003B!!#\u0002\u000e6\u0011\u00111\u0012\u0006\u0003[zIA!a$\u0002\f\n\u0001\u0002\n\u001e;q\u000bJ\u0014xN\u001d%b]\u0012dWM\u001d\u0005\t\u0003g\n\t\t1\u0001\u0002v!9\u0011Q\u0013\u0013\u0005\n\u0005]\u0015aF:f]\u0012\u001c\u0016.\u001c9mK\u0016\u0013(o\u001c:SKN\u0004xN\\:f)\u0019\tI*a(\u0002\"B\u0019q%a'\n\u0007\u0005u\u0005FA\u0007DQ\u0006tg.\u001a7GkR,(/\u001a\u0005\t\u0003\u0007\t\u0019\n1\u0001\u0002\u0006!A\u00111UAJ\u0001\u0004\t)+\u0001\u0004ti\u0006$Xo\u001d\t\u0004W\u0006\u001d\u0016bAAUY\n\u0011\u0002\n\u001e;q%\u0016\u001c\bo\u001c8tKN#\u0018\r^;t\u0001")
public class PlayRequestHandler
extends ChannelInboundHandlerAdapter {
    private final NettyServer server;
    private final AtomicLong play$core$server$netty$PlayRequestHandler$$requestsInFlight;
    private Future<BoxedUnit> lastResponseSent;
    private NettyModelConversion play$core$server$netty$PlayRequestHandler$$modelConversion;
    private volatile boolean bitmap$0;

    private NettyModelConversion play$core$server$netty$PlayRequestHandler$$modelConversion$lzycompute() {
        PlayRequestHandler playRequestHandler = this;
        synchronized (playRequestHandler) {
            if (!this.bitmap$0) {
                this.play$core$server$netty$PlayRequestHandler$$modelConversion = new NettyModelConversion(new ForwardedHeaderHandler(ForwardedHeaderHandler.ForwardedHeaderHandlerConfig$.MODULE$.apply(this.server().applicationProvider().get().toOption().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Configuration apply(Application x$1) {
                        return x$1.configuration();
                    }
                }))));
                this.bitmap$0 = true;
            }
            return this.play$core$server$netty$PlayRequestHandler$$modelConversion;
        }
    }

    public NettyServer server() {
        return this.server;
    }

    public AtomicLong play$core$server$netty$PlayRequestHandler$$requestsInFlight() {
        return this.play$core$server$netty$PlayRequestHandler$$requestsInFlight;
    }

    private Future<BoxedUnit> lastResponseSent() {
        return this.lastResponseSent;
    }

    private void lastResponseSent_$eq(Future<BoxedUnit> x$1) {
        this.lastResponseSent = x$1;
    }

    public NettyModelConversion play$core$server$netty$PlayRequestHandler$$modelConversion() {
        return this.bitmap$0 ? this.play$core$server$netty$PlayRequestHandler$$modelConversion : this.play$core$server$netty$PlayRequestHandler$$modelConversion$lzycompute();
    }

    public Future<HttpResponse> handle(Channel channel, HttpRequest request) {
        Try<RequestHeader> try_;
        block5: {
            Either<Future<Result>, Tuple3<RequestHeader, Handler, Application>> either;
            block8: {
                Tuple2 tuple2;
                block9: {
                    Either either2;
                    block14: {
                        Future future;
                        block11: {
                            RequestHeader requestHeader;
                            block13: {
                                Tuple2 tuple22;
                                Right right;
                                boolean bl;
                                block12: {
                                    Tuple2 tuple23;
                                    block10: {
                                        Tuple2 tuple24;
                                        Tuple2 tuple25;
                                        block3: {
                                            Tuple2 tuple26;
                                            block7: {
                                                Right right2;
                                                Tuple3 tuple3;
                                                block6: {
                                                    block4: {
                                                        Failure failure;
                                                        boolean bl2;
                                                        long requestId;
                                                        block2: {
                                                            PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().trace((Function0)new Serializable(this, request){
                                                                public static final long serialVersionUID = 0L;
                                                                private final HttpRequest request$1;

                                                                public final String apply() {
                                                                    return new StringBuilder().append((Object)"Http request received by netty: ").append((Object)this.request$1).toString();
                                                                }
                                                                {
                                                                    this.request$1 = request$1;
                                                                }
                                                            });
                                                            requestId = RequestIdProvider$.MODULE$.requestIDs().incrementAndGet();
                                                            Try<RequestHeader> tryRequest = this.play$core$server$netty$PlayRequestHandler$$modelConversion().convertRequest(requestId, (InetSocketAddress)channel.remoteAddress(), (Option<SslHandler>)Option$.MODULE$.apply((Object)channel.pipeline().get(SslHandler.class)), request);
                                                            bl2 = false;
                                                            failure = null;
                                                            try_ = tryRequest;
                                                            if (!(try_ instanceof Failure)) break block2;
                                                            bl2 = true;
                                                            failure = (Failure)try_;
                                                            Throwable exception = failure.exception();
                                                            if (!(exception instanceof TooLongFrameException)) break block2;
                                                            TooLongFrameException tooLongFrameException = (TooLongFrameException)exception;
                                                            tuple25 = this.clientError$1(Status$.MODULE$.REQUEST_URI_TOO_LONG(), tooLongFrameException.getMessage(), channel, request, requestId);
                                                            break block3;
                                                        }
                                                        if (!bl2) break block4;
                                                        Throwable exception = failure.exception();
                                                        tuple25 = this.clientError$1(Status$.MODULE$.BAD_REQUEST(), exception.getMessage(), channel, request, requestId);
                                                        break block3;
                                                    }
                                                    if (!(try_ instanceof Success)) break block5;
                                                    Success success = (Success)try_;
                                                    RequestHeader untagged = (RequestHeader)success.value();
                                                    either = this.server().getHandlerFor(untagged);
                                                    if (!(either instanceof Left)) break block6;
                                                    Left left = (Left)either;
                                                    Future directResult = (Future)left.a();
                                                    tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)untagged), (Object)package$.MODULE$.Left().apply((Object)directResult));
                                                    break block7;
                                                }
                                                if (!(either instanceof Right) || (tuple3 = (Tuple3)(right2 = (Right)either).b()) == null) break block8;
                                                RequestHeader taggedRequestHeader = (RequestHeader)tuple3._1();
                                                Handler handler = (Handler)tuple3._2();
                                                Application application = (Application)tuple3._3();
                                                tuple26 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)taggedRequestHeader), (Object)package$.MODULE$.Right().apply((Object)new Tuple2((Object)handler, (Object)application)));
                                            }
                                            tuple25 = tuple26;
                                        }
                                        tuple2 = tuple25;
                                        if (tuple2 == null) break block9;
                                        RequestHeader requestHeader2 = (RequestHeader)tuple2._1();
                                        Either resultOrHandler = (Either)tuple2._2();
                                        Tuple2 tuple27 = tuple24 = new Tuple2((Object)requestHeader2, (Object)resultOrHandler);
                                        requestHeader = (RequestHeader)tuple27._1();
                                        Either resultOrHandler2 = (Either)tuple27._2();
                                        bl = false;
                                        right = null;
                                        either2 = resultOrHandler2;
                                        if (!(either2 instanceof Right)) break block10;
                                        bl = true;
                                        right = (Right)either2;
                                        Tuple2 tuple28 = (Tuple2)right.b();
                                        if (tuple28 == null) break block10;
                                        Handler action = (Handler)tuple28._1();
                                        Application app = (Application)tuple28._2();
                                        if (!(action instanceof EssentialAction)) break block10;
                                        EssentialAction essentialAction = (EssentialAction)action;
                                        EssentialAction recovered = EssentialAction$.MODULE$.apply((Function1)new Serializable(this, app, essentialAction){
                                            public static final long serialVersionUID = 0L;
                                            public final Application app$1;
                                            private final EssentialAction x9$1;

                                            public final Accumulator<ByteString, Result> apply(RequestHeader rh) {
                                                return ((Accumulator)this.x9$1.apply((Object)rh)).recoverWith((PartialFunction)new Serializable(this, rh){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ $anonfun$2 $outer;
                                                    private final RequestHeader rh$1;

                                                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                                                        A1 A1 = x1;
                                                        Future future = this.$outer.app$1.errorHandler().onServerError(this.rh$1, A1);
                                                        return (B1)future;
                                                    }

                                                    public final boolean isDefinedAt(Throwable x1) {
                                                        Throwable throwable = x1;
                                                        boolean bl = true;
                                                        return bl;
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw null;
                                                        }
                                                        this.$outer = $outer;
                                                        this.rh$1 = rh$1;
                                                    }
                                                }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                                            }
                                            {
                                                this.app$1 = app$1;
                                                this.x9$1 = x9$1;
                                            }
                                        });
                                        future = this.play$core$server$netty$PlayRequestHandler$$handleAction(recovered, requestHeader, request, (Option<Application>)new Some((Object)app));
                                        break block11;
                                    }
                                    if (!bl || (tuple23 = (Tuple2)right.b()) == null) break block12;
                                    Handler ws = (Handler)tuple23._1();
                                    Application app = (Application)tuple23._2();
                                    if (!(ws instanceof WebSocket)) break block12;
                                    WebSocket webSocket = (WebSocket)ws;
                                    if (!requestHeader.headers().get(HeaderNames$.MODULE$.UPGRADE()).exists((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final boolean apply(String x$4) {
                                            return x$4.equalsIgnoreCase("websocket");
                                        }
                                    })) break block12;
                                    PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().trace((Function0)new Serializable(this, webSocket){
                                        public static final long serialVersionUID = 0L;
                                        private final WebSocket x10$1;

                                        public final String apply() {
                                            return new StringBuilder().append((Object)"Serving this request with: ").append((Object)this.x10$1).toString();
                                        }
                                        {
                                            this.x10$1 = x10$1;
                                        }
                                    });
                                    String wsProtocol = requestHeader.secure() ? "wss" : "ws";
                                    String wsUrl = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", "", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{wsProtocol, requestHeader.host(), requestHeader.path()}));
                                    int bufferLimit = (int)BoxesRunTime.unboxToLong((Object)app.configuration().getBytes("play.websocket.buffer.limit").getOrElse((Function0)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final long apply() {
                                            return this.apply$mcJ$sp();
                                        }

                                        public long apply$mcJ$sp() {
                                            return 65536L;
                                        }
                                    }));
                                    WebSocketServerHandshakerFactory factory = new WebSocketServerHandshakerFactory(wsUrl, "*", true, bufferLimit);
                                    Future executed = Future$.MODULE$.apply((Function0)new Serializable(this, requestHeader, webSocket){
                                        public static final long serialVersionUID = 0L;
                                        private final RequestHeader requestHeader$1;
                                        private final WebSocket x10$1;

                                        public final Future<Either<Result, Flow<Message, Message, ?>>> apply() {
                                            return this.x10$1.apply(this.requestHeader$1);
                                        }
                                        {
                                            this.requestHeader$1 = requestHeader$1;
                                            this.x10$1 = x10$1;
                                        }
                                    }, Execution$.MODULE$.defaultContext());
                                    future = executed.flatMap((Function1)new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final Future<Either<Result, Flow<Message, Message, ?>>> apply(Future<Either<Result, Flow<Message, Message, ?>>> x) {
                                            return (Future)Predef$.MODULE$.identity(x);
                                        }
                                    }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).flatMap((Function1)new Serializable(this, request, requestHeader, app, bufferLimit, factory){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ PlayRequestHandler $outer;
                                        private final HttpRequest request$1;
                                        private final RequestHeader requestHeader$1;
                                        private final Application app$3;
                                        private final int bufferLimit$1;
                                        private final WebSocketServerHandshakerFactory factory$1;

                                        public final Future<HttpResponse> apply(Either<Result, Flow<Message, Message, ?>> x0$1) {
                                            Either<Result, Flow<Message, Message, ?>> either;
                                            block4: {
                                                Future future;
                                                block3: {
                                                    block2: {
                                                        either = x0$1;
                                                        if (!(either instanceof Left)) break block2;
                                                        Left left = (Left)either;
                                                        Result result = (Result)left.a();
                                                        EssentialAction action = EssentialAction$.MODULE$.apply((Function1)new Serializable(this, result){
                                                            public static final long serialVersionUID = 0L;
                                                            private final Result result$1;

                                                            public final Accumulator<Object, Result> apply(RequestHeader x$5) {
                                                                return Accumulator$.MODULE$.done((Object)this.result$1);
                                                            }
                                                            {
                                                                this.result$1 = result$1;
                                                            }
                                                        });
                                                        future = this.$outer.play$core$server$netty$PlayRequestHandler$$handleAction(action, this.requestHeader$1, this.request$1, (Option<Application>)new Some((Object)this.app$3));
                                                        break block3;
                                                    }
                                                    if (!(either instanceof Right)) break block4;
                                                    Right right = (Right)either;
                                                    Flow flow = (Flow)right.b();
                                                    Processor<WebSocketFrame, WebSocketFrame> processor = WebSocketHandler$.MODULE$.messageFlowToFrameProcessor(flow, this.bufferLimit$1, this.app$3.materializer());
                                                    future = Future$.MODULE$.successful((Object)new DefaultWebSocketHttpResponse(this.request$1.getProtocolVersion(), HttpResponseStatus.OK, processor, this.factory$1));
                                                }
                                                return future;
                                            }
                                            throw new MatchError(either);
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.request$1 = request$1;
                                            this.requestHeader$1 = requestHeader$1;
                                            this.app$3 = app$3;
                                            this.bufferLimit$1 = bufferLimit$1;
                                            this.factory$1 = factory$1;
                                        }
                                    }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).recoverWith((PartialFunction)new Serializable(this, request, requestHeader, app){
                                        public static final long serialVersionUID = 0L;
                                        private final /* synthetic */ PlayRequestHandler $outer;
                                        public final HttpRequest request$1;
                                        public final RequestHeader requestHeader$1;
                                        public final Application app$3;

                                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                                            A1 A1 = x2;
                                            Future future = this.app$3.errorHandler().onServerError(this.requestHeader$1, A1).flatMap((Function1)new Serializable(this){
                                                public static final long serialVersionUID = 0L;
                                                private final /* synthetic */ $anonfun$handle$1 $outer;

                                                public final Future<HttpResponse> apply(Result result) {
                                                    EssentialAction action = EssentialAction$.MODULE$.apply((Function1)new Serializable(this, result){
                                                        public static final long serialVersionUID = 0L;
                                                        private final Result result$2;

                                                        public final Accumulator<Object, Result> apply(RequestHeader x$6) {
                                                            return Accumulator$.MODULE$.done((Object)this.result$2);
                                                        }
                                                        {
                                                            this.result$2 = result$2;
                                                        }
                                                    });
                                                    return this.$outer.play$core$server$netty$PlayRequestHandler$$anonfun$$$outer().play$core$server$netty$PlayRequestHandler$$handleAction(action, this.$outer.requestHeader$1, this.$outer.request$1, (Option<Application>)new Some((Object)this.$outer.app$3));
                                                }
                                                {
                                                    if ($outer == null) {
                                                        throw null;
                                                    }
                                                    this.$outer = $outer;
                                                }
                                            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                                            return (B1)future;
                                        }

                                        public final boolean isDefinedAt(Throwable x2) {
                                            Throwable throwable = x2;
                                            boolean bl = true;
                                            return bl;
                                        }

                                        public /* synthetic */ PlayRequestHandler play$core$server$netty$PlayRequestHandler$$anonfun$$$outer() {
                                            return this.$outer;
                                        }
                                        {
                                            if ($outer == null) {
                                                throw null;
                                            }
                                            this.$outer = $outer;
                                            this.request$1 = request$1;
                                            this.requestHeader$1 = requestHeader$1;
                                            this.app$3 = app$3;
                                        }
                                    }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                                    break block11;
                                }
                                if (!bl || (tuple22 = (Tuple2)right.b()) == null) break block13;
                                Handler ws = (Handler)tuple22._1();
                                Application app = (Application)tuple22._2();
                                if (!(ws instanceof WebSocket)) break block13;
                                PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().trace((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Bad websocket request";
                                    }
                                });
                                EssentialAction action = EssentialAction$.MODULE$.apply((Function1)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final Accumulator<Object, Result> apply(RequestHeader x$7) {
                                        return Accumulator$.MODULE$.done((Object)Results$.MODULE$.Status(Status$.MODULE$.UPGRADE_REQUIRED()).apply((Object)"Upgrade to WebSocket required", Writeable$.MODULE$.wString(Codec$.MODULE$.utf_8())).withHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.UPGRADE()), (Object)"websocket"), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONNECTION()), (Object)HeaderNames$.MODULE$.UPGRADE())})));
                                    }
                                });
                                future = this.play$core$server$netty$PlayRequestHandler$$handleAction(action, requestHeader, request, (Option<Application>)new Some((Object)app));
                                break block11;
                            }
                            if (!(either2 instanceof Left)) break block14;
                            Left left = (Left)either2;
                            Future e = (Future)left.a();
                            PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().trace((Function0)new Serializable(this, e){
                                public static final long serialVersionUID = 0L;
                                private final Future e$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"No handler, got direct result: ").append((Object)this.e$1).toString();
                                }
                                {
                                    this.e$1 = e$1;
                                }
                            });
                            EssentialAction action = EssentialAction$.MODULE$.apply((Function1)new Serializable(this, e){
                                public static final long serialVersionUID = 0L;
                                private final Future e$1;

                                public final Accumulator<Object, Result> apply(RequestHeader x$8) {
                                    return Accumulator$.MODULE$.done(this.e$1);
                                }
                                {
                                    this.e$1 = e$1;
                                }
                            });
                            future = this.play$core$server$netty$PlayRequestHandler$$handleAction(action, requestHeader, request, (Option<Application>)None$.MODULE$);
                        }
                        return future;
                    }
                    throw new MatchError((Object)either2);
                }
                throw new MatchError((Object)tuple2);
            }
            throw new MatchError(either);
        }
        throw new MatchError(try_);
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().trace((Function0)new Serializable(this, ctx, msg){
            public static final long serialVersionUID = 0L;
            private final ChannelHandlerContext ctx$1;
            private final Object msg$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"channelRead: ctx = ", ", msg = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ctx$1, this.msg$1}));
            }
            {
                this.ctx$1 = ctx$1;
                this.msg$1 = msg$1;
            }
        });
        Object object = msg;
        if (object instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)object;
            this.play$core$server$netty$PlayRequestHandler$$requestsInFlight().incrementAndGet();
            Future<HttpResponse> future = this.handle(ctx.channel(), httpRequest);
            this.lastResponseSent_$eq((Future<BoxedUnit>)this.lastResponseSent().flatMap((Function1)new Serializable(this, ctx, future){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PlayRequestHandler $outer;
                public final ChannelHandlerContext ctx$1;
                private final Future future$1;

                public final Future<BoxedUnit> apply(BoxedUnit x$9) {
                    Future f = this.future$1.map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$channelRead$2 $outer;

                        public final void apply(HttpResponse httpResponse) {
                            Object object = this.$outer.play$core$server$netty$PlayRequestHandler$$anonfun$$$outer().play$core$server$netty$PlayRequestHandler$$requestsInFlight().decrementAndGet() == 0L ? this.$outer.ctx$1.read() : BoxedUnit.UNIT;
                            this.$outer.ctx$1.writeAndFlush((Object)httpResponse);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                    return f.recover((PartialFunction)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$channelRead$2 $outer;

                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                            Object object;
                            A1 A1 = x3;
                            if (A1 instanceof Exception) {
                                Exception exception = (Exception)A1;
                                PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().error((Function0)new Serializable(this){
                                    public static final long serialVersionUID = 0L;

                                    public final String apply() {
                                        return "Exception caught in channelRead future";
                                    }
                                }, (Function0)new Serializable(this, exception){
                                    public static final long serialVersionUID = 0L;
                                    private final Exception x2$1;

                                    public final Exception apply() {
                                        return this.x2$1;
                                    }
                                    {
                                        this.x2$1 = x2$1;
                                    }
                                });
                                this.$outer.play$core$server$netty$PlayRequestHandler$$anonfun$$$outer().play$core$server$netty$PlayRequestHandler$$sendSimpleErrorResponse(this.$outer.ctx$1, HttpResponseStatus.SERVICE_UNAVAILABLE);
                                object = BoxedUnit.UNIT;
                            } else {
                                object = function1.apply(x3);
                            }
                            return (B1)object;
                        }

                        public final boolean isDefinedAt(Throwable x3) {
                            Throwable throwable = x3;
                            boolean bl = throwable instanceof Exception;
                            return bl;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
                }

                public /* synthetic */ PlayRequestHandler play$core$server$netty$PlayRequestHandler$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.ctx$1 = ctx$1;
                    this.future$1 = future$1;
                }
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        throw new MatchError(object);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().trace((Function0)new Serializable(this, ctx){
            public static final long serialVersionUID = 0L;
            private final ChannelHandlerContext ctx$2;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"channelReadComplete: ctx = ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.ctx$2}));
            }
            {
                this.ctx$2 = ctx$2;
            }
        });
        if (this.play$core$server$netty$PlayRequestHandler$$requestsInFlight().get() == 0L) {
            ctx.read();
        } else {
            ctx.fireChannelReadComplete();
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        IllegalArgumentException illegalArgumentException;
        Throwable throwable = cause;
        if (throwable instanceof IOException) {
            IOException iOException = (IOException)throwable;
            PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().trace((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Benign IO exception caught in Netty";
                }
            }, (Function0)new Serializable(this, iOException){
                public static final long serialVersionUID = 0L;
                private final IOException x2$2;

                public final IOException apply() {
                    return this.x2$2;
                }
                {
                    this.x2$2 = x2$2;
                }
            });
            ctx.channel().close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof TooLongFrameException) {
            TooLongFrameException tooLongFrameException = (TooLongFrameException)throwable;
            PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().warn((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Handling TooLongFrameException";
                }
            }, (Function0)new Serializable(this, tooLongFrameException){
                public static final long serialVersionUID = 0L;
                private final TooLongFrameException x3$1;

                public final TooLongFrameException apply() {
                    return this.x3$1;
                }
                {
                    this.x3$1 = x3$1;
                }
            });
            this.play$core$server$netty$PlayRequestHandler$$sendSimpleErrorResponse(ctx, HttpResponseStatus.REQUEST_URI_TOO_LONG);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (throwable instanceof IllegalArgumentException && Option$.MODULE$.apply((Object)(illegalArgumentException = (IllegalArgumentException)throwable).getMessage()).exists((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$10) {
                return x$10.contains("Header value contains a prohibited character");
            }
        })) {
            PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().debug((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Handling Header value error";
                }
            }, (Function0)new Serializable(this, illegalArgumentException){
                public static final long serialVersionUID = 0L;
                private final IllegalArgumentException x4$1;

                public final IllegalArgumentException apply() {
                    return this.x4$1;
                }
                {
                    this.x4$1 = x4$1;
                }
            });
            this.play$core$server$netty$PlayRequestHandler$$sendSimpleErrorResponse(ctx, HttpResponseStatus.BAD_REQUEST);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().error((Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Exception caught in Netty";
                }
            }, (Function0)new Serializable(this, throwable){
                public static final long serialVersionUID = 0L;
                private final Throwable x1$1;

                public final Throwable apply() {
                    return this.x1$1;
                }
                {
                    this.x1$1 = x1$1;
                }
            });
            ctx.channel().close();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.read();
    }

    public Future<HttpResponse> play$core$server$netty$PlayRequestHandler$$handleAction(EssentialAction action, RequestHeader requestHeader, HttpRequest request, Option<Application> app) {
        Option<Source<ByteString, Object>> option;
        block4: {
            Future future;
            Materializer mat;
            block3: {
                Accumulator bodyParser;
                block2: {
                    mat = (Materializer)app.fold((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ PlayRequestHandler $outer;

                        public final Materializer apply() {
                            return this.$outer.server().materializer();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, (Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Materializer apply(Application x$11) {
                            return x$11.materializer();
                        }
                    });
                    Option<Source<ByteString, Object>> body = this.play$core$server$netty$PlayRequestHandler$$modelConversion().convertRequestBody(request, mat);
                    bodyParser = (Accumulator)action.apply((Object)requestHeader);
                    option = body;
                    if (!None$.MODULE$.equals(option)) break block2;
                    future = bodyParser.run(mat);
                    break block3;
                }
                if (!(option instanceof Some)) break block4;
                Some some = (Some)option;
                Source source = (Source)some.x();
                future = bodyParser.run(source, mat);
            }
            Future resultFuture = future;
            return resultFuture.recoverWith((PartialFunction)new Serializable(this, requestHeader, app){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PlayRequestHandler $outer;
                private final RequestHeader requestHeader$2;
                private final Option app$2;

                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                    A1 A1 = x4;
                    PlayRequestHandler$.MODULE$.play$core$server$netty$PlayRequestHandler$$logger().error((Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Cannot invoke the action";
                        }
                    }, (Function0)new Serializable(this, A1){
                        public static final long serialVersionUID = 0L;
                        private final Throwable x1$2;

                        public final Throwable apply() {
                            return this.x1$2;
                        }
                        {
                            this.x1$2 = x1$2;
                        }
                    });
                    Future future = this.$outer.play$core$server$netty$PlayRequestHandler$$errorHandler((Option<Application>)this.app$2).onServerError(this.requestHeader$2, A1);
                    return (B1)future;
                }

                public final boolean isDefinedAt(Throwable x4) {
                    Throwable throwable = x4;
                    boolean bl = true;
                    return bl;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestHeader$2 = requestHeader$2;
                    this.app$2 = app$2;
                }
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline()).map((Function1)new Serializable(this, requestHeader, request, mat){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ PlayRequestHandler $outer;
                private final RequestHeader requestHeader$2;
                private final HttpRequest request$2;
                private final Materializer mat$1;

                public final HttpResponse apply(Result x0$2) {
                    Result result = x0$2;
                    Result cleanedResult = ServerResultUtils$.MODULE$.cleanFlashCookie(this.requestHeader$2, result);
                    Result validated = ServerResultUtils$.MODULE$.validateResult(this.requestHeader$2, cleanedResult, this.mat$1);
                    HttpResponse httpResponse = this.$outer.play$core$server$netty$PlayRequestHandler$$modelConversion().convertResult(validated, this.requestHeader$2, this.request$2.getProtocolVersion(), this.mat$1);
                    return httpResponse;
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.requestHeader$2 = requestHeader$2;
                    this.request$2 = request$2;
                    this.mat$1 = mat$1;
                }
            }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline());
        }
        throw new MatchError(option);
    }

    public HttpErrorHandler play$core$server$netty$PlayRequestHandler$$errorHandler(Option<Application> app) {
        return (HttpErrorHandler)app.fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DefaultHttpErrorHandler$ apply() {
                return DefaultHttpErrorHandler$.MODULE$;
            }
        }, (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final HttpErrorHandler apply(Application x$12) {
                return x$12.errorHandler();
            }
        });
    }

    public ChannelFuture play$core$server$netty$PlayRequestHandler$$sendSimpleErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
        response.headers().set("Connection", (Object)"close");
        response.headers().set("Content-Length", (Object)"0");
        ChannelFuture f = ctx.channel().write((Object)response);
        f.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return f;
    }

    private final Tuple2 clientError$1(int statusCode, String message, Channel channel$1, HttpRequest request$1, long requestId$1) {
        RequestHeader requestHeader = this.play$core$server$netty$PlayRequestHandler$$modelConversion().createUnparsedRequestHeader(requestId$1, request$1, (InetSocketAddress)channel$1.remoteAddress(), Option$.MODULE$.apply((Object)channel$1.pipeline().get(SslHandler.class)));
        Future result = this.play$core$server$netty$PlayRequestHandler$$errorHandler((Option<Application>)this.server().applicationProvider().current()).onClientError(requestHeader, statusCode, message == null ? "" : message);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)requestHeader), (Object)package$.MODULE$.Left().apply((Object)result.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Result apply(Result x$2) {
                return x$2.withHeaders((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)HeaderNames$.MODULE$.CONNECTION()), (Object)"close")}));
            }
        }, (ExecutionContext)Execution.Implicits$.MODULE$.trampoline())));
    }

    public PlayRequestHandler(NettyServer server) {
        this.server = server;
        this.play$core$server$netty$PlayRequestHandler$$requestsInFlight = new AtomicLong();
        this.lastResponseSent = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }
}

