/*
 * Decompiled with CFR 0.152.
 */
package play.test;

import akka.stream.Materializer;
import akka.util.ByteString;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import play.Application;
import play.GlobalSettings;
import play.api.Play;
import play.api.inject.Injector;
import play.api.mvc.Action;
import play.api.mvc.Handler;
import play.api.mvc.RequestHeader;
import play.api.mvc.Result;
import play.api.test.Helpers$;
import play.api.test.PlayRunners$;
import play.api.test.WebDriverFactory;
import play.core.j.JavaHandler;
import play.core.j.JavaHandlerComponents;
import play.http.HttpEntity;
import play.libs.F;
import play.libs.Scala;
import play.mvc.Call;
import play.mvc.Http;
import play.routing.Router;
import play.test.FakeApplication;
import play.test.TestBrowser;
import play.test.TestServer;
import play.twirl.api.Content;
import scala.Option;
import scala.concurrent.Future;

public class Helpers
implements Http.Status,
Http.HeaderNames {
    public static String GET = "GET";
    public static String POST = "POST";
    public static String PUT = "PUT";
    public static String DELETE = "DELETE";
    public static String HEAD = "HEAD";
    public static Class<? extends WebDriver> HTMLUNIT = HtmlUnitDriver.class;
    public static Class<? extends WebDriver> FIREFOX = FirefoxDriver.class;
    public static final long DEFAULT_TIMEOUT = Long.getLong("test.timeout", 30000L);

    private static play.mvc.Result invokeHandler(Handler handler, Http.Request request, long l) {
        if (handler instanceof Action) {
            Action action = (Action)handler;
            return Helpers.wrapScalaResult((Future<Result>)action.apply(request._underlyingRequest()), l);
        }
        if (handler instanceof JavaHandler) {
            Injector injector = Play.current().injector();
            return Helpers.invokeHandler(((JavaHandler)handler).withComponents((JavaHandlerComponents)injector.instanceOf(JavaHandlerComponents.class)), request, l);
        }
        throw new RuntimeException("This is not a JavaAction and can't be invoked this way.");
    }

    private static play.mvc.Result wrapScalaResult(Future<Result> future, long l) {
        if (future == null) {
            return null;
        }
        Result result = (Result)F.Promise.wrap(future).get(l);
        return result.asJava();
    }

    public static <V> V invokeWithContext(Http.RequestBuilder requestBuilder, Callable<V> callable) {
        try {
            Http.Context.current.set(new Http.Context(requestBuilder));
            V v = callable.call();
            return v;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        finally {
            Http.Context.current.remove();
        }
    }

    public static Http.RequestBuilder fakeRequest() {
        return Helpers.fakeRequest("GET", "/");
    }

    public static Http.RequestBuilder fakeRequest(String string, String string2) {
        return new Http.RequestBuilder().method(string).uri(string2);
    }

    public static Http.RequestBuilder fakeRequest(Call call2) {
        return Helpers.fakeRequest(call2.method(), call2.url());
    }

    public static Application fakeApplication() {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), new HashMap(), null);
    }

    @Deprecated
    public static Application fakeApplication(GlobalSettings globalSettings) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), new HashMap(), globalSettings);
    }

    @Deprecated
    public static GlobalSettings fakeGlobal() {
        return new GlobalSettings();
    }

    public static Map<String, String> inMemoryDatabase() {
        return Helpers.inMemoryDatabase("default");
    }

    public static Map<String, String> inMemoryDatabase(String string) {
        return Helpers.inMemoryDatabase(string, Collections.emptyMap());
    }

    public static Map<String, String> inMemoryDatabase(String string, Map<String, String> map) {
        return Scala.asJava(play.api.test.Helpers.inMemoryDatabase(string, (scala.collection.immutable.Map<String, String>)Scala.asScala(map)));
    }

    public static Application fakeApplication(Map<String, ? extends Object> map) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), map);
    }

    @Deprecated
    public static Application fakeApplication(Map<String, ? extends Object> map, GlobalSettings globalSettings) {
        return new FakeApplication(new File("."), Helpers.class.getClassLoader(), map, globalSettings);
    }

    public static ByteString contentAsBytes(play.mvc.Result result) {
        if (result.body() instanceof HttpEntity.Strict) {
            return ((HttpEntity.Strict)result.body()).data();
        }
        throw new UnsupportedOperationException("Tried to extract body from a non strict HTTP entity without a materializer, use the version of this method that accepts a materializer instead");
    }

    public static ByteString contentAsBytes(play.mvc.Result result, Materializer materializer) {
        return Helpers.contentAsBytes(result, materializer, DEFAULT_TIMEOUT);
    }

    public static ByteString contentAsBytes(play.mvc.Result result, Materializer materializer, long l) {
        try {
            return (ByteString)result.body().consumeData(materializer).thenApply(Function.identity()).toCompletableFuture().get(l, TimeUnit.MILLISECONDS);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static ByteString contentAsBytes(Content content) {
        return ByteString.fromString((String)content.body());
    }

    public static String contentAsString(Content content) {
        return content.body();
    }

    public static String contentAsString(play.mvc.Result result) {
        return Helpers.contentAsBytes(result).decodeString(result.charset().orElse("utf-8"));
    }

    public static String contentAsString(play.mvc.Result result, Materializer materializer) {
        return Helpers.contentAsBytes(result, materializer, DEFAULT_TIMEOUT).decodeString(result.charset().orElse("utf-8"));
    }

    public static String contentAsString(play.mvc.Result result, Materializer materializer, long l) {
        return Helpers.contentAsBytes(result, materializer, l).decodeString(result.charset().orElse("utf-8"));
    }

    public static play.mvc.Result routeAndCall(Http.RequestBuilder requestBuilder, long l) {
        try {
            return Helpers.routeAndCall(Http.RequestBuilder.class.getClassLoader().loadClass("Routes"), requestBuilder, l);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static play.mvc.Result routeAndCall(Class<? extends Router> clazz, Http.RequestBuilder requestBuilder, long l) {
        try {
            Http.RequestImpl requestImpl = requestBuilder.build();
            Router router = (Router)clazz.getClassLoader().loadClass(clazz.getName() + "$").getDeclaredField("MODULE$").get(null);
            return router.route((Http.RequestHeader)requestImpl).map(arg_0 -> Helpers.lambda$routeAndCall$0((Http.Request)requestImpl, l, arg_0)).orElse(null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static play.mvc.Result routeAndCall(Router router, Http.RequestBuilder requestBuilder) {
        return Helpers.routeAndCall(router, requestBuilder, DEFAULT_TIMEOUT);
    }

    public static play.mvc.Result routeAndCall(Router router, Http.RequestBuilder requestBuilder, long l) {
        try {
            Http.RequestImpl requestImpl = requestBuilder.build();
            return router.route((Http.RequestHeader)requestImpl).map(arg_0 -> Helpers.lambda$routeAndCall$1((Http.Request)requestImpl, l, arg_0)).orElse(null);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static play.mvc.Result route(Call call2) {
        return Helpers.route(Helpers.fakeRequest(call2));
    }

    public static play.mvc.Result route(Call call2, long l) {
        return Helpers.route(Helpers.fakeRequest(call2), l);
    }

    public static play.mvc.Result route(Application application, Call call2) {
        return Helpers.route(application, Helpers.fakeRequest(call2));
    }

    public static play.mvc.Result route(Application application, Call call2, long l) {
        return Helpers.route(application, Helpers.fakeRequest(call2), l);
    }

    public static play.mvc.Result route(Http.RequestBuilder requestBuilder) {
        return Helpers.route(requestBuilder, DEFAULT_TIMEOUT);
    }

    public static play.mvc.Result route(Http.RequestBuilder requestBuilder, long l) {
        Application application = (Application)Play.current().injector().instanceOf(Application.class);
        return Helpers.route(application, requestBuilder, l);
    }

    public static play.mvc.Result route(Application application, Http.RequestBuilder requestBuilder) {
        return Helpers.route(application, requestBuilder, DEFAULT_TIMEOUT);
    }

    public static play.mvc.Result route(Application application, Http.RequestBuilder requestBuilder, long l) {
        Option<Future<Result>> option = play.api.test.Helpers.jRoute(application.getWrappedApplication(), (RequestHeader)requestBuilder.build()._underlyingRequest(), requestBuilder.body());
        return Helpers.wrapScalaResult((Future<Result>)((Future)Scala.orNull(option)), l);
    }

    public static void start(Application application) {
        Play.start((play.api.Application)application.getWrappedApplication());
    }

    public static void stop(Application application) {
        Play.stop((play.api.Application)application.getWrappedApplication());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void running(Application application, Runnable runnable) {
        Object object = PlayRunners$.MODULE$.mutex();
        synchronized (object) {
            try {
                Helpers.start(application);
                runnable.run();
            }
            finally {
                Helpers.stop(application);
            }
        }
    }

    public static TestServer testServer() {
        return Helpers.testServer(play.api.test.Helpers.testServerPort());
    }

    public static TestServer testServer(Application application) {
        return Helpers.testServer(play.api.test.Helpers.testServerPort(), application);
    }

    public static TestServer testServer(int n) {
        return new TestServer(n, Helpers.fakeApplication());
    }

    public static TestServer testServer(int n, Application application) {
        return new TestServer(n, application);
    }

    public static void start(TestServer testServer) {
        testServer.start();
    }

    public static void stop(TestServer testServer) {
        testServer.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void running(TestServer testServer, Runnable runnable) {
        Object object = PlayRunners$.MODULE$.mutex();
        synchronized (object) {
            try {
                Helpers.start(testServer);
                runnable.run();
            }
            finally {
                Helpers.stop(testServer);
            }
        }
    }

    public static void running(TestServer testServer, Class<? extends WebDriver> clazz, Consumer<TestBrowser> consumer) {
        Helpers.running(testServer, WebDriverFactory.apply(clazz), consumer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void running(TestServer testServer, WebDriver webDriver, Consumer<TestBrowser> consumer) {
        Object object = PlayRunners$.MODULE$.mutex();
        synchronized (object) {
            TestBrowser testBrowser = null;
            TestServer testServer2 = null;
            try {
                Helpers.start(testServer);
                testServer2 = testServer;
                testBrowser = Helpers.testBrowser(webDriver, testServer.port());
                consumer.accept(testBrowser);
            }
            finally {
                if (testBrowser != null) {
                    testBrowser.quit();
                }
                if (testServer2 != null) {
                    Helpers.stop(testServer2);
                }
            }
        }
    }

    public static TestBrowser testBrowser() {
        return Helpers.testBrowser(HTMLUNIT);
    }

    public static TestBrowser testBrowser(int n) {
        return Helpers.testBrowser(HTMLUNIT, n);
    }

    public static TestBrowser testBrowser(Class<? extends WebDriver> clazz) {
        return Helpers.testBrowser(clazz, Helpers$.MODULE$.testServerPort());
    }

    public static TestBrowser testBrowser(Class<? extends WebDriver> clazz, int n) {
        try {
            return new TestBrowser(clazz, "http://localhost:" + n);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static TestBrowser testBrowser(WebDriver webDriver, int n) {
        return new TestBrowser(webDriver, "http://localhost:" + n);
    }

    public static TestBrowser testBrowser(WebDriver webDriver) {
        return Helpers.testBrowser(webDriver, Helpers$.MODULE$.testServerPort());
    }

    private static /* synthetic */ play.mvc.Result lambda$routeAndCall$1(Http.Request request, long l, Handler handler) {
        return Helpers.invokeHandler(handler, request, l);
    }

    private static /* synthetic */ play.mvc.Result lambda$routeAndCall$0(Http.Request request, long l, Handler handler) {
        return Helpers.invokeHandler(handler, request, l);
    }
}

