/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws.ahc;

import akka.stream.Graph;
import akka.stream.Materializer;
import akka.stream.javadsl.AsPublisher;
import akka.stream.javadsl.Sink;
import akka.stream.javadsl.Source;
import akka.util.ByteString;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.asynchttpclient.AsyncCompletionHandler;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.Realm;
import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;
import org.asynchttpclient.Response;
import org.asynchttpclient.SignatureCalculator;
import org.asynchttpclient.oauth.OAuthSignatureCalculator;
import org.asynchttpclient.request.body.generator.BodyGenerator;
import org.asynchttpclient.request.body.generator.ByteArrayBodyGenerator;
import org.asynchttpclient.request.body.generator.FileBodyGenerator;
import org.asynchttpclient.request.body.generator.InputStreamBodyGenerator;
import org.asynchttpclient.util.HttpUtils;
import org.reactivestreams.Publisher;
import play.api.libs.ws.ahc.Streamed;
import play.core.parsers.FormUrlEncodedParser;
import play.libs.Json;
import play.libs.oauth.OAuth;
import play.libs.ws.StreamedResponse;
import play.libs.ws.WSAuthScheme;
import play.libs.ws.WSRequest;
import play.libs.ws.WSRequestExecutor;
import play.libs.ws.WSRequestFilter;
import play.libs.ws.WSResponse;
import play.libs.ws.WSSignatureCalculator;
import play.libs.ws.ahc.AhcWSClient;
import play.libs.ws.ahc.AhcWSResponse;
import play.mvc.Http;
import play.mvc.MultipartFormatter;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;

public class AhcWSRequest
implements WSRequest {
    private final String url;
    private String method = "GET";
    private Object body = null;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private final Map<String, List<String>> queryParameters = new HashMap<String, List<String>>();
    private String username;
    private String password;
    private WSAuthScheme scheme;
    private WSSignatureCalculator calculator;
    private final AhcWSClient client;
    private final Materializer materializer;
    private int timeout = 0;
    private Boolean followRedirects = null;
    private String virtualHost = null;
    private final ArrayList<WSRequestFilter> filters = new ArrayList();

    public AhcWSRequest(AhcWSClient ahcWSClient, String string, Materializer materializer) {
        this.client = ahcWSClient;
        URI uRI = URI.create(string);
        this.url = string;
        this.materializer = materializer;
        String string2 = uRI.getUserInfo();
        if (string2 != null) {
            this.setAuth(string2);
        }
        if (uRI.getQuery() != null) {
            this.setQueryString(uRI.getQuery());
        }
    }

    @Override
    public AhcWSRequest setHeader(String string, String string2) {
        this.addValueTo(this.headers, string, string2);
        return this;
    }

    @Override
    public WSRequest setQueryString(String string) {
        String[] stringArray;
        for (String string2 : stringArray = string.split("&")) {
            String[] stringArray2 = string2.split("=");
            if (stringArray2.length > 2) {
                throw new RuntimeException(new MalformedURLException("QueryString parameter should not have more than 2 = per part"));
            }
            if (stringArray2.length >= 2) {
                this.setQueryParameter(stringArray2[0], stringArray2[1]);
                continue;
            }
            if (stringArray2.length == 1 && string2.charAt(0) != '=') {
                this.setQueryParameter(stringArray2[0], null);
                continue;
            }
            throw new RuntimeException(new MalformedURLException("QueryString part should not start with an = and not be empty"));
        }
        return this;
    }

    @Override
    public WSRequest setQueryParameter(String string, String string2) {
        this.addValueTo(this.queryParameters, string, string2);
        return this;
    }

    @Override
    public WSRequest setAuth(String string) {
        this.scheme = WSAuthScheme.BASIC;
        if (string.equals("")) {
            throw new RuntimeException(new MalformedURLException("userInfo should not be empty"));
        }
        int n = string.indexOf(":");
        if (n == 0) {
            this.username = "";
            this.password = string.substring(1);
        } else if (n == -1) {
            this.username = string;
            this.password = "";
        } else {
            this.username = string.substring(0, n);
            this.password = string.substring(n + 1);
        }
        return this;
    }

    @Override
    public WSRequest setAuth(String string, String string2) {
        this.username = string;
        this.password = string2;
        this.scheme = WSAuthScheme.BASIC;
        return this;
    }

    @Override
    public WSRequest setAuth(String string, String string2, WSAuthScheme wSAuthScheme) {
        this.username = string;
        this.password = string2;
        this.scheme = wSAuthScheme;
        return this;
    }

    @Override
    public WSRequest sign(WSSignatureCalculator wSSignatureCalculator) {
        this.calculator = wSSignatureCalculator;
        return this;
    }

    @Override
    public WSRequest setFollowRedirects(Boolean bl) {
        this.followRedirects = bl;
        return this;
    }

    @Override
    public WSRequest setVirtualHost(String string) {
        this.virtualHost = string;
        return this;
    }

    @Override
    public WSRequest setRequestTimeout(long l) {
        if (l < -1L || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Timeout must be between -1 and 2147483647 inclusive");
        }
        this.timeout = (int)l;
        return this;
    }

    @Override
    public WSRequest setContentType(String string) {
        return this.setHeader("Content-Type", string);
    }

    @Override
    public WSRequest setMethod(String string) {
        this.method = string;
        return this;
    }

    @Override
    public WSRequest setBody(String string) {
        this.body = string;
        return this;
    }

    @Override
    public WSRequest setBody(JsonNode jsonNode) {
        this.body = jsonNode;
        return this;
    }

    @Override
    public WSRequest setBody(InputStream inputStream) {
        this.body = inputStream;
        return this;
    }

    @Override
    public WSRequest setBody(File file) {
        this.body = file;
        return this;
    }

    @Override
    public WSRequest setBody(Source<ByteString, ?> source) {
        this.body = source;
        return this;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public Map<String, Collection<String>> getHeaders() {
        return new HashMap<String, Collection<String>>(this.headers);
    }

    @Override
    public Map<String, Collection<String>> getQueryParameters() {
        return new HashMap<String, Collection<String>>(this.queryParameters);
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public WSAuthScheme getScheme() {
        return this.scheme;
    }

    @Override
    public WSSignatureCalculator getCalculator() {
        return this.calculator;
    }

    @Override
    public long getRequestTimeout() {
        return this.timeout;
    }

    @Override
    public Boolean getFollowRedirects() {
        return this.followRedirects;
    }

    String getVirtualHost() {
        return this.virtualHost;
    }

    @Override
    public CompletionStage<WSResponse> get() {
        return this.execute("GET");
    }

    @Override
    public CompletionStage<WSResponse> patch(String string) {
        this.setMethod("PATCH");
        this.setBody(string);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> patch(JsonNode jsonNode) {
        this.setMethod("PATCH");
        this.setBody(jsonNode);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> patch(InputStream inputStream) {
        this.setMethod("PATCH");
        this.setBody(inputStream);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> patch(File file) {
        this.setMethod("PATCH");
        this.setBody(file);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> patch(Source<? super Http.MultipartFormData.Part<Source<ByteString, ?>>, ?> source) {
        this.setMethod("PATCH");
        return this.executeWithBody(source);
    }

    @Override
    public CompletionStage<WSResponse> post(String string) {
        this.setMethod("POST");
        this.setBody(string);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> post(JsonNode jsonNode) {
        this.setMethod("POST");
        this.setBody(jsonNode);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> post(InputStream inputStream) {
        this.setMethod("POST");
        this.setBody(inputStream);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> post(File file) {
        this.setMethod("POST");
        this.setBody(file);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> post(Source<? super Http.MultipartFormData.Part<Source<ByteString, ?>>, ?> source) {
        this.setMethod("POST");
        return this.executeWithBody(source);
    }

    @Override
    public CompletionStage<WSResponse> put(String string) {
        this.setMethod("PUT");
        this.setBody(string);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> put(JsonNode jsonNode) {
        this.setMethod("PUT");
        this.setBody(jsonNode);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> put(InputStream inputStream) {
        this.setMethod("PUT");
        this.setBody(inputStream);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> put(File file) {
        this.setMethod("PUT");
        this.setBody(file);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> put(Source<? super Http.MultipartFormData.Part<Source<ByteString, ?>>, ?> source) {
        this.setMethod("PUT");
        return this.executeWithBody(source);
    }

    @Override
    public CompletionStage<WSResponse> delete() {
        return this.execute("DELETE");
    }

    @Override
    public CompletionStage<WSResponse> head() {
        return this.execute("HEAD");
    }

    @Override
    public CompletionStage<WSResponse> options() {
        return this.execute("OPTIONS");
    }

    @Override
    public CompletionStage<WSResponse> execute(String string) {
        this.setMethod(string);
        return this.execute();
    }

    @Override
    public CompletionStage<WSResponse> execute() {
        WSRequestExecutor wSRequestExecutor = this.foldRight(wSRequest -> {
            AhcWSRequest ahcWSRequest = (AhcWSRequest)wSRequest;
            Request request = ahcWSRequest.buildRequest();
            return ahcWSRequest.execute(request);
        }, this.filters.iterator());
        return wSRequestExecutor.apply(this);
    }

    private CompletionStage<WSResponse> executeWithBody(Source<? super Http.MultipartFormData.Part<Source<ByteString, ?>>, ?> source) {
        String string = MultipartFormatter.randomBoundary();
        Source source2 = MultipartFormatter.transform(source, (String)string);
        this.setBody(source2);
        this.setHeader("Content-Type", MultipartFormatter.boundaryToContentType((String)string));
        return this.execute();
    }

    @Override
    public CompletionStage<StreamedResponse> stream() {
        AsyncHttpClient asyncHttpClient = (AsyncHttpClient)this.client.getUnderlying();
        Request request = this.buildRequest();
        return StreamedResponse.from((Future<play.api.libs.ws.StreamedResponse>)Streamed.execute((AsyncHttpClient)asyncHttpClient, (Request)request));
    }

    @Override
    public WSRequest withRequestFilter(WSRequestFilter wSRequestFilter) {
        this.filters.add(wSRequestFilter);
        return this;
    }

    Request buildRequest() {
        boolean bl = true;
        DefaultHttpHeaders defaultHttpHeaders = new DefaultHttpHeaders(bl);
        this.headers.forEach((arg_0, arg_1) -> ((HttpHeaders)defaultHttpHeaders).add(arg_0, arg_1));
        RequestBuilder requestBuilder = new RequestBuilder(this.method);
        requestBuilder.setUrl(this.url);
        requestBuilder.setQueryParams(this.queryParameters);
        if (this.body != null) {
            if (this.body instanceof String) {
                String string2 = (String)this.body;
                String string3 = defaultHttpHeaders.get("Content-Type");
                if (string3 == null) {
                    string3 = "text/plain";
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string3);
                defaultHttpHeaders.set("Content-Type", arrayList);
                Charset charset = HttpUtils.parseCharset((String)string3);
                if (charset == null) {
                    charset = StandardCharsets.UTF_8;
                }
                byte[] byArray = string2.getBytes(charset);
                if (string3.equals("application/x-www-form-urlencoded") && this.calculator != null) {
                    defaultHttpHeaders.remove("Content-Length");
                    Map map = FormUrlEncodedParser.parseAsJava((String)string2, (String)"utf-8");
                    map.forEach((string, list) -> list.forEach(string2 -> {
                        RequestBuilder cfr_ignored_0 = (RequestBuilder)requestBuilder.addFormParam(string, string2);
                    }));
                } else {
                    requestBuilder.setBody(string2);
                }
                requestBuilder.setCharset(charset);
            } else if (this.body instanceof JsonNode) {
                byte[] byArray;
                JsonNode jsonNode = (JsonNode)this.body;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add("application/json");
                defaultHttpHeaders.set("Content-Type", arrayList);
                try {
                    byArray = Json.mapper().writeValueAsBytes((Object)jsonNode);
                }
                catch (JsonProcessingException jsonProcessingException) {
                    throw new RuntimeException(jsonProcessingException);
                }
                requestBuilder.setBody((BodyGenerator)new ByteArrayBodyGenerator(byArray));
            } else if (this.body instanceof File) {
                File file = (File)this.body;
                FileBodyGenerator fileBodyGenerator = new FileBodyGenerator(file);
                requestBuilder.setBody((BodyGenerator)fileBodyGenerator);
            } else if (this.body instanceof InputStream) {
                InputStream inputStream = (InputStream)this.body;
                InputStreamBodyGenerator inputStreamBodyGenerator = new InputStreamBodyGenerator(inputStream);
                requestBuilder.setBody((BodyGenerator)inputStreamBodyGenerator);
            } else if (this.body instanceof Source) {
                long l = Optional.ofNullable(defaultHttpHeaders.get("Content-Length")).map(Long::valueOf).orElse(-1L);
                defaultHttpHeaders.remove("Content-Length");
                Source source = (Source)this.body;
                Publisher publisher = (Publisher)source.map(ByteString::toByteBuffer).runWith((Graph)Sink.asPublisher((AsPublisher)AsPublisher.WITHOUT_FANOUT), this.materializer);
                requestBuilder.setBody(publisher, l);
            } else {
                throw new IllegalStateException("Impossible body: " + this.body);
            }
        }
        requestBuilder.setHeaders((HttpHeaders)defaultHttpHeaders);
        if (this.timeout == -1 || this.timeout > 0) {
            requestBuilder.setRequestTimeout(this.timeout);
        }
        if (this.followRedirects != null) {
            requestBuilder.setFollowRedirect(this.followRedirects.booleanValue());
        }
        if (this.virtualHost != null) {
            requestBuilder.setVirtualHost(this.virtualHost);
        }
        if (this.username != null && this.password != null && this.scheme != null) {
            requestBuilder.setRealm(this.auth(this.username, this.password, this.scheme));
        }
        if (this.calculator != null) {
            if (this.calculator instanceof OAuth.OAuthCalculator) {
                OAuthSignatureCalculator oAuthSignatureCalculator = ((OAuth.OAuthCalculator)this.calculator).getCalculator();
                requestBuilder.setSignatureCalculator((SignatureCalculator)oAuthSignatureCalculator);
            } else if (this.calculator instanceof SignatureCalculator) {
                SignatureCalculator signatureCalculator = (SignatureCalculator)this.calculator;
                requestBuilder.setSignatureCalculator(signatureCalculator);
            } else {
                throw new IllegalStateException("Use OAuth.OAuthCalculator");
            }
        }
        return requestBuilder.build();
    }

    private void addValueTo(Map<String, List<String>> map, String string, String string2) {
        if (map.containsKey(string)) {
            Collection collection = map.get(string);
            collection.add(string2);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string2);
            map.put(string, arrayList);
        }
    }

    private CompletionStage<WSResponse> execute(Request request) {
        final Promise promise = Promise$.MODULE$.apply();
        try {
            AsyncHttpClient asyncHttpClient = (AsyncHttpClient)this.client.getUnderlying();
            asyncHttpClient.executeRequest(request, (AsyncHandler)new AsyncCompletionHandler<Response>(){

                public Response onCompleted(Response response) {
                    promise.success((Object)new AhcWSResponse(response));
                    return response;
                }

                public void onThrowable(Throwable throwable) {
                    promise.failure(throwable);
                }
            });
        }
        catch (RuntimeException runtimeException) {
            promise.failure((Throwable)runtimeException);
        }
        return FutureConverters.toJava((Future)promise.future());
    }

    private <U> WSRequestExecutor foldRight(WSRequestExecutor wSRequestExecutor, Iterator<WSRequestFilter> iterator) {
        if (!iterator.hasNext()) {
            return wSRequestExecutor;
        }
        WSRequestFilter wSRequestFilter = iterator.next();
        return this.foldRight(wSRequestFilter.apply(wSRequestExecutor), iterator);
    }

    Realm auth(String string, String string2, WSAuthScheme wSAuthScheme) {
        Realm.AuthScheme authScheme = Realm.AuthScheme.valueOf((String)wSAuthScheme.name());
        return new Realm.Builder(string, string2).setScheme(authScheme).setUsePreemptiveAuth(true).build();
    }
}

