/*
 * Decompiled with CFR 0.152.
 */
package play.libs.ws;

import akka.stream.javadsl.Source;
import akka.util.ByteString;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import play.libs.ws.DefaultWSResponseHeaders;
import play.libs.ws.WSResponseHeaders;
import play.libs.ws.util.CollectionUtil;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.compat.java8.FutureConverters;
import scala.concurrent.Future;

public class StreamedResponse {
    private final WSResponseHeaders headers;
    private final Source<ByteString, ?> body;

    private StreamedResponse(WSResponseHeaders wSResponseHeaders, Source<ByteString, ?> source) {
        this.headers = wSResponseHeaders;
        this.body = source;
    }

    public WSResponseHeaders getHeaders() {
        return this.headers;
    }

    public Source<ByteString, ?> getBody() {
        return this.body;
    }

    public static CompletionStage<StreamedResponse> from(Future<play.api.libs.ws.StreamedResponse> future) {
        CompletionStage completionStage = FutureConverters.toJava(future);
        Function<play.api.libs.ws.StreamedResponse, StreamedResponse> function = streamedResponse -> {
            WSResponseHeaders wSResponseHeaders = StreamedResponse.toJavaHeaders(streamedResponse.headers());
            Source source = streamedResponse.body().asJava();
            return new StreamedResponse(wSResponseHeaders, source);
        };
        return completionStage.thenApply(function);
    }

    private static WSResponseHeaders toJavaHeaders(play.api.libs.ws.WSResponseHeaders wSResponseHeaders) {
        return new DefaultWSResponseHeaders(wSResponseHeaders.status(), CollectionUtil.convert((Map<String, Seq<String>>)wSResponseHeaders.headers()));
    }
}

