/*
 * Decompiled with CFR 0.152.
 */
package akka.cluster;

import akka.actor.Actor;
import akka.actor.ActorContext;
import akka.actor.ActorLogging;
import akka.actor.ActorRef;
import akka.actor.ActorSelection$;
import akka.actor.Address;
import akka.actor.Cancellable;
import akka.actor.ExtendedActorSystem;
import akka.actor.SupervisorStrategy;
import akka.actor.package$;
import akka.cluster.Cluster;
import akka.cluster.Cluster$;
import akka.cluster.ClusterEvent;
import akka.cluster.InternalClusterAction;
import akka.cluster.InternalClusterAction$GossipTick$;
import akka.cluster.InternalClusterAction$MetricsTick$;
import akka.cluster.Member;
import akka.cluster.Member$;
import akka.cluster.MemberStatus;
import akka.cluster.MemberStatus$Up$;
import akka.cluster.MetricsCollector;
import akka.cluster.MetricsCollector$;
import akka.cluster.MetricsGossip;
import akka.cluster.MetricsGossip$;
import akka.cluster.MetricsGossipEnvelope;
import akka.event.LoggingAdapter;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Set;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.SortedSet$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.forkjoin.ThreadLocalRandom;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005uc!B\u0001\u0003\u0001\t1!aF\"mkN$XM]'fiJL7m]\"pY2,7\r^8s\u0015\t\u0019A!A\u0004dYV\u001cH/\u001a:\u000b\u0003\u0015\tA!Y6lCN!\u0001aB\u0007\u0014!\tA1\"D\u0001\n\u0015\u0005Q\u0011!B:dC2\f\u0017B\u0001\u0007\n\u0005\u0019\te.\u001f*fMB\u0011a\"E\u0007\u0002\u001f)\u0011\u0001\u0003B\u0001\u0006C\u000e$xN]\u0005\u0003%=\u0011Q!Q2u_J\u0004\"A\u0004\u000b\n\u0005Uy!\u0001D!di>\u0014Hj\\4hS:<\u0007\u0002C\f\u0001\u0005\u0003\u0005\u000b\u0011B\r\u0002\u0013A,(\r\\5tQ\u0016\u00148\u0001\u0001\t\u0003\u001diI!aG\b\u0003\u0011\u0005\u001bGo\u001c:SK\u001aDQ!\b\u0001\u0005\u0002y\ta\u0001P5oSRtDCA\u0010\"!\t\u0001\u0003!D\u0001\u0003\u0011\u00159B\u00041\u0001\u001a\u0011\u001d\u0019\u0001A1A\u0005\u0002\r*\u0012\u0001\n\t\u0003A\u0015J!A\n\u0002\u0003\u000f\rcWo\u001d;fe\"1\u0001\u0006\u0001Q\u0001\n\u0011\n\u0001b\u00197vgR,'\u000f\t\u0005\bU\u0001\u0001\r\u0011\"\u0001,\u0003\u0015qw\u000eZ3t+\u0005a\u0003cA\u00173i5\taF\u0003\u00020a\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0003c%\t!bY8mY\u0016\u001cG/[8o\u0013\t\u0019dFA\u0005T_J$X\rZ*fiB\u0011a\"N\u0005\u0003m=\u0011q!\u00113ee\u0016\u001c8\u000fC\u00049\u0001\u0001\u0007I\u0011A\u001d\u0002\u00139|G-Z:`I\u0015\fHC\u0001\u001e>!\tA1(\u0003\u0002=\u0013\t!QK\\5u\u0011\u001dqt'!AA\u00021\n1\u0001\u001f\u00132\u0011\u0019\u0001\u0005\u0001)Q\u0005Y\u00051an\u001c3fg\u0002BqA\u0011\u0001A\u0002\u0013\u00051)\u0001\u0007mCR,7\u000f^$pgNL\u0007/F\u0001E!\t\u0001S)\u0003\u0002G\u0005\tiQ*\u001a;sS\u000e\u001cxi\\:tSBDq\u0001\u0013\u0001A\u0002\u0013\u0005\u0011*\u0001\tmCR,7\u000f^$pgNL\u0007o\u0018\u0013fcR\u0011!H\u0013\u0005\b}\u001d\u000b\t\u00111\u0001E\u0011\u0019a\u0005\u0001)Q\u0005\t\u0006iA.\u0019;fgR<un]:ja\u0002BqA\u0014\u0001C\u0002\u0013\u0005q*A\u0005d_2dWm\u0019;peV\t\u0001\u000b\u0005\u0002!#&\u0011!K\u0001\u0002\u0011\u001b\u0016$(/[2t\u0007>dG.Z2u_JDa\u0001\u0016\u0001!\u0002\u0013\u0001\u0016AC2pY2,7\r^8sA!9a\u000b\u0001b\u0001\n\u00039\u0016AC4pgNL\u0007\u000fV1tWV\t\u0001\f\u0005\u0002\u000f3&\u0011!l\u0004\u0002\f\u0007\u0006t7-\u001a7mC\ndW\r\u0003\u0004]\u0001\u0001\u0006I\u0001W\u0001\fO>\u001c8/\u001b9UCN\\\u0007\u0005C\u0004_\u0001\t\u0007I\u0011A,\u0002\u00175,GO]5dgR\u000b7o\u001b\u0005\u0007A\u0002\u0001\u000b\u0011\u0002-\u0002\u00195,GO]5dgR\u000b7o\u001b\u0011\t\u000b\t\u0004A\u0011I2\u0002\u0011A\u0014Xm\u0015;beR$\u0012A\u000f\u0005\u0006K\u0002!\tAZ\u0001\be\u0016\u001cW-\u001b<f+\u00059\u0007\u0003\u0002\u0005iUjJ!![\u0005\u0003\u001fA\u000b'\u000f^5bY\u001a+hn\u0019;j_:\u0004\"\u0001C6\n\u00051L!aA!os\")a\u000e\u0001C!G\u0006A\u0001o\\:u'R|\u0007\u000fC\u0003q\u0001\u0011\u0005\u0011/A\u0005bI\u0012lU-\u001c2feR\u0011!H\u001d\u0005\u0006g>\u0004\r\u0001^\u0001\u0007[\u0016l'-\u001a:\u0011\u0005\u0001*\u0018B\u0001<\u0003\u0005\u0019iU-\u001c2fe\")\u0001\u0010\u0001C\u0001s\u0006a!/Z7pm\u0016lU-\u001c2feR\u0011!H\u001f\u0005\u0006g^\u0004\r\u0001\u001e\u0005\u0006y\u0002!\t!`\u0001\re\u0016\u001cW-\u001b<f'R\fG/\u001a\u000b\u0003uyDaa`>A\u0002\u0005\u0005\u0011!B:uCR,\u0007\u0003BA\u0002\u0003\u0013q1\u0001IA\u0003\u0013\r\t9AA\u0001\r\u00072,8\u000f^3s\u000bZ,g\u000e^\u0005\u0005\u0003\u0017\tiAA\nDkJ\u0014XM\u001c;DYV\u001cH/\u001a:Ti\u0006$XMC\u0002\u0002\b\tAa!!\u0005\u0001\t\u0003\u0019\u0017aB2pY2,7\r\u001e\u0005\b\u0003+\u0001A\u0011AA\f\u00035\u0011XmY3jm\u0016<un]:jaR\u0019!(!\u0007\t\u0011\u0005m\u00111\u0003a\u0001\u0003;\t\u0001\"\u001a8wK2|\u0007/\u001a\t\u0004A\u0005}\u0011bAA\u0011\u0005\t)R*\u001a;sS\u000e\u001cxi\\:tSB,eN^3m_B,\u0007BBA\u0013\u0001\u0011\u00051-\u0001\u0004h_N\u001c\u0018\u000e\u001d\u0005\b\u0003S\u0001A\u0011AA\u0016\u0003!9wn]:jaR{Gc\u0001\u001e\u0002.!9\u0011qFA\u0014\u0001\u0004!\u0014aB1eIJ,7o\u001d\u0005\b\u0003g\u0001A\u0011AA\u001b\u00035\u0011X\r\u001d7z\u000f>\u001c8/\u001b9U_R\u0019!(a\u000e\t\u000f\u0005=\u0012\u0011\u0007a\u0001i!9\u00111\b\u0001\u0005\u0002\u0005u\u0012AC:f]\u0012<un]:jaR)!(a\u0010\u0002B!9\u0011qFA\u001d\u0001\u0004!\u0004\u0002CA\u000e\u0003s\u0001\r!!\b\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002H\u0005\u00012/\u001a7fGR\u0014\u0016M\u001c3p[:{G-\u001a\u000b\u0005\u0003\u0013\ny\u0005\u0005\u0003\t\u0003\u0017\"\u0014bAA'\u0013\t1q\n\u001d;j_:D\u0001\"!\u0015\u0002D\u0001\u0007\u00111K\u0001\nC\u0012$'/Z:tKN\u0004B!LA+i%\u0019\u0011q\u000b\u0018\u0003\u0015%sG-\u001a=fIN+\u0017\u000f\u0003\u0004\u0002\\\u0001!\taY\u0001\baV\u0014G.[:i\u0001")
public class ClusterMetricsCollector
implements Actor,
ActorLogging {
    private final ActorRef publisher;
    private final Cluster cluster;
    private SortedSet<Address> nodes;
    private MetricsGossip latestGossip;
    private final MetricsCollector collector;
    private final Cancellable gossipTask;
    private final Cancellable metricsTask;
    private LoggingAdapter akka$actor$ActorLogging$$_log;
    private final ActorContext context;
    private final ActorRef self;

    public LoggingAdapter akka$actor$ActorLogging$$_log() {
        return this.akka$actor$ActorLogging$$_log;
    }

    public void akka$actor$ActorLogging$$_log_$eq(LoggingAdapter x$1) {
        this.akka$actor$ActorLogging$$_log = x$1;
    }

    public LoggingAdapter log() {
        return ActorLogging.class.log((ActorLogging)this);
    }

    public ActorContext context() {
        return this.context;
    }

    public final ActorRef self() {
        return this.self;
    }

    public void akka$actor$Actor$_setter_$context_$eq(ActorContext x$1) {
        this.context = x$1;
    }

    public final void akka$actor$Actor$_setter_$self_$eq(ActorRef x$1) {
        this.self = x$1;
    }

    public final ActorRef sender() {
        return Actor.class.sender((Actor)this);
    }

    public void aroundReceive(PartialFunction<Object, BoxedUnit> receive2, Object msg) {
        Actor.class.aroundReceive((Actor)this, receive2, (Object)msg);
    }

    public void aroundPreStart() {
        Actor.class.aroundPreStart((Actor)this);
    }

    public void aroundPostStop() {
        Actor.class.aroundPostStop((Actor)this);
    }

    public void aroundPreRestart(Throwable reason, Option<Object> message) {
        Actor.class.aroundPreRestart((Actor)this, (Throwable)reason, message);
    }

    public void aroundPostRestart(Throwable reason) {
        Actor.class.aroundPostRestart((Actor)this, (Throwable)reason);
    }

    public SupervisorStrategy supervisorStrategy() {
        return Actor.class.supervisorStrategy((Actor)this);
    }

    public void preRestart(Throwable reason, Option<Object> message) throws Exception {
        Actor.class.preRestart((Actor)this, (Throwable)reason, message);
    }

    public void postRestart(Throwable reason) throws Exception {
        Actor.class.postRestart((Actor)this, (Throwable)reason);
    }

    public void unhandled(Object message) {
        Actor.class.unhandled((Actor)this, (Object)message);
    }

    public Cluster cluster() {
        return this.cluster;
    }

    public SortedSet<Address> nodes() {
        return this.nodes;
    }

    public void nodes_$eq(SortedSet<Address> x$1) {
        this.nodes = x$1;
    }

    public MetricsGossip latestGossip() {
        return this.latestGossip;
    }

    public void latestGossip_$eq(MetricsGossip x$1) {
        this.latestGossip = x$1;
    }

    public MetricsCollector collector() {
        return this.collector;
    }

    public Cancellable gossipTask() {
        return this.gossipTask;
    }

    public Cancellable metricsTask() {
        return this.metricsTask;
    }

    public void preStart() {
        this.cluster().subscribe(this.self(), (Seq<Class<?>>)Predef$.MODULE$.wrapRefArray((Object[])new Class[]{ClusterEvent.MemberEvent.class, ClusterEvent.ReachabilityEvent.class}));
        this.cluster().InfoLogger().logInfo("Metrics collection has started successfully");
    }

    public PartialFunction<Object, BoxedUnit> receive() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterMetricsCollector $outer;

            public final <A1, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                InternalClusterAction$GossipTick$ internalClusterAction$GossipTick$ = InternalClusterAction$GossipTick$.MODULE$;
                A1 A12 = A1;
                if (!(internalClusterAction$GossipTick$ != null ? !internalClusterAction$GossipTick$.equals(A12) : A12 != null)) {
                    this.$outer.gossip();
                    object = BoxedUnit.UNIT;
                } else {
                    InternalClusterAction$MetricsTick$ internalClusterAction$MetricsTick$ = InternalClusterAction$MetricsTick$.MODULE$;
                    A1 A13 = A1;
                    if (!(internalClusterAction$MetricsTick$ != null ? !internalClusterAction$MetricsTick$.equals(A13) : A13 != null)) {
                        this.$outer.collect();
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof MetricsGossipEnvelope) {
                        MetricsGossipEnvelope metricsGossipEnvelope = (MetricsGossipEnvelope)A1;
                        this.$outer.receiveGossip(metricsGossipEnvelope);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ClusterEvent.CurrentClusterState) {
                        ClusterEvent.CurrentClusterState currentClusterState = (ClusterEvent.CurrentClusterState)A1;
                        this.$outer.receiveState(currentClusterState);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ClusterEvent.MemberUp) {
                        ClusterEvent.MemberUp memberUp = (ClusterEvent.MemberUp)A1;
                        Member m = memberUp.member();
                        this.$outer.addMember(m);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ClusterEvent.MemberRemoved) {
                        ClusterEvent.MemberRemoved memberRemoved = (ClusterEvent.MemberRemoved)A1;
                        Member m = memberRemoved.member();
                        this.$outer.removeMember(m);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ClusterEvent.MemberExited) {
                        ClusterEvent.MemberExited memberExited = (ClusterEvent.MemberExited)A1;
                        Member m = memberExited.member();
                        this.$outer.removeMember(m);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ClusterEvent.UnreachableMember) {
                        ClusterEvent.UnreachableMember unreachableMember = (ClusterEvent.UnreachableMember)A1;
                        Member m = unreachableMember.member();
                        this.$outer.removeMember(m);
                        object = BoxedUnit.UNIT;
                    } else if (A1 instanceof ClusterEvent.ReachableMember) {
                        BoxedUnit boxedUnit;
                        ClusterEvent.ReachableMember reachableMember = (ClusterEvent.ReachableMember)A1;
                        Member m = reachableMember.member();
                        MemberStatus memberStatus = m.status();
                        MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                        if (!(memberStatus != null ? !memberStatus.equals(memberStatus$Up$) : memberStatus$Up$ != null)) {
                            this.$outer.addMember(m);
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        object = boxedUnit;
                    } else {
                        object = A1 instanceof ClusterEvent.MemberEvent ? BoxedUnit.UNIT : function1.apply(x1);
                    }
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Object x1) {
                boolean bl;
                Object object = x1;
                InternalClusterAction$GossipTick$ internalClusterAction$GossipTick$ = InternalClusterAction$GossipTick$.MODULE$;
                Object object2 = object;
                if (!(internalClusterAction$GossipTick$ != null ? !internalClusterAction$GossipTick$.equals(object2) : object2 != null)) {
                    bl = true;
                } else {
                    InternalClusterAction$MetricsTick$ internalClusterAction$MetricsTick$ = InternalClusterAction$MetricsTick$.MODULE$;
                    Object object3 = object;
                    bl = !(internalClusterAction$MetricsTick$ != null ? !internalClusterAction$MetricsTick$.equals(object3) : object3 != null) ? true : (object instanceof MetricsGossipEnvelope ? true : (object instanceof ClusterEvent.CurrentClusterState ? true : (object instanceof ClusterEvent.MemberUp ? true : (object instanceof ClusterEvent.MemberRemoved ? true : (object instanceof ClusterEvent.MemberExited ? true : (object instanceof ClusterEvent.UnreachableMember ? true : (object instanceof ClusterEvent.ReachableMember ? true : object instanceof ClusterEvent.MemberEvent)))))));
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public void postStop() {
        this.cluster().unsubscribe(this.self());
        this.gossipTask().cancel();
        this.metricsTask().cancel();
        this.collector().close();
    }

    public void addMember(Member member2) {
        this.nodes_$eq((SortedSet<Address>)((SortedSet)this.nodes().$plus((Object)member2.address())));
    }

    public void removeMember(Member member2) {
        this.nodes_$eq((SortedSet<Address>)((SortedSet)this.nodes().$minus((Object)member2.address())));
        this.latestGossip_$eq(this.latestGossip().remove(member2.address()));
        this.publish();
    }

    public void receiveState(ClusterEvent.CurrentClusterState state) {
        this.nodes_$eq((SortedSet<Address>)((SortedSet)state.members().collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Member, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                A1 A1 = x2;
                MemberStatus memberStatus = A1.status();
                MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                Object object = !(memberStatus != null ? !memberStatus.equals(memberStatus$Up$) : memberStatus$Up$ != null) ? A1.address() : function1.apply(x2);
                return (B1)object;
            }

            public final boolean isDefinedAt(Member x2) {
                Member member2 = x2;
                MemberStatus memberStatus = member2.status();
                MemberStatus$Up$ memberStatus$Up$ = MemberStatus$Up$.MODULE$;
                boolean bl = !(memberStatus != null ? !memberStatus.equals(memberStatus$Up$) : memberStatus$Up$ != null);
                return bl;
            }
        }, SortedSet$.MODULE$.newCanBuildFrom(Member$.MODULE$.addressOrdering()))));
    }

    public void collect() {
        this.latestGossip_$eq(this.latestGossip().$colon$plus(this.collector().sample()));
        this.publish();
    }

    public void receiveGossip(MetricsGossipEnvelope envelope) {
        MetricsGossip otherGossip = envelope.gossip().filter((Set<Address>)this.nodes());
        this.latestGossip_$eq(this.latestGossip().merge(otherGossip));
        if (!envelope.reply()) {
            this.replyGossipTo(envelope.from());
        }
    }

    public void gossip() {
        this.selectRandomNode((IndexedSeq<Address>)this.nodes().$minus((Object)this.cluster().selfAddress()).toVector()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ ClusterMetricsCollector $outer;

            public final void apply(Address address) {
                this.$outer.gossipTo(address);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public void gossipTo(Address address) {
        this.sendGossip(address, new MetricsGossipEnvelope(this.cluster().selfAddress(), this.latestGossip(), false));
    }

    public void replyGossipTo(Address address) {
        this.sendGossip(address, new MetricsGossipEnvelope(this.cluster().selfAddress(), this.latestGossip(), true));
    }

    public void sendGossip(Address address, MetricsGossipEnvelope envelope) {
        ActorSelection$.MODULE$.toScala(this.context().actorSelection(this.self().path().toStringWithAddress(address))).$bang((Object)envelope, this.self());
    }

    public Option<Address> selectRandomNode(IndexedSeq<Address> addresses) {
        return addresses.isEmpty() ? None$.MODULE$ : new Some(addresses.apply(ThreadLocalRandom.current().nextInt(addresses.size())));
    }

    public void publish() {
        package$.MODULE$.actorRef2Scala(this.publisher).$bang((Object)new InternalClusterAction.PublishEvent(new ClusterEvent.ClusterMetricsChanged(this.latestGossip().nodes())), this.self());
    }

    public ClusterMetricsCollector(ActorRef publisher) {
        this.publisher = publisher;
        Actor.class.$init$((Actor)this);
        ActorLogging.class.$init$((ActorLogging)this);
        this.cluster = (Cluster)Cluster$.MODULE$.apply(this.context().system());
        this.nodes = SortedSet$.MODULE$.empty(Member$.MODULE$.addressOrdering());
        this.latestGossip = MetricsGossip$.MODULE$.empty();
        this.collector = MetricsCollector$.MODULE$.apply((ExtendedActorSystem)this.context().system(), this.cluster().settings());
        this.gossipTask = this.cluster().scheduler().schedule(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().MetricsGossipInterval()), this.cluster().settings().MetricsGossipInterval(), this.self(), (Object)InternalClusterAction$GossipTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
        this.metricsTask = this.cluster().scheduler().schedule(this.cluster().settings().PeriodicTasksInitialDelay().max(this.cluster().settings().MetricsInterval()), this.cluster().settings().MetricsInterval(), this.self(), (Object)InternalClusterAction$MetricsTick$.MODULE$, (ExecutionContext)this.context().dispatcher(), this.self());
    }
}

