/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.invocation;

import java.util.ArrayList;
import java.util.List;
import org.hamcrest.Matcher;
import org.mockito.internal.matchers.ArrayEquals;
import org.mockito.internal.matchers.Equals;
import org.mockito.internal.matchers.EqualsFunction0;
import org.mockito.internal.matchers.EqualsFunction1;
import org.mockito.internal.matchers.LocalizedMatcher;
import org.mockito.internal.progress.ThreadSafeMockingProgress2$;
import org.mockito.internal.util.collections.ArrayUtils;
import org.specs2.mock.HamcrestMatcherAdapter;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.GenSeqLike;
import scala.collection.GenSetLike;
import scala.collection.JavaConversions$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ArgumentsProcessor$ {
    public static final ArgumentsProcessor$ MODULE$;

    static {
        new ArgumentsProcessor$();
    }

    public Object[] expandVarArgs(boolean isVarArgs, Object[] args) {
        Object[] objectArray;
        if (isVarArgs && !new ArrayUtils().isEmpty(args) && (args[args.length - 1] == null || args[args.length - 1].getClass().isArray())) {
            int nonVarArgsCount = args.length - 1;
            Object[] varArgs = null;
            if (args[nonVarArgsCount] == null) {
                Object[] objectArray2 = new Object[1];
                objectArray2[0] = null;
                varArgs = objectArray2;
            } else {
                varArgs = ArrayEquals.createObjectArray((Object)args[nonVarArgsCount]);
            }
            int varArgsCount = varArgs.length;
            Object[] newArgs = (Object[])Array$.MODULE$.ofDim(nonVarArgsCount + varArgsCount, ClassTag$.MODULE$.Object());
            System.arraycopy(args, 0, newArgs, 0, nonVarArgsCount);
            System.arraycopy(varArgs, 0, newArgs, nonVarArgsCount, varArgsCount);
            objectArray = newArgs;
        } else {
            objectArray = args == null ? (Object[])Array$.MODULE$.ofDim(0, ClassTag$.MODULE$.Object()) : args;
        }
        return objectArray;
    }

    public List<Matcher<?>> argumentsToMatchers(Object[] arguments) {
        ObjectRef matchers = new ObjectRef(new ArrayList(arguments.length));
        Predef$.MODULE$.refArrayOps(arguments).foreach((Function1)new Serializable(matchers){
            public static final long serialVersionUID = 0L;
            private final ObjectRef matchers$1;

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public final Object apply(Object arg) {
                Object object;
                Object object2;
                if (arg != null && arg.getClass().isArray()) {
                    object2 = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new ArrayEquals(arg)));
                    return object2;
                }
                if (arg != null && arg.getClass().getName().startsWith("scala.collection.mutable.WrappedArray")) {
                    object2 = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new Equals(arg)));
                    return object2;
                }
                if (arg instanceof Function0) {
                    if (ArgumentsProcessor$.MODULE$.isCallRealMethod()) {
                        object2 = BoxedUnit.UNIT;
                        return object2;
                    }
                    try {
                        object = ((Function0)arg).apply();
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                    }
                } else {
                    if (arg instanceof org.specs2.matcher.Matcher) {
                        object2 = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new HamcrestMatcherAdapter<T>((org.specs2.matcher.Matcher)arg)));
                        return object2;
                    }
                    if (arg instanceof GenSeqLike || arg instanceof GenSetLike) {
                        object2 = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new Equals(arg)));
                        return object2;
                    }
                    if (arg instanceof AbstractFunction1) {
                        object2 = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new EqualsFunction1(arg)));
                        return object2;
                    }
                    object2 = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new Equals(arg)));
                    return object2;
                }
                Object value = object;
                List<LocalizedMatcher> argumentsMatchers = ThreadSafeMockingProgress2$.MODULE$.pullLocalizedMatchers();
                if (argumentsMatchers.isEmpty()) {
                    object2 = BoxesRunTime.boxToBoolean((boolean)((List)this.matchers$1.elem).add(new EqualsFunction0(value)));
                    return object2;
                }
                ((List)this.matchers$1.elem).addAll(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(argumentsMatchers).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Matcher<?> apply(LocalizedMatcher x$1) {
                        return x$1.getActualMatcher();
                    }
                }, Buffer$.MODULE$.canBuildFrom())));
                ThreadSafeMockingProgress2$.MODULE$.reportMatchers(JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer(argumentsMatchers).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Matcher<?> apply(LocalizedMatcher x$2) {
                        return x$2.getActualMatcher();
                    }
                }, Buffer$.MODULE$.canBuildFrom())));
                object2 = BoxedUnit.UNIT;
                return object2;
            }
            {
                this.matchers$1 = matchers$1;
            }
        });
        return (List)matchers.elem;
    }

    public boolean isCallRealMethod() {
        return Predef$.MODULE$.refArrayOps((Object[])new Exception().getStackTrace()).toList().exists((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean apply(StackTraceElement t) {
                String string = t.getClassName();
                String string2 = "org.mockito.internal.invocation.InvocationImpl";
                if (string == null) {
                    if (string2 != null) {
                        return false;
                    }
                } else if (!string.equals(string2)) return false;
                String string3 = t.getMethodName();
                String string4 = "callRealMethod";
                if (string3 == null) {
                    if (string4 == null) return true;
                    return false;
                } else {
                    if (!string3.equals(string4)) return false;
                    return true;
                }
            }
        });
    }

    private ArgumentsProcessor$() {
        MODULE$ = this;
    }
}

