/*
 * Decompiled with CFR 0.152.
 */
package play.data.validation;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.Constraint;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import javax.validation.metadata.ConstraintDescriptor;
import play.data.Form;
import play.libs.F;

public class Constraints {
    public static List<F.Tuple<String, List<Object>>> displayableConstraint(Set<ConstraintDescriptor<?>> set) {
        ArrayList<F.Tuple<String, List<Object>>> arrayList = new ArrayList<F.Tuple<String, List<Object>>>();
        for (ConstraintDescriptor<?> constraintDescriptor : set) {
            Class<? extends Annotation> clazz = constraintDescriptor.getAnnotation().annotationType();
            if (!clazz.isAnnotationPresent(Form.Display.class)) continue;
            Form.Display display = clazz.getAnnotation(Form.Display.class);
            String string = display.name();
            ArrayList arrayList2 = new ArrayList();
            Map map = constraintDescriptor.getAttributes();
            for (String string2 : display.attributes()) {
                arrayList2.add(map.get(string2));
            }
            arrayList.add((F.Tuple<String, List<Object>>)F.Tuple((Object)string, arrayList2));
        }
        return arrayList;
    }

    public static Validator<Object> required() {
        return new RequiredValidator();
    }

    public static Validator<Number> min(long l) {
        return new MinValidator(l);
    }

    public static Validator<Number> max(long l) {
        return new MaxValidator(l);
    }

    public static Validator<String> minLength(long l) {
        return new MinLengthValidator(l);
    }

    public static Validator<String> maxLength(long l) {
        return new MaxLengthValidator(l);
    }

    public static Validator<String> email() {
        return new EmailValidator();
    }

    public static Validator<String> pattern(String string) {
        return new PatternValidator(string);
    }

    public static class ValidateWithValidator
    extends Validator<Object>
    implements ConstraintValidator<ValidateWith, Object> {
        public static final String defaultMessage = "error.invalid";
        Class<?> clazz = null;
        Validator validator = null;

        public ValidateWithValidator() {
        }

        public ValidateWithValidator(Class clazz) {
            this.clazz = clazz;
        }

        public void initialize(ValidateWith validateWith) {
            this.clazz = validateWith.value();
            try {
                Constructor<?> constructor = this.clazz.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                this.validator = (Validator)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public boolean isValid(Object object) {
            try {
                return this.validator.isValid(object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            F.Tuple tuple = null;
            try {
                tuple = this.validator.getErrorMessageKey();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            return tuple != null ? tuple : F.Tuple((Object)defaultMessage, (Object)new Object[0]);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={ValidateWithValidator.class})
    @Form.Display(name="constraint.validatewith", attributes={})
    public static @interface ValidateWith {
        public String message() default "error.invalid";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public Class<? extends Validator> value();
    }

    public static class PatternValidator
    extends Validator<String>
    implements ConstraintValidator<Pattern, String> {
        public static final String message = "error.pattern";
        java.util.regex.Pattern regex = null;

        public PatternValidator() {
        }

        public PatternValidator(String string) {
            this.regex = java.util.regex.Pattern.compile(string);
        }

        public void initialize(Pattern pattern) {
            this.regex = java.util.regex.Pattern.compile(pattern.value());
        }

        @Override
        public boolean isValid(String string) {
            if (string == null || string.length() == 0) {
                return true;
            }
            return this.regex.matcher(string).matches();
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.regex});
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={PatternValidator.class})
    @Form.Display(name="constraint.pattern", attributes={"value"})
    public static @interface Pattern {
        public String message() default "error.pattern";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public String value();
    }

    public static class EmailValidator
    extends Validator<String>
    implements ConstraintValidator<Email, String> {
        public static final String message = "error.email";
        static final java.util.regex.Pattern regex = java.util.regex.Pattern.compile("\\b[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*\\b");

        public void initialize(Email email) {
        }

        @Override
        public boolean isValid(String string) {
            if (string == null || string.length() == 0) {
                return true;
            }
            return regex.matcher(string).matches();
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[0]);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={EmailValidator.class})
    @Form.Display(name="constraint.email", attributes={})
    public static @interface Email {
        public String message() default "error.email";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static class MaxLengthValidator
    extends Validator<String>
    implements ConstraintValidator<MaxLength, String> {
        public static final String message = "error.maxLength";
        private long max;

        public MaxLengthValidator() {
        }

        public MaxLengthValidator(long l) {
            this.max = l;
        }

        public void initialize(MaxLength maxLength) {
            this.max = maxLength.value();
        }

        @Override
        public boolean isValid(String string) {
            if (string == null || string.length() == 0) {
                return true;
            }
            return (long)string.length() <= this.max;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.max});
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MaxLengthValidator.class})
    @Form.Display(name="constraint.maxLength", attributes={"value"})
    public static @interface MaxLength {
        public String message() default "error.maxLength";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();
    }

    public static class MinLengthValidator
    extends Validator<String>
    implements ConstraintValidator<MinLength, String> {
        public static final String message = "error.minLength";
        private long min;

        public MinLengthValidator() {
        }

        public MinLengthValidator(long l) {
            this.min = l;
        }

        public void initialize(MinLength minLength) {
            this.min = minLength.value();
        }

        @Override
        public boolean isValid(String string) {
            if (string == null || string.length() == 0) {
                return true;
            }
            return (long)string.length() >= this.min;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.min});
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MinLengthValidator.class})
    @Form.Display(name="constraint.minLength", attributes={"value"})
    public static @interface MinLength {
        public String message() default "error.minLength";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();
    }

    public static class MaxValidator
    extends Validator<Number>
    implements ConstraintValidator<Max, Number> {
        public static final String message = "error.max";
        private long max;

        public MaxValidator() {
        }

        public MaxValidator(long l) {
            this.max = l;
        }

        public void initialize(Max max) {
            this.max = max.value();
        }

        @Override
        public boolean isValid(Number number) {
            if (number == null) {
                return true;
            }
            return number.longValue() <= this.max;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.max});
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MaxValidator.class})
    @Form.Display(name="constraint.max", attributes={"value"})
    public static @interface Max {
        public String message() default "error.max";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();
    }

    public static class MinValidator
    extends Validator<Number>
    implements ConstraintValidator<Min, Number> {
        public static final String message = "error.min";
        private long min;

        public MinValidator() {
        }

        public MinValidator(long l) {
            this.min = l;
        }

        public void initialize(Min min) {
            this.min = min.value();
        }

        @Override
        public boolean isValid(Number number) {
            if (number == null) {
                return true;
            }
            return number.longValue() >= this.min;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[]{this.min});
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={MinValidator.class})
    @Form.Display(name="constraint.min", attributes={"value"})
    public static @interface Min {
        public String message() default "error.min";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};

        public long value();
    }

    public static class RequiredValidator
    extends Validator<Object>
    implements ConstraintValidator<Required, Object> {
        public static final String message = "error.required";

        public void initialize(Required required) {
        }

        @Override
        public boolean isValid(Object object) {
            if (object == null) {
                return false;
            }
            if (object instanceof String) {
                return !((String)object).isEmpty();
            }
            if (object instanceof Collection) {
                return !((Collection)object).isEmpty();
            }
            return true;
        }

        @Override
        public F.Tuple<String, Object[]> getErrorMessageKey() {
            return F.Tuple((Object)message, (Object)new Object[0]);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Constraint(validatedBy={RequiredValidator.class})
    @Form.Display(name="constraint.required")
    public static @interface Required {
        public String message() default "error.required";

        public Class<?>[] groups() default {};

        public Class<? extends Payload>[] payload() default {};
    }

    public static abstract class Validator<T> {
        public abstract boolean isValid(T var1);

        public boolean isValid(T t, ConstraintValidatorContext constraintValidatorContext) {
            return this.isValid(t);
        }

        public abstract F.Tuple<String, Object[]> getErrorMessageKey();
    }
}

