/*
 * Decompiled with CFR 0.152.
 */
package sbt;

import java.io.BufferedWriter;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import jline.TerminalFactory;
import sbt.AttributeMap;
import sbt.Command;
import sbt.ErrorHandling$;
import sbt.ExitHook;
import sbt.GlobalLogBacking;
import sbt.GlobalLogging;
import sbt.Logger;
import sbt.MainLoop;
import sbt.MainLoop$;
import sbt.State;
import sbt.State$;
import sbt.State$ClearGlobalLog$;
import sbt.State$Continue$;
import sbt.State$KeepLastLog$;
import sbt.Using;
import sbt.Using$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.StringBuilder;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import xsbti.AppConfiguration;
import xsbti.FullReload;
import xsbti.MainResult;

public final class MainLoop$ {
    public static final MainLoop$ MODULE$;

    static {
        new MainLoop$();
    }

    public MainResult runLogged(State state) {
        Thread shutdownHook = new Thread(new Runnable(){

            public void run() {
                TerminalFactory.get().restore();
            }
        });
        try {
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            return this.runLoggedLoop(state, state.globalLogging().backing());
        }
        finally {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
    }

    public MainResult runLoggedLoop(State state, GlobalLogBacking logBacking) {
        MainLoop.RunNext runNext;
        while (true) {
            if ((runNext = this.runAndClearLast(state, logBacking)) instanceof MainLoop.Return) {
                MainLoop.Return return_ = (MainLoop.Return)runNext;
                logBacking.file().delete();
                this.deleteLastLog(logBacking);
                MainResult mainResult = return_.result();
                return mainResult;
            }
            if (runNext instanceof MainLoop.ClearGlobalLog) {
                MainLoop.ClearGlobalLog clearGlobalLog = (MainLoop.ClearGlobalLog)runNext;
                this.deleteLastLog(logBacking);
                logBacking = logBacking.shiftNew();
                state = clearGlobalLog.state();
                continue;
            }
            if (!(runNext instanceof MainLoop.KeepGlobalLog)) break;
            MainLoop.KeepGlobalLog keepGlobalLog = (MainLoop.KeepGlobalLog)runNext;
            logBacking.file().delete();
            logBacking = logBacking.unshift();
            state = keepGlobalLog.state();
        }
        throw new MatchError((Object)runNext);
    }

    public MainLoop.RunNext runAndClearLast(State state, GlobalLogBacking logBacking) {
        try {
            return this.runWithNewLog(state, logBacking);
        }
        catch (Throwable throwable) {
            System.err.println(new StringBuilder().append((Object)"sbt appears to be exiting abnormally.\n  The log file for this session is at ").append((Object)logBacking.file()).toString());
            this.deleteLastLog(logBacking);
            throw throwable;
        }
        catch (FullReload fullReload) {
            this.deleteLastLog(logBacking);
            throw fullReload;
        }
    }

    public void deleteLastLog(GlobalLogBacking logBacking) {
        logBacking.last().foreach((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File x$1) {
                return x$1.delete();
            }
        });
    }

    public MainLoop.RunNext runWithNewLog(State state, GlobalLogBacking logBacking) {
        boolean x$2 = true;
        Charset x$3 = Using$.MODULE$.fileWriter$default$1();
        return (MainLoop.RunNext)((Using)Using$.MODULE$.fileWriter(x$3, x$2)).apply((Object)logBacking.file(), (Function1)new Serializable(state, logBacking){
            public static final long serialVersionUID = 0L;
            private final State state$1;
            private final GlobalLogBacking logBacking$1;

            public final MainLoop.RunNext apply(BufferedWriter writer) {
                PrintWriter out = new PrintWriter(writer);
                GlobalLogging x$4 = (GlobalLogging)this.state$1.globalLogging().newLogger().apply((Object)out, (Object)this.logBacking$1);
                AppConfiguration x$5 = this.state$1.copy$default$1();
                Seq<Command> x$6 = this.state$1.copy$default$2();
                Set<ExitHook> x$7 = this.state$1.copy$default$3();
                Option<String> x$8 = this.state$1.copy$default$4();
                Seq<String> x$9 = this.state$1.copy$default$5();
                State.History x$10 = this.state$1.copy$default$6();
                AttributeMap x$11 = this.state$1.copy$default$7();
                State.Next x$12 = this.state$1.copy$default$9();
                State loggedState = this.state$1.copy(x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$4, x$12);
                try {
                    return MainLoop$.MODULE$.run(loggedState);
                }
                finally {
                    out.close();
                }
            }
            {
                this.state$1 = state$1;
                this.logBacking$1 = logBacking$1;
            }
        });
    }

    public MainLoop.RunNext run(State state) {
        State.Next next;
        block6: {
            MainLoop.RunNext runNext;
            block4: {
                block5: {
                    block3: {
                        while (true) {
                            next = state.next();
                            State$Continue$ state$Continue$ = State$Continue$.MODULE$;
                            State.Next next2 = next;
                            if (state$Continue$ != null ? !state$Continue$.equals(next2) : next2 != null) break;
                            state = this.next(state);
                        }
                        State$ClearGlobalLog$ state$ClearGlobalLog$ = State$ClearGlobalLog$.MODULE$;
                        State.Next next3 = next;
                        if (state$ClearGlobalLog$ != null ? !state$ClearGlobalLog$.equals(next3) : next3 != null) break block3;
                        runNext = new MainLoop.ClearGlobalLog(State$.MODULE$.stateOps(state).continue());
                        break block4;
                    }
                    State$KeepLastLog$ state$KeepLastLog$ = State$KeepLastLog$.MODULE$;
                    State.Next next4 = next;
                    if (state$KeepLastLog$ != null ? !state$KeepLastLog$.equals(next4) : next4 != null) break block5;
                    runNext = new MainLoop.KeepGlobalLog(State$.MODULE$.stateOps(state).continue());
                    break block4;
                }
                if (!(next instanceof State.Return)) break block6;
                State.Return return_ = (State.Return)next;
                runNext = new MainLoop.Return(return_.result());
            }
            return runNext;
        }
        throw new MatchError((Object)next);
    }

    public State next(State state) {
        Either either;
        block7: {
            State state2;
            block6: {
                Left left;
                boolean bl;
                block5: {
                    State s;
                    bl = false;
                    left = null;
                    either = ErrorHandling$.MODULE$.wideConvert((Function0)new anonfun.1(state));
                    if (!(either instanceof Right)) break block5;
                    Right right = (Right)either;
                    state2 = s = (State)right.b();
                    break block6;
                }
                if (either instanceof Left) {
                    bl = true;
                    left = (Left)either;
                    Throwable t = (Throwable)left.a();
                    if (t instanceof FullReload) {
                        FullReload fullReload = (FullReload)t;
                        throw fullReload;
                    }
                }
                if (!bl) break block7;
                Throwable t = (Throwable)left.a();
                state2 = this.handleException(t, state);
            }
            return state2;
        }
        throw new MatchError((Object)either);
    }

    public State handleException(Throwable e, State s) {
        return State$.MODULE$.stateOps(s).handleError(e);
    }

    public State handleException(Throwable t, State s, Logger log) {
        return State$.MODULE$.handleException(t, s, log);
    }

    public void logFullException(Throwable e, Logger log) {
        State$.MODULE$.logFullException(e, log);
    }

    private MainLoop$() {
        MODULE$ = this;
    }
}

