/*
 * Decompiled with CFR 0.152.
 */
package com.novocode.junit;

import org.scalatools.testing.Logger;

final class RichLogger {
    private final Logger[] loggers;

    RichLogger(Logger[] loggerArray) {
        this.loggers = loggerArray;
    }

    void debug(String string) {
        for (Logger logger : this.loggers) {
            logger.debug(string);
        }
    }

    void error(String string) {
        for (Logger logger : this.loggers) {
            logger.error(string);
        }
    }

    void error(String string, Throwable throwable) {
        this.error(string);
        if (throwable != null && !(throwable instanceof AssertionError)) {
            this.logStackTrace(throwable);
        }
    }

    void info(String string) {
        for (Logger logger : this.loggers) {
            logger.info(string);
        }
    }

    void warn(String string) {
        for (Logger logger : this.loggers) {
            logger.warn(string);
        }
    }

    private void logStackTrace(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        this.logStackTracePart(stackTraceElementArray, stackTraceElementArray.length - 1, 0, throwable);
    }

    private void logStackTracePart(StackTraceElement[] stackTraceElementArray, int n, int n2, Throwable throwable) {
        int n3;
        int n4 = n;
        for (n3 = 0; n3 <= n; ++n3) {
            String string;
            if (!stackTraceElementArray[n3].toString().startsWith("org.junit.")) continue;
            for (n = n3 - 1; n > 0 && ((string = stackTraceElementArray[n].toString()).startsWith("java.lang.reflect.") || string.startsWith("sun.reflect.")); --n) {
            }
            break;
        }
        for (n3 = 0; n3 <= n; ++n3) {
            this.error("    at " + stackTraceElementArray[n3]);
        }
        if (n4 != n) {
            this.error("    ...");
        } else if (n2 != 0) {
            this.error("    ... " + n2 + " more");
        }
        this.logStackTraceAsCause(stackTraceElementArray, throwable.getCause());
    }

    private void logStackTraceAsCause(StackTraceElement[] stackTraceElementArray, Throwable throwable) {
        if (throwable == null) {
            return;
        }
        StackTraceElement[] stackTraceElementArray2 = throwable.getStackTrace();
        int n = stackTraceElementArray2.length - 1;
        for (int i = stackTraceElementArray.length - 1; n >= 0 && i >= 0 && stackTraceElementArray2[n].equals(stackTraceElementArray[i]); --n, --i) {
        }
        this.error("Caused by: " + throwable);
        this.logStackTracePart(stackTraceElementArray2, n, stackTraceElementArray2.length - 1 - n, throwable);
    }
}

