/*
 * Decompiled with CFR 0.152.
 */
package play.api.libs.ws;

import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Environment;
import play.api.PlayConfig;
import play.api.PlayConfig$;
import play.api.libs.ws.WSClientConfig;
import play.api.libs.ws.ssl.SSLConfig;
import play.api.libs.ws.ssl.SSLConfigParser;
import scala.Option;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Singleton
@ScalaSignature(bytes="\u0006\u0001y2A!\u0001\u0002\u0001\u0017\tqqkU\"p]\u001aLw\rU1sg\u0016\u0014(BA\u0002\u0005\u0003\t98O\u0003\u0002\u0006\r\u0005!A.\u001b2t\u0015\t9\u0001\"A\u0002ba&T\u0011!C\u0001\u0005a2\f\u0017p\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\r)\"\u0004H\u0007\u0002-)\u0011q\u0003G\u0001\u0007S:TWm\u0019;\u000b\u0003e\tQA[1wCbL!a\u0007\f\u0003\u0011A\u0013xN^5eKJ\u0004\"!\b\u0010\u000e\u0003\tI!a\b\u0002\u0003\u001d]\u001b6\t\\5f]R\u001cuN\u001c4jO\"A\u0011\u0005\u0001B\u0001B\u0003%!%A\u0007d_:4\u0017nZ;sCRLwN\u001c\t\u0003G\u0011j\u0011AB\u0005\u0003K\u0019\u0011QbQ8oM&<WO]1uS>t\u0007\u0002C\u0014\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0015\u0002\u0017\u0015tg/\u001b:p]6,g\u000e\u001e\t\u0003G%J!A\u000b\u0004\u0003\u0017\u0015sg/\u001b:p]6,g\u000e\u001e\u0005\u0006Y\u0001!\t!L\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00079z\u0003\u0007\u0005\u0002\u001e\u0001!)\u0011e\u000ba\u0001E!)qe\u000ba\u0001Q!\u00121F\r\t\u0003+MJ!\u0001\u000e\f\u0003\r%s'.Z2u\u0011\u00151\u0004\u0001\"\u00018\u0003\r9W\r\u001e\u000b\u00029!)\u0011\b\u0001C\u0001o\u0005)\u0001/\u0019:tK\"\u0012\u0001a\u000f\t\u0003+qJ!!\u0010\f\u0003\u0013MKgn\u001a7fi>t\u0007")
public class WSConfigParser
implements Provider<WSClientConfig> {
    private final Configuration configuration;
    private final Environment environment;

    public WSClientConfig get() {
        return this.parse();
    }

    public WSClientConfig parse() {
        PlayConfig qual$1 = PlayConfig$.MODULE$.apply(this.configuration);
        String x$1 = "play.ws";
        String x$2 = "ws";
        String x$3 = qual$1.getDeprecatedWithFallback$default$3();
        PlayConfig config = qual$1.getDeprecatedWithFallback(x$1, x$2, x$3);
        Duration connectionTimeout = (Duration)config.get("timeout.connection", ConfigLoader$.MODULE$.durationLoader());
        Duration idleTimeout = (Duration)config.get("timeout.idle", ConfigLoader$.MODULE$.durationLoader());
        Duration requestTimeout = (Duration)config.get("timeout.request", ConfigLoader$.MODULE$.durationLoader());
        boolean followRedirects = BoxesRunTime.unboxToBoolean((Object)config.get("followRedirects", ConfigLoader$.MODULE$.booleanLoader()));
        boolean useProxyProperties = BoxesRunTime.unboxToBoolean((Object)config.get("useProxyProperties", ConfigLoader$.MODULE$.booleanLoader()));
        Option userAgent = (Option)config.get("useragent", ConfigLoader$.MODULE$.optionLoader(ConfigLoader$.MODULE$.stringLoader()));
        boolean compressionEnabled = BoxesRunTime.unboxToBoolean((Object)config.get("compressionEnabled", ConfigLoader$.MODULE$.booleanLoader()));
        SSLConfig sslConfig = new SSLConfigParser((PlayConfig)config.get("ssl", ConfigLoader$.MODULE$.playConfigLoader()), this.environment.classLoader()).parse();
        return new WSClientConfig(connectionTimeout, idleTimeout, requestTimeout, followRedirects, useProxyProperties, (Option<String>)userAgent, compressionEnabled, sslConfig);
    }

    @Inject
    public WSConfigParser(Configuration configuration, Environment environment) {
        this.configuration = configuration;
        this.environment = environment;
    }
}

