/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.easymock.internal.ClassExtensionHelper;
import org.easymock.internal.Invocation;
import org.easymock.internal.MethodSerializationWrapper;
import org.easymock.internal.MockInvocationHandler;
import org.easymock.internal.ReflectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectMethodsFilter
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -1726286682930686024L;
    private transient Method equalsMethod;
    private transient Method hashCodeMethod;
    private transient Method toStringMethod;
    private transient Method finalizeMethod;
    private final MockInvocationHandler delegate;
    private final String name;

    public ObjectMethodsFilter(Class<?> toMock, MockInvocationHandler delegate, String name) {
        if (name != null && !Invocation.isJavaIdentifier(name)) {
            throw new IllegalArgumentException(String.format("'%s' is not a valid Java identifier.", name));
        }
        try {
            if (toMock.isInterface()) {
                this.equalsMethod = ReflectionUtils.OBJECT_EQUALS;
                this.hashCodeMethod = ReflectionUtils.OBJECT_HASHCODE;
                this.toStringMethod = ReflectionUtils.OBJECT_TOSTRING;
                this.finalizeMethod = ReflectionUtils.OBJECT_FINALIZE;
            } else {
                this.equalsMethod = toMock.getMethod("equals", Object.class);
                this.hashCodeMethod = toMock.getMethod("hashCode", null);
                this.toStringMethod = toMock.getMethod("toString", null);
                this.finalizeMethod = ReflectionUtils.findMethod(toMock, "finalize", null);
                if (this.finalizeMethod == null) {
                    this.finalizeMethod = ReflectionUtils.OBJECT_FINALIZE;
                }
            }
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("An Object method could not be found!");
        }
        this.delegate = delegate;
        this.name = name;
    }

    @Override
    public final Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (this.equalsMethod.equals(method)) {
            return proxy == args[0];
        }
        if (this.hashCodeMethod.equals(method)) {
            return System.identityHashCode(proxy);
        }
        if (this.toStringMethod.equals(method)) {
            return this.mockToString(proxy);
        }
        if (this.finalizeMethod.equals(method)) {
            return null;
        }
        return this.delegate.invoke(proxy, method, args);
    }

    private String mockToString(Object proxy) {
        return this.name != null ? this.name : "EasyMock for " + ClassExtensionHelper.getMockedType(proxy);
    }

    public MockInvocationHandler getDelegate() {
        return this.delegate;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        try {
            this.toStringMethod = ((MethodSerializationWrapper)stream.readObject()).getMethod();
            this.equalsMethod = ((MethodSerializationWrapper)stream.readObject()).getMethod();
            this.hashCodeMethod = ((MethodSerializationWrapper)stream.readObject()).getMethod();
            this.finalizeMethod = ((MethodSerializationWrapper)stream.readObject()).getMethod();
        }
        catch (NoSuchMethodException e) {
            throw new IOException(e.toString());
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(new MethodSerializationWrapper(this.toStringMethod));
        stream.writeObject(new MethodSerializationWrapper(this.equalsMethod));
        stream.writeObject(new MethodSerializationWrapper(this.hashCodeMethod));
        stream.writeObject(new MethodSerializationWrapper(this.finalizeMethod));
    }
}

