/*
 * Decompiled with CFR 0.152.
 */
package akka.stream.impl.io;

import akka.actor.ActorRef;
import akka.actor.Props;
import akka.stream.ActorAttributes;
import akka.stream.ActorMaterializer;
import akka.stream.ActorMaterializerHelper$;
import akka.stream.ActorMaterializerSettings;
import akka.stream.Attributes;
import akka.stream.IOResult;
import akka.stream.MaterializationContext;
import akka.stream.SourceShape;
import akka.stream.actor.ActorPublisher$;
import akka.stream.impl.SourceModule;
import akka.stream.impl.Stages$DefaultAttributes$;
import akka.stream.impl.StreamLayout;
import akka.stream.impl.io.FilePublisher$;
import akka.util.ByteString;
import java.nio.file.Path;
import org.reactivestreams.Publisher;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.concurrent.Future;
import scala.concurrent.Promise;
import scala.concurrent.Promise$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\ra!B\u0001\u0003\u0005!Q!A\u0003$jY\u0016\u001cv.\u001e:dK*\u00111\u0001B\u0001\u0003S>T!!\u0002\u0004\u0002\t%l\u0007\u000f\u001c\u0006\u0003\u000f!\taa\u001d;sK\u0006l'\"A\u0005\u0002\t\u0005\\7.Y\n\u0003\u0001-\u0001B\u0001D\u0007\u0010+5\tA!\u0003\u0002\u000f\t\ta1k\\;sG\u0016lu\u000eZ;mKB\u0011\u0001cE\u0007\u0002#)\u0011!\u0003C\u0001\u0005kRLG.\u0003\u0002\u0015#\tQ!)\u001f;f'R\u0014\u0018N\\4\u0011\u0007YYR$D\u0001\u0018\u0015\tA\u0012$\u0001\u0006d_:\u001cWO\u001d:f]RT\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039]\u0011aAR;ukJ,\u0007C\u0001\u0010 \u001b\u00051\u0011B\u0001\u0011\u0007\u0005!IuJU3tk2$\b\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u0003\u0019\u001c\u0001\u0001\u0005\u0002&Y5\taE\u0003\u0002(Q\u0005!a-\u001b7f\u0015\tI#&A\u0002oS>T\u0011aK\u0001\u0005U\u00064\u0018-\u0003\u0002.M\t!\u0001+\u0019;i\u0011!y\u0003A!A!\u0002\u0013\u0001\u0014!C2ik:\\7+\u001b>f!\t\t$'D\u0001\u001a\u0013\t\u0019\u0014DA\u0002J]RD\u0001\"\u000e\u0001\u0003\u0006\u0004%\tAN\u0001\u000bCR$(/\u001b2vi\u0016\u001cX#A\u001c\u0011\u0005yA\u0014BA\u001d\u0007\u0005)\tE\u000f\u001e:jEV$Xm\u001d\u0005\tw\u0001\u0011\t\u0011)A\u0005o\u0005Y\u0011\r\u001e;sS\n,H/Z:!\u0011%i\u0004A!A!\u0002\u0013q\u0014)A\u0003tQ\u0006\u0004X\rE\u0002\u001f\u007f=I!\u0001\u0011\u0004\u0003\u0017M{WO]2f'\"\f\u0007/Z\u0005\u0003{5AQa\u0011\u0001\u0005\u0002\u0011\u000ba\u0001P5oSRtD#B#H\u0011&S\u0005C\u0001$\u0001\u001b\u0005\u0011\u0001\"\u0002\u0012C\u0001\u0004!\u0003\"B\u0018C\u0001\u0004\u0001\u0004\"B\u001bC\u0001\u00049\u0004\"B\u001fC\u0001\u0004q\u0004\"\u0002'\u0001\t\u0003j\u0015AB2sK\u0006$X\r\u0006\u0002O3B!\u0011gT)\u0016\u0013\t\u0001\u0016D\u0001\u0004UkBdWM\r\t\u0004%^{Q\"A*\u000b\u0005Q+\u0016a\u0004:fC\u000e$\u0018N^3tiJ,\u0017-\\:\u000b\u0003Y\u000b1a\u001c:h\u0013\tA6KA\u0005Qk\nd\u0017n\u001d5fe\")!l\u0013a\u00017\u000691m\u001c8uKb$\bC\u0001\u0010]\u0013\tifA\u0001\fNCR,'/[1mSj\fG/[8o\u0007>tG/\u001a=u\u0011\u0015y\u0006\u0001\"\u0015a\u0003-qWm^%ogR\fgnY3\u0015\u0005-\t\u0007\"B\u001f_\u0001\u0004q\u0004\"B2\u0001\t\u0003\"\u0017AD<ji\"\fE\u000f\u001e:jEV$Xm\u001d\u000b\u0003KV\u0004\"A\u001a:\u000f\u0005\u001d\u0004hB\u00015p\u001d\tIgN\u0004\u0002k[6\t1N\u0003\u0002mG\u00051AH]8pizJ\u0011!C\u0005\u0003\u000f!I!!\u0002\u0004\n\u0005E$\u0011\u0001D*ue\u0016\fW\u000eT1z_V$\u0018BA:u\u0005\u0019iu\u000eZ;mK*\u0011\u0011\u000f\u0002\u0005\u0006m\n\u0004\raN\u0001\u0005CR$(\u000fC\u0003y\u0001\u0011E\u00130A\u0003mC\n,G.F\u0001{!\tYhP\u0004\u00022y&\u0011Q0G\u0001\u0007!J,G-\u001a4\n\u0007}\f\tA\u0001\u0004TiJLgn\u001a\u0006\u0003{f\u0001")
public final class FileSource
extends SourceModule<ByteString, Future<IOResult>> {
    private final Path f;
    private final int chunkSize;
    private final Attributes attributes;

    @Override
    public Attributes attributes() {
        return this.attributes;
    }

    @Override
    public Tuple2<Publisher<ByteString>, Future<IOResult>> create(MaterializationContext context) {
        ActorMaterializer materializer = ActorMaterializerHelper$.MODULE$.downcast(context.materializer());
        ActorMaterializerSettings settings = materializer.effectiveSettings(context.effectiveAttributes());
        Promise ioResultPromise = Promise$.MODULE$.apply();
        Props props2 = FilePublisher$.MODULE$.props(this.f, (Promise<IOResult>)ioResultPromise, this.chunkSize, settings.initialInputBufferSize(), settings.maxInputBufferSize());
        String dispatcher = context.effectiveAttributes().get(Stages$DefaultAttributes$.MODULE$.IODispatcher(), ClassTag$.MODULE$.apply(ActorAttributes.Dispatcher.class)).dispatcher();
        ActorRef ref = materializer.actorOf(context, props2.withDispatcher(dispatcher));
        return new Tuple2(ActorPublisher$.MODULE$.apply(ref), (Object)ioResultPromise.future());
    }

    @Override
    public SourceModule<ByteString, Future<IOResult>> newInstance(SourceShape<ByteString> shape) {
        return new FileSource(this.f, this.chunkSize, this.attributes(), shape);
    }

    @Override
    public StreamLayout.Module withAttributes(Attributes attr) {
        return new FileSource(this.f, this.chunkSize, attr, this.amendShape(attr));
    }

    @Override
    public String label() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"FileSource(", ", ", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.f, BoxesRunTime.boxToInteger((int)this.chunkSize)}));
    }

    public FileSource(Path f, int chunkSize, Attributes attributes, SourceShape<ByteString> shape) {
        this.f = f;
        this.chunkSize = chunkSize;
        this.attributes = attributes;
        super(shape);
        Predef$.MODULE$.require(chunkSize > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "chunkSize must be greater than 0";
            }
        });
    }
}

