/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLHelper {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    static final String XERCES_LOAD_EXTERNAL_DTD = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    static final String XML_NAMESPACE_PREFIXES = "http://xml.org/sax/features/namespace-prefixes";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private static boolean canUseSchemaValidation = true;
    private static Boolean canDisableExternalDtds = null;

    private static SAXParser newSAXParser(URL uRL, InputStream inputStream, boolean bl) throws ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setValidating(canUseSchemaValidation && uRL != null);
        if (!bl && XMLHelper.canDisableExternalDtds(sAXParserFactory)) {
            sAXParserFactory.setFeature(XERCES_LOAD_EXTERNAL_DTD, false);
        }
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        if (canUseSchemaValidation && uRL != null) {
            try {
                sAXParser.setProperty(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                sAXParser.setProperty(JAXP_SCHEMA_SOURCE, inputStream);
            }
            catch (SAXNotRecognizedException sAXNotRecognizedException) {
                Message.warn("problem while setting JAXP validating property on SAXParser... XML validation will not be done", sAXNotRecognizedException);
                canUseSchemaValidation = false;
                sAXParserFactory.setValidating(false);
                sAXParser = sAXParserFactory.newSAXParser();
            }
        }
        sAXParser.getXMLReader().setFeature(XML_NAMESPACE_PREFIXES, true);
        return sAXParser;
    }

    private static boolean canDisableExternalDtds(SAXParserFactory sAXParserFactory) {
        if (canDisableExternalDtds == null) {
            try {
                sAXParserFactory.getFeature(XERCES_LOAD_EXTERNAL_DTD);
                canDisableExternalDtds = Boolean.TRUE;
            }
            catch (Exception exception) {
                canDisableExternalDtds = Boolean.FALSE;
            }
        }
        return canDisableExternalDtds;
    }

    public static String toSystemId(URL uRL) {
        try {
            return new URI(uRL.toExternalForm()).toASCIIString();
        }
        catch (URISyntaxException uRISyntaxException) {
            return uRL.toExternalForm();
        }
    }

    public static void parse(URL uRL, URL uRL2, DefaultHandler defaultHandler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(uRL, uRL2, defaultHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(URL uRL, URL uRL2, DefaultHandler defaultHandler, LexicalHandler lexicalHandler) throws SAXException, IOException, ParserConfigurationException {
        InputStream inputStream = URLHandlerRegistry.getDefault().openStream(uRL);
        try {
            InputSource inputSource = new InputSource(inputStream);
            inputSource.setSystemId(XMLHelper.toSystemId(uRL));
            XMLHelper.parse(inputSource, uRL2, defaultHandler, lexicalHandler);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static void parse(InputStream inputStream, URL uRL, DefaultHandler defaultHandler, LexicalHandler lexicalHandler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(new InputSource(inputStream), uRL, defaultHandler, lexicalHandler);
    }

    public static void parse(InputSource inputSource, URL uRL, DefaultHandler defaultHandler, LexicalHandler lexicalHandler) throws SAXException, IOException, ParserConfigurationException {
        XMLHelper.parse(inputSource, uRL, defaultHandler, lexicalHandler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(InputSource inputSource, URL uRL, DefaultHandler defaultHandler, LexicalHandler lexicalHandler, boolean bl) throws SAXException, IOException, ParserConfigurationException {
        InputStream inputStream = null;
        try {
            if (uRL != null) {
                inputStream = URLHandlerRegistry.getDefault().openStream(uRL);
            }
            SAXParser sAXParser = XMLHelper.newSAXParser(uRL, inputStream, bl);
            if (lexicalHandler != null) {
                try {
                    sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", lexicalHandler);
                }
                catch (SAXException sAXException) {
                    Message.warn("problem while setting the lexical handler property on SAXParser", sAXException);
                }
            }
            sAXParser.parse(inputSource, defaultHandler);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean canUseSchemaValidation() {
        return canUseSchemaValidation;
    }

    public static String escape(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        char[] cArray = string.toCharArray();
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static Document parseToDom(InputSource inputSource, EntityResolver entityResolver) throws IOException, SAXException {
        DocumentBuilder documentBuilder = XMLHelper.getDocBuilder(entityResolver);
        return documentBuilder.parse(inputSource);
    }

    public static DocumentBuilder getDocBuilder(EntityResolver entityResolver) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            if (entityResolver != null) {
                documentBuilder.setEntityResolver(entityResolver);
            }
            return documentBuilder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new RuntimeException(parserConfigurationException);
        }
    }

    private XMLHelper() {
    }
}

