/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.ivy.util.CopyProgressEvent;
import org.apache.ivy.util.CopyProgressListener;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.url.URLHandlerRegistry;

public final class FileUtil {
    private static final int BUFFER_SIZE = 65536;
    private static final byte[] EMPTY_BUFFER = new byte[0];
    private static final Pattern ALLOWED_PATH_PATTERN = Pattern.compile("[\\w-./\\\\:~ %\\(\\)]+");

    private FileUtil() {
    }

    public static void symlinkInMass(Map map, boolean bl) throws IOException {
        try {
            Object object;
            Object object2;
            Object object3;
            StringBuffer stringBuffer = new StringBuffer();
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                object3 = iterator.next();
                object2 = (File)object3.getKey();
                object = (File)object3.getValue();
                if (!ALLOWED_PATH_PATTERN.matcher(((File)object).getAbsolutePath()).matches()) {
                    throw new IOException("Unsafe file to 'mass' symlink: '" + ((File)object).getAbsolutePath() + "'");
                }
                if (!ALLOWED_PATH_PATTERN.matcher(((File)object2).getAbsolutePath()).matches()) {
                    throw new IOException("Unsafe file to 'mass' symlink to: '" + ((File)object2).getAbsolutePath() + "'");
                }
                stringBuffer.append("ln -s -f \"" + ((File)object).getAbsolutePath() + "\"  \"" + ((File)object2).getAbsolutePath() + "\";");
                if (!iterator.hasNext()) continue;
                stringBuffer.append("\n");
            }
            object3 = stringBuffer.toString();
            object2 = Runtime.getRuntime();
            Message.verbose("executing \"sh\" of:\n\t" + ((String)object3).replaceAll("\n", "\n\t"));
            object = ((Runtime)object2).exec("sh");
            OutputStream outputStream = ((Process)object).getOutputStream();
            outputStream.write(((String)object3).getBytes("UTF-8"));
            outputStream.flush();
            outputStream.close();
            if (((Process)object).waitFor() != 0) {
                String string;
                InputStream inputStream = ((Process)object).getErrorStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer2 = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer2.append(string);
                    stringBuffer2.append('\n');
                }
                throw new IOException("error running ln commands with 'sh':\n" + stringBuffer2);
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static void symlink(File file, File file2, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        if (!FileUtil.prepareCopy(file, file2, bl)) {
            return;
        }
        try {
            Runtime runtime = Runtime.getRuntime();
            Message.verbose("executing 'ln -s -f " + file.getAbsolutePath() + " " + file2.getPath() + "'");
            Process process = runtime.exec(new String[]{"ln", "-s", "-f", file.getAbsolutePath(), file2.getPath()});
            if (process.waitFor() != 0) {
                String string;
                InputStream inputStream = process.getErrorStream();
                InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
                BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
                StringBuffer stringBuffer = new StringBuffer();
                while ((string = bufferedReader.readLine()) != null) {
                    stringBuffer.append(string);
                    stringBuffer.append('\n');
                }
                throw new IOException("error symlinking " + file + " to " + file2 + ":\n" + stringBuffer);
            }
            if (!file2.exists()) {
                throw new IOException("error symlinking: " + file2 + " doesn't exists");
            }
            if (file2.getAbsolutePath().equals(file2.getCanonicalPath())) {
                file2.delete();
                throw new IOException("error symlinking: " + file2 + " isn't a symlink");
            }
        }
        catch (IOException iOException) {
            Message.verbose("symlink failed; falling back to copy", iOException);
            FileUtil.copy(file, file2, copyProgressListener, bl);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean copy(File file, File file2, CopyProgressListener copyProgressListener) throws IOException {
        return FileUtil.copy(file, file2, copyProgressListener, false);
    }

    public static boolean prepareCopy(File file, File file2, boolean bl) throws IOException {
        if (file.isDirectory()) {
            if (file2.exists()) {
                if (!file2.isDirectory()) {
                    throw new IOException("impossible to copy: destination is not a directory: " + file2);
                }
            } else {
                file2.mkdirs();
            }
            return true;
        }
        if (file2.exists()) {
            if (!file2.isFile()) {
                throw new IOException("impossible to copy: destination is not a file: " + file2);
            }
            if (bl) {
                if (!file2.canWrite()) {
                    file2.delete();
                }
            } else {
                Message.verbose(file2 + " already exists, nothing done");
                return false;
            }
        }
        if (file2.getParentFile() != null) {
            file2.getParentFile().mkdirs();
        }
        return true;
    }

    public static boolean copy(File file, File file2, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        if (!FileUtil.prepareCopy(file, file2, bl)) {
            return false;
        }
        if (file.isDirectory()) {
            return FileUtil.deepCopy(file, file2, copyProgressListener, bl);
        }
        FileUtil.copy((InputStream)new FileInputStream(file), file2, copyProgressListener);
        long l = file.length();
        long l2 = file2.length();
        if (l != l2) {
            file2.delete();
            throw new IOException("size of source file " + file.toString() + "(" + l + ") differs from size of dest file " + file2.toString() + "(" + l2 + ") - please retry");
        }
        file2.setLastModified(file.lastModified());
        return true;
    }

    public static boolean deepCopy(File file, File file2, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        int n;
        File[] fileArray;
        List<File> list = Collections.EMPTY_LIST;
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                file2.delete();
                file2.mkdirs();
                file2.setLastModified(file.lastModified());
            } else {
                fileArray = file2.listFiles();
                if (fileArray != null) {
                    list = Arrays.asList(fileArray);
                }
            }
        } else {
            file2.mkdirs();
            file2.setLastModified(file.lastModified());
        }
        fileArray = file.listFiles();
        if (fileArray != null) {
            for (n = 0; n < fileArray.length; ++n) {
                File file3 = new File(file2, fileArray[n].getName());
                list.remove(file3);
                if (fileArray[n].isDirectory()) {
                    FileUtil.deepCopy(fileArray[n], file3, copyProgressListener, bl);
                    continue;
                }
                FileUtil.copy(fileArray[n], file3, copyProgressListener, bl);
            }
        }
        for (n = 0; n < list.size(); ++n) {
            FileUtil.forceDelete(list.get(n));
        }
        return true;
    }

    public static void copy(URL uRL, File file, CopyProgressListener copyProgressListener) throws IOException {
        URLHandlerRegistry.getDefault().download(uRL, file, copyProgressListener);
    }

    public static void copy(File file, URL uRL, CopyProgressListener copyProgressListener) throws IOException {
        URLHandlerRegistry.getDefault().upload(file, uRL, copyProgressListener);
    }

    public static void copy(InputStream inputStream, File file, CopyProgressListener copyProgressListener) throws IOException {
        if (file.getParentFile() != null) {
            file.getParentFile().mkdirs();
        }
        FileUtil.copy(inputStream, new FileOutputStream(file), copyProgressListener);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, CopyProgressListener copyProgressListener) throws IOException {
        FileUtil.copy(inputStream, outputStream, copyProgressListener, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream inputStream, OutputStream outputStream, CopyProgressListener copyProgressListener, boolean bl) throws IOException {
        CopyProgressEvent copyProgressEvent = null;
        if (copyProgressListener != null) {
            copyProgressEvent = new CopyProgressEvent();
        }
        try {
            int n;
            byte[] byArray = new byte[65536];
            long l = 0L;
            if (copyProgressListener != null) {
                copyProgressListener.start(copyProgressEvent);
            }
            while ((n = inputStream.read(byArray)) != -1) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new IOException("transfer interrupted");
                }
                outputStream.write(byArray, 0, n);
                l += (long)n;
                if (copyProgressListener == null) continue;
                copyProgressListener.progress(copyProgressEvent.update(byArray, n, l));
            }
            if (copyProgressListener != null) {
                copyProgressEvent.update(EMPTY_BUFFER, 0, l);
            }
            try {
                outputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (bl) {
                inputStream.close();
                outputStream.close();
            }
        }
        finally {
            if (bl) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (copyProgressListener != null) {
            copyProgressListener.end(copyProgressEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(BufferedReader bufferedReader) throws IOException {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = bufferedReader.readLine();
            while (string != null) {
                stringBuffer.append(string + "\n");
                string = bufferedReader.readLine();
            }
            String string2 = stringBuffer.toString();
            return string2;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static String readEntirely(File file) throws IOException {
        return FileUtil.readEntirely(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readEntirely(InputStream inputStream) throws IOException {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) != -1) {
                stringBuffer.append(new String(byArray, 0, n));
            }
            String string = stringBuffer.toString();
            return string;
        }
        finally {
            inputStream.close();
        }
    }

    public static String concat(String string, String string2) {
        return string + "/" + string2;
    }

    public static boolean forceDelete(File file) {
        File[] fileArray;
        if (!file.exists()) {
            return true;
        }
        if (file.isDirectory() && (fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (FileUtil.forceDelete(fileArray[i])) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static List getPathFiles(File file, File file2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        while (file2 != null && !file2.getAbsolutePath().equals(file.getAbsolutePath())) {
            arrayList.add(file2);
            file2 = file2.getParentFile();
        }
        if (file != null) {
            arrayList.add(file);
        }
        Collections.reverse(arrayList);
        return arrayList;
    }

    public static Collection listAll(File file, Collection collection) {
        return FileUtil.listAll(file, new ArrayList(), collection);
    }

    private static Collection listAll(File file, Collection collection, Collection collection2) {
        if (collection2.contains(file.getName())) {
            return collection;
        }
        if (file.exists()) {
            collection.add(file);
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                FileUtil.listAll(fileArray[i], collection, collection2);
            }
        }
        return collection;
    }

    public static File resolveFile(File file, String string) {
        File file2 = new File(string);
        if (!file2.isAbsolute()) {
            file2 = new File(file, string);
        }
        return FileUtil.normalize(file2.getPath());
    }

    public static File normalize(String string) {
        CharSequence charSequence;
        Stack<CharSequence> stack = new Stack<CharSequence>();
        String[] stringArray = FileUtil.dissect(string);
        stack.push(stringArray[0]);
        StringTokenizer stringTokenizer = new StringTokenizer(stringArray[1], File.separator);
        while (stringTokenizer.hasMoreTokens()) {
            charSequence = stringTokenizer.nextToken();
            if (".".equals(charSequence)) continue;
            if ("..".equals(charSequence)) {
                if (stack.size() < 2) {
                    return new File(string);
                }
                stack.pop();
                continue;
            }
            stack.push(charSequence);
        }
        charSequence = new StringBuffer();
        for (int i = 0; i < stack.size(); ++i) {
            if (i > 1) {
                ((StringBuffer)charSequence).append(File.separatorChar);
            }
            ((StringBuffer)charSequence).append(stack.elementAt(i));
        }
        return new File(((StringBuffer)charSequence).toString());
    }

    private static String[] dissect(String string) {
        char c = File.separatorChar;
        string = string.replace('/', c).replace('\\', c);
        String string2 = null;
        int n = string.indexOf(58);
        if (n > 0) {
            int n2 = n + 1;
            string2 = string.substring(0, n2);
            char[] cArray = string.toCharArray();
            string2 = string2 + c;
            n2 = cArray[n2] == c ? n2 + 1 : n2;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = n2; i < cArray.length; ++i) {
                if (cArray[i] == c && cArray[i - 1] == c) continue;
                stringBuffer.append(cArray[i]);
            }
            string = stringBuffer.toString();
        } else if (string.length() > 1 && string.charAt(1) == c) {
            int n3 = string.indexOf(c, 2);
            string2 = (n3 = string.indexOf(c, n3 + 1)) > 2 ? string.substring(0, n3 + 1) : string;
            string = string.substring(string2.length());
        } else {
            string2 = File.separator;
            string = string.substring(1);
        }
        return new String[]{string2, string};
    }

    public static long getFileLength(File file) {
        long l = 0L;
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    l += FileUtil.getFileLength(fileArray[i]);
                }
            }
        } else {
            l = file.length();
        }
        return l;
    }
}

