/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.report;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.XMLHelper;

public class XmlReportWriter {
    static final String REPORT_ENCODING = "UTF-8";

    public void output(ConfigurationResolveReport configurationResolveReport, OutputStream outputStream) {
        this.output(configurationResolveReport, new String[]{configurationResolveReport.getConfiguration()}, outputStream);
    }

    public void output(ConfigurationResolveReport configurationResolveReport, String[] stringArray, OutputStream outputStream) {
        OutputStreamWriter outputStreamWriter;
        try {
            outputStreamWriter = new OutputStreamWriter(outputStream, REPORT_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 is not known on your jvm", unsupportedEncodingException);
        }
        PrintWriter printWriter = new PrintWriter(new BufferedWriter(outputStreamWriter));
        ModuleRevisionId moduleRevisionId = configurationResolveReport.getModuleDescriptor().getModuleRevisionId();
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        printWriter.println("<?xml-stylesheet type=\"text/xsl\" href=\"ivy-report.xsl\"?>");
        printWriter.println("<ivy-report version=\"1.0\">");
        printWriter.println("\t<info");
        printWriter.println("\t\torganisation=\"" + XMLHelper.escape(moduleRevisionId.getOrganisation()) + "\"");
        printWriter.println("\t\tmodule=\"" + XMLHelper.escape(moduleRevisionId.getName()) + "\"");
        printWriter.println("\t\trevision=\"" + XMLHelper.escape(moduleRevisionId.getRevision()) + "\"");
        if (moduleRevisionId.getBranch() != null) {
            printWriter.println("\t\tbranch=\"" + XMLHelper.escape(moduleRevisionId.getBranch()) + "\"");
        }
        Map map = moduleRevisionId.getExtraAttributes();
        for (Map.Entry object : map.entrySet()) {
            printWriter.println("\t\textra-" + object.getKey() + "=\"" + XMLHelper.escape(object.getValue().toString()) + "\"");
        }
        printWriter.println("\t\tconf=\"" + XMLHelper.escape(configurationResolveReport.getConfiguration()) + "\"");
        printWriter.println("\t\tconfs=\"" + XMLHelper.escape(StringUtils.join(stringArray, ", ")) + "\"");
        printWriter.println("\t\tdate=\"" + DateUtil.format(configurationResolveReport.getDate()) + "\"/>");
        printWriter.println("\t<dependencies>");
        ArrayList<ModuleRevisionId> arrayList = new ArrayList<ModuleRevisionId>(configurationResolveReport.getModuleRevisionIds());
        for (ModuleId moduleId : configurationResolveReport.getModuleIds()) {
            printWriter.println("\t\t<module organisation=\"" + XMLHelper.escape(moduleId.getOrganisation()) + "\"" + " name=\"" + XMLHelper.escape(moduleId.getName()) + "\">");
            for (IvyNode ivyNode : configurationResolveReport.getNodes(moduleId)) {
                this.ouputRevision(configurationResolveReport, printWriter, arrayList, ivyNode);
            }
            printWriter.println("\t\t</module>");
        }
        printWriter.println("\t</dependencies>");
        printWriter.println("</ivy-report>");
        printWriter.flush();
    }

    private void ouputRevision(ConfigurationResolveReport configurationResolveReport, PrintWriter printWriter, List list, IvyNode ivyNode) {
        Object object;
        ModuleDescriptor moduleDescriptor = null;
        if (ivyNode.getModuleRevision() != null) {
            moduleDescriptor = ivyNode.getModuleRevision().getDescriptor();
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (ivyNode.isLoaded()) {
            stringBuffer.append(" status=\"");
            stringBuffer.append(XMLHelper.escape(ivyNode.getDescriptor().getStatus()));
            stringBuffer.append("\" pubdate=\"");
            stringBuffer.append(DateUtil.format(new Date(ivyNode.getPublication())));
            stringBuffer.append("\" resolver=\"");
            stringBuffer.append(XMLHelper.escape(ivyNode.getModuleRevision().getResolver().getName()));
            stringBuffer.append("\" artresolver=\"");
            stringBuffer.append(XMLHelper.escape(ivyNode.getModuleRevision().getArtifactResolver().getName()));
            stringBuffer.append("\"");
        }
        if (ivyNode.isEvicted(configurationResolveReport.getConfiguration())) {
            object = ivyNode.getEvictedData(configurationResolveReport.getConfiguration());
            if (((IvyNodeEviction.EvictionData)object).getConflictManager() != null) {
                stringBuffer.append(" evicted=\"").append(XMLHelper.escape(((IvyNodeEviction.EvictionData)object).getConflictManager().toString())).append("\"");
            } else {
                stringBuffer.append(" evicted=\"transitive\"");
            }
            stringBuffer.append(" evicted-reason=\"").append(XMLHelper.escape(((IvyNodeEviction.EvictionData)object).getDetail() == null ? "" : ((IvyNodeEviction.EvictionData)object).getDetail())).append("\"");
        }
        if (ivyNode.hasProblem()) {
            stringBuffer.append(" error=\"").append(XMLHelper.escape(ivyNode.getProblem().getMessage())).append("\"");
        }
        if (moduleDescriptor != null && moduleDescriptor.getHomePage() != null) {
            stringBuffer.append(" homepage=\"").append(XMLHelper.escape(moduleDescriptor.getHomePage())).append("\"");
        }
        Map map = moduleDescriptor != null ? moduleDescriptor.getExtraAttributes() : ivyNode.getResolvedId().getExtraAttributes();
        for (String string : map.keySet()) {
            stringBuffer.append(" extra-").append(string).append("=\"").append(XMLHelper.escape(map.get(string).toString())).append("\"");
        }
        object = ivyNode.getDescriptor() != null ? " default=\"" + ivyNode.getDescriptor().isDefault() + "\"" : "";
        int n = list.indexOf(ivyNode.getResolvedId());
        printWriter.println("\t\t\t<revision name=\"" + XMLHelper.escape(ivyNode.getResolvedId().getRevision()) + "\"" + (ivyNode.getResolvedId().getBranch() == null ? "" : " branch=\"" + XMLHelper.escape(ivyNode.getResolvedId().getBranch()) + "\"") + stringBuffer + " downloaded=\"" + ivyNode.isDownloaded() + "\"" + " searched=\"" + ivyNode.isSearched() + "\"" + (String)object + " conf=\"" + this.toString(ivyNode.getConfigurations(configurationResolveReport.getConfiguration())) + "\"" + " position=\"" + n + "\">");
        if (moduleDescriptor != null) {
            License[] licenseArray = moduleDescriptor.getLicenses();
            for (int i = 0; i < licenseArray.length; ++i) {
                String string = licenseArray[i].getUrl() != null ? " url=\"" + XMLHelper.escape(licenseArray[i].getUrl()) + "\"" : "";
                printWriter.println("\t\t\t\t<license name=\"" + XMLHelper.escape(licenseArray[i].getName()) + "\"" + string + "/>");
            }
        }
        this.outputMetadataArtifact(printWriter, ivyNode);
        this.outputEvictionInformation(configurationResolveReport, printWriter, ivyNode);
        this.outputCallers(configurationResolveReport, printWriter, ivyNode);
        this.outputArtifacts(configurationResolveReport, printWriter, ivyNode);
        printWriter.println("\t\t\t</revision>");
    }

    private void outputEvictionInformation(ConfigurationResolveReport configurationResolveReport, PrintWriter printWriter, IvyNode ivyNode) {
        IvyNodeEviction.EvictionData evictionData;
        Collection collection;
        if (ivyNode.isEvicted(configurationResolveReport.getConfiguration()) && (collection = (evictionData = ivyNode.getEvictedData(configurationResolveReport.getConfiguration())).getSelected()) != null) {
            for (IvyNode ivyNode2 : collection) {
                printWriter.println("\t\t\t\t<evicted-by rev=\"" + XMLHelper.escape(ivyNode2.getResolvedId().getRevision()) + "\"/>");
            }
        }
    }

    private void outputMetadataArtifact(PrintWriter printWriter, IvyNode ivyNode) {
        if (ivyNode.getModuleRevision() != null) {
            ArtifactOrigin artifactOrigin;
            MetadataArtifactDownloadReport metadataArtifactDownloadReport = ivyNode.getModuleRevision().getReport();
            printWriter.print("\t\t\t\t<metadata-artifact");
            printWriter.print(" status=\"" + XMLHelper.escape(metadataArtifactDownloadReport.getDownloadStatus().toString()) + "\"");
            printWriter.print(" details=\"" + XMLHelper.escape(metadataArtifactDownloadReport.getDownloadDetails()) + "\"");
            printWriter.print(" size=\"" + metadataArtifactDownloadReport.getSize() + "\"");
            printWriter.print(" time=\"" + metadataArtifactDownloadReport.getDownloadTimeMillis() + "\"");
            if (metadataArtifactDownloadReport.getLocalFile() != null) {
                printWriter.print(" location=\"" + XMLHelper.escape(metadataArtifactDownloadReport.getLocalFile().getAbsolutePath()) + "\"");
            }
            printWriter.print(" searched=\"" + metadataArtifactDownloadReport.isSearched() + "\"");
            if (metadataArtifactDownloadReport.getOriginalLocalFile() != null) {
                printWriter.print(" original-local-location=\"" + XMLHelper.escape(metadataArtifactDownloadReport.getOriginalLocalFile().getAbsolutePath()) + "\"");
            }
            if ((artifactOrigin = metadataArtifactDownloadReport.getArtifactOrigin()) != null) {
                printWriter.print(" origin-is-local=\"" + String.valueOf(artifactOrigin.isLocal()) + "\"");
                printWriter.print(" origin-location=\"" + XMLHelper.escape(artifactOrigin.getLocation()) + "\"");
            }
            printWriter.println("/>");
        }
    }

    private void outputCallers(ConfigurationResolveReport configurationResolveReport, PrintWriter printWriter, IvyNode ivyNode) {
        IvyNodeCallers.Caller[] callerArray = ivyNode.getCallers(configurationResolveReport.getConfiguration());
        for (int i = 0; i < callerArray.length; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            Map map = callerArray[i].getDependencyDescriptor().getExtraAttributes();
            for (String string : map.keySet()) {
                stringBuffer.append(" extra-").append(string).append("=\"").append(XMLHelper.escape(map.get(string).toString())).append("\"");
            }
            printWriter.println("\t\t\t\t<caller organisation=\"" + XMLHelper.escape(callerArray[i].getModuleRevisionId().getOrganisation()) + "\"" + " name=\"" + XMLHelper.escape(callerArray[i].getModuleRevisionId().getName()) + "\"" + " conf=\"" + XMLHelper.escape(this.toString(callerArray[i].getCallerConfigurations())) + "\"" + " rev=\"" + XMLHelper.escape(callerArray[i].getAskedDependencyId(ivyNode.getData()).getRevision()) + "\"" + " rev-constraint-default=\"" + XMLHelper.escape(callerArray[i].getDependencyDescriptor().getDependencyRevisionId().getRevision()) + "\"" + " rev-constraint-dynamic=\"" + XMLHelper.escape(callerArray[i].getDependencyDescriptor().getDynamicConstraintDependencyRevisionId().getRevision()) + "\"" + " callerrev=\"" + XMLHelper.escape(callerArray[i].getModuleRevisionId().getRevision()) + "\"" + stringBuffer + "/>");
        }
    }

    private void outputArtifacts(ConfigurationResolveReport configurationResolveReport, PrintWriter printWriter, IvyNode ivyNode) {
        ArtifactDownloadReport[] artifactDownloadReportArray = configurationResolveReport.getDownloadReports(ivyNode.getResolvedId());
        printWriter.println("\t\t\t\t<artifacts>");
        for (int i = 0; i < artifactDownloadReportArray.length; ++i) {
            printWriter.print("\t\t\t\t\t<artifact name=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getName()) + "\" type=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getType()) + "\" ext=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getExt()) + "\"");
            Map map = artifactDownloadReportArray[i].getArtifact().getExtraAttributes();
            Object object = map.keySet().iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                printWriter.print(" extra-" + string + "=\"" + XMLHelper.escape(map.get(string).toString()) + "\"");
            }
            printWriter.print(" status=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getDownloadStatus().toString()) + "\"");
            printWriter.print(" details=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getDownloadDetails()) + "\"");
            printWriter.print(" size=\"" + artifactDownloadReportArray[i].getSize() + "\"");
            printWriter.print(" time=\"" + artifactDownloadReportArray[i].getDownloadTimeMillis() + "\"");
            if (artifactDownloadReportArray[i].getLocalFile() != null) {
                printWriter.print(" location=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getLocalFile().getAbsolutePath()) + "\"");
            }
            if (artifactDownloadReportArray[i].getUnpackedLocalFile() != null) {
                printWriter.print(" unpackedFile=\"" + XMLHelper.escape(artifactDownloadReportArray[i].getUnpackedLocalFile().getAbsolutePath()) + "\"");
            }
            if ((object = artifactDownloadReportArray[i].getArtifactOrigin()) != null) {
                printWriter.println(">");
                printWriter.println("\t\t\t\t\t\t<origin-location is-local=\"" + String.valueOf(((ArtifactOrigin)object).isLocal()) + "\"" + " location=\"" + XMLHelper.escape(((ArtifactOrigin)object).getLocation()) + "\"/>");
                printWriter.println("\t\t\t\t\t</artifact>");
                continue;
            }
            printWriter.println("/>");
        }
        printWriter.println("\t\t\t\t</artifacts>");
    }

    private String toString(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            if (i + 1 >= stringArray.length) continue;
            stringBuffer.append(", ");
        }
        return XMLHelper.escape(stringBuffer.toString());
    }
}

