/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.parser.xml;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationAware;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultIncludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.ExtraInfoHolder;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.descriptor.OverrideDependencyDescriptorMediator;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.conflict.FixedConflictManager;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.parser.AbstractModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.ParserSettings;
import org.apache.ivy.plugins.parser.xml.UpdateOptions;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorUpdater;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.apache.ivy.util.extendable.ExtendableItemHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlModuleDescriptorParser
extends AbstractModuleDescriptorParser {
    static final String[] DEPENDENCY_REGULAR_ATTRIBUTES = new String[]{"org", "name", "branch", "branchConstraint", "rev", "revConstraint", "force", "transitive", "changing", "conf"};
    private static final XmlModuleDescriptorParser INSTANCE = new XmlModuleDescriptorParser();

    public static XmlModuleDescriptorParser getInstance() {
        return INSTANCE;
    }

    protected XmlModuleDescriptorParser() {
    }

    @Override
    public ModuleDescriptor parseDescriptor(ParserSettings parserSettings, URL uRL, Resource resource, boolean bl) throws ParseException, IOException {
        Parser parser = this.newParser(parserSettings);
        parser.setValidate(bl);
        parser.setResource(resource);
        parser.setInput(uRL);
        parser.parse();
        return parser.getModuleDescriptor();
    }

    ModuleDescriptor parseDescriptor(ParserSettings parserSettings, InputStream inputStream, Resource resource, boolean bl) throws ParseException, IOException {
        Parser parser = this.newParser(parserSettings);
        parser.setValidate(bl);
        parser.setResource(resource);
        parser.setInput(inputStream);
        parser.parse();
        return parser.getModuleDescriptor();
    }

    protected Parser newParser(ParserSettings parserSettings) {
        return new Parser(this, parserSettings);
    }

    @Override
    public boolean accept(Resource resource) {
        return true;
    }

    @Override
    public void toIvyFile(InputStream inputStream, Resource resource, File file, ModuleDescriptor moduleDescriptor) throws IOException, ParseException {
        try {
            Namespace namespace = null;
            if (moduleDescriptor instanceof DefaultModuleDescriptor) {
                DefaultModuleDescriptor defaultModuleDescriptor = (DefaultModuleDescriptor)moduleDescriptor;
                namespace = defaultModuleDescriptor.getNamespace();
            }
            XmlModuleDescriptorUpdater.update(inputStream, resource, file, new UpdateOptions().setSettings(IvyContext.getContext().getSettings()).setStatus(moduleDescriptor.getStatus()).setRevision(moduleDescriptor.getResolvedModuleRevisionId().getRevision()).setPubdate(moduleDescriptor.getResolvedPublicationDate()).setUpdateBranch(false).setNamespace(namespace));
        }
        catch (SAXException sAXException) {
            ParseException parseException = new ParseException("exception occurred while parsing " + resource, 0);
            parseException.initCause(sAXException);
            throw parseException;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    public String toString() {
        return "ivy parser";
    }

    public static class Parser
    extends AbstractModuleDescriptorParser.AbstractParser {
        protected static final List ALLOWED_VERSIONS = Arrays.asList("1.0", "1.1", "1.2", "1.3", "1.4", "2.0", "2.1", "2.2", "2.3", "2.4");
        private ParserSettings settings;
        private boolean validate = true;
        private URL descriptorURL;
        private InputStream descriptorInput;
        private int state = 0;
        private PatternMatcher defaultMatcher;
        private DefaultDependencyDescriptor dd;
        private ConfigurationAware confAware;
        private MDArtifact artifact;
        private String conf;
        private boolean artifactsDeclared = false;
        private StringBuffer buffer;
        private String descriptorVersion;
        private String[] publicationsDefaultConf;
        private Stack<ExtraInfoHolder> extraInfoStack = new Stack();

        public Parser(ModuleDescriptorParser moduleDescriptorParser, ParserSettings parserSettings) {
            super(moduleDescriptorParser);
            this.settings = parserSettings;
        }

        public void setInput(InputStream inputStream) {
            this.descriptorInput = inputStream;
        }

        public void setInput(URL uRL) {
            this.descriptorURL = uRL;
        }

        public void setValidate(boolean bl) {
            this.validate = bl;
        }

        public void parse() throws ParseException, IOException {
            try {
                URL uRL;
                URL uRL2 = uRL = this.validate ? this.getSchemaURL() : null;
                if (this.descriptorURL != null) {
                    XMLHelper.parse(this.descriptorURL, uRL, this);
                } else {
                    XMLHelper.parse(this.descriptorInput, uRL, (DefaultHandler)this, null);
                }
                this.checkConfigurations();
                this.replaceConfigurationWildcards();
                this.getMd().setModuleArtifact(DefaultArtifact.newIvyArtifact(this.getMd().getResolvedModuleRevisionId(), this.getMd().getPublicationDate()));
                if (!this.artifactsDeclared) {
                    String[] stringArray = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.getMd().addArtifact(stringArray[i], new MDArtifact(this.getMd(), this.getMd().getModuleRevisionId().getName(), "jar", "jar"));
                    }
                }
                this.getMd().check();
            }
            catch (ParserConfigurationException parserConfigurationException) {
                IllegalStateException illegalStateException = new IllegalStateException(parserConfigurationException.getMessage() + " in " + this.descriptorURL);
                illegalStateException.initCause(parserConfigurationException);
                throw illegalStateException;
            }
            catch (Exception exception) {
                this.checkErrors();
                ParseException parseException = new ParseException(exception.getMessage() + " in " + this.descriptorURL, 0);
                parseException.initCause(exception);
                throw parseException;
            }
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            try {
                if (this.state == 11) {
                    this.getBuffer().append("<").append(string3);
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        this.getBuffer().append(" ");
                        this.getBuffer().append(attributes.getQName(i));
                        this.getBuffer().append("=\"");
                        this.getBuffer().append(attributes.getValue(i));
                        this.getBuffer().append("\"");
                    }
                    this.getBuffer().append(">");
                    return;
                }
                if ("ivy-module".equals(string3)) {
                    this.ivyModuleStarted(attributes);
                } else if ("info".equals(string3)) {
                    this.infoStarted(attributes);
                } else if (this.state == 1 && "extends".equals(string3)) {
                    this.extendsStarted(attributes);
                } else if (this.state == 1 && "license".equals(string3)) {
                    this.getMd().addLicense(new License(this.settings.substitute(attributes.getValue("name")), this.settings.substitute(attributes.getValue("url"))));
                } else if (this.state == 1 && "description".equals(string3)) {
                    this.getMd().setHomePage(this.settings.substitute(attributes.getValue("homepage")));
                    this.state = 11;
                    this.buffer = new StringBuffer();
                } else if (!(this.state == 1 && "ivyauthor".equals(string3) || this.state == 1 && "repository".equals(string3))) {
                    if (this.state == 12 || this.state == 1 && this.isOtherNamespace(string3)) {
                        this.buffer = new StringBuffer();
                        this.state = 12;
                        ExtraInfoHolder extraInfoHolder = new ExtraInfoHolder();
                        extraInfoHolder.setName(string3);
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            extraInfoHolder.getAttributes().put(attributes.getQName(i), attributes.getValue(i));
                        }
                        this.extraInfoStack.push(extraInfoHolder);
                    } else if ("configurations".equals(string3)) {
                        this.configurationStarted(attributes);
                    } else if ("publications".equals(string3)) {
                        this.publicationsStarted(attributes);
                    } else if ("dependencies".equals(string3)) {
                        this.dependenciesStarted(attributes);
                    } else if ("conflicts".equals(string3)) {
                        if (!this.descriptorVersion.startsWith("1.")) {
                            Message.deprecated("using conflicts section is deprecated: please use hints section instead. Ivy file URL: " + this.descriptorURL);
                        }
                        this.state = 8;
                        this.checkConfigurations();
                    } else if ("artifact".equals(string3)) {
                        this.artifactStarted(string3, attributes);
                    } else if ("include".equals(string3) && this.state == 4) {
                        this.addIncludeRule(string3, attributes);
                    } else if ("exclude".equals(string3) && this.state == 4) {
                        this.addExcludeRule(string3, attributes);
                    } else if ("exclude".equals(string3) && this.state == 10) {
                        this.state = 9;
                        this.parseRule(string3, attributes);
                        this.getMd().addExcludeRule((ExcludeRule)((Object)this.confAware));
                    } else if ("dependency".equals(string3)) {
                        this.dependencyStarted(attributes);
                    } else if ("conf".equals(string3)) {
                        this.confStarted(attributes);
                    } else if ("mapped".equals(string3)) {
                        this.dd.addDependencyConfiguration(this.conf, this.settings.substitute(attributes.getValue("name")));
                    } else if ("conflict".equals(string3) && this.state == 10 || "manager".equals(string3) && this.state == 8) {
                        this.managerStarted(attributes, this.state == 8 ? "name" : "manager");
                    } else if ("override".equals(string3) && this.state == 10) {
                        this.mediationOverrideStarted(attributes);
                    } else if ("include".equals(string3) && this.state == 2) {
                        this.includeConfStarted(attributes);
                    } else if (this.validate && this.state != 12 && this.state != 11) {
                        this.addError("unknown tag " + string3);
                    }
                }
            }
            catch (Exception exception) {
                if (exception instanceof SAXException) {
                    throw (SAXException)exception;
                }
                SAXException sAXException = new SAXException("Problem occurred while parsing ivy file: " + exception.getMessage(), exception);
                sAXException.initCause(exception);
                throw sAXException;
            }
        }

        protected String getDefaultParentLocation() {
            return "../ivy.xml";
        }

        protected void extendsStarted(Attributes attributes) throws ParseException {
            Object object;
            String string = this.settings.substitute(attributes.getValue("organisation"));
            String string2 = this.settings.substitute(attributes.getValue("module"));
            String string3 = attributes.getValue("revision") != null ? this.settings.substitute(attributes.getValue("revision")) : Ivy.getWorkingRevision();
            String string4 = attributes.getValue("location") != null ? this.settings.substitute(attributes.getValue("location")) : this.getDefaultParentLocation();
            ModuleDescriptor moduleDescriptor = null;
            String string5 = attributes.getValue("extendType") != null ? this.settings.substitute(attributes.getValue("extendType").toLowerCase(Locale.US)) : "all";
            List<String> list = Arrays.asList(string5.split(","));
            ModuleId moduleId = new ModuleId(string, string2);
            ModuleRevisionId moduleRevisionId = new ModuleRevisionId(moduleId, string3);
            boolean bl = false;
            try {
                moduleDescriptor = this.parseParentModuleOnFilesystem(string4);
                if (moduleDescriptor != null && !((ModuleId)(object = moduleDescriptor.getResolvedModuleRevisionId().getModuleId())).equals(moduleId)) {
                    Message.info("Found a parent module with unexpected ModuleRevisionId at source location " + string4 + "! Expected: " + moduleId + ". Found: " + object + ". This parent module will be ignored.");
                    moduleDescriptor = null;
                }
                bl = moduleDescriptor != null;
            }
            catch (IOException iOException) {
                Message.warn("Unable to parse included ivy file " + string4, iOException);
            }
            if (moduleDescriptor == null) {
                try {
                    moduleDescriptor = this.parseOtherIvyFile(moduleRevisionId);
                }
                catch (ParseException parseException) {
                    Message.warn("Unable to parse included ivy file for " + moduleRevisionId.toString(), parseException);
                }
            }
            if (moduleDescriptor == null) {
                throw new ParseException("Unable to parse included ivy file for " + moduleRevisionId.toString(), 0);
            }
            object = new DefaultExtendsDescriptor(moduleDescriptor, string4, list.toArray(new String[list.size()]), bl);
            this.getMd().addInheritedDescriptor((ExtendsDescriptor)object);
            this.mergeWithOtherModuleDescriptor(list, moduleDescriptor);
        }

        protected void mergeWithOtherModuleDescriptor(List list, ModuleDescriptor moduleDescriptor) throws ParseException {
            if (list.contains("all")) {
                this.mergeAll(moduleDescriptor);
            } else {
                if (list.contains("info")) {
                    this.mergeInfo(moduleDescriptor);
                }
                if (list.contains("configurations")) {
                    this.mergeConfigurations(moduleDescriptor);
                }
                if (list.contains("dependencies")) {
                    this.mergeDependencies(moduleDescriptor.getDependencies());
                }
                if (list.contains("description")) {
                    this.mergeDescription(moduleDescriptor.getDescription());
                }
                if (list.contains("licenses")) {
                    this.mergeLicenses(moduleDescriptor.getLicenses());
                }
                if (list.contains("excludes")) {
                    this.mergeExcludes(moduleDescriptor.getAllExcludeRules());
                }
            }
        }

        protected void mergeAll(ModuleDescriptor moduleDescriptor) {
            this.mergeInfo(moduleDescriptor);
            this.mergeConfigurations(moduleDescriptor);
            this.mergeDependencies(moduleDescriptor.getDependencies());
            this.mergeDescription(moduleDescriptor.getDescription());
            this.mergeLicenses(moduleDescriptor.getLicenses());
            this.mergeExcludes(moduleDescriptor.getAllExcludeRules());
        }

        protected void mergeInfo(ModuleDescriptor moduleDescriptor) {
            ModuleRevisionId moduleRevisionId = moduleDescriptor.getModuleRevisionId();
            DefaultModuleDescriptor defaultModuleDescriptor = this.getMd();
            ModuleRevisionId moduleRevisionId2 = defaultModuleDescriptor.getModuleRevisionId();
            ModuleRevisionId moduleRevisionId3 = ModuleRevisionId.newInstance(Parser.mergeValue(moduleRevisionId.getOrganisation(), moduleRevisionId2.getOrganisation()), moduleRevisionId2.getName(), Parser.mergeValue(moduleRevisionId.getBranch(), moduleRevisionId2.getBranch()), Parser.mergeRevisionValue(moduleRevisionId.getRevision(), moduleRevisionId2.getRevision()), Parser.mergeValues(moduleRevisionId.getQualifiedExtraAttributes(), moduleRevisionId2.getQualifiedExtraAttributes()));
            defaultModuleDescriptor.setModuleRevisionId(moduleRevisionId3);
            defaultModuleDescriptor.setResolvedModuleRevisionId(moduleRevisionId3);
            defaultModuleDescriptor.setStatus(Parser.mergeValue(moduleDescriptor.getStatus(), defaultModuleDescriptor.getStatus()));
            if (defaultModuleDescriptor.getNamespace() == null && moduleDescriptor instanceof DefaultModuleDescriptor) {
                Namespace namespace = ((DefaultModuleDescriptor)moduleDescriptor).getNamespace();
                defaultModuleDescriptor.setNamespace(namespace);
            }
        }

        private static String mergeRevisionValue(String string, String string2) {
            if (string2 == null || string2.equals(Ivy.getWorkingRevision())) {
                return string;
            }
            return string2;
        }

        private static String mergeValue(String string, String string2) {
            return string2 == null ? string : string2;
        }

        private static Map mergeValues(Map map, Map map2) {
            LinkedHashMap linkedHashMap = new LinkedHashMap(map.size() + map2.size());
            linkedHashMap.putAll(map);
            linkedHashMap.putAll(map2);
            return linkedHashMap;
        }

        protected void mergeConfigurations(ModuleDescriptor moduleDescriptor) {
            ModuleRevisionId moduleRevisionId = moduleDescriptor.getModuleRevisionId();
            Configuration[] configurationArray = moduleDescriptor.getConfigurations();
            for (int i = 0; i < configurationArray.length; ++i) {
                Configuration configuration = configurationArray[i];
                Message.debug("Merging configuration with: " + configuration.getName());
                this.getMd().addConfiguration(new Configuration(configuration, moduleRevisionId));
            }
            if (moduleDescriptor instanceof DefaultModuleDescriptor) {
                this.setDefaultConfMapping(((DefaultModuleDescriptor)moduleDescriptor).getDefaultConfMapping());
                this.setDefaultConf(((DefaultModuleDescriptor)moduleDescriptor).getDefaultConf());
                this.getMd().setMappingOverride(((DefaultModuleDescriptor)moduleDescriptor).isMappingOverride());
            }
        }

        protected void mergeDependencies(DependencyDescriptor[] dependencyDescriptorArray) {
            DefaultModuleDescriptor defaultModuleDescriptor = this.getMd();
            for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                DependencyDescriptor dependencyDescriptor = dependencyDescriptorArray[i];
                Message.debug("Merging dependency with: " + dependencyDescriptor.getDependencyRevisionId().toString());
                defaultModuleDescriptor.addDependency(dependencyDescriptor);
            }
        }

        protected void mergeDescription(String string) {
            String string2 = this.getMd().getDescription();
            if (string2 == null || string2.trim().length() == 0) {
                this.getMd().setDescription(string);
            }
        }

        public void mergeLicenses(License[] licenseArray) {
            for (int i = 0; i < licenseArray.length; ++i) {
                this.getMd().addLicense(licenseArray[i]);
            }
        }

        public void mergeExcludes(ExcludeRule[] excludeRuleArray) {
            for (int i = 0; i < excludeRuleArray.length; ++i) {
                this.getMd().addExcludeRule(excludeRuleArray[i]);
            }
        }

        private ModuleDescriptor parseParentModuleOnFilesystem(String string) throws IOException, ParseException {
            Object object;
            if (!"file".equals(this.descriptorURL.getProtocol())) {
                return null;
            }
            File file = new File(string);
            if (!file.isAbsolute()) {
                object = this.settings.getRelativeUrlResolver().getURL(this.descriptorURL, string);
                try {
                    file = new File(new URI(((URL)object).toExternalForm()));
                }
                catch (URISyntaxException uRISyntaxException) {
                    file = new File(((URL)object).getPath());
                }
            }
            if (!(file = FileUtil.normalize(file.getAbsolutePath())).exists()) {
                Message.verbose("Parent module doesn't exist on the filesystem: " + file.getAbsolutePath());
                return null;
            }
            object = new FileResource(null, file);
            ModuleDescriptorParser moduleDescriptorParser = ModuleDescriptorParserRegistry.getInstance().getParser((Resource)object);
            return moduleDescriptorParser.parseDescriptor(this.getSettings(), file.toURL(), (Resource)object, this.isValidate());
        }

        protected ModuleDescriptor parseOtherIvyFile(ModuleRevisionId moduleRevisionId) throws ParseException {
            Object object;
            Object object2;
            Message.debug("Trying to parse included ivy file by asking repository for module :" + moduleRevisionId.toString());
            DependencyDescriptor dependencyDescriptor = new DefaultDependencyDescriptor(moduleRevisionId, true);
            ResolveData resolveData = IvyContext.getContext().getResolveData();
            if (resolveData == null) {
                object2 = IvyContext.getContext().getIvy().getResolveEngine();
                object = new ResolveOptions();
                ((ResolveOptions)object).setDownload(false);
                resolveData = new ResolveData((ResolveEngine)object2, (ResolveOptions)object);
            }
            if ((object = (object2 = this.getSettings().getResolver(moduleRevisionId)).getDependency(dependencyDescriptor = NameSpaceHelper.toSystem(dependencyDescriptor, this.getSettings().getContextNamespace()), resolveData)) == null) {
                throw new ParseException("Unable to find " + moduleRevisionId.toString(), 0);
            }
            return ((ResolvedModuleRevision)object).getDescriptor();
        }

        protected void publicationsStarted(Attributes attributes) {
            this.state = 3;
            this.artifactsDeclared = true;
            this.checkConfigurations();
            String string = this.settings.substitute(attributes.getValue("defaultconf"));
            if (string != null) {
                this.setPublicationsDefaultConf(string);
            }
        }

        protected void setPublicationsDefaultConf(String string) {
            this.publicationsDefaultConf = string == null ? null : string.split(",");
        }

        protected boolean isOtherNamespace(String string) {
            return string.indexOf(58) != -1;
        }

        protected void managerStarted(Attributes attributes, String string) {
            PatternMatcher patternMatcher;
            ConflictManager conflictManager;
            Object object;
            String string2 = this.settings.substitute(attributes.getValue("org"));
            string2 = string2 == null ? "*" : string2;
            String string3 = this.settings.substitute(attributes.getValue("module"));
            string3 = string3 == null ? "*" : string3;
            String string4 = this.settings.substitute(attributes.getValue(string));
            String string5 = this.settings.substitute(attributes.getValue("rev"));
            if (string5 != null) {
                object = string5.split(",");
                for (int i = 0; i < ((String[])object).length; ++i) {
                    object[i] = object[i].trim();
                }
                conflictManager = new FixedConflictManager((String[])object);
            } else if (string4 != null) {
                conflictManager = this.settings.getConflictManager(string4);
                if (conflictManager == null) {
                    this.addError("unknown conflict manager: " + string4);
                    return;
                }
            } else {
                this.addError("bad conflict manager: no manager nor rev");
                return;
            }
            object = this.settings.substitute(attributes.getValue("matcher"));
            PatternMatcher patternMatcher2 = patternMatcher = object == null ? this.defaultMatcher : this.settings.getMatcher((String)object);
            if (patternMatcher == null) {
                this.addError("unknown matcher: " + (String)object);
                return;
            }
            this.getMd().addConflictManager(new ModuleId(string2, string3), patternMatcher, conflictManager);
        }

        protected void mediationOverrideStarted(Attributes attributes) {
            PatternMatcher patternMatcher;
            String string = this.settings.substitute(attributes.getValue("org"));
            string = string == null ? "*" : string;
            String string2 = this.settings.substitute(attributes.getValue("module"));
            string2 = string2 == null ? "*" : string2;
            String string3 = this.settings.substitute(attributes.getValue("rev"));
            String string4 = this.settings.substitute(attributes.getValue("branch"));
            String string5 = this.settings.substitute(attributes.getValue("matcher"));
            PatternMatcher patternMatcher2 = patternMatcher = string5 == null ? this.defaultMatcher : this.settings.getMatcher(string5);
            if (patternMatcher == null) {
                this.addError("unknown matcher: " + string5);
                return;
            }
            this.getMd().addDependencyDescriptorMediator(new ModuleId(string, string2), patternMatcher, new OverrideDependencyDescriptorMediator(string4, string3));
        }

        protected void includeConfStarted(Attributes attributes) throws SAXException, IOException, ParserConfigurationException, ParseException {
            URL uRL = this.settings.getRelativeUrlResolver().getURL(this.descriptorURL, this.settings.substitute(attributes.getValue("file")), this.settings.substitute(attributes.getValue("url")));
            if (uRL == null) {
                throw new SAXException("include tag must have a file or an url attribute");
            }
            Parser parser = new Parser(this.getModuleDescriptorParser(), this.settings);
            parser.setInput(uRL);
            parser.setMd(new DefaultModuleDescriptor(this.getModuleDescriptorParser(), new URLResource(uRL)));
            XMLHelper.parse(uRL, null, parser);
            Configuration[] configurationArray = parser.getModuleDescriptor().getConfigurations();
            for (int i = 0; i < configurationArray.length; ++i) {
                this.getMd().addConfiguration(configurationArray[i]);
            }
            if (parser.getDefaultConfMapping() != null) {
                Message.debug("setting default conf mapping from imported configurations file: " + parser.getDefaultConfMapping());
                this.setDefaultConfMapping(parser.getDefaultConfMapping());
            }
            if (parser.getDefaultConf() != null) {
                Message.debug("setting default conf from imported configurations file: " + parser.getDefaultConf());
                this.setDefaultConf(parser.getDefaultConf());
            }
            if (parser.getMd().isMappingOverride()) {
                Message.debug("enabling mapping-override from imported configurations file");
                this.getMd().setMappingOverride(true);
            }
        }

        protected void confStarted(Attributes attributes) {
            String string = this.settings.substitute(attributes.getValue("name"));
            switch (this.state) {
                case 2: {
                    String string2 = this.settings.substitute(attributes.getValue("visibility"));
                    String string3 = this.settings.substitute(attributes.getValue("extends"));
                    String string4 = attributes.getValue("transitive");
                    boolean bl = string4 == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
                    String string5 = attributes.getValue("deprecated");
                    Configuration configuration = new Configuration(string, Configuration.Visibility.getVisibility(string2 == null ? "public" : string2), this.settings.substitute(attributes.getValue("description")), string3 == null ? null : string3.split(","), bl, string5);
                    ExtendableItemHelper.fillExtraAttributes(this.settings, configuration, attributes, new String[]{"name", "visibility", "extends", "transitive", "description", "deprecated"});
                    this.getMd().addConfiguration(configuration);
                    break;
                }
                case 3: {
                    if ("*".equals(string)) {
                        String[] stringArray = this.getMd().getConfigurationsNames();
                        for (int i = 0; i < stringArray.length; ++i) {
                            this.artifact.addConfiguration(stringArray[i]);
                            this.getMd().addArtifact(stringArray[i], this.artifact);
                        }
                        break;
                    }
                    this.artifact.addConfiguration(string);
                    this.getMd().addArtifact(string, this.artifact);
                    break;
                }
                case 4: {
                    this.conf = string;
                    String string6 = this.settings.substitute(attributes.getValue("mapped"));
                    if (string6 == null) break;
                    String[] stringArray = string6.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.dd.addDependencyConfiguration(string, stringArray[i].trim());
                    }
                    break;
                }
                case 5: 
                case 6: 
                case 7: {
                    this.addConfiguration(string);
                    break;
                }
                default: {
                    if (!this.validate) break;
                    this.addError("conf tag found in invalid tag: " + this.state);
                }
            }
        }

        protected void dependencyStarted(Attributes attributes) {
            this.state = 4;
            String string = this.settings.substitute(attributes.getValue("org"));
            if (string == null) {
                string = this.getMd().getModuleRevisionId().getOrganisation();
            }
            boolean bl = Boolean.valueOf(this.settings.substitute(attributes.getValue("force")));
            boolean bl2 = Boolean.valueOf(this.settings.substitute(attributes.getValue("changing")));
            String string2 = this.settings.substitute(attributes.getValue("transitive"));
            boolean bl3 = string2 == null ? true : Boolean.valueOf(attributes.getValue("transitive"));
            String string3 = this.settings.substitute(attributes.getValue("name"));
            String string4 = this.settings.substitute(attributes.getValue("branch"));
            String string5 = this.settings.substitute(attributes.getValue("branchConstraint"));
            String string6 = this.settings.substitute(attributes.getValue("rev"));
            String string7 = this.settings.substitute(attributes.getValue("revConstraint"));
            Map map = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, DEPENDENCY_REGULAR_ATTRIBUTES);
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(string, string3, string4, string6, map);
            ModuleRevisionId moduleRevisionId2 = null;
            moduleRevisionId2 = string7 == null && string5 == null ? ModuleRevisionId.newInstance(string, string3, string4, string6, map, false) : (string5 == null ? ModuleRevisionId.newInstance(string, string3, null, string7, map, false) : ModuleRevisionId.newInstance(string, string3, string5, string7, map));
            this.dd = new DefaultDependencyDescriptor(this.getMd(), moduleRevisionId, moduleRevisionId2, bl, bl2, bl3);
            this.getMd().addDependency(this.dd);
            String string8 = this.settings.substitute(attributes.getValue("conf"));
            if (string8 != null && string8.length() > 0) {
                this.parseDepsConfs(string8, this.dd);
            }
        }

        protected void artifactStarted(String string, Attributes attributes) throws MalformedURLException {
            if (this.state == 3) {
                String string2 = this.settings.substitute(attributes.getValue("name"));
                string2 = string2 == null ? this.getMd().getModuleRevisionId().getName() : string2;
                String string3 = this.settings.substitute(attributes.getValue("type"));
                string3 = string3 == null ? "jar" : string3;
                String string4 = this.settings.substitute(attributes.getValue("ext"));
                string4 = string4 != null ? string4 : string3;
                String string5 = this.settings.substitute(attributes.getValue("url"));
                this.artifact = new MDArtifact(this.getMd(), string2, string3, string4, string5 == null ? null : new URL(string5), ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"ext", "type", "name", "conf"}));
                String string6 = this.settings.substitute(attributes.getValue("conf"));
                if (string6 != null && string6.length() > 0) {
                    String[] stringArray = "*".equals(string6) ? this.getMd().getConfigurationsNames() : string6.split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.artifact.addConfiguration(stringArray[i].trim());
                        this.getMd().addArtifact(stringArray[i].trim(), this.artifact);
                    }
                }
            } else if (this.state == 4) {
                this.addDependencyArtifacts(string, attributes);
            } else if (this.validate) {
                this.addError("artifact tag found in invalid tag: " + this.state);
            }
        }

        protected void dependenciesStarted(Attributes attributes) {
            String string;
            this.state = 10;
            String string2 = this.settings.substitute(attributes.getValue("defaultconf"));
            if (string2 != null) {
                this.setDefaultConf(string2);
            }
            if ((string2 = this.settings.substitute(attributes.getValue("defaultconfmapping"))) != null) {
                this.setDefaultConfMapping(string2);
            }
            if ((string = this.settings.substitute(attributes.getValue("confmappingoverride"))) != null) {
                this.getMd().setMappingOverride(Boolean.valueOf(string));
            }
            this.checkConfigurations();
        }

        protected void configurationStarted(Attributes attributes) {
            this.state = 2;
            this.setDefaultConfMapping(this.settings.substitute(attributes.getValue("defaultconfmapping")));
            this.setDefaultConf(this.settings.substitute(attributes.getValue("defaultconf")));
            this.getMd().setMappingOverride(Boolean.valueOf(this.settings.substitute(attributes.getValue("confmappingoverride"))));
        }

        protected void infoStarted(Attributes attributes) {
            Object object;
            this.state = 1;
            String string = this.settings.substitute(attributes.getValue("organisation"));
            String string2 = this.settings.substitute(attributes.getValue("module"));
            String string3 = this.settings.substitute(attributes.getValue("revision"));
            String string4 = this.settings.substitute(attributes.getValue("branch"));
            this.getMd().setModuleRevisionId(ModuleRevisionId.newInstance(string, string2, string4, string3, ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"organisation", "module", "revision", "status", "publication", "branch", "namespace", "default", "resolver"})));
            String string5 = this.settings.substitute(attributes.getValue("namespace"));
            if (string5 != null) {
                object = this.settings.getNamespace(string5);
                if (object == null) {
                    Message.warn("namespace not found for " + this.getMd().getModuleRevisionId() + ": " + string5);
                } else {
                    this.getMd().setNamespace((Namespace)object);
                }
            }
            object = this.settings.substitute(attributes.getValue("status"));
            this.getMd().setStatus((String)(object == null ? this.settings.getStatusManager().getDefaultStatus() : object));
            this.getMd().setDefault(Boolean.valueOf(this.settings.substitute(attributes.getValue("default"))));
            String string6 = this.settings.substitute(attributes.getValue("publication"));
            if (string6 != null && string6.length() > 0) {
                try {
                    this.getMd().setPublicationDate(DateUtil.parse(string6));
                }
                catch (ParseException parseException) {
                    this.addError("invalid publication date format: " + string6);
                    this.getMd().setPublicationDate(this.getDefaultPubDate());
                }
            } else {
                this.getMd().setPublicationDate(this.getDefaultPubDate());
            }
        }

        protected void ivyModuleStarted(Attributes attributes) throws SAXException {
            this.descriptorVersion = attributes.getValue("version");
            int n = ALLOWED_VERSIONS.indexOf(this.descriptorVersion);
            if (n == -1) {
                this.addError("invalid version " + this.descriptorVersion);
                throw new SAXException("invalid version " + this.descriptorVersion);
            }
            if (n >= ALLOWED_VERSIONS.indexOf("1.3")) {
                Message.debug("post 1.3 ivy file: using exact as default matcher");
                this.defaultMatcher = this.settings.getMatcher("exact");
            } else {
                Message.debug("pre 1.3 ivy file: using exactOrRegexp as default matcher");
                this.defaultMatcher = this.settings.getMatcher("exactOrRegexp");
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getQName(i).startsWith("xmlns:")) continue;
                this.getMd().addExtraAttributeNamespace(attributes.getQName(i).substring("xmlns:".length()), attributes.getValue(i));
            }
        }

        protected void addDependencyArtifacts(String string, Attributes attributes) throws MalformedURLException {
            this.state = 5;
            this.parseRule(string, attributes);
        }

        protected void addIncludeRule(String string, Attributes attributes) throws MalformedURLException {
            this.state = 6;
            this.parseRule(string, attributes);
        }

        protected void addExcludeRule(String string, Attributes attributes) throws MalformedURLException {
            this.state = 7;
            this.parseRule(string, attributes);
        }

        protected void parseRule(String string, Attributes attributes) throws MalformedURLException {
            Map map;
            ArtifactId artifactId;
            String string2;
            Object object;
            Object object2;
            String string3;
            String string4;
            String string5 = this.settings.substitute(attributes.getValue("name"));
            if (string5 == null && (string5 = this.settings.substitute(attributes.getValue("artifact"))) == null) {
                String string6 = string5 = "artifact".equals(string) ? this.dd.getDependencyId().getName() : "*";
            }
            if ((string4 = this.settings.substitute(attributes.getValue("type"))) == null) {
                string4 = "artifact".equals(string) ? "jar" : "*";
            }
            String string7 = string3 = (string3 = this.settings.substitute(attributes.getValue("ext"))) != null ? string3 : string4;
            if (this.state == 5) {
                object2 = this.settings.substitute(attributes.getValue("url"));
                object = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"name", "type", "ext", "url", "conf"});
                this.confAware = new DefaultDependencyArtifactDescriptor(this.dd, string5, string4, string3, object2 == null ? null : new URL((String)object2), (Map)object);
            } else if (this.state == 6) {
                object2 = this.getPatternMatcher(attributes.getValue("matcher"));
                object = this.settings.substitute(attributes.getValue("org"));
                object = object == null ? "*" : object;
                string2 = this.settings.substitute(attributes.getValue("module"));
                string2 = string2 == null ? "*" : string2;
                artifactId = new ArtifactId(new ModuleId((String)object, string2), string5, string4, string3);
                map = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultIncludeRule(artifactId, (PatternMatcher)object2, map);
            } else {
                object2 = this.getPatternMatcher(attributes.getValue("matcher"));
                object = this.settings.substitute(attributes.getValue("org"));
                object = object == null ? "*" : object;
                string2 = this.settings.substitute(attributes.getValue("module"));
                string2 = string2 == null ? "*" : string2;
                artifactId = new ArtifactId(new ModuleId((String)object, string2), string5, string4, string3);
                map = ExtendableItemHelper.getExtraAttributes(this.settings, attributes, new String[]{"org", "module", "name", "type", "ext", "matcher", "conf"});
                this.confAware = new DefaultExcludeRule(artifactId, (PatternMatcher)object2, map);
            }
            object2 = this.settings.substitute(attributes.getValue("conf"));
            if (object2 != null && ((String)object2).length() > 0) {
                object = "*".equals(object2) ? this.getMd().getConfigurationsNames() : ((String)object2).split(",");
                for (int i = 0; i < ((String[])object).length; ++i) {
                    this.addConfiguration(object[i].trim());
                }
            }
        }

        protected void addConfiguration(String string) {
            this.confAware.addConfiguration(string);
            if (this.state != 9) {
                if (this.confAware instanceof DependencyArtifactDescriptor) {
                    this.dd.addDependencyArtifact(string, (DependencyArtifactDescriptor)((Object)this.confAware));
                } else if (this.confAware instanceof IncludeRule) {
                    this.dd.addIncludeRule(string, (IncludeRule)((Object)this.confAware));
                } else if (this.confAware instanceof ExcludeRule) {
                    this.dd.addExcludeRule(string, (ExcludeRule)((Object)this.confAware));
                }
            }
        }

        protected PatternMatcher getPatternMatcher(String string) {
            PatternMatcher patternMatcher;
            String string2 = this.settings.substitute(string);
            PatternMatcher patternMatcher2 = patternMatcher = string2 == null ? this.defaultMatcher : this.settings.getMatcher(string2);
            if (patternMatcher == null) {
                throw new IllegalArgumentException("unknown matcher " + string2);
            }
            return patternMatcher;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.buffer != null) {
                this.buffer.append(cArray, n, n2);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            if (this.state == 3 && "artifact".equals(string3) && this.artifact.getConfigurations().length == 0) {
                String[] stringArray = this.publicationsDefaultConf == null ? this.getMd().getConfigurationsNames() : this.publicationsDefaultConf;
                for (int i = 0; i < stringArray.length; ++i) {
                    this.artifact.addConfiguration(stringArray[i].trim());
                    this.getMd().addArtifact(stringArray[i].trim(), this.artifact);
                }
            } else if ("configurations".equals(string3)) {
                this.checkConfigurations();
            } else if (this.state == 5 && "artifact".equals(string3) || this.state == 6 && "include".equals(string3) || this.state == 7 && "exclude".equals(string3)) {
                this.state = 4;
                if (this.confAware.getConfigurations().length == 0) {
                    String[] stringArray = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.addConfiguration(stringArray[i]);
                    }
                }
                this.confAware = null;
            } else if ("exclude".equals(string3) && this.state == 9) {
                if (this.confAware.getConfigurations().length == 0) {
                    String[] stringArray = this.getMd().getConfigurationsNames();
                    for (int i = 0; i < stringArray.length; ++i) {
                        this.addConfiguration(stringArray[i]);
                    }
                }
                this.confAware = null;
                this.state = 10;
            } else if ("dependency".equals(string3) && this.state == 4) {
                if (this.dd.getModuleConfigurations().length == 0) {
                    this.parseDepsConfs(this.getDefaultConf(), this.dd);
                }
                this.state = 10;
            } else if ("dependencies".equals(string3) && this.state == 10) {
                this.state = 0;
            } else if (this.state == 1 && "info".equals(string3)) {
                this.state = 0;
            } else if (this.state == 11 && "description".equals(string3)) {
                this.getMd().setDescription(this.buffer == null ? "" : this.buffer.toString().trim());
                this.buffer = null;
                this.state = 1;
            } else if (this.state == 12) {
                String string4 = this.buffer == null ? "" : this.buffer.toString();
                this.buffer = null;
                this.getMd().addExtraInfo(string3, string4);
                ExtraInfoHolder extraInfoHolder = this.extraInfoStack.pop();
                extraInfoHolder.setContent(string4);
                if (this.extraInfoStack.isEmpty()) {
                    this.getMd().addExtraInfo(extraInfoHolder);
                    this.state = 1;
                } else {
                    ExtraInfoHolder extraInfoHolder2 = this.extraInfoStack.peek();
                    extraInfoHolder2.getNestedExtraInfoHolder().add(extraInfoHolder);
                }
            } else if (this.state == 11) {
                if (this.buffer.toString().endsWith("<" + string3 + ">")) {
                    this.buffer.deleteCharAt(this.buffer.length() - 1);
                    this.buffer.append("/>");
                } else {
                    this.buffer.append("</" + string3 + ">");
                }
            }
        }

        protected void checkConfigurations() {
            if (this.getMd().getConfigurations().length == 0) {
                this.getMd().addConfiguration(new Configuration("default"));
            }
        }

        protected void replaceConfigurationWildcards() {
            Configuration[] configurationArray = this.getMd().getConfigurations();
            for (int i = 0; i < configurationArray.length; ++i) {
                configurationArray[i].replaceWildcards(this.getMd());
            }
        }

        protected ParserSettings getSettings() {
            return this.settings;
        }

        protected URL getDescriptorURL() {
            return this.descriptorURL;
        }

        protected InputStream getDescriptorInput() {
            return this.descriptorInput;
        }

        protected int getState() {
            return this.state;
        }

        protected void setState(int n) {
            this.state = n;
        }

        protected PatternMatcher getDefaultMatcher() {
            return this.defaultMatcher;
        }

        protected DefaultDependencyDescriptor getDd() {
            return this.dd;
        }

        protected void setDd(DefaultDependencyDescriptor defaultDependencyDescriptor) {
            this.dd = defaultDependencyDescriptor;
        }

        protected ConfigurationAware getConfAware() {
            return this.confAware;
        }

        protected void setConfAware(ConfigurationAware configurationAware) {
            this.confAware = configurationAware;
        }

        protected MDArtifact getArtifact() {
            return this.artifact;
        }

        protected void setArtifact(MDArtifact mDArtifact) {
            this.artifact = mDArtifact;
        }

        protected String getConf() {
            return this.conf;
        }

        protected void setConf(String string) {
            this.conf = string;
        }

        protected boolean isArtifactsDeclared() {
            return this.artifactsDeclared;
        }

        protected void setArtifactsDeclared(boolean bl) {
            this.artifactsDeclared = bl;
        }

        protected StringBuffer getBuffer() {
            return this.buffer;
        }

        protected void setBuffer(StringBuffer stringBuffer) {
            this.buffer = stringBuffer;
        }

        protected String getDescriptorVersion() {
            return this.descriptorVersion;
        }

        protected void setDescriptorVersion(String string) {
            this.descriptorVersion = string;
        }

        protected String[] getPublicationsDefaultConf() {
            return this.publicationsDefaultConf;
        }

        protected void setPublicationsDefaultConf(String[] stringArray) {
            this.publicationsDefaultConf = stringArray;
        }

        protected boolean isValidate() {
            return this.validate;
        }

        protected URL getSchemaURL() {
            return this.getClass().getResource("ivy.xsd");
        }

        public static final class State {
            public static final int NONE = 0;
            public static final int INFO = 1;
            public static final int CONF = 2;
            public static final int PUB = 3;
            public static final int DEP = 4;
            public static final int DEP_ARTIFACT = 5;
            public static final int ARTIFACT_INCLUDE = 6;
            public static final int ARTIFACT_EXCLUDE = 7;
            public static final int CONFLICT = 8;
            public static final int EXCLUDE = 9;
            public static final int DEPS = 10;
            public static final int DESCRIPTION = 11;
            public static final int EXTRA_INFO = 12;

            private State() {
            }
        }
    }
}

