/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.lock;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.ivy.plugins.lock.AbstractLockStrategy;
import org.apache.ivy.plugins.lock.DeleteOnExitHook;
import org.apache.ivy.util.Message;

public abstract class FileBasedLockStrategy
extends AbstractLockStrategy {
    private static final int SLEEP_TIME = 100;
    private static final long DEFAULT_TIMEOUT = 120000L;
    private FileLocker locker;
    private long timeout = 120000L;
    private static ConcurrentMap currentLockHolders = new ConcurrentHashMap();

    protected FileBasedLockStrategy() {
        this(new CreateFileLocker(false), false);
    }

    protected FileBasedLockStrategy(boolean bl) {
        this(new CreateFileLocker(bl), bl);
    }

    protected FileBasedLockStrategy(FileLocker fileLocker, boolean bl) {
        super(bl);
        this.locker = fileLocker;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean acquireLock(File file) throws InterruptedException {
        Thread thread = Thread.currentThread();
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("acquiring lock on " + file);
        }
        long l = System.currentTimeMillis();
        do {
            ConcurrentMap concurrentMap = currentLockHolders;
            synchronized (concurrentMap) {
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("entered synchronized area (locking)");
                }
                int n = this.hasLock(file, thread);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("current status for " + file + " is " + n + " held locks: " + this.getCurrentLockHolderNames(file));
                }
                if (n < 0) {
                    if (this.isDebugLocking()) {
                        FileBasedLockStrategy.debugLocking("waiting for another thread to release the lock: " + this.getCurrentLockHolderNames(file));
                    }
                } else {
                    if (n > 0) {
                        int n2 = this.incrementLock(file, thread);
                        if (this.isDebugLocking()) {
                            FileBasedLockStrategy.debugLocking("reentrant lock acquired on " + file + " in " + (System.currentTimeMillis() - l) + "ms" + " - hold locks = " + n2);
                        }
                        return true;
                    }
                    if (this.locker.tryLock(file)) {
                        if (this.isDebugLocking()) {
                            FileBasedLockStrategy.debugLocking("lock acquired on " + file + " in " + (System.currentTimeMillis() - l) + "ms");
                        }
                        this.incrementLock(file, thread);
                        return true;
                    }
                }
            }
            if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("failed to acquire lock; sleeping for retry...");
            }
            Thread.sleep(100L);
        } while (System.currentTimeMillis() - l < this.timeout);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseLock(File file) {
        Thread thread = Thread.currentThread();
        if (this.isDebugLocking()) {
            FileBasedLockStrategy.debugLocking("releasing lock on " + file);
        }
        ConcurrentMap concurrentMap = currentLockHolders;
        synchronized (concurrentMap) {
            int n;
            if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("entered synchronized area (unlocking)");
            }
            if ((n = this.decrementLock(file, thread)) == 0) {
                this.locker.unlock(file);
                if (this.isDebugLocking()) {
                    FileBasedLockStrategy.debugLocking("lock released on " + file);
                }
            } else if (this.isDebugLocking()) {
                FileBasedLockStrategy.debugLocking("reentrant lock released on " + file + " - hold locks = " + n);
            }
        }
    }

    private static void debugLocking(String string) {
        Message.info(Thread.currentThread() + " " + System.currentTimeMillis() + " " + string);
    }

    private int hasLock(File file, Thread thread) {
        int n;
        Map map = (Map)currentLockHolders.get(file);
        if (map == null) {
            return 0;
        }
        if (map.isEmpty()) {
            return 0;
        }
        Integer n2 = (Integer)map.get(thread);
        int n3 = n = n2 == null ? 0 : n2;
        if (n > 0) {
            return n;
        }
        return -1;
    }

    private int incrementLock(File file, Thread thread) {
        Integer n;
        ConcurrentHashMap<Thread, Integer> concurrentHashMap = (ConcurrentHashMap<Thread, Integer>)currentLockHolders.get(file);
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap<Thread, Integer>();
            currentLockHolders.put(file, concurrentHashMap);
        }
        int n2 = (n = (Integer)concurrentHashMap.get(thread)) == null ? 1 : n + 1;
        concurrentHashMap.put(thread, new Integer(n2));
        return n2;
    }

    private int decrementLock(File file, Thread thread) {
        int n;
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)currentLockHolders.get(file);
        if (concurrentHashMap == null) {
            throw new RuntimeException("Calling decrementLock on a thread which holds no locks");
        }
        Integer n2 = (Integer)concurrentHashMap.get(thread);
        int n3 = n = n2 == null ? 0 : n2;
        if (n <= 0) {
            throw new RuntimeException("Calling decrementLock on a thread which holds no locks");
        }
        int n4 = n - 1;
        if (n4 > 0) {
            concurrentHashMap.put(thread, new Integer(n4));
        } else {
            concurrentHashMap.remove(thread);
        }
        return n4;
    }

    protected String getCurrentLockHolderNames(File file) {
        StringBuilder stringBuilder = new StringBuilder();
        ConcurrentHashMap concurrentHashMap = (ConcurrentHashMap)currentLockHolders.get(file);
        if (concurrentHashMap == null) {
            return "(NULL)";
        }
        Enumeration enumeration = concurrentHashMap.keys();
        while (enumeration.hasMoreElements()) {
            Thread thread = (Thread)enumeration.nextElement();
            stringBuilder.append(thread.toString());
            if (!enumeration.hasMoreElements()) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    public static class NIOFileLocker
    implements FileLocker {
        private Map locks = new ConcurrentHashMap();
        private boolean debugLocking;

        public NIOFileLocker(boolean bl) {
            this.debugLocking = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean tryLock(File file) {
            block7: {
                try {
                    if (!file.getParentFile().exists() && !file.getParentFile().mkdirs()) break block7;
                    RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
                    FileLock fileLock = randomAccessFile.getChannel().tryLock();
                    if (fileLock != null) {
                        NIOFileLocker nIOFileLocker = this;
                        synchronized (nIOFileLocker) {
                            this.locks.put(file, new LockData(randomAccessFile, fileLock));
                        }
                        return true;
                    }
                    if (this.debugLocking) {
                        FileBasedLockStrategy.debugLocking("failed to acquire lock on " + file);
                    }
                }
                catch (IOException iOException) {
                    Message.verbose("file lock failed due to an exception: " + iOException.getMessage() + " (" + file + ")");
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unlock(File file) {
            NIOFileLocker nIOFileLocker = this;
            synchronized (nIOFileLocker) {
                LockData lockData = (LockData)this.locks.get(file);
                if (lockData == null) {
                    throw new IllegalArgumentException("file not previously locked: " + file);
                }
                try {
                    this.locks.remove(file);
                    lockData.l.release();
                    lockData.raf.close();
                }
                catch (IOException iOException) {
                    Message.error("problem while releasing lock on " + file + ": " + iOException.getMessage());
                }
            }
        }

        private static class LockData {
            private RandomAccessFile raf;
            private FileLock l;

            LockData(RandomAccessFile randomAccessFile, FileLock fileLock) {
                this.raf = randomAccessFile;
                this.l = fileLock;
            }
        }
    }

    public static class CreateFileLocker
    implements FileLocker {
        private boolean debugLocking;

        public CreateFileLocker(boolean bl) {
            this.debugLocking = bl;
        }

        @Override
        public boolean tryLock(File file) {
            try {
                if (file.getParentFile().exists() || file.getParentFile().mkdirs()) {
                    if (file.createNewFile()) {
                        DeleteOnExitHook.add(file);
                        return true;
                    }
                    if (this.debugLocking) {
                        FileBasedLockStrategy.debugLocking("file creation failed " + file);
                    }
                }
            }
            catch (IOException iOException) {
                Message.verbose("file creation failed due to an exception: " + iOException.getMessage() + " (" + file + ")");
            }
            return false;
        }

        @Override
        public void unlock(File file) {
            file.delete();
            DeleteOnExitHook.remove(file);
        }
    }

    public static interface FileLocker {
        public boolean tryLock(File var1);

        public void unlock(File var1);
    }
}

