/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.conflict;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.plugins.conflict.AbstractConflictManager;
import org.apache.ivy.plugins.latest.ArtifactInfo;
import org.apache.ivy.plugins.latest.LatestStrategy;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.extendable.ExtendableItem;

public class LatestConflictManager
extends AbstractConflictManager {
    private LatestStrategy strategy;
    private String strategyName;

    public LatestConflictManager() {
    }

    public LatestConflictManager(LatestStrategy latestStrategy) {
        this.strategy = latestStrategy;
    }

    public LatestConflictManager(String string, LatestStrategy latestStrategy) {
        this.setName(string);
        this.strategy = latestStrategy;
    }

    @Override
    public Collection resolveConflicts(IvyNode ivyNode, Collection collection) {
        ExtendableItem extendableItem;
        if (collection.size() < 2) {
            return collection;
        }
        for (IvyNode ivyNode2 : collection) {
            extendableItem = ivyNode2.getDependencyDescriptor(ivyNode);
            if (extendableItem == null || !extendableItem.isForce() || !ivyNode.getResolvedId().equals(extendableItem.getParentRevisionId())) continue;
            return Collections.singleton(ivyNode2);
        }
        for (IvyNode ivyNode2 : collection) {
            extendableItem = ivyNode2.getResolvedId();
            if (!this.getSettings().getVersionMatcher().isDynamic((ModuleRevisionId)extendableItem)) continue;
            return null;
        }
        try {
            IvyNodeArtifactInfo ivyNodeArtifactInfo = (IvyNodeArtifactInfo)this.getStrategy().findLatest(this.toArtifactInfo(collection), null);
            if (ivyNodeArtifactInfo != null) {
                return Collections.singleton(ivyNodeArtifactInfo.getNode());
            }
            return collection;
        }
        catch (NoConflictResolvedYetException noConflictResolvedYetException) {
            return null;
        }
    }

    protected ArtifactInfo[] toArtifactInfo(Collection collection) {
        ArrayList<IvyNodeArtifactInfo> arrayList = new ArrayList<IvyNodeArtifactInfo>(collection.size());
        for (IvyNode ivyNode : collection) {
            arrayList.add(new IvyNodeArtifactInfo(ivyNode));
        }
        return arrayList.toArray(new ArtifactInfo[arrayList.size()]);
    }

    public LatestStrategy getStrategy() {
        if (this.strategy == null) {
            if (this.strategyName != null) {
                this.strategy = this.getSettings().getLatestStrategy(this.strategyName);
                if (this.strategy == null) {
                    Message.error("unknown latest strategy: " + this.strategyName);
                    this.strategy = this.getSettings().getDefaultLatestStrategy();
                }
            } else {
                this.strategy = this.getSettings().getDefaultLatestStrategy();
            }
        }
        return this.strategy;
    }

    public void setLatest(String string) {
        this.strategyName = string;
    }

    public void setStrategy(LatestStrategy latestStrategy) {
        this.strategy = latestStrategy;
    }

    @Override
    public String toString() {
        return this.strategy != null ? String.valueOf(this.strategy) : this.strategyName;
    }

    protected static final class IvyNodeArtifactInfo
    implements ArtifactInfo {
        private final IvyNode node;

        private IvyNodeArtifactInfo(IvyNode ivyNode) {
            this.node = ivyNode;
        }

        @Override
        public long getLastModified() {
            long l = this.node.getLastModified();
            if (l == 0L) {
                throw new NoConflictResolvedYetException();
            }
            return l;
        }

        @Override
        public String getRevision() {
            return this.node.getResolvedId().getRevision();
        }

        public IvyNode getNode() {
            return this.node;
        }
    }

    public static class NoConflictResolvedYetException
    extends RuntimeException {
    }
}

