/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.ivy.util.Message;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class DelegatingHandler
extends DefaultHandler
implements DTDHandler,
ContentHandler,
ErrorHandler {
    private DelegatingHandler delegate = null;
    DelegatingHandler parent;
    private final Map<String, DelegatingHandler> saxHandlerMapping = new HashMap<String, DelegatingHandler>();
    private final Map<String, ChildElementHandler<?>> childHandlerMapping = new HashMap();
    private final String tagName;
    private boolean started = false;
    private boolean skip = false;
    private boolean skipOnError = false;
    private StringBuffer charBuffer = new StringBuffer();
    private boolean bufferingChar = false;
    private Locator locator;
    static final String TRUE = Boolean.TRUE.toString().toLowerCase(Locale.US);
    static final String FALSE = Boolean.FALSE.toString().toLowerCase(Locale.US);

    public DelegatingHandler(String string) {
        this.tagName = string;
        this.charBuffer.setLength(0);
    }

    protected <DH extends DelegatingHandler> void addChild(DH DH, ChildElementHandler<DH> childElementHandler) {
        this.saxHandlerMapping.put(DH.getName(), DH);
        this.childHandlerMapping.put(DH.getName(), childElementHandler);
        DH.parent = this;
    }

    public String getName() {
        return this.tagName;
    }

    public DelegatingHandler getParent() {
        return this.parent;
    }

    public void setBufferingChar(boolean bl) {
        this.bufferingChar = bl;
    }

    public void setSkipOnError(boolean bl) {
        this.skipOnError = bl;
    }

    public boolean isBufferingChar() {
        return this.bufferingChar;
    }

    public String getBufferedChars() {
        return this.charBuffer.toString();
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
        for (DelegatingHandler delegatingHandler : this.saxHandlerMapping.values()) {
            delegatingHandler.setDocumentLocator(locator);
        }
    }

    public Locator getLocator() {
        return this.locator;
    }

    protected String getCurrentElementIdentifier() {
        return "";
    }

    public void skip() {
        this.skip = true;
        for (DelegatingHandler delegatingHandler : this.saxHandlerMapping.values()) {
            delegatingHandler.stopDelegating();
        }
    }

    protected void stopDelegating() {
        this.parent.delegate = null;
        this.skip = false;
        this.started = false;
        for (DelegatingHandler delegatingHandler : this.saxHandlerMapping.values()) {
            delegatingHandler.stopDelegating();
        }
    }

    private void skipOnError(SkipOnErrorCallback skipOnErrorCallback) throws SAXException {
        try {
            skipOnErrorCallback.call();
        }
        catch (SAXException sAXException) {
            if (this.skipOnError) {
                this.skip();
                this.log(0, sAXException.getMessage(), sAXException);
            }
            throw sAXException;
        }
    }

    @Override
    public final void startDocument() throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.startDocument();
        } else {
            this.doStartDocument();
        }
    }

    protected void doStartDocument() throws SAXException {
    }

    @Override
    public final void endDocument() throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.endDocument();
        } else {
            this.doEndDocument();
        }
    }

    protected void doEndDocument() throws SAXException {
    }

    @Override
    public final void startElement(final String string, final String string2, final String string3, final Attributes attributes) throws SAXException {
        this.charBuffer.setLength(0);
        if (this.delegate != null) {
            this.skipOnError(new SkipOnErrorCallback(){

                @Override
                public void call() throws SAXException {
                    DelegatingHandler.this.delegate.startElement(string, string2, string3, attributes);
                }
            });
        } else if (!this.started) {
            if (this.parent == null && !string2.equals(this.tagName)) {
                throw new SAXException("The root element of the parsed document '" + string2 + "' didn't matched the expected one: '" + this.tagName + "'");
            }
            this.skipOnError(new SkipOnErrorCallback(){

                @Override
                public void call() throws SAXException {
                    DelegatingHandler.this.handleAttributes(attributes);
                }
            });
            this.started = true;
        } else {
            if (this.skip) {
                return;
            }
            this.delegate = this.saxHandlerMapping.get(string2);
            if (this.delegate != null) {
                this.skipOnError(new SkipOnErrorCallback(){

                    @Override
                    public void call() throws SAXException {
                        DelegatingHandler.this.delegate.startElement(string, string2, string3, attributes);
                    }
                });
            }
        }
    }

    protected void handleAttributes(Attributes attributes) throws SAXException {
    }

    protected void doStartElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
    }

    @Override
    public final void endElement(final String string, final String string2, final String string3) throws SAXException {
        if (this.delegate != null) {
            ChildElementHandler<?> childElementHandler;
            final DelegatingHandler delegatingHandler = this.delegate;
            this.skipOnError(new SkipOnErrorCallback(){

                @Override
                public void call() throws SAXException {
                    DelegatingHandler.this.delegate.endElement(string, string2, string3);
                }
            });
            if (this.delegate == null && (childElementHandler = this.childHandlerMapping.get(string2)) != null) {
                this.skipOnError(new SkipOnErrorCallback(){

                    @Override
                    public void call() throws SAXException {
                        childElementHandler._childHanlded(delegatingHandler);
                    }
                });
            }
        } else {
            if (!this.skip) {
                this.doEndElement(string, string2, string3);
            }
            if (this.parent != null && this.tagName.equals(string2)) {
                this.stopDelegating();
            }
        }
    }

    protected void doEndElement(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public final void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.characters(cArray, n, n2);
        } else {
            this.doCharacters(cArray, n, n2);
        }
    }

    protected void doCharacters(char[] cArray, int n, int n2) throws SAXException {
        if (this.bufferingChar) {
            this.charBuffer.append(cArray, n, n2);
        }
    }

    @Override
    public final void startPrefixMapping(String string, String string2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.startPrefixMapping(string, string2);
        } else {
            this.doStartPrefixMapping(string, string2);
        }
    }

    protected void doStartPrefixMapping(String string, String string2) throws SAXException {
    }

    @Override
    public final void endPrefixMapping(String string) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.endPrefixMapping(string);
        } else {
            this.doEndPrefixMapping(string);
        }
    }

    protected void doEndPrefixMapping(String string) throws SAXException {
    }

    @Override
    public final void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.ignorableWhitespace(cArray, n, n2);
        } else {
            this.doIgnorableWhitespace(cArray, n, n2);
        }
    }

    protected void doIgnorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    @Override
    public final void notationDecl(String string, String string2, String string3) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.notationDecl(string, string2, string3);
        } else {
            this.doNotationDecl(string, string2, string3);
        }
    }

    protected void doNotationDecl(String string, String string2, String string3) throws SAXException {
    }

    @Override
    public final void processingInstruction(String string, String string2) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.processingInstruction(string, string2);
        } else {
            this.doProcessingInstruction(string, string2);
        }
    }

    protected void doProcessingInstruction(String string, String string2) throws SAXException {
    }

    @Override
    public final void skippedEntity(String string) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.skippedEntity(string);
        } else {
            this.doSkippedEntity(string);
        }
    }

    protected void doSkippedEntity(String string) throws SAXException {
    }

    @Override
    public final void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.unparsedEntityDecl(string, string2, string3, string4);
        } else {
            this.doUnparsedEntityDecl(string, string2, string3, string4);
        }
    }

    protected void doUnparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
    }

    @Override
    public final void warning(SAXParseException sAXParseException) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.warning(sAXParseException);
        } else {
            this.doWarning(sAXParseException);
        }
    }

    protected void doWarning(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public final void error(SAXParseException sAXParseException) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.error(sAXParseException);
        } else {
            this.doError(sAXParseException);
        }
    }

    protected void doError(SAXParseException sAXParseException) throws SAXException {
    }

    @Override
    public final void fatalError(SAXParseException sAXParseException) throws SAXException {
        if (this.skip) {
            return;
        }
        if (this.delegate != null) {
            this.delegate.fatalError(sAXParseException);
        } else {
            this.doFatalError(sAXParseException);
        }
    }

    protected void doFatalError(SAXParseException sAXParseException) throws SAXException {
    }

    protected void log(int n, String string, Throwable throwable) {
        Message.debug(throwable);
        this.log(n, string);
    }

    protected void log(int n, String string) {
        Message.log(n, DelegatingHandler.getLocation(this.getLocator()) + string);
    }

    protected static String getLocation(Locator locator) {
        if (locator == null) {
            return "";
        }
        return "[line " + locator.getLineNumber() + " col. " + locator.getColumnNumber() + "] ";
    }

    private void skipOnError(DelegatingHandler delegatingHandler, Class<? extends DelegatingHandler> clazz, String string) {
        DelegatingHandler delegatingHandler2 = delegatingHandler;
        while (!clazz.isAssignableFrom(delegatingHandler2.getClass())) {
            delegatingHandler2 = delegatingHandler2.getParent();
        }
        this.log(0, string + ". The '" + delegatingHandler2.getName() + "' element " + this.getCurrentElementIdentifier() + " is then ignored.");
        delegatingHandler2.skip();
    }

    protected String getRequiredAttribute(Attributes attributes, String string) throws SAXParseException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            throw new SAXParseException("Required attribute '" + string + "' not found", this.getLocator());
        }
        return string2;
    }

    protected String getOptionalAttribute(Attributes attributes, String string, String string2) {
        String string3 = attributes.getValue(string);
        if (string3 == null) {
            return string2;
        }
        return string3;
    }

    protected int getRequiredIntAttribute(Attributes attributes, String string, Integer n) throws SAXParseException {
        return this.parseInt(string, this.getRequiredAttribute(attributes, string));
    }

    protected Integer getOptionalIntAttribute(Attributes attributes, String string, Integer n) throws SAXParseException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return n;
        }
        return new Integer(this.parseInt(string, string2));
    }

    private int parseInt(String string, String string2) throws SAXParseException {
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXParseException("Attribute '" + string + "' is expected to be an integer but was '" + string2 + "' (" + numberFormatException.getMessage() + ")", this.getLocator());
        }
    }

    protected long getRequiredLongAttribute(Attributes attributes, String string) throws SAXParseException {
        return this.parseLong(string, this.getRequiredAttribute(attributes, string));
    }

    protected Long getOptionalLongAttribute(Attributes attributes, String string, Long l) throws SAXParseException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return l;
        }
        return new Long(this.parseLong(string, string2));
    }

    private long parseLong(String string, String string2) throws SAXParseException {
        try {
            return Long.parseLong(string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new SAXParseException("Attribute '" + string + "' is expected to be an long but was '" + string2 + "' (" + numberFormatException.getMessage() + ")", this.getLocator());
        }
    }

    protected boolean getRequiredBooleanAttribute(Attributes attributes, String string) throws SAXParseException {
        return this.parseBoolean(string, this.getRequiredAttribute(attributes, string));
    }

    protected Boolean getOptionalBooleanAttribute(Attributes attributes, String string, Boolean bl) throws SAXParseException {
        String string2 = attributes.getValue(string);
        if (string2 == null) {
            return bl;
        }
        return this.parseBoolean(string, string2);
    }

    private boolean parseBoolean(String string, String string2) throws SAXParseException {
        String string3 = string2.toLowerCase(Locale.US);
        if (string3.equals(TRUE)) {
            return true;
        }
        if (string3.equals(FALSE)) {
            return false;
        }
        throw new SAXParseException("Attribute '" + string + "' is expected to be a boolean but was '" + string2 + "'", this.getLocator());
    }

    public static abstract class ChildElementHandler<DH extends DelegatingHandler> {
        public abstract void childHanlded(DH var1) throws SAXParseException;

        private void _childHanlded(DelegatingHandler delegatingHandler) throws SAXParseException {
            this.childHanlded(delegatingHandler);
        }
    }

    private static interface SkipOnErrorCallback {
        public void call() throws SAXException;
    }
}

