/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.updatesite;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ivy.core.cache.CacheResourceOptions;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.event.EventManager;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.p2.P2ArtifactParser;
import org.apache.ivy.osgi.p2.P2CompositeParser;
import org.apache.ivy.osgi.p2.P2Descriptor;
import org.apache.ivy.osgi.p2.P2MetadataParser;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.repo.EditableRepoDescriptor;
import org.apache.ivy.osgi.repo.RepoDescriptor;
import org.apache.ivy.osgi.updatesite.UpdateSiteDescriptor;
import org.apache.ivy.osgi.updatesite.xml.EclipseFeature;
import org.apache.ivy.osgi.updatesite.xml.EclipseUpdateSiteParser;
import org.apache.ivy.osgi.updatesite.xml.FeatureParser;
import org.apache.ivy.osgi.updatesite.xml.UpdateSite;
import org.apache.ivy.osgi.updatesite.xml.UpdateSiteDigestParser;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.util.Message;
import org.xml.sax.SAXException;

public class UpdateSiteLoader {
    private final RepositoryCacheManager repositoryCacheManager;
    private final URLRepository urlRepository = new URLRepository();
    private final CacheResourceOptions options;
    private int logLevel = 2;

    public UpdateSiteLoader(RepositoryCacheManager repositoryCacheManager, EventManager eventManager, CacheResourceOptions cacheResourceOptions) {
        this.repositoryCacheManager = repositoryCacheManager;
        this.options = cacheResourceOptions;
        if (eventManager != null) {
            this.urlRepository.addTransferListener(eventManager);
        }
    }

    public void setLogLevel(int n) {
        this.logLevel = n;
    }

    public RepoDescriptor load(URI uRI) throws IOException, ParseException, SAXException {
        if (!uRI.toString().endsWith("/")) {
            try {
                uRI = new URI(uRI.toString() + "/");
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("Cannot make an uri for the repo");
            }
        }
        Message.info("Loading the update site " + uRI);
        EditableRepoDescriptor editableRepoDescriptor = this.loadP2(uRI);
        if (editableRepoDescriptor != null) {
            return editableRepoDescriptor;
        }
        Message.verbose("\tNo P2 artifacts, falling back on the old fashioned updatesite");
        UpdateSite updateSite = this.loadSite(uRI);
        if (updateSite == null) {
            return null;
        }
        editableRepoDescriptor = this.loadFromDigest(updateSite);
        if (editableRepoDescriptor != null) {
            return editableRepoDescriptor;
        }
        return this.loadFromSite(updateSite);
    }

    private P2Descriptor loadP2(URI uRI) throws IOException, ParseException, SAXException {
        P2Descriptor p2Descriptor = new P2Descriptor(uRI, ExecutionEnvironmentProfileProvider.getInstance());
        p2Descriptor.setLogLevel(this.logLevel);
        if (!this.populateP2Descriptor(uRI, p2Descriptor)) {
            return null;
        }
        p2Descriptor.finish();
        return p2Descriptor;
    }

    private boolean populateP2Descriptor(URI uRI, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        Message.verbose("Loading P2 repository " + uRI);
        boolean bl = this.readContent(uRI, p2Descriptor);
        boolean bl2 = this.readArtifacts(uRI, p2Descriptor);
        return bl2 || bl;
    }

    private boolean readContent(URI uRI, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        boolean bl = this.readCompositeContent(uRI, "compositeContent", p2Descriptor);
        if (!bl) {
            P2MetadataParser p2MetadataParser = new P2MetadataParser(p2Descriptor);
            p2MetadataParser.setLogLevel(this.logLevel);
            bl = this.readJarOrXml(uRI, "content", p2MetadataParser);
        }
        return bl;
    }

    private boolean readArtifacts(URI uRI, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        boolean bl = this.readCompositeArtifact(uRI, "compositeArtifacts", p2Descriptor);
        if (!bl) {
            bl = this.readJarOrXml(uRI, "artifacts", new P2ArtifactParser(p2Descriptor, uRI.toURL().toExternalForm()));
        }
        return bl;
    }

    private boolean readCompositeContent(URI uRI, String string, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        P2CompositeParser p2CompositeParser = new P2CompositeParser();
        boolean bl = this.readJarOrXml(uRI, string, p2CompositeParser);
        if (bl) {
            for (String string2 : p2CompositeParser.getChildLocations()) {
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                URI uRI2 = uRI.resolve(string2);
                this.readContent(uRI2, p2Descriptor);
            }
        }
        return bl;
    }

    private boolean readCompositeArtifact(URI uRI, String string, P2Descriptor p2Descriptor) throws IOException, ParseException, SAXException {
        P2CompositeParser p2CompositeParser = new P2CompositeParser();
        boolean bl = this.readJarOrXml(uRI, string, p2CompositeParser);
        if (bl) {
            for (String string2 : p2CompositeParser.getChildLocations()) {
                if (!string2.endsWith("/")) {
                    string2 = string2 + "/";
                }
                URI uRI2 = uRI.resolve(string2);
                this.readArtifacts(uRI2, p2Descriptor);
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean readJarOrXml(URI uRI, String string, XMLInputParser xMLInputParser) throws IOException, ParseException, SAXException {
        InputStream inputStream = null;
        URL uRL = uRI.resolve(string + ".jar").toURL();
        URLResource uRLResource = new URLResource(uRL);
        ArtifactDownloadReport artifactDownloadReport = this.repositoryCacheManager.downloadRepositoryResource(uRLResource, string, string, "jar", this.options, this.urlRepository);
        if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) {
            uRL = uRI.resolve(string + ".xml").toURL();
            uRLResource = new URLResource(uRL);
            artifactDownloadReport = this.repositoryCacheManager.downloadRepositoryResource(uRLResource, string, string, "xml", this.options, this.urlRepository);
            if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) {
                return false;
            }
            inputStream = new FileInputStream(artifactDownloadReport.getLocalFile());
        } else {
            FileInputStream fileInputStream = new FileInputStream(artifactDownloadReport.getLocalFile());
            try {
                inputStream = this.findEntry(fileInputStream, string + ".xml");
                if (inputStream == null) {
                    ((InputStream)fileInputStream).close();
                    return false;
                }
            }
            catch (IOException iOException) {
                ((InputStream)fileInputStream).close();
                throw iOException;
            }
        }
        try {
            xMLInputParser.parse(inputStream);
        }
        finally {
            ((InputStream)inputStream).close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateSite loadSite(URI uRI) throws IOException, ParseException, SAXException {
        URI uRI2 = this.normalizeSiteUri(uRI, null);
        URL uRL = uRI2.resolve("site.xml").toURL();
        URLResource uRLResource = new URLResource(uRL);
        ArtifactDownloadReport artifactDownloadReport = this.repositoryCacheManager.downloadRepositoryResource(uRLResource, "site", "updatesite", "xml", this.options, this.urlRepository);
        if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(artifactDownloadReport.getLocalFile());
        try {
            UpdateSite updateSite = EclipseUpdateSiteParser.parse(fileInputStream);
            updateSite.setUri(this.normalizeSiteUri(updateSite.getUri(), uRI2));
            UpdateSite updateSite2 = updateSite;
            return updateSite2;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    private URI normalizeSiteUri(URI uRI, URI uRI2) {
        if (uRI == null) {
            return uRI2;
        }
        String string = uRI.toString();
        if (string.endsWith("site.xml")) {
            try {
                return new URI(string.substring(0, string.length() - 8));
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("Illegal uri", uRISyntaxException);
            }
        }
        if (!string.endsWith("/")) {
            try {
                return new URI(string + "/");
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new RuntimeException("Illegal uri", uRISyntaxException);
            }
        }
        return uRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateSiteDescriptor loadFromDigest(UpdateSite updateSite) throws IOException, ParseException, SAXException {
        URI uRI = updateSite.getDigestUri();
        if (uRI == null) {
            uRI = updateSite.getUri();
        } else if (!uRI.isAbsolute()) {
            uRI = updateSite.getUri().resolve(uRI);
        }
        URL uRL = uRI.resolve("digest.zip").toURL();
        Message.verbose("\tReading " + uRL);
        URLResource uRLResource = new URLResource(uRL);
        ArtifactDownloadReport artifactDownloadReport = this.repositoryCacheManager.downloadRepositoryResource(uRLResource, "digest", "digest", "zip", this.options, this.urlRepository);
        if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) {
            return null;
        }
        FileInputStream fileInputStream = new FileInputStream(artifactDownloadReport.getLocalFile());
        try {
            ZipInputStream zipInputStream = this.findEntry(fileInputStream, "digest.xml");
            if (zipInputStream == null) {
                UpdateSiteDescriptor updateSiteDescriptor = null;
                return updateSiteDescriptor;
            }
            UpdateSiteDescriptor updateSiteDescriptor = UpdateSiteDigestParser.parse(zipInputStream, updateSite);
            return updateSiteDescriptor;
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpdateSiteDescriptor loadFromSite(UpdateSite updateSite) throws IOException, ParseException, SAXException {
        UpdateSiteDescriptor updateSiteDescriptor = new UpdateSiteDescriptor(updateSite.getUri(), ExecutionEnvironmentProfileProvider.getInstance());
        for (EclipseFeature eclipseFeature : updateSite.getFeatures()) {
            URL uRL = updateSite.getUri().resolve(eclipseFeature.getUrl()).toURL();
            URLResource uRLResource = new URLResource(uRL);
            ArtifactDownloadReport artifactDownloadReport = this.repositoryCacheManager.downloadRepositoryResource(uRLResource, eclipseFeature.getId(), "feature", "jar", this.options, this.urlRepository);
            if (artifactDownloadReport.getDownloadStatus() == DownloadStatus.FAILED) {
                return null;
            }
            FileInputStream fileInputStream = new FileInputStream(artifactDownloadReport.getLocalFile());
            try {
                EclipseFeature eclipseFeature2;
                ZipInputStream zipInputStream = this.findEntry(fileInputStream, "feature.xml");
                if (zipInputStream == null) {
                    eclipseFeature2 = null;
                    return eclipseFeature2;
                }
                eclipseFeature2 = FeatureParser.parse(zipInputStream);
                eclipseFeature2.setURL(eclipseFeature.getUrl());
                updateSiteDescriptor.addFeature(eclipseFeature2);
            }
            finally {
                ((InputStream)fileInputStream).close();
            }
        }
        return updateSiteDescriptor;
    }

    private ZipInputStream findEntry(InputStream inputStream, String string) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null && !zipEntry.getName().equals(string)) {
            zipEntry = zipInputStream.getNextEntry();
        }
        if (zipEntry == null) {
            return null;
        }
        return zipInputStream;
    }
}

