/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.util.Message;

public class ArtifactReportManifestIterable
implements Iterable<ManifestAndLocation> {
    private final Map<ModuleRevisionId, List<ArtifactDownloadReport>> artifactReports = new HashMap<ModuleRevisionId, List<ArtifactDownloadReport>>();
    private List<String> sourceTypes;

    public ArtifactReportManifestIterable(List<ArtifactDownloadReport> list, List<String> list2) {
        this.sourceTypes = list2;
        for (ArtifactDownloadReport artifactDownloadReport : list) {
            ModuleRevisionId moduleRevisionId = artifactDownloadReport.getArtifact().getModuleRevisionId();
            List<ArtifactDownloadReport> list3 = this.artifactReports.get(moduleRevisionId);
            if (list3 == null) {
                list3 = new ArrayList<ArtifactDownloadReport>();
                this.artifactReports.put(moduleRevisionId, list3);
            }
            list3.add(artifactDownloadReport);
        }
    }

    @Override
    public Iterator<ManifestAndLocation> iterator() {
        return new ArtifactReportManifestIterator();
    }

    class ArtifactReportManifestIterator
    implements Iterator<ManifestAndLocation> {
        private ManifestAndLocation next = null;
        private Iterator<ModuleRevisionId> it;

        public ArtifactReportManifestIterator() {
            this.it = ArtifactReportManifestIterable.this.artifactReports.keySet().iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            while (this.next == null && this.it.hasNext()) {
                Object object3;
                ModuleRevisionId moduleRevisionId = this.it.next();
                List list = (List)ArtifactReportManifestIterable.this.artifactReports.get(moduleRevisionId);
                ArtifactDownloadReport artifactDownloadReport = null;
                Object object2 = null;
                for (Object object3 : list) {
                    if (ArtifactReportManifestIterable.this.sourceTypes != null && ArtifactReportManifestIterable.this.sourceTypes.contains(((ArtifactDownloadReport)object3).getArtifact().getType())) {
                        object2 = object3;
                        continue;
                    }
                    artifactDownloadReport = object3;
                }
                if (artifactDownloadReport == null) continue;
                Object object4 = null;
                if (object2 != null) {
                    object4 = ((ArtifactDownloadReport)object2).getUnpackedLocalFile() != null ? ((ArtifactDownloadReport)object2).getUnpackedLocalFile().toURI() : ((ArtifactDownloadReport)object2).getLocalFile().toURI();
                }
                if (artifactDownloadReport.getUnpackedLocalFile() != null && artifactDownloadReport.getUnpackedLocalFile().isDirectory()) {
                    object3 = null;
                    try {
                        object3 = new FileInputStream(new File(artifactDownloadReport.getUnpackedLocalFile(), "META-INF/MANIFEST.MF"));
                        this.next = new ManifestAndLocation(new Manifest((InputStream)object3), artifactDownloadReport.getUnpackedLocalFile().toURI(), (URI)object4);
                        boolean bl = true;
                        return bl;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Message.debug("Bundle directory file just removed: " + artifactDownloadReport.getUnpackedLocalFile(), fileNotFoundException);
                        continue;
                    }
                    catch (IOException iOException) {
                        Message.debug("The Manifest in the bundle directory could not be read: " + artifactDownloadReport.getUnpackedLocalFile(), iOException);
                        continue;
                    }
                    finally {
                        if (object3 == null) continue;
                        try {
                            ((FileInputStream)object3).close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
                object3 = artifactDownloadReport.getUnpackedLocalFile() != null ? artifactDownloadReport.getUnpackedLocalFile() : artifactDownloadReport.getLocalFile();
                ZipInputStream zipInputStream = null;
                try {
                    zipInputStream = new JarInputStream(new FileInputStream((File)object3));
                    Manifest manifest = ((JarInputStream)zipInputStream).getManifest();
                    if (manifest != null) {
                        this.next = new ManifestAndLocation(manifest, ((File)object3).toURI(), (URI)object4);
                        boolean bl = true;
                        return bl;
                    }
                    Message.debug("No manifest in jar: " + object3);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    Message.debug("Jar file just removed: " + object3, fileNotFoundException);
                }
                catch (IOException iOException) {
                    Message.warn("Unreadable jar: " + object3, iOException);
                }
                finally {
                    if (zipInputStream == null) continue;
                    try {
                        zipInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            return this.next != null;
        }

        @Override
        public ManifestAndLocation next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ManifestAndLocation manifestAndLocation = this.next;
            this.next = null;
            return manifestAndLocation;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

