/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.ivy.osgi.repo.ModuleDescriptorWrapper;
import org.apache.ivy.osgi.repo.RepoDescriptor;

public class AggregatedRepoDescriptor
extends RepoDescriptor {
    private List<RepoDescriptor> repos;

    public AggregatedRepoDescriptor(List<RepoDescriptor> list) {
        this.repos = list;
    }

    @Override
    public Iterator<ModuleDescriptorWrapper> getModules() {
        final Iterator<RepoDescriptor> iterator = this.repos.iterator();
        return new Iterator<ModuleDescriptorWrapper>(){
            private Iterator<ModuleDescriptorWrapper> current = null;
            private ModuleDescriptorWrapper next = null;

            @Override
            public boolean hasNext() {
                while (this.next == null) {
                    if (this.current == null) {
                        if (!iterator.hasNext()) {
                            return false;
                        }
                        RepoDescriptor repoDescriptor = (RepoDescriptor)iterator.next();
                        this.current = repoDescriptor.getModules();
                    }
                    if (this.current.hasNext()) {
                        this.next = this.current.next();
                        continue;
                    }
                    this.current = null;
                }
                return true;
            }

            @Override
            public ModuleDescriptorWrapper next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ModuleDescriptorWrapper moduleDescriptorWrapper = this.next;
                this.next = null;
                return moduleDescriptorWrapper;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Set<String> getCapabilities() {
        HashSet<String> hashSet = new HashSet<String>();
        for (RepoDescriptor repoDescriptor : this.repos) {
            Set<String> set = repoDescriptor.getCapabilities();
            if (set == null) continue;
            hashSet.addAll(set);
        }
        return hashSet;
    }

    @Override
    public Set<ModuleDescriptorWrapper> findModules(String string, String string2) {
        HashSet<ModuleDescriptorWrapper> hashSet = new HashSet<ModuleDescriptorWrapper>();
        for (RepoDescriptor repoDescriptor : this.repos) {
            Set<ModuleDescriptorWrapper> set = repoDescriptor.findModules(string, string2);
            if (set == null) continue;
            hashSet.addAll(set);
        }
        return hashSet;
    }

    @Override
    public Set<String> getCapabilityValues(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        for (RepoDescriptor repoDescriptor : this.repos) {
            Set<String> set = repoDescriptor.getCapabilityValues(string);
            if (set == null) continue;
            hashSet.addAll(set);
        }
        return hashSet;
    }
}

