/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Stack;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipInputStream;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.util.Message;

public abstract class AbstractFSManifestIterable<T>
implements Iterable<ManifestAndLocation> {
    private final T root;

    public AbstractFSManifestIterable(T t) {
        this.root = t;
    }

    @Override
    public Iterator<ManifestAndLocation> iterator() {
        return new FSManifestIterator();
    }

    protected abstract List<T> listBundleFiles(T var1) throws IOException;

    protected abstract List<T> listDirs(T var1) throws IOException;

    protected abstract InputStream getInputStream(T var1) throws IOException;

    protected abstract URI buildBundleURI(T var1) throws IOException;

    class FSManifestIterator
    implements Iterator<ManifestAndLocation> {
        private ManifestAndLocation next = null;
        private Stack<Iterator<T>> dirs = new Stack();
        private Iterator<T> bundleCandidates = null;
        private T currentDir = null;

        FSManifestIterator() {
            this.dirs.add(Collections.singleton(AbstractFSManifestIterable.this.root).iterator());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            while (this.next == null) {
                if (this.currentDir == null) {
                    if (this.dirs.peek().hasNext()) {
                        this.currentDir = this.dirs.peek().next();
                        try {
                            this.bundleCandidates = AbstractFSManifestIterable.this.listBundleFiles(this.currentDir).iterator();
                        }
                        catch (IOException iOException) {
                            Message.warn("Unlistable dir: " + this.currentDir, iOException);
                            this.currentDir = null;
                        }
                        continue;
                    }
                    if (this.dirs.size() <= 1) {
                        return false;
                    }
                    this.dirs.pop();
                    continue;
                }
                if (this.bundleCandidates.hasNext()) {
                    Object t = this.bundleCandidates.next();
                    ZipInputStream zipInputStream = null;
                    try {
                        zipInputStream = new JarInputStream(AbstractFSManifestIterable.this.getInputStream(t));
                        Manifest manifest = ((JarInputStream)zipInputStream).getManifest();
                        if (manifest != null) {
                            this.next = new ManifestAndLocation(manifest, AbstractFSManifestIterable.this.buildBundleURI(t), null);
                            continue;
                        }
                        Message.debug("No manifest in jar: " + t);
                        continue;
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        Message.debug("Jar file just removed: " + t, fileNotFoundException);
                        continue;
                    }
                    catch (IOException iOException) {
                        Message.warn("Unreadable jar: " + t, iOException);
                        continue;
                    }
                    finally {
                        if (zipInputStream == null) continue;
                        try {
                            zipInputStream.close();
                        }
                        catch (IOException iOException) {}
                        continue;
                    }
                }
                try {
                    this.dirs.add(AbstractFSManifestIterable.this.listDirs(this.currentDir).iterator());
                }
                catch (IOException iOException) {
                    Message.warn("Unlistable dir: " + this.currentDir + " (" + iOException + ")");
                    this.dirs.add(Collections.emptyList().iterator());
                }
                this.currentDir = null;
            }
            return true;
        }

        @Override
        public ManifestAndLocation next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ManifestAndLocation manifestAndLocation = this.next;
            this.next = null;
            return manifestAndLocation;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

