/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.xml.sax.Attributes;

public class PropertiesParser {

    static class PropertyHandler
    extends DelegatingHandler {
        private static final String PROPERTY = "property";
        private static final String NAME = "name";
        private static final String VALUE = "value";
        String name;
        String value;

        public PropertyHandler() {
            super(PROPERTY);
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            this.name = attributes.getValue(NAME);
            this.value = attributes.getValue(VALUE);
        }
    }

    static class PropertiesHandler
    extends DelegatingHandler {
        private static final String PROPERTIES = "properties";
        private static final String SIZE = "size";
        Map<String, String> properties;

        public PropertiesHandler(String ... stringArray) {
            super(PROPERTIES);
            final List<String> list = Arrays.asList(stringArray);
            this.addChild(new PropertyHandler(), new DelegatingHandler.ChildElementHandler<PropertyHandler>(){

                @Override
                public void childHanlded(PropertyHandler propertyHandler) {
                    if (list.isEmpty() || list.contains(propertyHandler.name)) {
                        PropertiesHandler.this.properties.put(propertyHandler.name, propertyHandler.value);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.properties = new HashMap<String, String>(n);
        }
    }
}

