/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.osgi.core.BundleArtifact;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.repo.EditableRepoDescriptor;
import org.apache.ivy.osgi.repo.ModuleDescriptorWrapper;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.Message;

public class P2Descriptor
extends EditableRepoDescriptor {
    private Map<String, Map<Version, BundleInfo>> sourceTargetBundles = new HashMap<String, Map<Version, BundleInfo>>();
    private Map<String, Map<Version, BundleInfo>> sourceBundles = new HashMap<String, Map<Version, BundleInfo>>();

    public P2Descriptor(URI uRI, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) {
        super(uRI, executionEnvironmentProfileProvider);
    }

    @Override
    public void addBundle(BundleInfo bundleInfo) {
        if (bundleInfo.isSource()) {
            BundleInfo bundleInfo2;
            if (bundleInfo.getSymbolicNameTarget() == null || bundleInfo.getVersionTarget() == null) {
                if (this.getLogLevel() <= 3) {
                    Message.verbose("The source bundle " + bundleInfo.getSymbolicName() + " did not declare its target. Ignoring it");
                }
                return;
            }
            Map<Version, BundleInfo> map = this.sourceBundles.get(bundleInfo.getSymbolicName());
            if (map == null) {
                map = new HashMap<Version, BundleInfo>();
                this.sourceBundles.put(bundleInfo.getSymbolicName(), map);
            }
            map.put(bundleInfo.getVersion(), bundleInfo);
            Map<Version, BundleInfo> map2 = this.sourceTargetBundles.get(bundleInfo.getSymbolicNameTarget());
            if (map2 == null) {
                map2 = new HashMap<Version, BundleInfo>();
                this.sourceTargetBundles.put(bundleInfo.getSymbolicNameTarget(), map2);
            }
            if ((bundleInfo2 = map2.put(bundleInfo.getVersionTarget(), bundleInfo)) != null && !bundleInfo2.equals(bundleInfo) && this.getLogLevel() <= 3) {
                Message.verbose("Duplicate source for the bundle " + bundleInfo.getSymbolicNameTarget() + "@" + bundleInfo.getVersionTarget() + " : " + bundleInfo + " is replacing " + bundleInfo2);
            }
            return;
        }
        super.addBundle(bundleInfo);
    }

    public void finish() {
        this.sourceBundles = null;
        Set<String> set = this.getCapabilityValues("bundle");
        if (set == null) {
            return;
        }
        for (String string : set) {
            Set<ModuleDescriptorWrapper> set2 = this.findModules("bundle", string);
            for (ModuleDescriptorWrapper moduleDescriptorWrapper : set2) {
                BundleInfo bundleInfo;
                String string2 = moduleDescriptorWrapper.getBundleInfo().getSymbolicName();
                Map<Version, BundleInfo> map = this.sourceTargetBundles.get(string2);
                if (map == null || (bundleInfo = map.get(moduleDescriptorWrapper.getBundleInfo().getVersion())) == null) continue;
                for (BundleArtifact bundleArtifact : bundleInfo.getArtifacts()) {
                    moduleDescriptorWrapper.getBundleInfo().addArtifact(bundleArtifact);
                }
            }
        }
        this.sourceTargetBundles = null;
    }

    public void addArtifactUrl(String string, String string2, Version version, URI uRI, String string3) {
        if (!string.equals("osgi.bundle")) {
            return;
        }
        ModuleDescriptorWrapper moduleDescriptorWrapper = this.findModule(string2, version);
        if (moduleDescriptorWrapper != null) {
            this.addArtifact(moduleDescriptorWrapper.getBundleInfo(), new BundleArtifact(false, uRI, string3));
            return;
        }
        Map<Version, BundleInfo> map = this.sourceBundles.get(string2);
        if (map == null) {
            return;
        }
        BundleInfo bundleInfo = map.get(version);
        if (bundleInfo == null) {
            return;
        }
        this.addArtifact(bundleInfo, new BundleArtifact(true, uRI, string3));
    }

    private void addArtifact(BundleInfo bundleInfo, BundleArtifact bundleArtifact) {
        BundleArtifact bundleArtifact2 = null;
        for (BundleArtifact bundleArtifact3 : bundleInfo.getArtifacts()) {
            if (bundleArtifact3.isSource() != bundleArtifact.isSource()) continue;
            bundleArtifact2 = bundleArtifact3;
            break;
        }
        BundleArtifact bundleArtifact4 = bundleArtifact;
        if (bundleArtifact2 != null) {
            if (bundleArtifact.getFormat() == null || bundleArtifact2.getFormat() != null) {
                return;
            }
            bundleInfo.removeArtifact(bundleArtifact2);
        }
        bundleInfo.addArtifact(bundleArtifact4);
    }
}

