/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.filter.OSGiFilter;
import org.apache.ivy.osgi.filter.OSGiFilterParser;
import org.apache.ivy.osgi.p2.P2Artifact;
import org.apache.ivy.osgi.p2.P2Descriptor;
import org.apache.ivy.osgi.p2.PropertiesParser;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class P2ArtifactParser
implements XMLInputParser {
    private final P2Descriptor p2Descriptor;
    private final String repoUrl;

    public P2ArtifactParser(P2Descriptor p2Descriptor, String string) {
        this.p2Descriptor = p2Descriptor;
        this.repoUrl = string;
    }

    @Override
    public void parse(InputStream inputStream) throws ParseException, IOException, SAXException {
        RepositoryHandler repositoryHandler = new RepositoryHandler(this.p2Descriptor, this.repoUrl);
        try {
            XMLHelper.parse(inputStream, null, (DefaultHandler)repositoryHandler, null);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new SAXException(parserConfigurationException);
        }
    }

    private static class ArtifactHandler
    extends DelegatingHandler {
        private static final String ARTIFACT = "artifact";
        private static final String CLASSIFIER = "classifier";
        private static final String ID = "id";
        private static final String VERSION = "version";
        private P2Artifact p2Artifact;
        private Map<String, String> properties;

        public ArtifactHandler() {
            super(ARTIFACT);
            this.addChild(new PropertiesParser.PropertiesHandler(new String[0]), new DelegatingHandler.ChildElementHandler<PropertiesParser.PropertiesHandler>(){

                @Override
                public void childHanlded(PropertiesParser.PropertiesHandler propertiesHandler) {
                    ArtifactHandler.this.properties = propertiesHandler.properties;
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) throws SAXException {
            Version version;
            String string = attributes.getValue(ID);
            try {
                version = new Version(attributes.getValue(VERSION));
            }
            catch (ParseException parseException) {
                throw new SAXException("Incorrect version attribute on artifact '" + string + "': " + attributes.getValue(VERSION) + " (" + parseException.getMessage() + ")");
            }
            String string2 = attributes.getValue(CLASSIFIER);
            this.p2Artifact = new P2Artifact(string, version, string2);
        }
    }

    private static class ArtifactsHandler
    extends DelegatingHandler {
        private static final String ARTIFACTS = "artifacts";

        public ArtifactsHandler(final P2Descriptor p2Descriptor, final Map<OSGiFilter, String> map, final String string) {
            super(ARTIFACTS);
            this.addChild(new ArtifactHandler(), new DelegatingHandler.ChildElementHandler<ArtifactHandler>(){

                @Override
                public void childHanlded(ArtifactHandler artifactHandler) throws SAXParseException {
                    String string2 = this.getPattern(artifactHandler.p2Artifact, artifactHandler.properties);
                    if (string2 != null) {
                        URI uRI;
                        string2 = string2.replaceAll("\\$\\{repoUrl\\}", string);
                        string2 = string2.replaceAll("\\$\\{id\\}", artifactHandler.p2Artifact.getId());
                        string2 = string2.replaceAll("\\$\\{version\\}", artifactHandler.p2Artifact.getVersion().toString());
                        try {
                            uRI = new URL(string2).toURI();
                        }
                        catch (MalformedURLException malformedURLException) {
                            throw new SAXParseException("Incorrect artifact url '" + string2 + "' (" + malformedURLException.getMessage() + ")", ArtifactsHandler.this.getLocator(), malformedURLException);
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            throw new SAXParseException("Incorrect artifact url '" + string2 + "' (" + uRISyntaxException.getMessage() + ")", ArtifactsHandler.this.getLocator(), uRISyntaxException);
                        }
                        p2Descriptor.addArtifactUrl(artifactHandler.p2Artifact.getClassifier(), artifactHandler.p2Artifact.getId(), artifactHandler.p2Artifact.getVersion(), uRI, (String)artifactHandler.properties.get("format"));
                    }
                }

                private String getPattern(P2Artifact p2Artifact, Map<String, String> map2) {
                    HashMap<String, String> hashMap = new HashMap<String, String>(map2);
                    hashMap.put("classifier", p2Artifact.getClassifier());
                    for (Map.Entry entry : map.entrySet()) {
                        if (!((OSGiFilter)entry.getKey()).eval(hashMap)) continue;
                        return (String)entry.getValue();
                    }
                    return null;
                }
            });
        }
    }

    private static class RuleHandler
    extends DelegatingHandler {
        private static final String RULE = "rule";
        private static final String FILTER = "filter";
        private static final String OUTPUT = "output";
        private String filter;
        private String output;

        public RuleHandler() {
            super(RULE);
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            this.filter = attributes.getValue(FILTER);
            this.output = attributes.getValue(OUTPUT);
        }
    }

    private static class MappingsHandler
    extends DelegatingHandler {
        private static final String MAPPINGS = "mappings";
        private static final String SIZE = "size";
        Map<String, String> outputByFilter;

        public MappingsHandler() {
            super(MAPPINGS);
            this.addChild(new RuleHandler(), new DelegatingHandler.ChildElementHandler<RuleHandler>(){

                @Override
                public void childHanlded(RuleHandler ruleHandler) {
                    MappingsHandler.this.outputByFilter.put(ruleHandler.filter, ruleHandler.output);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes attributes) {
            int n = Integer.parseInt(attributes.getValue(SIZE));
            this.outputByFilter = new LinkedHashMap<String, String>(n);
        }
    }

    private static class RepositoryHandler
    extends DelegatingHandler {
        private static final String REPOSITORY = "repository";
        private Map<OSGiFilter, String> artifactPatterns = new LinkedHashMap<OSGiFilter, String>();

        public RepositoryHandler(P2Descriptor p2Descriptor, String string) {
            super(REPOSITORY);
            this.addChild(new MappingsHandler(), new DelegatingHandler.ChildElementHandler<MappingsHandler>(){

                @Override
                public void childHanlded(MappingsHandler mappingsHandler) {
                    for (Map.Entry<String, String> entry : mappingsHandler.outputByFilter.entrySet()) {
                        OSGiFilter oSGiFilter;
                        try {
                            oSGiFilter = OSGiFilterParser.parse(entry.getKey());
                        }
                        catch (ParseException parseException) {
                            throw new IllegalStateException();
                        }
                        RepositoryHandler.this.artifactPatterns.put(oSGiFilter, entry.getValue());
                    }
                }
            });
            this.addChild(new ArtifactsHandler(p2Descriptor, this.artifactPatterns, string), new DelegatingHandler.ChildElementHandler<ArtifactsHandler>(){

                @Override
                public void childHanlded(ArtifactsHandler artifactsHandler) {
                }
            });
        }
    }
}

