/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.xml;

import java.text.ParseException;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.obr.xml.Capability;
import org.apache.ivy.osgi.obr.xml.CapabilityProperty;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.util.Message;

public class CapabilityAdapter {
    public static void adapt(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String string = capability.getName();
        if ("package".equals(string)) {
            ExportPackage exportPackage = CapabilityAdapter.getExportPackage(bundleInfo, capability);
            bundleInfo.addCapability(exportPackage);
        } else if (!"bundle".equals(string)) {
            if ("service".equals(string)) {
                BundleCapability bundleCapability = CapabilityAdapter.getOSGiService(bundleInfo, capability);
                bundleInfo.addCapability(bundleCapability);
            } else {
                Message.warn("Unsupported capability '" + string + "' on the bundle '" + bundleInfo.getSymbolicName() + "'");
            }
        }
    }

    private static ExportPackage getExportPackage(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String string = null;
        Version version = null;
        String string2 = null;
        for (CapabilityProperty stringArray : capability.getProperties()) {
            String i = stringArray.getName();
            if ("package".equals(i)) {
                string = stringArray.getValue();
                continue;
            }
            if ("version".equals(i)) {
                version = new Version(stringArray.getValue());
                continue;
            }
            if ("uses".equals(i)) {
                string2 = stringArray.getValue();
                continue;
            }
            Message.warn("Unsupported property '" + i + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (string == null) {
            throw new ParseException("No package name for the capability", 0);
        }
        ExportPackage exportPackage = new ExportPackage(string, version);
        if (string2 != null) {
            String[] stringArray = string2.trim().split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                exportPackage.addUse(string3.trim());
            }
        }
        return exportPackage;
    }

    private static BundleCapability getOSGiService(BundleInfo bundleInfo, Capability capability) throws ParseException {
        String string = null;
        Version version = null;
        for (CapabilityProperty capabilityProperty : capability.getProperties()) {
            String string2 = capabilityProperty.getName();
            if ("service".equals(string2)) {
                string = capabilityProperty.getValue();
                continue;
            }
            if ("version".equals(string2)) {
                version = new Version(capabilityProperty.getValue());
                continue;
            }
            Message.warn("Unsupported property '" + string2 + "' on the 'package' capability of the bundle '" + bundleInfo.getSymbolicName() + "'");
        }
        if (string == null) {
            throw new ParseException("No service name for the capability", 0);
        }
        BundleCapability bundleCapability = new BundleCapability("service", string, version);
        return bundleCapability;
    }
}

