/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.filter;

import java.text.ParseException;
import org.apache.ivy.osgi.filter.AndFilter;
import org.apache.ivy.osgi.filter.CompareFilter;
import org.apache.ivy.osgi.filter.MultiOperatorFilter;
import org.apache.ivy.osgi.filter.NotFilter;
import org.apache.ivy.osgi.filter.OSGiFilter;
import org.apache.ivy.osgi.filter.OrFilter;

public class OSGiFilterParser {
    public static OSGiFilter parse(String string) throws ParseException {
        return new Parser(string).parse();
    }

    static class Parser {
        private final String text;
        private int length;
        private int pos = 0;
        private char c;

        Parser(String string) {
            this.text = string;
            this.length = string.length();
        }

        OSGiFilter parse() throws ParseException {
            return this.parseFilter();
        }

        private char readNext() {
            this.c = this.pos == this.length ? (char)'\u0000' : this.text.charAt(this.pos++);
            return this.c;
        }

        private void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }

        private OSGiFilter parseFilter() throws ParseException {
            OSGiFilter oSGiFilter;
            this.skipWhiteSpace();
            this.readNext();
            if (this.c != '(') {
                throw new ParseException("Expecting '(' as the start of the filter", this.pos);
            }
            switch (this.readNext()) {
                case '&': {
                    oSGiFilter = this.parseAnd();
                    break;
                }
                case '|': {
                    oSGiFilter = this.parseOr();
                    break;
                }
                case '!': {
                    oSGiFilter = this.parseNot();
                    break;
                }
                default: {
                    this.unread();
                    oSGiFilter = this.parseCompare();
                }
            }
            this.readNext();
            if (this.c != ')') {
                throw new ParseException("Expecting ')' as the end of the filter", this.pos);
            }
            return oSGiFilter;
        }

        private OSGiFilter parseCompare() throws ParseException {
            String string = this.parseCompareValue();
            CompareFilter.Operator operator = this.parseCompareOperator();
            String string2 = this.parseCompareValue();
            return new CompareFilter(string, operator, string2);
        }

        private String parseCompareValue() {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                this.readNext();
                if (this.isOperator(this.c) || this.c == ')' || this.c == '(') {
                    this.unread();
                    break;
                }
                stringBuffer.append(this.c);
            } while (this.pos < this.length);
            return stringBuffer.toString();
        }

        private boolean isOperator(char c) {
            return c == '=' || c == '<' || c == '>';
        }

        private CompareFilter.Operator parseCompareOperator() throws ParseException {
            switch (this.readNext()) {
                case '=': {
                    return CompareFilter.Operator.EQUALS;
                }
                case '>': {
                    if (this.readNext() == '=') {
                        return CompareFilter.Operator.GREATER_OR_EQUAL;
                    }
                    this.unread();
                    return CompareFilter.Operator.GREATER_THAN;
                }
                case '<': {
                    if (this.readNext() == '=') {
                        return CompareFilter.Operator.LOWER_OR_EQUAL;
                    }
                    this.unread();
                    return CompareFilter.Operator.LOWER_THAN;
                }
            }
            throw new ParseException("Expecting an operator: =, <, <=, > or >=", this.pos);
        }

        private OSGiFilter parseAnd() throws ParseException {
            AndFilter andFilter = new AndFilter();
            this.parseMultiOperator(andFilter);
            return andFilter;
        }

        private OSGiFilter parseOr() throws ParseException {
            OrFilter orFilter = new OrFilter();
            this.parseMultiOperator(orFilter);
            return orFilter;
        }

        private void parseMultiOperator(MultiOperatorFilter multiOperatorFilter) throws ParseException {
            do {
                this.skipWhiteSpace();
                this.readNext();
                if (this.c != '(') {
                    this.unread();
                    break;
                }
                this.unread();
                multiOperatorFilter.add(this.parseFilter());
            } while (this.pos < this.length);
            if (multiOperatorFilter.getSubFilters().size() == 0) {
                throw new ParseException("Expecting at least one sub filter", this.pos);
            }
        }

        private OSGiFilter parseNot() throws ParseException {
            this.readNext();
            if (this.c != '(') {
                throw new ParseException("The ! operator is expecting a filter", this.pos);
            }
            this.unread();
            return new NotFilter(this.parseFilter());
        }

        private void skipWhiteSpace() {
            do {
                switch (this.readNext()) {
                    case ' ': {
                        break;
                    }
                    default: {
                        this.unread();
                        return;
                    }
                }
            } while (this.pos < this.length);
        }
    }
}

