/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.filter;

import java.util.Map;
import org.apache.ivy.osgi.filter.OSGiFilter;

public class CompareFilter
extends OSGiFilter {
    private Operator operator;
    private final String rightValue;
    private final String leftValue;

    public CompareFilter(String string, Operator operator, String string2) {
        this.leftValue = string;
        this.rightValue = string2;
        this.operator = operator;
    }

    public String getLeftValue() {
        return this.leftValue;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getRightValue() {
        return this.rightValue;
    }

    @Override
    public void append(StringBuffer stringBuffer) {
        stringBuffer.append("(");
        stringBuffer.append(this.leftValue);
        stringBuffer.append(this.operator.toString());
        stringBuffer.append(this.rightValue);
        stringBuffer.append(")");
    }

    @Override
    public boolean eval(Map<String, String> map) {
        String string = map.get(this.leftValue);
        if (string == null) {
            return false;
        }
        int n = this.rightValue.compareTo(string);
        switch (this.operator) {
            case EQUALS: {
                return n == 0;
            }
            case GREATER_THAN: {
                return n > 0;
            }
            case GREATER_OR_EQUAL: {
                return n >= 0;
            }
            case LOWER_OR_EQUAL: {
                return n <= 0;
            }
            case LOWER_THAN: {
                return n < 0;
            }
        }
        throw new IllegalStateException();
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.leftValue == null ? 0 : this.leftValue.hashCode());
        n = 31 * n + (this.operator == null ? 0 : this.operator.hashCode());
        n = 31 * n + (this.rightValue == null ? 0 : this.rightValue.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof CompareFilter)) {
            return false;
        }
        CompareFilter compareFilter = (CompareFilter)object;
        if (this.leftValue == null ? compareFilter.leftValue != null : !this.leftValue.equals(compareFilter.leftValue)) {
            return false;
        }
        if (this.operator == null ? compareFilter.operator != null : !this.operator.equals((Object)compareFilter.operator)) {
            return false;
        }
        return !(this.rightValue == null ? compareFilter.rightValue != null : !this.rightValue.equals(compareFilter.rightValue));
    }

    public static enum Operator {
        EQUALS("="),
        LOWER_THAN("<"),
        LOWER_OR_EQUAL("<="),
        GREATER_THAN(">"),
        GREATER_OR_EQUAL(">=");

        private String op;

        private Operator(String string2) {
            this.op = string2;
        }

        public String toString() {
            return this.op;
        }
    }
}

