/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestHeaderElement;
import org.apache.ivy.osgi.core.ManifestHeaderValue;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;

public class ManifestParser {
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String EXPORT_SERVICE = "Export-Service";
    private static final String IMPORT_SERVICE = "Import-Service";
    private static final String REQUIRE_BUNDLE = "Require-Bundle";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_DESCRIPTION = "Bundle-Description";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_MANIFEST_VERSION = "Bundle-ManifestVersion";
    private static final String BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    private static final String ECLIPSE_SOURCE_BUNDLE = "Eclipse-SourceBundle";
    private static final String ATTR_RESOLUTION = "resolution";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_BUNDLE_VERSION = "bundle-version";
    private static final String ATTR_USE = "use";

    public static BundleInfo parseJarManifest(InputStream inputStream) throws IOException, ParseException {
        JarInputStream jarInputStream = new JarInputStream(inputStream);
        Manifest manifest = jarInputStream.getManifest();
        if (manifest == null) {
            return null;
        }
        BundleInfo bundleInfo = ManifestParser.parseManifest(manifest);
        return bundleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleInfo parseManifest(File file) throws IOException, ParseException {
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            BundleInfo bundleInfo;
            BundleInfo bundleInfo2 = bundleInfo = ManifestParser.parseManifest(fileInputStream);
            return bundleInfo2;
        }
        finally {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static BundleInfo parseManifest(String string) throws IOException, ParseException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes("UTF-8"));
        BundleInfo bundleInfo = ManifestParser.parseManifest(byteArrayInputStream);
        byteArrayInputStream.close();
        return bundleInfo;
    }

    public static BundleInfo parseManifest(InputStream inputStream) throws IOException, ParseException {
        BundleInfo bundleInfo = ManifestParser.parseManifest(new Manifest(inputStream));
        return bundleInfo;
    }

    public static BundleInfo parseManifest(Manifest manifest) throws ParseException {
        String string;
        Object object;
        Object object2;
        Version version;
        Attributes attributes = manifest.getMainAttributes();
        String string2 = new ManifestHeaderValue(attributes.getValue(BUNDLE_SYMBOLIC_NAME)).getSingleValue();
        if (string2 == null) {
            throw new ParseException("No Bundle-SymbolicName in the manifest", 0);
        }
        String string22 = new ManifestHeaderValue(attributes.getValue(BUNDLE_DESCRIPTION)).getSingleValue();
        if (string22 == null) {
            string22 = new ManifestHeaderValue(attributes.getValue(BUNDLE_DESCRIPTION)).getSingleValue();
        }
        String string3 = new ManifestHeaderValue(attributes.getValue(BUNDLE_VERSION)).getSingleValue();
        try {
            version = ManifestParser.versionOf(string3);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("The Bundle-Version has an incorrect version: " + string3 + " (" + numberFormatException.getMessage() + ")", 0);
        }
        BundleInfo bundleInfo = new BundleInfo(string2, version);
        bundleInfo.setDescription(string22);
        List<String> list = new ManifestHeaderValue(attributes.getValue(BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT)).getValues();
        bundleInfo.setExecutionEnvironments(list);
        ManifestParser.parseRequirement(bundleInfo, attributes, REQUIRE_BUNDLE, "bundle", ATTR_BUNDLE_VERSION);
        ManifestParser.parseRequirement(bundleInfo, attributes, IMPORT_PACKAGE, "package", ATTR_VERSION);
        ManifestParser.parseRequirement(bundleInfo, attributes, IMPORT_SERVICE, "service", ATTR_VERSION);
        ManifestHeaderValue manifestHeaderValue = new ManifestHeaderValue(attributes.getValue(EXPORT_PACKAGE));
        for (ManifestHeaderElement object32 : manifestHeaderValue.getElements()) {
            object2 = object32.getAttributes().get(ATTR_VERSION);
            object = null;
            try {
                object = ManifestParser.versionOf((String)object2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The Export-Package has an incorrect version: " + (String)object2 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            for (String string4 : object32.getValues()) {
                ExportPackage exportPackage = new ExportPackage(string4, (Version)object);
                String string5 = object32.getDirectives().get(ATTR_USE);
                if (string5 != null) {
                    String[] stringArray = string5.trim().split(",");
                    for (int i = 0; i < stringArray.length; ++i) {
                        exportPackage.addUse(stringArray[i].trim());
                    }
                }
                bundleInfo.addCapability(exportPackage);
            }
        }
        ManifestParser.parseCapability(bundleInfo, attributes, EXPORT_SERVICE, "service");
        String string6 = attributes.getValue(ECLIPSE_SOURCE_BUNDLE);
        if (string6 != null) {
            bundleInfo.setSource(true);
            ManifestHeaderValue manifestHeaderValue2 = new ManifestHeaderValue(string6);
            object2 = manifestHeaderValue2.getElements().iterator().next();
            object = ((ManifestHeaderElement)object2).getValues().iterator().next();
            bundleInfo.setSymbolicNameTarget((String)object);
            String string7 = ((ManifestHeaderElement)object2).getAttributes().get(ATTR_VERSION);
            if (string7 != null) {
                bundleInfo.setVersionTarget(new Version(string7));
            }
        }
        if ((string = attributes.getValue(BUNDLE_CLASSPATH)) != null) {
            object2 = new ManifestHeaderValue(string);
            bundleInfo.setClasspath(((ManifestHeaderValue)object2).getValues());
        }
        return bundleInfo;
    }

    private static void parseRequirement(BundleInfo bundleInfo, Attributes attributes, String string, String string2, String string3) throws ParseException {
        ManifestHeaderValue manifestHeaderValue = new ManifestHeaderValue(attributes.getValue(string));
        for (ManifestHeaderElement manifestHeaderElement : manifestHeaderValue.getElements()) {
            String string4 = manifestHeaderElement.getDirectives().get(ATTR_RESOLUTION);
            String string5 = manifestHeaderElement.getAttributes().get(string3);
            VersionRange versionRange = null;
            try {
                versionRange = ManifestParser.versionRangeOf(string5);
            }
            catch (ParseException parseException) {
                throw new ParseException("The " + string + " has an incorrect version: " + string5 + " (" + parseException.getMessage() + ")", 0);
            }
            for (String string6 : manifestHeaderElement.getValues()) {
                bundleInfo.addRequirement(new BundleRequirement(string2, string6, versionRange, string4));
            }
        }
    }

    private static void parseCapability(BundleInfo bundleInfo, Attributes attributes, String string, String string2) throws ParseException {
        ManifestHeaderValue manifestHeaderValue = new ManifestHeaderValue(attributes.getValue(string));
        for (ManifestHeaderElement manifestHeaderElement : manifestHeaderValue.getElements()) {
            String string3 = manifestHeaderElement.getAttributes().get(ATTR_VERSION);
            Version version = null;
            try {
                version = ManifestParser.versionOf(string3);
            }
            catch (NumberFormatException numberFormatException) {
                throw new ParseException("The " + string + " has an incorrect version: " + string3 + " (" + numberFormatException.getMessage() + ")", 0);
            }
            for (String string4 : manifestHeaderElement.getValues()) {
                BundleCapability bundleCapability = new BundleCapability(string2, string4, version);
                bundleInfo.addCapability(bundleCapability);
            }
        }
    }

    private static VersionRange versionRangeOf(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return new VersionRange(string);
    }

    private static Version versionOf(String string) throws ParseException {
        if (string == null) {
            return null;
        }
        return new Version(string);
    }

    public static String formatLines(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        String[] stringArray = string.split("\n");
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 72) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append('\n');
                continue;
            }
            stringBuffer.append(stringArray[i].substring(0, 72));
            stringBuffer.append("\n ");
            int n = 72;
            while (n <= stringArray[i].length() - 1) {
                int n2 = n + 71;
                if (n2 > stringArray[i].length()) {
                    n2 = stringArray[i].length();
                }
                stringBuffer.append(stringArray[i].substring(n, n2));
                stringBuffer.append('\n');
                if (n2 != stringArray[i].length()) {
                    stringBuffer.append(' ');
                }
                n = n2;
            }
        }
        return stringBuffer.toString();
    }
}

