/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.retrieve;

import org.apache.ivy.core.LogOptions;
import org.apache.ivy.core.retrieve.FileNameMapper;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public class RetrieveOptions
extends LogOptions {
    public static final String OVERWRITEMODE_NEVER = "never";
    public static final String OVERWRITEMODE_ALWAYS = "always";
    public static final String OVERWRITEMODE_NEWER = "newer";
    public static final String OVERWRITEMODE_DIFFERENT = "different";
    private String[] confs = new String[]{"*"};
    private String destIvyPattern = null;
    private String destArtifactPattern = null;
    private Filter artifactFilter = FilterHelper.NO_FILTER;
    private boolean sync = false;
    private String overwriteMode = "newer";
    private boolean useOrigin = false;
    private boolean makeSymlinks = false;
    private boolean makeSymlinksInMass = false;
    private String resolveId;
    private FileNameMapper mapper;

    public RetrieveOptions() {
    }

    public RetrieveOptions(RetrieveOptions retrieveOptions) {
        super(retrieveOptions);
        this.confs = retrieveOptions.confs;
        this.destIvyPattern = retrieveOptions.destIvyPattern;
        this.destArtifactPattern = retrieveOptions.destArtifactPattern;
        this.artifactFilter = retrieveOptions.artifactFilter;
        this.sync = retrieveOptions.sync;
        this.overwriteMode = retrieveOptions.overwriteMode;
        this.useOrigin = retrieveOptions.useOrigin;
        this.makeSymlinks = retrieveOptions.makeSymlinks;
        this.makeSymlinksInMass = retrieveOptions.makeSymlinksInMass;
        this.resolveId = retrieveOptions.resolveId;
        this.mapper = retrieveOptions.mapper;
    }

    public String getDestArtifactPattern() {
        return this.destArtifactPattern;
    }

    public RetrieveOptions setDestArtifactPattern(String string) {
        this.destArtifactPattern = string;
        return this;
    }

    public Filter getArtifactFilter() {
        return this.artifactFilter;
    }

    public RetrieveOptions setArtifactFilter(Filter filter) {
        this.artifactFilter = filter;
        return this;
    }

    public String[] getConfs() {
        return this.confs;
    }

    public RetrieveOptions setConfs(String[] stringArray) {
        this.confs = stringArray;
        return this;
    }

    public String getOverwriteMode() {
        return this.overwriteMode == null ? OVERWRITEMODE_NEWER : this.overwriteMode;
    }

    public RetrieveOptions setOverwriteMode(String string) {
        this.overwriteMode = string;
        return this;
    }

    public String getDestIvyPattern() {
        return this.destIvyPattern;
    }

    public RetrieveOptions setDestIvyPattern(String string) {
        this.destIvyPattern = string;
        return this;
    }

    public boolean isMakeSymlinks() {
        return this.makeSymlinks;
    }

    public boolean isMakeSymlinksInMass() {
        return this.makeSymlinksInMass;
    }

    public RetrieveOptions setMakeSymlinks(boolean bl) {
        this.makeSymlinks = bl;
        return this;
    }

    public RetrieveOptions setMakeSymlinksInMass(boolean bl) {
        this.makeSymlinksInMass = bl;
        return this;
    }

    public boolean isSync() {
        return this.sync;
    }

    public RetrieveOptions setSync(boolean bl) {
        this.sync = bl;
        return this;
    }

    public boolean isUseOrigin() {
        return this.useOrigin;
    }

    public RetrieveOptions setUseOrigin(boolean bl) {
        this.useOrigin = bl;
        return this;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    public RetrieveOptions setResolveId(String string) {
        this.resolveId = string;
        return this;
    }

    public FileNameMapper getMapper() {
        return this.mapper;
    }

    public RetrieveOptions setMapper(FileNameMapper fileNameMapper) {
        this.mapper = fileNameMapper;
        return this;
    }
}

