/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.event.resolve.EndResolveDependencyEvent;
import org.apache.ivy.core.event.resolve.StartResolveDependencyEvent;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.IvyNodeEviction;
import org.apache.ivy.core.resolve.IvyNodeUsage;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolveEngineSettings;
import org.apache.ivy.core.resolve.ResolveProcessException;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.ivy.util.filter.Filter;
import org.apache.ivy.util.filter.FilterHelper;

public class IvyNode
implements Comparable {
    private static final Pattern FALLBACK_CONF_PATTERN = Pattern.compile("(.+)\\((.*)\\)");
    private ResolveData data;
    private ResolveEngineSettings settings;
    private IvyNodeCallers callers;
    private IvyNodeEviction eviction;
    private IvyNode root;
    private ModuleRevisionId id;
    private Map dds = new HashMap();
    private ModuleDescriptor md;
    private ResolvedModuleRevision module;
    private Exception problem = null;
    private boolean downloaded = false;
    private boolean searched = false;
    private Collection confsToFetch = new HashSet();
    private Collection fetchedConfigurations = new HashSet();
    private Collection loadedRootModuleConfs = new HashSet();
    private IvyNodeUsage usage = new IvyNodeUsage(this);
    private Map mergedUsages = new LinkedHashMap();

    public IvyNode(ResolveData resolveData, IvyNode ivyNode, DependencyDescriptor dependencyDescriptor) {
        this.id = dependencyDescriptor.getDependencyRevisionId();
        this.dds.put(ivyNode, dependencyDescriptor);
        this.root = ivyNode.getRoot();
        this.init(resolveData);
    }

    public IvyNode(ResolveData resolveData, ModuleDescriptor moduleDescriptor) {
        this.id = moduleDescriptor.getModuleRevisionId();
        this.md = moduleDescriptor;
        this.root = this;
        this.init(resolveData);
    }

    private void init(ResolveData resolveData) {
        this.data = resolveData;
        this.settings = resolveData.getSettings();
        this.eviction = new IvyNodeEviction(this);
        this.callers = new IvyNodeCallers(this);
    }

    public boolean loadData(String string, IvyNode ivyNode, String string2, String string3, boolean bl, IvyNodeUsage ivyNodeUsage) {
        Object object;
        Message.debug("loadData of " + this.toString() + " of rootConf=" + string);
        if (!this.isRoot() && this.data.getReport() != null) {
            this.data.getReport().addDependency(this);
        }
        boolean bl2 = false;
        if (this.hasProblem()) {
            Message.debug("Node has problem.  Skip loading");
        } else if (this.isEvicted(string)) {
            Message.debug(string + " is evicted.  Skip loading");
        } else if (!this.hasConfigurationsToLoad() && this.isRootModuleConfLoaded(string)) {
            Message.debug(string + " is loaded and no conf to load.  Skip loading");
        } else {
            this.markRootModuleConfLoaded(string);
            if (this.md == null) {
                object = this.data.getSettings().getResolver(this.getId());
                if (object == null) {
                    Message.error("no resolver found for " + this.getModuleId() + ": check your configuration");
                    this.problem = new RuntimeException("no resolver found for " + this.getModuleId() + ": check your configuration");
                    return false;
                }
                try {
                    Message.debug("\tusing " + object + " to resolve " + this.getId());
                    DependencyDescriptor dependencyDescriptor = this.getDependencyDescriptor(ivyNode);
                    long l = System.currentTimeMillis();
                    ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
                    this.data.getEventManager().fireIvyEvent(new StartResolveDependencyEvent((DependencyResolver)object, dependencyDescriptor, moduleRevisionId));
                    this.module = object.getDependency(dependencyDescriptor, this.data);
                    this.data.getEventManager().fireIvyEvent(new EndResolveDependencyEvent((DependencyResolver)object, dependencyDescriptor, moduleRevisionId, this.module, System.currentTimeMillis() - l));
                    if (this.module != null) {
                        this.module.getResolver().getRepositoryCacheManager().saveResolvers(this.module.getDescriptor(), this.module.getResolver().getName(), this.module.getArtifactResolver().getName());
                        if (this.settings.logModuleWhenFound() && "default".equals(this.getData().getOptions().getLog())) {
                            Message.info("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        } else {
                            Message.verbose("\tfound " + this.module.getId() + " in " + this.module.getResolver().getName());
                        }
                        if (this.settings.getVersionMatcher().isDynamic(this.getId()) && this.settings.getVersionMatcher().isDynamic(this.module.getId())) {
                            Message.error("impossible to resolve dynamic revision for " + this.getId() + ": check your configuration and " + "make sure revision is part of your pattern");
                            this.problem = new RuntimeException("impossible to resolve dynamic revision");
                            return false;
                        }
                        if (!this.getId().equals(this.module.getId())) {
                            IvyNode ivyNode2 = this.data.getNode(this.module.getId());
                            if (ivyNode2 != null) {
                                this.md = this.module.getDescriptor();
                                if (!this.handleConfiguration(bl2, string, ivyNode, string2, string3, bl, ivyNodeUsage)) {
                                    return false;
                                }
                                this.moveToRealNode(string, ivyNode, string2, string3, bl, ivyNode2);
                                return true;
                            }
                            String string4 = "\t[" + this.module.getId().getRevision() + "] " + this.getId();
                            if (!this.settings.getVersionMatcher().isDynamic(this.getId())) {
                                string4 = string4 + " (forced)";
                            }
                            if (this.settings.logResolvedRevision() && "default".equals(this.getData().getOptions().getLog())) {
                                Message.info(string4);
                            } else {
                                Message.verbose(string4);
                            }
                        }
                    } else {
                        Message.warn("\tmodule not found: " + this.getId());
                        object.reportFailure();
                        this.problem = new RuntimeException("not found");
                        return false;
                    }
                    this.downloaded = this.module.getReport().isDownloaded();
                    this.searched = this.module.getReport().isSearched();
                    bl2 = true;
                    this.md = this.module.getDescriptor();
                    this.confsToFetch.remove("*");
                    this.updateConfsToFetch(Arrays.asList(this.resolveSpecialConfigurations(this.getRequiredConfigurations(ivyNode, string2))));
                }
                catch (ResolveProcessException resolveProcessException) {
                    throw resolveProcessException;
                }
                catch (Exception exception) {
                    this.problem = exception;
                    Message.debug("Unexpected error: " + this.problem.getMessage(), this.problem);
                    return false;
                }
            } else {
                bl2 = true;
            }
        }
        this.handleConfiguration(bl2, string, ivyNode, string2, string3, bl, ivyNodeUsage);
        if (this.hasProblem()) {
            Message.debug("problem : " + this.problem.getMessage());
            return false;
        }
        object = this.getDependencyDescriptor(ivyNode);
        if (object != null) {
            ivyNodeUsage.addUsage(string, (DependencyDescriptor)object, string2);
        }
        return bl2;
    }

    private void moveToRealNode(String string, IvyNode ivyNode, String string2, String string3, boolean bl, IvyNode ivyNode2) {
        if (ivyNode2.md == null) {
            ivyNode2.md = this.md;
        }
        if (ivyNode2.module == null) {
            ivyNode2.module = this.module;
        }
        ivyNode2.downloaded |= this.module.getReport().isDownloaded();
        ivyNode2.searched |= this.module.getReport().isSearched();
        ivyNode2.dds.putAll(this.dds);
        ivyNode2.updateDataFrom(this, string, true);
        ivyNode2.loadData(string, ivyNode, string2, string3, bl, this.usage);
        ivyNode2.usage.updateDataFrom(this.getAllUsages(), string);
        this.usage = ivyNode2.usage;
        this.data.replaceNode(this.getId(), ivyNode2, string);
        if (this.settings.logResolvedRevision() && "default".equals(this.getData().getOptions().getLog())) {
            Message.info("\t[" + this.module.getId().getRevision() + "] " + this.getId());
        } else {
            Message.verbose("\t[" + this.module.getId().getRevision() + "] " + this.getId());
        }
    }

    public Collection getDependencies(String string, String[] stringArray, String string2) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        if (Arrays.asList(stringArray).contains("*")) {
            stringArray = this.isRoot() ? this.md.getConfigurationsNames() : this.md.getPublicConfigurationsNames();
        }
        HashSet hashSet = new HashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            hashSet.addAll(this.getDependencies(string, stringArray[i], string2));
        }
        return hashSet;
    }

    public Collection getDependencies(String string, String string2, String string3) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get dependencies when data has not been loaded");
        }
        DependencyDescriptor[] dependencyDescriptorArray = this.md.getDependencies();
        LinkedHashMap<ModuleRevisionId, IvyNode> linkedHashMap = new LinkedHashMap<ModuleRevisionId, IvyNode>();
        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
            DependencyDescriptor dependencyDescriptor = this.data.mediate(dependencyDescriptorArray[i]);
            String[] stringArray = dependencyDescriptor.getDependencyConfigurations(string2, string3);
            if (stringArray.length == 0) continue;
            ModuleRevisionId moduleRevisionId = dependencyDescriptor.getDependencyRevisionId();
            if (this.isDependencyModuleExcluded(dependencyDescriptor, string, moduleRevisionId, string2)) {
                Message.verbose("excluding " + dependencyDescriptor + " in " + string2);
                continue;
            }
            IvyNode ivyNode = (IvyNode)linkedHashMap.get(moduleRevisionId);
            if (ivyNode == null) {
                ivyNode = this.data.getNode(moduleRevisionId);
            }
            if (ivyNode == null) {
                ivyNode = new IvyNode(this.data, this, dependencyDescriptor);
            } else {
                ivyNode.addDependencyDescriptor(this, dependencyDescriptor);
                if (ivyNode.hasProblem()) {
                    // empty if block
                }
            }
            String[] stringArray2 = ivyNode.resolveSpecialConfigurations(stringArray);
            List<String> list = Arrays.asList(stringArray2);
            ivyNode.updateConfsToFetch(list);
            ivyNode.addRootModuleConfigurations(ivyNode.usage, string, stringArray2);
            ivyNode.usage.setRequiredConfs(this, string2, list);
            ivyNode.addCaller(string, this, string2, string3, stringArray, dependencyDescriptor);
            linkedHashMap.put(moduleRevisionId, ivyNode);
        }
        return linkedHashMap.values();
    }

    private void addDependencyDescriptor(IvyNode ivyNode, DependencyDescriptor dependencyDescriptor) {
        this.dds.put(ivyNode, dependencyDescriptor);
    }

    public DependencyDescriptor getDependencyDescriptor(IvyNode ivyNode) {
        return (DependencyDescriptor)this.dds.get(ivyNode);
    }

    private boolean isDependencyModuleExcluded(DependencyDescriptor dependencyDescriptor, String string, ModuleRevisionId moduleRevisionId, String string2) {
        Artifact artifact = DefaultArtifact.newIvyArtifact(moduleRevisionId, null);
        if (this.isRoot()) {
            Boolean bl = this.doesExclude(this.md, string, new String[]{string}, dependencyDescriptor, artifact, new Stack());
            return bl == null ? false : bl;
        }
        return this.callers.doesCallersExclude(string, artifact);
    }

    Boolean doesExclude(ModuleDescriptor moduleDescriptor, String string, String[] stringArray, DependencyDescriptor dependencyDescriptor, Artifact artifact, Stack stack) {
        if (dependencyDescriptor != null && dependencyDescriptor.doesExclude(stringArray, artifact.getId().getArtifactId())) {
            return Boolean.TRUE;
        }
        if (moduleDescriptor.doesExclude(stringArray, artifact.getId().getArtifactId())) {
            return Boolean.TRUE;
        }
        IvyNode ivyNode = this.getData().getNode(moduleDescriptor.getModuleRevisionId());
        if (ivyNode != null) {
            if (stack.contains(ivyNode.getId())) {
                return null;
            }
            return ivyNode.doesCallersExclude(string, artifact, stack);
        }
        return Boolean.FALSE;
    }

    public boolean hasConfigurationsToLoad() {
        return !this.confsToFetch.isEmpty();
    }

    private boolean markRootModuleConfLoaded(String string) {
        return this.loadedRootModuleConfs.add(string);
    }

    private boolean isRootModuleConfLoaded(String string) {
        return this.loadedRootModuleConfs.contains(string);
    }

    private boolean handleConfiguration(boolean bl, String string, IvyNode ivyNode, String string2, String string3, boolean bl2, IvyNodeUsage ivyNodeUsage) {
        if (this.md != null) {
            String[] stringArray = this.getRealConfs(string3);
            this.addRootModuleConfigurations(ivyNodeUsage, string, stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                Configuration configuration = this.md.getConfiguration(stringArray[i]);
                if (configuration == null) {
                    this.confsToFetch.remove(string3);
                    if (this.isConfRequiredByMergedUsageOnly(string, string3)) {
                        Message.verbose("configuration required by evicted revision is not available in selected revision. skipping " + string3 + " in " + this);
                    } else {
                        this.problem = !string3.equals(stringArray[i]) ? new RuntimeException("configuration not found in " + this + ": '" + string3 + "'. Missing configuration: '" + stringArray[i] + "'. It was required from " + ivyNode + " " + string2) : new RuntimeException("configuration not found in " + this + ": '" + stringArray[i] + "'. It was required from " + ivyNode + " " + string2);
                    }
                    return false;
                }
                if (!bl2 || this.isRoot() || configuration.getVisibility() == Configuration.Visibility.PUBLIC) continue;
                this.confsToFetch.remove(string3);
                if (this.isConfRequiredByMergedUsageOnly(string, string3)) {
                    Message.verbose("configuration required by evicted revision is not visible in selected revision. skipping " + string3 + " in " + this);
                } else {
                    this.problem = new RuntimeException("configuration not public in " + this + ": '" + configuration + "'. It was required from " + ivyNode + " " + string2);
                }
                return false;
            }
            if (bl) {
                this.fetchedConfigurations.add(string3);
                this.confsToFetch.removeAll(Arrays.asList(stringArray));
                this.confsToFetch.remove(string3);
            }
        }
        return true;
    }

    private String getDefaultConf(String string) {
        Matcher matcher = FALLBACK_CONF_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return string;
    }

    private String getMainConf(String string) {
        Matcher matcher = FALLBACK_CONF_PATTERN.matcher(string);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    public void updateConfsToFetch(Collection collection) {
        this.confsToFetch.addAll(collection);
        this.confsToFetch.removeAll(this.fetchedConfigurations);
    }

    private String[] resolveSpecialConfigurations(String[] stringArray) {
        if (stringArray.length == 1 && stringArray[0].startsWith("*") && this.isLoaded()) {
            String string = stringArray[0];
            if ("*".equals(string)) {
                return this.getDescriptor().getPublicConfigurationsNames();
            }
            List<String> list = Arrays.asList(string.substring(2).split("\\!"));
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(this.getDescriptor().getPublicConfigurationsNames()));
            arrayList.removeAll(list);
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return stringArray;
    }

    public String[] getRequiredConfigurations(IvyNode ivyNode, String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.addAllIfNotNull(linkedHashSet, this.usage.getRequiredConfigurations(ivyNode, string));
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            this.addAllIfNotNull(linkedHashSet, ivyNodeUsage.getRequiredConfigurations(ivyNode, string));
        }
        return linkedHashSet == null ? new String[]{} : linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    private void addAllIfNotNull(Collection collection, Collection collection2) {
        if (collection2 != null) {
            collection.addAll(collection2);
        }
    }

    public String[] getRequiredConfigurations() {
        ArrayList arrayList = new ArrayList(this.confsToFetch.size() + this.fetchedConfigurations.size());
        arrayList.addAll(this.fetchedConfigurations);
        arrayList.addAll(this.confsToFetch);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public Configuration getConfiguration(String string) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get configuration when data has not been loaded");
        }
        String string2 = this.getDefaultConf(string);
        Configuration configuration = this.md.getConfiguration(string = this.getMainConf(string));
        if (configuration == null) {
            configuration = this.md.getConfiguration(string2);
        }
        return configuration;
    }

    public String[] getConfigurations(String string) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.addAllIfNotNull(linkedHashSet, this.usage.getConfigurations(string));
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            this.addAllIfNotNull(linkedHashSet, ivyNodeUsage.getConfigurations(string));
        }
        return linkedHashSet.toArray(new String[linkedHashSet.size()]);
    }

    protected boolean isConfRequiredByMergedUsageOnly(String string, String string2) {
        Set set = this.usage.getConfigurations(string);
        return set == null || !set.contains(string2);
    }

    public void discardConf(String string, String string2) {
        Set set = this.usage.addAndGetConfigurations(string);
        if (this.md != null) {
            Configuration configuration = this.md.getConfiguration(string2);
            if (string2 != null) {
                String[] stringArray = configuration.getExtends();
                for (int i = 0; i < stringArray.length; ++i) {
                    this.discardConf(string, stringArray[i]);
                }
                set.remove(configuration.getName());
            } else {
                Message.warn("unknown configuration in " + this.getId() + ": " + string2);
            }
        } else {
            set.remove(string2);
        }
    }

    private void addRootModuleConfigurations(IvyNodeUsage ivyNodeUsage, String string, String[] stringArray) {
        Set set = ivyNodeUsage.addAndGetConfigurations(string);
        if (this.md != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                set.add(stringArray[i]);
                Configuration configuration = this.md.getConfiguration(stringArray[i]);
                if (configuration == null) continue;
                String[] stringArray2 = configuration.getExtends();
                this.addRootModuleConfigurations(ivyNodeUsage, string, stringArray2);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                set.add(stringArray[i]);
            }
        }
    }

    public String[] getRootModuleConfigurations() {
        Set set = this.getRootModuleConfigurationsSet();
        return set.toArray(new String[set.size()]);
    }

    public Set getRootModuleConfigurationsSet() {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        this.addAllIfNotNull(linkedHashSet, this.usage.getRootModuleConfigurations());
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            this.addAllIfNotNull(linkedHashSet, ivyNodeUsage.getRootModuleConfigurations());
        }
        return linkedHashSet;
    }

    public String[] getConfsToFetch() {
        return this.confsToFetch.toArray(new String[this.confsToFetch.size()]);
    }

    public String[] getRealConfs(String string) {
        if (this.md == null) {
            return new String[]{string};
        }
        String string2 = this.getDefaultConf(string);
        if (this.md.getConfiguration(string = this.getMainConf(string)) == null || Configuration.Visibility.PRIVATE.equals(this.md.getConfiguration(string).getVisibility())) {
            if ("".equals(string2)) {
                return new String[0];
            }
            string = string2;
        }
        if (string.startsWith("*")) {
            return this.resolveSpecialConfigurations(new String[]{string});
        }
        if (string.indexOf(44) != -1) {
            String[] stringArray = string.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        return new String[]{string};
    }

    private Collection findPath(ModuleId moduleId) {
        return this.findPath(moduleId, this, new LinkedList());
    }

    private Collection findPath(ModuleId moduleId, IvyNode ivyNode, List list) {
        IvyNode ivyNode2 = ivyNode.getDirectCallerFor(moduleId);
        if (ivyNode2 == null) {
            throw new IllegalArgumentException("no path from " + moduleId + " to " + this.getId() + " found");
        }
        if (list.contains(ivyNode2)) {
            list.add(0, ivyNode2);
            Message.verbose("circular dependency found while looking for the path for another one: was looking for " + moduleId + " as a caller of " + list.get(list.size() - 1));
            return list;
        }
        list.add(0, ivyNode2);
        if (ivyNode2.getId().getModuleId().equals(moduleId)) {
            return list;
        }
        return this.findPath(moduleId, ivyNode2, list);
    }

    private void updateDataFrom(IvyNode ivyNode, String string, boolean bl) {
        this.callers.updateFrom(ivyNode.callers, string, bl);
        if (bl) {
            this.usage.updateDataFrom(ivyNode.getAllUsages(), string);
        } else {
            IvyNodeUsage ivyNodeUsage = (IvyNodeUsage)this.mergedUsages.get(ivyNode.getId());
            if (ivyNodeUsage == null) {
                ivyNodeUsage = new IvyNodeUsage(ivyNode);
                this.mergedUsages.put(ivyNode.getId(), ivyNodeUsage);
            }
            ivyNodeUsage.updateDataFrom(ivyNode.getAllUsages(), string);
        }
        this.updateConfsToFetch(ivyNode.fetchedConfigurations);
        this.updateConfsToFetch(ivyNode.confsToFetch);
    }

    private Collection getAllUsages() {
        ArrayList<IvyNodeUsage> arrayList = new ArrayList<IvyNodeUsage>();
        arrayList.add(this.usage);
        arrayList.addAll(this.mergedUsages.values());
        return arrayList;
    }

    public Artifact[] getAllArtifacts() {
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        for (String string : this.getRootModuleConfigurationsSet()) {
            hashSet.addAll(Arrays.asList(this.getArtifacts(string)));
        }
        return hashSet.toArray(new Artifact[hashSet.size()]);
    }

    public Artifact[] getSelectedArtifacts(Filter filter) {
        Collection<Artifact> collection = new HashSet();
        for (String string : this.getRootModuleConfigurationsSet()) {
            if (this.isEvicted(string) || this.isBlacklisted(string)) continue;
            collection.addAll(Arrays.asList(this.getArtifacts(string)));
        }
        collection = FilterHelper.filter(collection, filter);
        return collection.toArray(new Artifact[collection.size()]);
    }

    public Artifact[] getArtifacts(String string) {
        Object object;
        String[] stringArray = this.getConfigurations(string);
        if (stringArray == null || stringArray.length == 0) {
            return new Artifact[0];
        }
        if (this.md == null) {
            throw new IllegalStateException("impossible to get artifacts when data has not been loaded. IvyNode = " + this.toString());
        }
        HashSet<Artifact> hashSet = new HashSet<Artifact>();
        Set set = this.usage.getDependencyArtifactsSet(string);
        if (this.md.isDefault() && set != null && !set.isEmpty()) {
            this.addArtifactsFromOwnUsage(hashSet, set);
            this.addArtifactsFromMergedUsage(string, hashSet);
        } else {
            object = new LinkedHashSet();
            this.addAllIfNotNull((Collection)object, this.usage.getDependencyIncludesSet(string));
            for (Object object2 : this.mergedUsages.values()) {
                this.addAllIfNotNull((Collection)object, ((IvyNodeUsage)object2).getDependencyIncludesSet(string));
            }
            if ((set == null || set.isEmpty()) && object.isEmpty()) {
                for (int i = 0; i < stringArray.length; ++i) {
                    hashSet.addAll(Arrays.asList(this.md.getArtifacts(stringArray[i])));
                }
            } else {
                Object object3;
                Object object2;
                HashMap hashMap = new HashMap();
                for (int i = 0; i < stringArray.length; ++i) {
                    object3 = this.md.getArtifacts(stringArray[i]);
                    for (int j = 0; j < ((Artifact[])object3).length; ++j) {
                        hashMap.put(object3[j].getId().getArtifactId(), object3[j]);
                    }
                }
                if (set != null) {
                    this.addArtifactsFromOwnUsage(hashSet, set);
                }
                this.addArtifactsFromMergedUsage(string, hashSet);
                object2 = object.iterator();
                while (object2.hasNext()) {
                    object3 = (IncludeRule)object2.next();
                    Collection collection = IvyNode.findArtifactsMatching((IncludeRule)object3, hashMap);
                    if (collection.isEmpty()) {
                        Message.error("a required artifact is not listed by module descriptor: " + object3.getId());
                        object2.remove();
                        continue;
                    }
                    Message.debug(this + " in " + string + ": including " + collection);
                    hashSet.addAll(collection);
                }
            }
        }
        object = hashSet.iterator();
        while (object.hasNext()) {
            Artifact artifact = (Artifact)object.next();
            boolean bl = this.callers.doesCallersExclude(string, artifact);
            if (!bl) continue;
            Message.debug(this + " in " + string + ": excluding " + artifact);
            object.remove();
        }
        return hashSet.toArray(new Artifact[hashSet.size()]);
    }

    private void addArtifactsFromOwnUsage(Set set, Set set2) {
        for (DependencyArtifactDescriptor dependencyArtifactDescriptor : set2) {
            set.add(new MDArtifact(this.md, dependencyArtifactDescriptor.getName(), dependencyArtifactDescriptor.getType(), dependencyArtifactDescriptor.getExt(), dependencyArtifactDescriptor.getUrl(), dependencyArtifactDescriptor.getQualifiedExtraAttributes()));
        }
    }

    private void addArtifactsFromMergedUsage(String string, Set set) {
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            Set set2 = ivyNodeUsage.getDependencyArtifactsSet(string);
            if (set2 == null) continue;
            for (DependencyArtifactDescriptor dependencyArtifactDescriptor : set2) {
                HashMap<String, String> hashMap = new HashMap<String, String>(dependencyArtifactDescriptor.getQualifiedExtraAttributes());
                MDArtifact mDArtifact = new MDArtifact(this.md, dependencyArtifactDescriptor.getName(), dependencyArtifactDescriptor.getType(), dependencyArtifactDescriptor.getExt(), dependencyArtifactDescriptor.getUrl(), hashMap);
                if (set.contains(mDArtifact)) continue;
                hashMap.put("ivy:merged", dependencyArtifactDescriptor.getDependencyDescriptor().getParentRevisionId() + " -> " + ivyNodeUsage.getNode().getId());
                set.add(mDArtifact);
            }
        }
    }

    private static Collection findArtifactsMatching(IncludeRule includeRule, Map map) {
        ArrayList arrayList = new ArrayList();
        for (ArtifactId artifactId : map.keySet()) {
            if (!MatcherHelper.matches(includeRule.getMatcher(), includeRule.getId(), artifactId)) continue;
            arrayList.add(map.get(artifactId));
        }
        return arrayList;
    }

    public boolean hasProblem() {
        return this.problem != null;
    }

    public Exception getProblem() {
        return this.problem;
    }

    public String getProblemMessage() {
        return StringUtils.getErrorMessage(this.problem);
    }

    public boolean isDownloaded() {
        return this.downloaded;
    }

    public boolean isSearched() {
        return this.searched;
    }

    public boolean isLoaded() {
        return this.md != null;
    }

    public boolean isFetched(String string) {
        return this.fetchedConfigurations.contains(string);
    }

    public IvyNode findNode(ModuleRevisionId moduleRevisionId) {
        return this.data.getNode(moduleRevisionId);
    }

    boolean isRoot() {
        return this.root == this;
    }

    public IvyNode getRoot() {
        return this.root;
    }

    public ConflictManager getConflictManager(ModuleId moduleId) {
        if (this.md == null) {
            throw new IllegalStateException("impossible to get conflict manager when data has not been loaded. IvyNode = " + this.toString());
        }
        ConflictManager conflictManager = this.md.getConflictManager(moduleId);
        return conflictManager == null ? this.settings.getConflictManager(moduleId) : conflictManager;
    }

    public IvyNode getRealNode() {
        IvyNode ivyNode = this.data.getNode(this.getId());
        return ivyNode != null ? ivyNode : this;
    }

    public ModuleRevisionId getId() {
        return this.id;
    }

    public ModuleId getModuleId() {
        return this.id.getModuleId();
    }

    public ModuleDescriptor getDescriptor() {
        return this.md;
    }

    public ResolveData getData() {
        return this.data;
    }

    public ResolvedModuleRevision getModuleRevision() {
        return this.module;
    }

    public long getPublication() {
        if (this.module != null) {
            return this.module.getPublicationDate().getTime();
        }
        return 0L;
    }

    public long getLastModified() {
        if (this.md != null) {
            return this.md.getLastModified();
        }
        return 0L;
    }

    public ModuleRevisionId getResolvedId() {
        if (this.md != null && this.md.getResolvedModuleRevisionId().getRevision() != null) {
            return this.md.getResolvedModuleRevisionId();
        }
        if (this.module != null) {
            return this.module.getId();
        }
        return this.getId();
    }

    public void clean() {
        this.confsToFetch.clear();
    }

    boolean canExclude(String string) {
        IvyNodeCallers.Caller[] callerArray = this.getCallers(string);
        for (int i = 0; i < callerArray.length; ++i) {
            if (!callerArray[i].canExclude()) continue;
            return true;
        }
        return false;
    }

    private IvyNode getDirectCallerFor(ModuleId moduleId) {
        return this.callers.getDirectCallerFor(moduleId);
    }

    public IvyNodeCallers.Caller[] getCallers(String string) {
        return this.callers.getCallers(string);
    }

    public Collection getAllCallersModuleIds() {
        return this.callers.getAllCallersModuleIds();
    }

    public IvyNodeCallers.Caller[] getAllCallers() {
        return this.callers.getAllCallers();
    }

    public IvyNodeCallers.Caller[] getAllRealCallers() {
        return this.callers.getAllRealCallers();
    }

    public void addCaller(String string, IvyNode ivyNode, String string2, String string3, String[] stringArray, DependencyDescriptor dependencyDescriptor) {
        this.callers.addCaller(string, ivyNode, string2, string3, stringArray, dependencyDescriptor);
        boolean bl = this.callers.getAllCallersModuleIds().contains(this.getId().getModuleId());
        if (bl) {
            IvyContext.getContext().getCircularDependencyStrategy().handleCircularDependency(this.toMrids(this.findPath(this.getId().getModuleId()), this));
        }
    }

    public boolean doesCallersExclude(String string, Artifact artifact, Stack stack) {
        return this.callers.doesCallersExclude(string, artifact, stack);
    }

    private ModuleRevisionId[] toMrids(Collection collection, IvyNode ivyNode) {
        ModuleRevisionId[] moduleRevisionIdArray = new ModuleRevisionId[collection.size() + 1];
        int n = 0;
        for (IvyNode ivyNode2 : collection) {
            moduleRevisionIdArray[n] = ivyNode2.getId();
            ++n;
        }
        moduleRevisionIdArray[moduleRevisionIdArray.length - 1] = ivyNode.getId();
        return moduleRevisionIdArray;
    }

    public Set getResolvedNodes(ModuleId moduleId, String string) {
        return this.eviction.getResolvedNodes(moduleId, string);
    }

    public Collection getResolvedRevisions(ModuleId moduleId, String string) {
        return this.eviction.getResolvedRevisions(moduleId, string);
    }

    public void markEvicted(IvyNodeEviction.EvictionData evictionData) {
        this.eviction.markEvicted(evictionData);
        String string = evictionData.getRootModuleConf();
        if (evictionData.getSelected() != null) {
            for (IvyNode ivyNode : evictionData.getSelected()) {
                ivyNode.updateDataFrom(this, string, false);
            }
        }
    }

    public Collection getAllEvictingConflictManagers() {
        return this.eviction.getAllEvictingConflictManagers();
    }

    public Collection getAllEvictingNodes() {
        return this.eviction.getAllEvictingNodes();
    }

    public Collection getAllEvictingNodesDetails() {
        return this.eviction.getAllEvictingNodesDetails();
    }

    public String[] getEvictedConfs() {
        return this.eviction.getEvictedConfs();
    }

    public IvyNodeEviction.EvictionData getEvictedData(String string) {
        return this.eviction.getEvictedData(string);
    }

    public Collection getEvictedNodes(ModuleId moduleId, String string) {
        return this.eviction.getEvictedNodes(moduleId, string);
    }

    public Collection getEvictedRevisions(ModuleId moduleId, String string) {
        return this.eviction.getEvictedRevisions(moduleId, string);
    }

    public IvyNodeEviction.EvictionData getEvictionDataInRoot(String string, IvyNode ivyNode) {
        return this.eviction.getEvictionDataInRoot(string, ivyNode);
    }

    public boolean isCompletelyEvicted() {
        return this.eviction.isCompletelyEvicted();
    }

    public boolean isEvicted(String string) {
        return this.eviction.isEvicted(string);
    }

    public void markEvicted(String string, IvyNode ivyNode, ConflictManager conflictManager, Collection collection) {
        IvyNodeEviction.EvictionData evictionData = new IvyNodeEviction.EvictionData(string, ivyNode, conflictManager, collection);
        this.markEvicted(evictionData);
    }

    public void setEvictedNodes(ModuleId moduleId, String string, Collection collection) {
        this.eviction.setEvictedNodes(moduleId, string, collection);
    }

    public void setResolvedNodes(ModuleId moduleId, String string, Collection collection) {
        this.eviction.setResolvedNodes(moduleId, string, collection);
    }

    public String toString() {
        return this.getResolvedId().toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof IvyNode)) {
            return false;
        }
        IvyNode ivyNode = (IvyNode)object;
        return ivyNode.getId().equals(this.getId());
    }

    public int compareTo(Object object) {
        IvyNode ivyNode = (IvyNode)object;
        return this.getModuleId().compareTo(ivyNode.getModuleId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public Collection getPendingConflicts(String string, ModuleId moduleId) {
        return this.eviction.getPendingConflicts(string, moduleId);
    }

    public void setPendingConflicts(ModuleId moduleId, String string, Collection collection) {
        this.eviction.setPendingConflicts(moduleId, string, collection);
    }

    public void blacklist(IvyNodeBlacklist ivyNodeBlacklist) {
        if (this.data.getSettings().logResolvedRevision()) {
            Message.info("BLACKLISTING " + ivyNodeBlacklist);
        } else {
            Message.verbose("BLACKLISTING " + ivyNodeBlacklist);
        }
        Stack<IvyNode> stack = new Stack<IvyNode>();
        stack.push(this);
        this.clearEvictionDataInAllCallers(ivyNodeBlacklist.getRootModuleConf(), stack);
        this.usage.blacklist(ivyNodeBlacklist);
        this.data.blacklist(this);
    }

    private void clearEvictionDataInAllCallers(String string, Stack stack) {
        IvyNode ivyNode = (IvyNode)stack.peek();
        IvyNodeCallers.Caller[] callerArray = ivyNode.getCallers(string);
        for (int i = 0; i < callerArray.length; ++i) {
            IvyNode ivyNode2 = this.findNode(callerArray[i].getModuleRevisionId());
            if (ivyNode2 == null) continue;
            ivyNode2.eviction = new IvyNodeEviction(ivyNode2);
            if (stack.contains(ivyNode2)) continue;
            stack.push(ivyNode2);
            this.clearEvictionDataInAllCallers(string, stack);
            stack.pop();
        }
    }

    public boolean isBlacklisted(String string) {
        return this.usage.isBlacklisted(string);
    }

    public boolean isCompletelyBlacklisted() {
        if (this.isRoot()) {
            return false;
        }
        String[] stringArray = this.getRootModuleConfigurations();
        for (int i = 0; i < stringArray.length; ++i) {
            if (this.isBlacklisted(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    public IvyNodeBlacklist getBlacklistData(String string) {
        return this.usage.getBlacklistData(string);
    }

    public IvyNodeUsage getMainUsage() {
        return this.usage;
    }

    public boolean hasAnyMergedUsageWithTransitiveDependency(String string) {
        if (this.mergedUsages == null) {
            return false;
        }
        for (IvyNodeUsage ivyNodeUsage : this.mergedUsages.values()) {
            if (!ivyNodeUsage.hasTransitiveDepender(string)) continue;
            return true;
        }
        return false;
    }
}

