/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.report;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.cache.ResolutionCacheManager;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ConfigurationResolveReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.report.ReportOutputter;
import org.apache.ivy.util.filter.Filter;

public class ResolveReport {
    private ModuleDescriptor md;
    private Map confReports = new LinkedHashMap();
    private List problemMessages = new ArrayList();
    private List dependencies = new ArrayList();
    private List artifacts = new ArrayList();
    private long resolveTime;
    private long downloadTime;
    private String resolveId;
    private long downloadSize;

    public ResolveReport(ModuleDescriptor moduleDescriptor) {
        this(moduleDescriptor, ResolveOptions.getDefaultResolveId(moduleDescriptor));
    }

    public ResolveReport(ModuleDescriptor moduleDescriptor, String string) {
        this.md = moduleDescriptor;
        this.resolveId = string;
    }

    public void addReport(String string, ConfigurationResolveReport configurationResolveReport) {
        this.confReports.put(string, configurationResolveReport);
    }

    public ConfigurationResolveReport getConfigurationReport(String string) {
        return (ConfigurationResolveReport)this.confReports.get(string);
    }

    public String[] getConfigurations() {
        return this.confReports.keySet().toArray(new String[this.confReports.size()]);
    }

    public boolean hasError() {
        boolean bl;
        ConfigurationResolveReport configurationResolveReport;
        Iterator iterator = this.confReports.values().iterator();
        for (bl = false; iterator.hasNext() && !bl; bl |= configurationResolveReport.hasError()) {
            configurationResolveReport = (ConfigurationResolveReport)iterator.next();
        }
        return bl;
    }

    public void output(ReportOutputter[] reportOutputterArray, ResolutionCacheManager resolutionCacheManager, ResolveOptions resolveOptions) throws IOException {
        for (int i = 0; i < reportOutputterArray.length; ++i) {
            reportOutputterArray[i].output(this, resolutionCacheManager, resolveOptions);
        }
    }

    public ModuleDescriptor getModuleDescriptor() {
        return this.md;
    }

    public IvyNode[] getEvictedNodes() {
        LinkedHashSet<IvyNode> linkedHashSet = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport configurationResolveReport : this.confReports.values()) {
            linkedHashSet.addAll(Arrays.asList(configurationResolveReport.getEvictedNodes()));
        }
        return linkedHashSet.toArray(new IvyNode[linkedHashSet.size()]);
    }

    public IvyNode[] getUnresolvedDependencies() {
        LinkedHashSet<IvyNode> linkedHashSet = new LinkedHashSet<IvyNode>();
        for (ConfigurationResolveReport configurationResolveReport : this.confReports.values()) {
            linkedHashSet.addAll(Arrays.asList(configurationResolveReport.getUnresolvedDependencies()));
        }
        return linkedHashSet.toArray(new IvyNode[linkedHashSet.size()]);
    }

    public ArtifactDownloadReport[] getFailedArtifactsReports() {
        return ConfigurationResolveReport.filterOutMergedArtifacts(this.getArtifactsReports(DownloadStatus.FAILED, true));
    }

    public ArtifactDownloadReport[] getAllArtifactsReports() {
        return this.getArtifactsReports(null, true);
    }

    public ArtifactDownloadReport[] getArtifactsReports(DownloadStatus downloadStatus, boolean bl) {
        LinkedHashSet<ArtifactDownloadReport> linkedHashSet = new LinkedHashSet<ArtifactDownloadReport>();
        for (ConfigurationResolveReport configurationResolveReport : this.confReports.values()) {
            ArtifactDownloadReport[] artifactDownloadReportArray = configurationResolveReport.getArtifactsReports(downloadStatus, bl);
            linkedHashSet.addAll(Arrays.asList(artifactDownloadReportArray));
        }
        return linkedHashSet.toArray(new ArtifactDownloadReport[linkedHashSet.size()]);
    }

    public ArtifactDownloadReport[] getArtifactsReports(ModuleRevisionId moduleRevisionId) {
        LinkedHashSet<ArtifactDownloadReport> linkedHashSet = new LinkedHashSet<ArtifactDownloadReport>();
        for (ConfigurationResolveReport configurationResolveReport : this.confReports.values()) {
            linkedHashSet.addAll(Arrays.asList(configurationResolveReport.getDownloadReports(moduleRevisionId)));
        }
        return linkedHashSet.toArray(new ArtifactDownloadReport[linkedHashSet.size()]);
    }

    public void checkIfChanged() {
        for (ConfigurationResolveReport configurationResolveReport : this.confReports.values()) {
            configurationResolveReport.checkIfChanged();
        }
    }

    public boolean hasChanged() {
        for (ConfigurationResolveReport configurationResolveReport : this.confReports.values()) {
            if (!configurationResolveReport.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void setProblemMessages(List list) {
        this.problemMessages = list;
    }

    public List getProblemMessages() {
        return this.problemMessages;
    }

    public List getAllProblemMessages() {
        ArrayList<String> arrayList = new ArrayList<String>(this.problemMessages);
        for (ConfigurationResolveReport configurationResolveReport : this.confReports.values()) {
            IvyNode[] ivyNodeArray = configurationResolveReport.getUnresolvedDependencies();
            for (int i = 0; i < ivyNodeArray.length; ++i) {
                String string = ivyNodeArray[i].getProblemMessage();
                if (string.length() > 0) {
                    arrayList.add("unresolved dependency: " + ivyNodeArray[i].getId() + ": " + string);
                    continue;
                }
                arrayList.add("unresolved dependency: " + ivyNodeArray[i].getId());
            }
            ArtifactDownloadReport[] artifactDownloadReportArray = configurationResolveReport.getFailedArtifactsReports();
            for (int i = 0; i < artifactDownloadReportArray.length; ++i) {
                arrayList.add("download failed: " + artifactDownloadReportArray[i].getArtifact());
            }
        }
        return arrayList;
    }

    public void setDependencies(List list, Filter filter) {
        this.dependencies = list;
        this.artifacts = new ArrayList();
        for (IvyNode ivyNode : list) {
            if (!ivyNode.isCompletelyEvicted() && !ivyNode.hasProblem()) {
                this.artifacts.addAll(Arrays.asList(ivyNode.getSelectedArtifacts(filter)));
            }
            String[] stringArray = ivyNode.getRootModuleConfigurations();
            for (int i = 0; i < stringArray.length; ++i) {
                ConfigurationResolveReport configurationResolveReport = this.getConfigurationReport(stringArray[i]);
                if (configurationResolveReport == null) continue;
                configurationResolveReport.addDependency(ivyNode);
            }
        }
    }

    public List getDependencies() {
        return this.dependencies;
    }

    public List getArtifacts() {
        return this.artifacts;
    }

    public List getModuleIds() {
        ArrayList<ModuleId> arrayList = new ArrayList<ModuleId>();
        ArrayList arrayList2 = new ArrayList(this.dependencies);
        for (IvyNode ivyNode : arrayList2) {
            ModuleId moduleId = ivyNode.getResolvedId().getModuleId();
            if (arrayList.contains(moduleId)) continue;
            arrayList.add(moduleId);
        }
        return arrayList;
    }

    public void setResolveTime(long l) {
        this.resolveTime = l;
    }

    public long getResolveTime() {
        return this.resolveTime;
    }

    public void setDownloadTime(long l) {
        this.downloadTime = l;
    }

    public long getDownloadTime() {
        return this.downloadTime;
    }

    public void setDownloadSize(long l) {
        this.downloadSize = l;
    }

    public long getDownloadSize() {
        return this.downloadSize;
    }

    public String getResolveId() {
        return this.resolveId;
    }

    private String[] getExtendingConfs(String string) {
        String[] stringArray = this.md.getConfigurationsNames();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string);
        for (int i = 0; i < stringArray.length; ++i) {
            this.gatherExtendingConfs(hashSet, stringArray[i], string);
        }
        return hashSet.toArray(new String[hashSet.size()]);
    }

    private boolean gatherExtendingConfs(Set<String> set, String string, String string2) {
        if (set.contains(string)) {
            return true;
        }
        String[] stringArray = this.md.getConfiguration(string).getExtends();
        if (stringArray == null || stringArray.length == 0) {
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (set.contains(stringArray[i])) {
                set.add(string);
                return true;
            }
            if (stringArray[i].equals(string2)) {
                set.add(string);
                return true;
            }
            if (!this.gatherExtendingConfs(set, stringArray[i], string2)) continue;
            set.add(string);
            return true;
        }
        return false;
    }

    public ModuleDescriptor toFixedModuleDescriptor(IvySettings ivySettings, List<ModuleId> list) {
        Object object;
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(this.md.getModuleRevisionId(), this.md.getStatus(), new Date());
        List<String> list2 = Arrays.asList(this.getConfigurations());
        for (String string : list2) {
            defaultModuleDescriptor.addConfiguration(new Configuration(string));
        }
        if (list != null && !list.isEmpty()) {
            DependencyDescriptor[] dependencyDescriptorArray = this.md.getDependencies();
            for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
                if (!list.contains(dependencyDescriptorArray[i].getDependencyId())) continue;
                object = new DefaultDependencyDescriptor(defaultModuleDescriptor, dependencyDescriptorArray[i].getDependencyRevisionId(), true, false, false);
                List<String> list3 = Arrays.asList(dependencyDescriptorArray[i].getModuleConfigurations());
                if (list3.size() == 1 && list3.get(0).equals("*")) {
                    list3 = list2;
                }
                for (String object2 : list3) {
                    String[] stringArray = this.getExtendingConfs(object2);
                    String[] stringArray2 = dependencyDescriptorArray[i].getDependencyConfigurations(object2);
                    for (String string : stringArray) {
                        if (!list2.contains(string)) continue;
                        for (String string2 : stringArray2) {
                            ((DefaultDependencyDescriptor)object).addDependencyConfiguration(string, string2);
                        }
                    }
                }
                defaultModuleDescriptor.addDependency((DependencyDescriptor)object);
            }
        }
        block5: for (int i = 0; i < this.dependencies.size(); ++i) {
            IvyNode ivyNode = (IvyNode)this.dependencies.get(i);
            if (list != null && list.contains(ivyNode.getModuleId())) continue;
            object = ivyNode.getRootModuleConfigurations();
            for (int j = 0; j < ((String[])object).length; ++j) {
                if (ivyNode.isEvicted(object[j])) continue;
                if (ivyNode.getAllArtifacts().length == 0) continue block5;
                DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(defaultModuleDescriptor, ivyNode.getResolvedId(), true, false, false);
                String[] stringArray = ivyNode.getConfigurations(object[j]);
                for (int k = 0; k < stringArray.length; ++k) {
                    defaultDependencyDescriptor.addDependencyConfiguration(object[j], stringArray[k]);
                }
                defaultModuleDescriptor.addDependency(defaultDependencyDescriptor);
            }
        }
        return defaultModuleDescriptor;
    }
}

