/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.pack;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.ivy.core.pack.ArchivePacking;
import org.apache.ivy.util.FileUtil;
import org.apache.ivy.util.Message;

public class ZipPacking
extends ArchivePacking {
    private static final String[] NAMES = new String[]{"zip", "jar", "war"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getUnpackedExtension(String string) {
        if ((string.endsWith("zip") || string.endsWith("jar") || string.endsWith("war")) && (string = string.substring(0, string.length() - 3)).endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unpack(InputStream inputStream, File file) throws IOException {
        ZipInputStream zipInputStream = null;
        try {
            zipInputStream = new ZipInputStream(inputStream);
            ZipEntry zipEntry = null;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                File file2 = new File(file, zipEntry.getName());
                Message.verbose("\t\texpanding " + zipEntry.getName() + " to " + file2);
                File file3 = file2.getParentFile();
                if (file3 != null) {
                    file3.mkdirs();
                }
                if (zipEntry.isDirectory()) {
                    file2.mkdirs();
                } else {
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    try {
                        FileUtil.copy(zipInputStream, fileOutputStream, null, false);
                    }
                    finally {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                file2.setLastModified(zipEntry.getTime());
            }
        }
        finally {
            if (zipInputStream != null) {
                try {
                    zipInputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

