/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.pack;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.pack.ArchivePacking;
import org.apache.ivy.core.pack.StreamPacking;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.IvySettingsAware;

public class PackagingManager
implements IvySettingsAware {
    private IvySettings settings;

    @Override
    public void setSettings(IvySettings ivySettings) {
        this.settings = ivySettings;
    }

    public Artifact getUnpackedArtifact(Artifact artifact) {
        Object object;
        String string = artifact.getExtraAttribute("packaging");
        if (string == null) {
            return null;
        }
        String string2 = artifact.getExt();
        String[] stringArray = string.split(",");
        for (int i = stringArray.length - 1; i >= 1; --i) {
            object = this.settings.getPackingRegistry().get(stringArray[i]);
            if (object == null) {
                throw new IllegalStateException("Unknown packing type '" + stringArray[i] + "' in the packing chain: " + string);
            }
            if (!(object instanceof StreamPacking)) {
                throw new IllegalStateException("Unsupported archive only packing type '" + stringArray[i] + "' in the streamed chain: " + string);
            }
            string2 = ((StreamPacking)object).getUnpackedExtension(string2);
        }
        ArchivePacking archivePacking = this.settings.getPackingRegistry().get(stringArray[0]);
        if (archivePacking == null) {
            throw new IllegalStateException("Unknown packing type '" + stringArray[0] + "' in the packing chain: " + string);
        }
        string2 = archivePacking.getUnpackedExtension(string2);
        object = new DefaultArtifact(artifact.getModuleRevisionId(), artifact.getPublicationDate(), artifact.getName(), artifact.getType() + "_unpacked", string2);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unpackArtifact(Artifact artifact, File file, File file2) throws IOException {
        String string = artifact.getExtraAttribute("packaging");
        if (string == null) {
            return;
        }
        String[] stringArray = string.split(",");
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            for (int i = stringArray.length - 1; i >= 1; --i) {
                ArchivePacking archivePacking = this.settings.getPackingRegistry().get(stringArray[i]);
                if (archivePacking == null) {
                    throw new IllegalStateException("Unknown packing type '" + stringArray[i] + "' in the packing chain: " + string);
                }
                if (!(archivePacking instanceof StreamPacking)) {
                    throw new IllegalStateException("Unsupported archive only packing type '" + stringArray[i] + "' in the streamed chain: " + string);
                }
                inputStream = ((StreamPacking)archivePacking).unpack(inputStream);
            }
            ArchivePacking archivePacking = this.settings.getPackingRegistry().get(stringArray[0]);
            if (archivePacking == null) {
                throw new IllegalStateException("Unknown packing type '" + stringArray[0] + "' in the packing chain: " + string);
            }
            archivePacking.unpack(inputStream, file2);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

