/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.pack;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import org.apache.ivy.core.pack.StreamPacking;

public class Pack200Packing
extends StreamPacking {
    private static final String[] NAMES = new String[]{"pack200"};

    @Override
    public String[] getNames() {
        return NAMES;
    }

    @Override
    public String getUnpackedExtension(String string) {
        if (string.endsWith("pack.gz")) {
            if ((string = string.substring(0, string.length() - 7)).endsWith(".")) {
                string = string.substring(0, string.length() - 1);
            }
        } else if (string.endsWith("pack") && (string = string.substring(0, string.length() - 4)).endsWith(".")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    @Override
    public InputStream unpack(InputStream inputStream) throws IOException {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        bufferedInputStream.mark(4);
        byte[] byArray = new byte[4];
        bufferedInputStream.read(byArray, 0, 4);
        bufferedInputStream.reset();
        FilterInputStream filterInputStream = bufferedInputStream;
        if (byArray[0] == 31 && byArray[1] == -117 && byArray[2] == 8) {
            filterInputStream = new GZIPInputStream(filterInputStream);
        }
        Pack200.Unpacker unpacker = Pack200.newUnpacker();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JarOutputStream jarOutputStream = new JarOutputStream(byteArrayOutputStream);
        unpacker.unpack((InputStream)filterInputStream, jarOutputStream);
        jarOutputStream.close();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }
}

