/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.module.descriptor;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.ConfigurationGroup;
import org.apache.ivy.core.module.descriptor.ConfigurationIntersection;
import org.apache.ivy.core.module.descriptor.DefaultArtifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptorMediator;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ExtendsDescriptor;
import org.apache.ivy.core.module.descriptor.ExtraInfoHolder;
import org.apache.ivy.core.module.descriptor.License;
import org.apache.ivy.core.module.descriptor.MDArtifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.module.id.ModuleRules;
import org.apache.ivy.core.module.status.StatusManager;
import org.apache.ivy.plugins.conflict.ConflictManager;
import org.apache.ivy.plugins.matcher.MapMatcher;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.namespace.NameSpaceHelper;
import org.apache.ivy.plugins.namespace.Namespace;
import org.apache.ivy.plugins.namespace.NamespaceTransformer;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorParser;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.version.VersionMatcher;
import org.apache.ivy.util.Message;

public class DefaultModuleDescriptor
implements ModuleDescriptor {
    private ModuleRevisionId revId;
    private ModuleRevisionId resolvedRevId;
    private String status = StatusManager.getCurrent().getDefaultStatus();
    private Date publicationDate;
    private Date resolvedPublicationDate;
    private List dependencies = new ArrayList();
    private Map configurations = new LinkedHashMap();
    private Map artifactsByConf = new HashMap();
    private Collection artifacts = new LinkedHashSet();
    private boolean isDefault = false;
    private ModuleRules conflictManagers = new ModuleRules();
    private ModuleRules dependencyDescriptorMediators = new ModuleRules();
    private List licenses = new ArrayList();
    private String homePage;
    private String description = "";
    private long lastModified = 0L;
    private Namespace namespace;
    private String defaultConf;
    private String defaultConfMapping;
    private boolean mappingOverride;
    private ModuleDescriptorParser parser;
    private Resource resource;
    private List excludeRules = new ArrayList();
    private Artifact metadataArtifact;
    private List inheritedDescriptors = new ArrayList();
    private Map extraAttributesNamespaces = new LinkedHashMap();
    private Map extraInfo = new HashMap();
    private List<ExtraInfoHolder> extraInfos = new ArrayList<ExtraInfoHolder>();

    public static DefaultModuleDescriptor newDefaultInstance(ModuleRevisionId moduleRevisionId) {
        return DefaultModuleDescriptor.newDefaultInstance(moduleRevisionId, null);
    }

    public static DefaultModuleDescriptor newCallerInstance(ModuleRevisionId moduleRevisionId, String[] stringArray, boolean bl, boolean bl2) {
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(ModuleRevisionId.newInstance(moduleRevisionId.getOrganisation(), moduleRevisionId.getName() + "-caller", "working"), "integration", null, true);
        for (int i = 0; i < stringArray.length; ++i) {
            defaultModuleDescriptor.addConfiguration(new Configuration(stringArray[i]));
        }
        defaultModuleDescriptor.setLastModified(System.currentTimeMillis());
        DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(defaultModuleDescriptor, moduleRevisionId, true, bl2, bl);
        for (int i = 0; i < stringArray.length; ++i) {
            defaultDependencyDescriptor.addDependencyConfiguration(stringArray[i], stringArray[i]);
        }
        defaultModuleDescriptor.addDependency(defaultDependencyDescriptor);
        return defaultModuleDescriptor;
    }

    public static DefaultModuleDescriptor newCallerInstance(ModuleRevisionId[] moduleRevisionIdArray, boolean bl, boolean bl2) {
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(ModuleRevisionId.newInstance("caller", "all-caller", "working"), "integration", null, true);
        defaultModuleDescriptor.addConfiguration(new Configuration("default"));
        defaultModuleDescriptor.setLastModified(System.currentTimeMillis());
        for (int i = 0; i < moduleRevisionIdArray.length; ++i) {
            DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(defaultModuleDescriptor, moduleRevisionIdArray[i], true, bl2, bl);
            defaultDependencyDescriptor.addDependencyConfiguration("default", "*");
            defaultModuleDescriptor.addDependency(defaultDependencyDescriptor);
        }
        return defaultModuleDescriptor;
    }

    public static DefaultModuleDescriptor newDefaultInstance(ModuleRevisionId moduleRevisionId, DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray) {
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleRevisionId, "release", null, true);
        defaultModuleDescriptor.addConfiguration(new Configuration("default"));
        if (dependencyArtifactDescriptorArray != null && dependencyArtifactDescriptorArray.length > 0) {
            for (int i = 0; i < dependencyArtifactDescriptorArray.length; ++i) {
                defaultModuleDescriptor.addArtifact("default", new MDArtifact(defaultModuleDescriptor, dependencyArtifactDescriptorArray[i].getName(), dependencyArtifactDescriptorArray[i].getType(), dependencyArtifactDescriptorArray[i].getExt(), dependencyArtifactDescriptorArray[i].getUrl(), dependencyArtifactDescriptorArray[i].getExtraAttributes()));
            }
        } else {
            defaultModuleDescriptor.addArtifact("default", new MDArtifact(defaultModuleDescriptor, moduleRevisionId.getName(), "jar", "jar"));
        }
        defaultModuleDescriptor.setLastModified(System.currentTimeMillis());
        return defaultModuleDescriptor;
    }

    public static DefaultModuleDescriptor newBasicInstance(ModuleRevisionId moduleRevisionId, Date date) {
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleRevisionId, "release", date, false);
        defaultModuleDescriptor.addConfiguration(new Configuration("default"));
        defaultModuleDescriptor.addArtifact("default", new MDArtifact(defaultModuleDescriptor, moduleRevisionId.getName(), "jar", "jar"));
        return defaultModuleDescriptor;
    }

    public static ModuleDescriptor transformInstance(ModuleDescriptor moduleDescriptor, Namespace namespace) {
        NamespaceTransformer namespaceTransformer = namespace.getToSystemTransformer();
        if (namespaceTransformer.isIdentity()) {
            return moduleDescriptor;
        }
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleDescriptor.getParser(), moduleDescriptor.getResource());
        defaultModuleDescriptor.revId = namespaceTransformer.transform(moduleDescriptor.getModuleRevisionId());
        defaultModuleDescriptor.resolvedRevId = namespaceTransformer.transform(moduleDescriptor.getResolvedModuleRevisionId());
        defaultModuleDescriptor.status = moduleDescriptor.getStatus();
        defaultModuleDescriptor.publicationDate = moduleDescriptor.getPublicationDate();
        defaultModuleDescriptor.resolvedPublicationDate = moduleDescriptor.getResolvedPublicationDate();
        ExtendsDescriptor[] extendsDescriptorArray = moduleDescriptor.getInheritedDescriptors();
        for (int i = 0; i < extendsDescriptorArray.length; ++i) {
            ModuleDescriptor moduleDescriptor2 = extendsDescriptorArray[i].getParentMd();
            DefaultModuleDescriptor defaultModuleDescriptor2 = new DefaultModuleDescriptor(moduleDescriptor2.getParser(), moduleDescriptor2.getResource());
            defaultModuleDescriptor2.revId = namespaceTransformer.transform(moduleDescriptor2.getModuleRevisionId());
            defaultModuleDescriptor2.resolvedRevId = namespaceTransformer.transform(moduleDescriptor2.getResolvedModuleRevisionId());
            defaultModuleDescriptor2.status = moduleDescriptor2.getStatus();
            defaultModuleDescriptor2.publicationDate = moduleDescriptor2.getPublicationDate();
            defaultModuleDescriptor2.resolvedPublicationDate = moduleDescriptor2.getResolvedPublicationDate();
            defaultModuleDescriptor.inheritedDescriptors.add(new DefaultExtendsDescriptor(defaultModuleDescriptor2, extendsDescriptorArray[i].getLocation(), extendsDescriptorArray[i].getExtendsTypes()));
        }
        DependencyDescriptor[] dependencyDescriptorArray = moduleDescriptor.getDependencies();
        for (int i = 0; i < dependencyDescriptorArray.length; ++i) {
            defaultModuleDescriptor.dependencies.add(NameSpaceHelper.toSystem(dependencyDescriptorArray[i], namespace));
        }
        Configuration[] configurationArray = moduleDescriptor.getConfigurations();
        for (int i = 0; i < configurationArray.length; ++i) {
            defaultModuleDescriptor.configurations.put(configurationArray[i].getName(), configurationArray[i]);
            Artifact[] artifactArray = moduleDescriptor.getArtifacts(configurationArray[i].getName());
            for (int j = 0; j < artifactArray.length; ++j) {
                defaultModuleDescriptor.addArtifact(configurationArray[i].getName(), NameSpaceHelper.transform(artifactArray[j], namespaceTransformer));
            }
        }
        defaultModuleDescriptor.setDefault(moduleDescriptor.isDefault());
        if (moduleDescriptor instanceof DefaultModuleDescriptor) {
            DefaultModuleDescriptor defaultModuleDescriptor3 = (DefaultModuleDescriptor)moduleDescriptor;
            defaultModuleDescriptor.conflictManagers = (ModuleRules)defaultModuleDescriptor3.conflictManagers.clone();
            defaultModuleDescriptor.dependencyDescriptorMediators = (ModuleRules)defaultModuleDescriptor3.dependencyDescriptorMediators.clone();
        } else {
            Message.warn("transformed module descriptor is not a default module descriptor: impossible to copy conflict manager and version mediation configuration: " + moduleDescriptor);
        }
        defaultModuleDescriptor.licenses.addAll(Arrays.asList(moduleDescriptor.getLicenses()));
        defaultModuleDescriptor.homePage = moduleDescriptor.getHomePage();
        defaultModuleDescriptor.description = moduleDescriptor.getDescription();
        defaultModuleDescriptor.lastModified = moduleDescriptor.getLastModified();
        defaultModuleDescriptor.extraAttributesNamespaces = moduleDescriptor.getExtraAttributesNamespaces();
        defaultModuleDescriptor.extraInfo = moduleDescriptor.getExtraInfo();
        defaultModuleDescriptor.extraInfos = moduleDescriptor.getExtraInfos();
        defaultModuleDescriptor.namespace = namespace;
        return defaultModuleDescriptor;
    }

    public DefaultModuleDescriptor(ModuleRevisionId moduleRevisionId, String string, Date date) {
        this(moduleRevisionId, string, date, false);
    }

    public DefaultModuleDescriptor(ModuleRevisionId moduleRevisionId, String string, Date date, boolean bl) {
        if (moduleRevisionId == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        if (string == null) {
            throw new NullPointerException("null status not allowed");
        }
        this.revId = moduleRevisionId;
        this.resolvedRevId = moduleRevisionId;
        this.status = string;
        this.publicationDate = date;
        this.resolvedPublicationDate = this.publicationDate == null ? new Date() : this.publicationDate;
        this.isDefault = bl;
        this.parser = XmlModuleDescriptorParser.getInstance();
    }

    public DefaultModuleDescriptor(ModuleDescriptorParser moduleDescriptorParser, Resource resource) {
        this.parser = moduleDescriptorParser;
        this.resource = resource;
    }

    @Override
    public Artifact getMetadataArtifact() {
        if (this.metadataArtifact == null) {
            this.metadataArtifact = DefaultArtifact.newIvyArtifact(this.resolvedRevId, this.resolvedPublicationDate);
        }
        return this.metadataArtifact;
    }

    public void setModuleArtifact(Artifact artifact) {
        this.metadataArtifact = artifact;
    }

    @Override
    public boolean isDefault() {
        return this.isDefault;
    }

    public void setPublicationDate(Date date) {
        this.publicationDate = date;
        if (this.resolvedPublicationDate == null) {
            this.resolvedPublicationDate = date == null ? new Date() : date;
        }
    }

    @Override
    public Date getPublicationDate() {
        return this.publicationDate;
    }

    @Override
    public void setResolvedPublicationDate(Date date) {
        if (date == null) {
            throw new NullPointerException("null publication date not allowed");
        }
        this.resolvedPublicationDate = date;
    }

    @Override
    public Date getResolvedPublicationDate() {
        return this.resolvedPublicationDate;
    }

    @Override
    public String getRevision() {
        return this.getResolvedModuleRevisionId().getRevision();
    }

    public void setModuleRevisionId(ModuleRevisionId moduleRevisionId) {
        if (moduleRevisionId == null) {
            throw new NullPointerException("null module revision id not allowed");
        }
        this.revId = moduleRevisionId;
        if (this.resolvedRevId == null) {
            this.resolvedRevId = moduleRevisionId;
        }
    }

    @Override
    public void setResolvedModuleRevisionId(ModuleRevisionId moduleRevisionId) {
        this.resolvedRevId = moduleRevisionId;
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public void addInheritedDescriptor(ExtendsDescriptor extendsDescriptor) {
        this.inheritedDescriptors.add(extendsDescriptor);
    }

    public void addDependency(DependencyDescriptor dependencyDescriptor) {
        this.dependencies.add(dependencyDescriptor);
    }

    public void addConfiguration(Configuration configuration) {
        this.configurations.put(configuration.getName(), configuration);
    }

    public void addArtifact(String string, Artifact artifact) {
        Configuration configuration = this.getConfiguration(string);
        if (configuration == null) {
            throw new IllegalArgumentException("Cannot add artifact '" + artifact.getId().getArtifactId().getShortDescription() + "' to configuration '" + string + "' of module " + this.revId + " because this configuration doesn't exist!");
        }
        if (configuration instanceof ConfigurationGroup) {
            ConfigurationGroup configurationGroup = (ConfigurationGroup)configuration;
            String[] stringArray = configurationGroup.getMembersConfigurationNames();
            for (int i = 0; i < stringArray.length; ++i) {
                this.addArtifact(stringArray[i], artifact);
            }
        } else {
            ArrayList<Artifact> arrayList = (ArrayList<Artifact>)this.artifactsByConf.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<Artifact>();
                this.artifactsByConf.put(string, arrayList);
            }
            arrayList.add(artifact);
            this.artifacts.add(artifact);
        }
    }

    @Override
    public ModuleRevisionId getModuleRevisionId() {
        return this.revId;
    }

    @Override
    public ModuleRevisionId getResolvedModuleRevisionId() {
        return this.resolvedRevId;
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public ExtendsDescriptor[] getInheritedDescriptors() {
        return this.inheritedDescriptors.toArray(new ExtendsDescriptor[this.inheritedDescriptors.size()]);
    }

    @Override
    public Configuration[] getConfigurations() {
        return this.configurations.values().toArray(new Configuration[this.configurations.size()]);
    }

    @Override
    public String[] getConfigurationsNames() {
        return this.configurations.keySet().toArray(new String[this.configurations.size()]);
    }

    @Override
    public String[] getPublicConfigurationsNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Configuration configuration : this.configurations.values()) {
            if (configuration.getVisibility() != Configuration.Visibility.PUBLIC) continue;
            arrayList.add(configuration.getName());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public Configuration getConfiguration(String string) {
        Configuration configuration = (Configuration)this.configurations.get(string);
        if (configuration == null && string != null) {
            Matcher matcher = Pattern.compile("\\*\\[([^=]+)\\=([^\\]]+)\\]").matcher(string);
            if (matcher.matches()) {
                String string2 = matcher.group(1);
                String string3 = matcher.group(2);
                LinkedHashMap<String, Configuration> linkedHashMap = new LinkedHashMap<String, Configuration>();
                for (Configuration configuration2 : this.configurations.values()) {
                    if (!string3.equals(configuration2.getAttribute(string2))) continue;
                    linkedHashMap.put(configuration2.getName(), configuration2);
                }
                return new ConfigurationGroup(string, linkedHashMap);
            }
            String[] stringArray = string.split("\\+");
            if (stringArray.length <= 1) {
                return null;
            }
            LinkedHashMap<String, Configuration> linkedHashMap = new LinkedHashMap<String, Configuration>();
            for (int i = 0; i < stringArray.length; ++i) {
                Configuration configuration3 = (Configuration)this.configurations.get(stringArray[i]);
                if (configuration3 == null) {
                    Message.verbose("missing configuration '" + stringArray[i] + "' from intersection " + string + " in " + this);
                    return null;
                }
                linkedHashMap.put(stringArray[i], configuration3);
            }
            return new ConfigurationIntersection(string, linkedHashMap);
        }
        return configuration;
    }

    @Override
    public Artifact[] getArtifacts(String string) {
        Configuration configuration = this.getConfiguration(string);
        if (configuration == null) {
            return new Artifact[0];
        }
        Collection collection = (Collection)this.artifactsByConf.get(string);
        if (configuration instanceof ConfigurationIntersection) {
            ConfigurationIntersection configurationIntersection = (ConfigurationIntersection)configuration;
            String[] stringArray = configurationIntersection.getIntersectedConfigurationNames();
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (int i = 0; i < stringArray.length; ++i) {
                Collection collection2 = this.getArtifactsIncludingExtending(stringArray[i]);
                if (linkedHashSet.isEmpty()) {
                    linkedHashSet.addAll(collection2);
                    continue;
                }
                linkedHashSet.retainAll(collection2);
            }
            if (collection != null) {
                linkedHashSet.addAll(collection);
            }
            return linkedHashSet.toArray(new Artifact[linkedHashSet.size()]);
        }
        if (configuration instanceof ConfigurationGroup) {
            ConfigurationGroup configurationGroup = (ConfigurationGroup)configuration;
            String[] stringArray = configurationGroup.getMembersConfigurationNames();
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            for (int i = 0; i < stringArray.length; ++i) {
                linkedHashSet.addAll(this.getArtifactsIncludingExtending(stringArray[i]));
            }
            if (collection != null) {
                linkedHashSet.addAll(collection);
            }
            return linkedHashSet.toArray(new Artifact[linkedHashSet.size()]);
        }
        if (collection == null) {
            return new Artifact[0];
        }
        return collection.toArray(new Artifact[collection.size()]);
    }

    private Collection getArtifactsIncludingExtending(String string) {
        Collection collection = Configuration.findConfigurationExtending(string, this.getConfigurations());
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        Collection collection2 = (Collection)this.artifactsByConf.get(string);
        if (collection2 != null) {
            linkedHashSet.addAll(collection2);
        }
        for (Configuration configuration : collection) {
            collection2 = (Collection)this.artifactsByConf.get(configuration.getName());
            if (collection2 == null) continue;
            linkedHashSet.addAll(collection2);
        }
        return linkedHashSet;
    }

    @Override
    public Artifact[] getAllArtifacts() {
        return this.artifacts.toArray(new Artifact[this.artifacts.size()]);
    }

    @Override
    public DependencyDescriptor[] getDependencies() {
        return this.dependencies.toArray(new DependencyDescriptor[this.dependencies.size()]);
    }

    @Override
    public boolean dependsOn(VersionMatcher versionMatcher, ModuleDescriptor moduleDescriptor) {
        for (DependencyDescriptor dependencyDescriptor : this.dependencies) {
            if (!dependencyDescriptor.getDependencyId().equals(moduleDescriptor.getModuleRevisionId().getModuleId())) continue;
            if (moduleDescriptor.getResolvedModuleRevisionId().getRevision() == null) {
                return true;
            }
            if (!versionMatcher.accept(dependencyDescriptor.getDependencyRevisionId(), moduleDescriptor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void toIvyFile(File file) throws ParseException, IOException {
        if (this.parser != null && this.resource != null) {
            this.parser.toIvyFile(this.resource.openStream(), this.resource, file, this);
        } else {
            XmlModuleDescriptorWriter.write(this, file);
        }
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.revId == null ? 0 : this.revId.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        DefaultModuleDescriptor defaultModuleDescriptor = (DefaultModuleDescriptor)object;
        return !(this.revId == null ? defaultModuleDescriptor.revId != null : !this.revId.equals(defaultModuleDescriptor.revId));
    }

    public String toString() {
        return "module: " + this.revId + " status=" + this.status + " publication=" + this.publicationDate + " configurations=" + this.configurations + " artifacts=" + this.artifactsByConf + " dependencies=" + this.dependencies;
    }

    public void setDefault(boolean bl) {
        this.isDefault = bl;
    }

    public void addConflictManager(ModuleId moduleId, PatternMatcher patternMatcher, ConflictManager conflictManager) {
        this.conflictManagers.defineRule(new MapMatcher(moduleId.getAttributes(), patternMatcher), conflictManager);
    }

    @Override
    public ConflictManager getConflictManager(ModuleId moduleId) {
        return (ConflictManager)this.conflictManagers.getRule(moduleId);
    }

    public void addDependencyDescriptorMediator(ModuleId moduleId, PatternMatcher patternMatcher, DependencyDescriptorMediator dependencyDescriptorMediator) {
        this.dependencyDescriptorMediators.defineRule(new MapMatcher(moduleId.getAttributes(), patternMatcher), dependencyDescriptorMediator);
    }

    @Override
    public DependencyDescriptor mediate(DependencyDescriptor dependencyDescriptor) {
        Object[] objectArray = this.dependencyDescriptorMediators.getRules(dependencyDescriptor.getDependencyId());
        for (int i = 0; i < objectArray.length; ++i) {
            dependencyDescriptor = ((DependencyDescriptorMediator)objectArray[i]).mediate(dependencyDescriptor);
        }
        return dependencyDescriptor;
    }

    @Override
    public ModuleRules getAllDependencyDescriptorMediators() {
        return (ModuleRules)this.dependencyDescriptorMediators.clone();
    }

    public void addLicense(License license) {
        this.licenses.add(license);
    }

    @Override
    public License[] getLicenses() {
        return this.licenses.toArray(new License[this.licenses.size()]);
    }

    @Override
    public String getHomePage() {
        return this.homePage;
    }

    public void setHomePage(String string) {
        this.homePage = string;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long l) {
        this.lastModified = l;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public boolean isNamespaceUseful() {
        for (DependencyDescriptor dependencyDescriptor : this.dependencies) {
            if (dependencyDescriptor.getAllExcludeRules().length <= 0) continue;
            return true;
        }
        return false;
    }

    public void setNamespace(Namespace namespace) {
        this.namespace = namespace;
    }

    public void check() {
        Stack<String> stack = new Stack<String>();
        for (Configuration configuration : this.configurations.values()) {
            String[] stringArray = configuration.getExtends();
            for (int i = 0; i < stringArray.length; ++i) {
                stack.push(configuration.getName());
                this.checkConf(stack, stringArray[i].trim());
                stack.pop();
            }
        }
    }

    private void checkConf(Stack stack, String string) {
        int n = stack.indexOf(string);
        if (n != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            while (n < stack.size()) {
                stringBuffer.append(stack.get(n)).append(" => ");
                ++n;
            }
            stringBuffer.append(string);
            throw new IllegalStateException("illegal cycle detected in configuration extension: " + stringBuffer);
        }
        Configuration configuration = this.getConfiguration(string);
        if (configuration == null) {
            throw new IllegalStateException("unknown configuration '" + string + "'. It is extended by " + stack.get(stack.size() - 1));
        }
        String[] stringArray = configuration.getExtends();
        for (int i = 0; i < stringArray.length; ++i) {
            stack.push(configuration.getName());
            this.checkConf(stack, stringArray[i].trim());
            stack.pop();
        }
    }

    public String getDefaultConf() {
        return this.defaultConf;
    }

    public void setDefaultConf(String string) {
        this.defaultConf = string;
    }

    public String getDefaultConfMapping() {
        return this.defaultConfMapping;
    }

    public void setDefaultConfMapping(String string) {
        this.defaultConfMapping = string;
    }

    public void setMappingOverride(boolean bl) {
        this.mappingOverride = bl;
    }

    public boolean isMappingOverride() {
        return this.mappingOverride;
    }

    @Override
    public String getAttribute(String string) {
        return this.resolvedRevId.getAttribute(string);
    }

    @Override
    public Map getAttributes() {
        return this.resolvedRevId.getAttributes();
    }

    @Override
    public String getExtraAttribute(String string) {
        return this.resolvedRevId.getExtraAttribute(string);
    }

    @Override
    public Map getExtraAttributes() {
        return this.resolvedRevId.getExtraAttributes();
    }

    @Override
    public Map getQualifiedExtraAttributes() {
        return this.resolvedRevId.getQualifiedExtraAttributes();
    }

    @Override
    public ModuleDescriptorParser getParser() {
        return this.parser;
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    public void addExcludeRule(ExcludeRule excludeRule) {
        this.excludeRules.add(excludeRule);
    }

    @Override
    public boolean canExclude() {
        return !this.excludeRules.isEmpty();
    }

    @Override
    public boolean doesExclude(String[] stringArray, ArtifactId artifactId) {
        if (this.namespace != null) {
            artifactId = NameSpaceHelper.transform(artifactId, this.namespace.getFromSystemTransformer());
        }
        ExcludeRule[] excludeRuleArray = this.getExcludeRules(stringArray);
        for (int i = 0; i < excludeRuleArray.length; ++i) {
            if (!MatcherHelper.matches(excludeRuleArray[i].getMatcher(), excludeRuleArray[i].getId(), artifactId)) continue;
            return true;
        }
        return false;
    }

    @Override
    public ExcludeRule[] getAllExcludeRules() {
        return this.excludeRules.toArray(new ExcludeRule[this.excludeRules.size()]);
    }

    public ExcludeRule[] getExcludeRules(String[] stringArray) {
        LinkedHashSet<ExcludeRule> linkedHashSet = new LinkedHashSet<ExcludeRule>();
        for (ExcludeRule excludeRule : this.excludeRules) {
            String[] stringArray2 = excludeRule.getConfigurations();
            if (!this.containsAny(stringArray2, stringArray)) continue;
            linkedHashSet.add(excludeRule);
        }
        return linkedHashSet.toArray(new ExcludeRule[linkedHashSet.size()]);
    }

    private boolean containsAny(String[] stringArray, String[] stringArray2) {
        return new ArrayList<String>(Arrays.asList(stringArray)).removeAll(Arrays.asList(stringArray2));
    }

    @Override
    public Map getExtraAttributesNamespaces() {
        return this.extraAttributesNamespaces;
    }

    public void addExtraAttributeNamespace(String string, String string2) {
        this.extraAttributesNamespaces.put(string, string2);
    }

    public void addExtraInfo(String string, String string2) {
        this.extraInfo.put(string, string2);
    }

    @Override
    public Map getExtraInfo() {
        return this.extraInfo;
    }

    @Override
    public List<ExtraInfoHolder> getExtraInfos() {
        return this.extraInfos;
    }

    public void addExtraInfo(ExtraInfoHolder extraInfoHolder) {
        this.extraInfos.add(extraInfoHolder);
    }
}

