/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.install;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.install.InstallEngineSettings;
import org.apache.ivy.core.install.InstallOptions;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveEngine;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.search.SearchEngine;
import org.apache.ivy.plugins.conflict.NoConflictManager;
import org.apache.ivy.plugins.matcher.ExactPatternMatcher;
import org.apache.ivy.plugins.matcher.MatcherHelper;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.util.Message;

public class InstallEngine {
    private InstallEngineSettings settings;
    private ResolveEngine resolveEngine;
    private SearchEngine searchEngine;

    public InstallEngine(InstallEngineSettings installEngineSettings, SearchEngine searchEngine, ResolveEngine resolveEngine) {
        this.settings = installEngineSettings;
        this.searchEngine = searchEngine;
        this.resolveEngine = resolveEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolveReport install(ModuleRevisionId moduleRevisionId, String string, String string2, InstallOptions installOptions) throws IOException {
        DependencyResolver dependencyResolver = this.settings.getResolver(string);
        DependencyResolver dependencyResolver2 = this.settings.getResolver(string2);
        if (dependencyResolver == null) {
            throw new IllegalArgumentException("unknown resolver " + string + ". Available resolvers are: " + this.settings.getResolverNames());
        }
        if (dependencyResolver2 == null) {
            throw new IllegalArgumentException("unknown resolver " + string2 + ". Available resolvers are: " + this.settings.getResolverNames());
        }
        PatternMatcher patternMatcher = this.settings.getMatcher(installOptions.getMatcherName());
        if (patternMatcher == null) {
            throw new IllegalArgumentException("unknown matcher " + installOptions.getMatcherName() + ". Available matchers are: " + this.settings.getMatcherNames());
        }
        Message.info(":: installing " + moduleRevisionId + " ::");
        DependencyResolver dependencyResolver3 = this.resolveEngine.getDictatorResolver();
        boolean bl = this.settings.logNotConvertedExclusionRule();
        try {
            Object object;
            Object object2;
            this.settings.setLogNotConvertedExclusionRule(true);
            this.resolveEngine.setDictatorResolver(dependencyResolver);
            DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(ModuleRevisionId.newInstance("apache", "ivy-install", "1.0"), this.settings.getStatusManager().getDefaultStatus(), new Date());
            String string3 = ResolveOptions.getDefaultResolveId(defaultModuleDescriptor);
            defaultModuleDescriptor.addConfiguration(new Configuration("default"));
            defaultModuleDescriptor.addConflictManager(new ModuleId("*", "*"), ExactPatternMatcher.INSTANCE, new NoConflictManager());
            for (int i = 0; i < installOptions.getConfs().length; ++i) {
                object2 = installOptions.getConfs();
                for (int j = 0; j < ((String[])object2).length; ++j) {
                    String string4 = object2[j].trim();
                    if (MatcherHelper.isExact(patternMatcher, moduleRevisionId)) {
                        object = new DefaultDependencyDescriptor(defaultModuleDescriptor, moduleRevisionId, false, false, installOptions.isTransitive());
                        ((DefaultDependencyDescriptor)object).addDependencyConfiguration("default", string4);
                        defaultModuleDescriptor.addDependency((DependencyDescriptor)object);
                        continue;
                    }
                    object = this.searchEngine.listModules(dependencyResolver, moduleRevisionId, patternMatcher);
                    for (int k = 0; k < ((ModuleRevisionId[])object).length; ++k) {
                        Message.info("\tfound " + object[k] + " to install: adding to the list");
                        DefaultDependencyDescriptor defaultDependencyDescriptor = new DefaultDependencyDescriptor(defaultModuleDescriptor, (ModuleRevisionId)object[k], false, false, installOptions.isTransitive());
                        defaultDependencyDescriptor.addDependencyConfiguration("default", string4);
                        defaultModuleDescriptor.addDependency(defaultDependencyDescriptor);
                    }
                }
            }
            ResolveReport resolveReport = new ResolveReport(defaultModuleDescriptor, string3);
            Message.info(":: resolving dependencies ::");
            object2 = new ResolveOptions().setResolveId(string3).setConfs(new String[]{"default"}).setValidate(installOptions.isValidate());
            IvyNode[] ivyNodeArray = this.resolveEngine.getDependencies(defaultModuleDescriptor, (ResolveOptions)object2, resolveReport);
            resolveReport.setDependencies(Arrays.asList(ivyNodeArray), installOptions.getArtifactFilter());
            Message.info(":: downloading artifacts to cache ::");
            this.resolveEngine.downloadArtifacts(resolveReport, installOptions.getArtifactFilter(), new DownloadOptions());
            Message.info(":: installing in " + string2 + " ::");
            for (int i = 0; i < ivyNodeArray.length; ++i) {
                object = ivyNodeArray[i].getDescriptor();
                if (object == null) continue;
                ModuleRevisionId moduleRevisionId2 = object.getModuleRevisionId();
                Message.verbose("installing " + moduleRevisionId2);
                boolean bl2 = false;
                try {
                    dependencyResolver2.beginPublishTransaction(moduleRevisionId2, installOptions.isOverwrite());
                    ArtifactDownloadReport[] artifactDownloadReportArray = resolveReport.getArtifactsReports(moduleRevisionId2);
                    for (int j = 0; j < artifactDownloadReportArray.length; ++j) {
                        if (artifactDownloadReportArray[j].getLocalFile() == null) continue;
                        dependencyResolver2.publish(artifactDownloadReportArray[j].getArtifact(), artifactDownloadReportArray[j].getLocalFile(), installOptions.isOverwrite());
                    }
                    MetadataArtifactDownloadReport metadataArtifactDownloadReport = ivyNodeArray[i].getModuleRevision().getReport();
                    File file = metadataArtifactDownloadReport.getLocalFile();
                    dependencyResolver2.publish(object.getMetadataArtifact(), file, installOptions.isOverwrite());
                    if (installOptions.isInstallOriginalMetadata() && metadataArtifactDownloadReport.getArtifactOrigin() != null && metadataArtifactDownloadReport.getArtifactOrigin().isExists() && !ArtifactOrigin.isUnknown(metadataArtifactDownloadReport.getArtifactOrigin()) && metadataArtifactDownloadReport.getArtifactOrigin().getArtifact() != null && metadataArtifactDownloadReport.getArtifactOrigin().getArtifact().getType().endsWith(".original") && !metadataArtifactDownloadReport.getArtifactOrigin().getArtifact().getType().equals(object.getMetadataArtifact().getType() + ".original")) {
                        dependencyResolver2.publish(metadataArtifactDownloadReport.getArtifactOrigin().getArtifact(), metadataArtifactDownloadReport.getOriginalLocalFile(), installOptions.isOverwrite());
                    }
                    dependencyResolver2.commitPublishTransaction();
                    bl2 = true;
                    continue;
                }
                finally {
                    if (!bl2) {
                        dependencyResolver2.abortPublishTransaction();
                    }
                }
            }
            Message.info(":: install resolution report ::");
            this.resolveEngine.outputReport(resolveReport, this.settings.getResolutionCacheManager(), (ResolveOptions)object2);
            ResolveReport resolveReport2 = resolveReport;
            return resolveReport2;
        }
        finally {
            Message.sumupProblems();
            this.resolveEngine.setDictatorResolver(dependencyResolver3);
            this.settings.setLogNotConvertedExclusionRule(bl);
        }
    }
}

