/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.cache;

import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.util.Checks;

public class ArtifactOrigin {
    private static final String UNKNOWN = "UNKNOWN";
    private static final int MAGIC_HASH_VALUE = 31;
    private boolean isLocal;
    private String location;
    private Artifact artifact;
    private Long lastChecked;
    private boolean exists = true;

    public static final ArtifactOrigin unkwnown(Artifact artifact) {
        return new ArtifactOrigin(artifact, false, UNKNOWN);
    }

    public static final boolean isUnknown(ArtifactOrigin artifactOrigin) {
        return artifactOrigin == null || UNKNOWN.equals(artifactOrigin.getLocation());
    }

    public static final boolean isUnknown(String string) {
        return string == null || UNKNOWN.equals(string);
    }

    public ArtifactOrigin(Artifact artifact, boolean bl, String string) {
        Checks.checkNotNull(artifact, "artifact");
        Checks.checkNotNull(string, "location");
        this.artifact = artifact;
        this.isLocal = bl;
        this.location = string;
    }

    public boolean isLocal() {
        return this.isLocal;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String string) {
        this.location = string;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Long getLastChecked() {
        return this.lastChecked;
    }

    public void setLastChecked(Long l) {
        this.lastChecked = l;
    }

    public boolean isExists() {
        return this.exists;
    }

    public void setExist(boolean bl) {
        this.exists = bl;
    }

    public String toString() {
        return "ArtifactOrigin { isLocal=" + this.isLocal + ", location=" + this.location + ", lastChecked=" + this.lastChecked + ", exists=" + this.exists + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ArtifactOrigin artifactOrigin = (ArtifactOrigin)object;
        if (this.isLocal != artifactOrigin.isLocal) {
            return false;
        }
        if (!this.location.equals(artifactOrigin.location)) {
            return false;
        }
        if (this.lastChecked == null ? artifactOrigin.lastChecked != null : !this.lastChecked.equals(artifactOrigin.lastChecked)) {
            return false;
        }
        return this.exists == artifactOrigin.exists;
    }

    public int hashCode() {
        int n = this.isLocal ? 1 : 0;
        n = 31 * n + this.location.hashCode();
        n = 31 * n + (this.lastChecked == null ? 0 : this.lastChecked.hashCode());
        n = 31 * n + (this.exists ? 1 : 0);
        return n;
    }
}

