/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.util.Date;
import java.util.Locale;
import org.apache.ivy.Ivy;
import org.apache.ivy.ant.AntMessageLogger;
import org.apache.ivy.ant.IvyAntSettings;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.DateUtil;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.StringUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectComponent;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Reference;

public abstract class IvyTask
extends Task {
    public static final String ANT_PROJECT_CONTEXT_KEY = "ant-project";
    private Boolean validate = null;
    private Reference antIvyEngineRef = null;

    protected boolean doValidate(IvySettings ivySettings) {
        if (this.validate != null) {
            return this.validate;
        }
        return ivySettings.doValidate();
    }

    public boolean isValidate() {
        return this.validate == null ? true : this.validate;
    }

    public void setValidate(boolean bl) {
        this.validate = bl;
    }

    public void setSettingsRef(Reference reference) {
        this.antIvyEngineRef = reference;
    }

    public Reference getSettingsRef() {
        return this.antIvyEngineRef;
    }

    protected IvySettings getSettings() {
        return this.getIvyInstance().getSettings();
    }

    protected Ivy getIvyInstance() {
        Object object;
        if (this.antIvyEngineRef != null) {
            object = this.antIvyEngineRef.getReferencedObject(this.getProject());
            if (!object.getClass().getName().equals(IvyAntSettings.class.getName())) {
                throw new BuildException(this.antIvyEngineRef.getRefId() + " doesn't reference an ivy:settings", this.getLocation());
            }
            if (!(object instanceof IvyAntSettings)) {
                throw new BuildException(this.antIvyEngineRef.getRefId() + " has been defined in a different classloader.  " + "Please use the same loader when defining your task, or " + "redeclare your ivy:settings in this classloader", this.getLocation());
            }
        } else {
            object = IvyAntSettings.getDefaultInstance(this);
        }
        Ivy ivy = ((IvyAntSettings)((Object)object)).getConfiguredIvyInstance(this);
        AntMessageLogger.register((ProjectComponent)this, ivy);
        return ivy;
    }

    protected void setResolved(ResolveReport resolveReport, boolean bl) {
        ModuleDescriptor moduleDescriptor = resolveReport.getModuleDescriptor();
        String[] stringArray = resolveReport.getConfigurations();
        if (bl) {
            this.getProject().addReference("ivy.resolved.report", (Object)resolveReport);
            this.getProject().addReference("ivy.resolved.configurations.ref", (Object)stringArray);
            this.getProject().addReference("ivy.resolved.descriptor", (Object)moduleDescriptor);
        }
        String string = moduleDescriptor.getModuleRevisionId().getModuleId().getOrganisation() + "." + moduleDescriptor.getModuleRevisionId().getModuleId().getName();
        this.getProject().addReference("ivy.resolved.report." + string, (Object)resolveReport);
        this.getProject().addReference("ivy.resolved.descriptor." + string, (Object)moduleDescriptor);
        this.getProject().addReference("ivy.resolved.configurations.ref." + string, (Object)stringArray);
    }

    protected void setResolved(ResolveReport resolveReport, String string, boolean bl) {
        this.setResolved(resolveReport, bl);
        if (string != null) {
            ModuleDescriptor moduleDescriptor = resolveReport.getModuleDescriptor();
            String[] stringArray = resolveReport.getConfigurations();
            this.getProject().addReference("ivy.resolved.report." + string, (Object)resolveReport);
            this.getProject().addReference("ivy.resolved.descriptor." + string, (Object)moduleDescriptor);
            this.getProject().addReference("ivy.resolved.configurations.ref." + string, (Object)stringArray);
        }
    }

    protected String[] getResolvedConfigurations(String string, String string2, boolean bl) {
        return (String[])this.getReference("ivy.resolved.configurations.ref", string, string2, bl);
    }

    protected Object getResolvedDescriptor(String string) {
        return this.getResolvedDescriptor(string, true);
    }

    protected Object getResolvedDescriptor(String string, boolean bl) {
        Object object = this.getProject().getReference("ivy.resolved.descriptor." + string);
        if (bl && object == null) {
            throw new BuildException("ModuleDescriptor for resolve with id '" + string + "' not found.");
        }
        return object;
    }

    protected Object getResolvedDescriptor(String string, String string2) {
        return this.getResolvedDescriptor(string, string2, false);
    }

    protected Object getResolvedDescriptor(String string, String string2, boolean bl) {
        return this.getReference("ivy.resolved.descriptor", string, string2, bl);
    }

    private Object getReference(String string, String string2, String string3, boolean bl) {
        Object object = null;
        if (string2 != null && string3 != null) {
            object = this.getProject().getReference(string + "." + string2 + "." + string3);
        }
        if (!bl && object == null) {
            object = this.getProject().getReference(string);
        }
        return object;
    }

    protected ResolveReport getResolvedReport(String string, String string2, String string3) {
        ResolveReport resolveReport = null;
        resolveReport = string3 == null ? (ResolveReport)this.getReference("ivy.resolved.report", string, string2, false) : (ResolveReport)this.getReference("ivy.resolved.report." + string3, null, null, false);
        return resolveReport;
    }

    protected String[] splitConfs(String string) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(",");
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringArray[i].trim();
        }
        return stringArray;
    }

    protected String mergeConfs(String[] stringArray) {
        return StringUtils.join(stringArray, ", ");
    }

    protected static Date getPubDate(String string, Date date) {
        if (string != null) {
            if ("now".equals(string.toLowerCase(Locale.US))) {
                return new Date();
            }
            try {
                return DateUtil.parse(string);
            }
            catch (Exception exception) {
                throw new BuildException("Publication date provided in bad format. Should be 'yyyyMMddHHmmss' and not '" + string + "'!");
            }
        }
        return date;
    }

    protected String getProperty(String string, IvySettings ivySettings, String string2) {
        if (string == null) {
            return this.getProperty(ivySettings, string2);
        }
        string = ivySettings.substitute(string);
        Message.debug("parameter found as attribute value: " + string2 + "=" + string);
        return string;
    }

    protected String getProperty(String string, IvySettings ivySettings, String string2, String string3) {
        if (string3 == null) {
            return this.getProperty(string, ivySettings, string2);
        }
        return this.getProperty(string, ivySettings, string2 + "." + string3);
    }

    protected String getProperty(IvySettings ivySettings, String string, String string2) {
        if (string2 == null) {
            return this.getProperty(ivySettings, string);
        }
        return this.getProperty(ivySettings, string + "." + string2);
    }

    protected String getProperty(IvySettings ivySettings, String string) {
        String string2 = ivySettings.getVariable(string);
        if (string2 == null) {
            string2 = ivySettings.substitute(this.getProject().getProperty(string));
            if (string2 != null) {
                Message.debug("parameter found as ant project property: " + string + "=" + string2);
            } else {
                Message.debug("parameter not found: " + string);
            }
        } else {
            string2 = ivySettings.substitute(string2);
            Message.debug("parameter found as ivy variable: " + string + "=" + string2);
        }
        return string2;
    }

    protected void prepareTask() {
        this.getProject().setProperty("ivy.version", Ivy.getIvyVersion());
        IvyContext.pushNewCopyContext();
        IvyContext.getContext().setIvy(this.getIvyInstance());
        IvyContext.getContext().push(ANT_PROJECT_CONTEXT_KEY, this.getProject());
    }

    protected void finalizeTask() {
        if (!IvyContext.getContext().pop(ANT_PROJECT_CONTEXT_KEY, this.getProject())) {
            Message.error("ANT project poped from stack not equals current !. Ignoring");
        }
        IvyContext.popContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute() throws BuildException {
        try {
            this.prepareTask();
            this.doExecute();
        }
        finally {
            this.finalizeTask();
        }
    }

    public abstract void doExecute() throws BuildException;

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + ":" + this.getTaskName();
    }

    protected void cacheAttributeNotSupported() {
        throw new BuildException("cache attribute is not supported any more. See IVY-685 for details.");
    }
}

