/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.ant.MapperAdapter;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.retrieve.RetrieveReport;
import org.apache.ivy.util.filter.Filter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Mapper;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.util.FileNameMapper;

public class IvyRetrieve
extends IvyPostResolveTask {
    private static final Collection OVERWRITEMODE_VALUES = Arrays.asList("always", "never", "newer", "different");
    private String pattern;
    private String ivypattern = null;
    private boolean sync = false;
    private boolean symlink = false;
    private boolean symlinkmass = false;
    private String overwriteMode = "newer";
    private String pathId = null;
    private String setId = null;
    private Mapper mapper = null;

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String string) {
        this.pattern = string;
    }

    public String getPathId() {
        return this.pathId;
    }

    public void setPathId(String string) {
        this.pathId = string;
    }

    public String getSetId() {
        return this.setId;
    }

    public void setSetId(String string) {
        this.setId = string;
    }

    @Override
    public void doExecute() throws BuildException {
        this.prepareAndCheck();
        if (!this.getAllowedLogOptions().contains(this.getLog())) {
            throw new BuildException("invalid option for 'log': " + this.getLog() + ". Available options are " + this.getAllowedLogOptions());
        }
        this.pattern = this.getProperty(this.pattern, this.getSettings(), "ivy.retrieve.pattern");
        try {
            Iterator iterator;
            Path path;
            Filter filter = this.getArtifactFilter();
            RetrieveReport retrieveReport = this.getIvyInstance().retrieve(this.getResolvedMrid(), ((RetrieveOptions)new RetrieveOptions().setLog(this.getLog())).setConfs(this.splitConfs(this.getConf())).setDestArtifactPattern(this.pattern).setDestIvyPattern(this.ivypattern).setArtifactFilter(filter).setSync(this.sync).setOverwriteMode(this.getOverwriteMode()).setUseOrigin(this.isUseOrigin()).setMakeSymlinks(this.symlink).setMakeSymlinksInMass(this.symlinkmass).setResolveId(this.getResolveId()).setMapper(this.mapper == null ? null : new MapperAdapter(this.mapper)));
            int n = retrieveReport.getNbrArtifactsCopied();
            boolean bl = n > 0;
            this.getProject().setProperty("ivy.nb.targets.copied", String.valueOf(n));
            this.getProject().setProperty("ivy.targets.copied", String.valueOf(bl));
            if (this.getPathId() != null) {
                path = new Path(this.getProject());
                this.getProject().addReference(this.getPathId(), (Object)path);
                iterator = retrieveReport.getRetrievedFiles().iterator();
                while (iterator.hasNext()) {
                    path.createPathElement().setLocation((File)iterator.next());
                }
            }
            if (this.getSetId() != null) {
                path = new FileSet();
                path.setProject(this.getProject());
                this.getProject().addReference(this.getSetId(), (Object)path);
                path.setDir(retrieveReport.getRetrieveRoot());
                iterator = retrieveReport.getRetrievedFiles().iterator();
                while (iterator.hasNext()) {
                    PatternSet.NameEntry nameEntry = path.createInclude();
                    nameEntry.setName(this.getPath(retrieveReport.getRetrieveRoot(), (File)iterator.next()));
                }
            }
        }
        catch (Exception exception) {
            throw new BuildException("impossible to ivy retrieve: " + exception, (Throwable)exception);
        }
    }

    protected Collection getAllowedLogOptions() {
        return Arrays.asList("default", "download-only", "quiet");
    }

    public String getIvypattern() {
        return this.ivypattern;
    }

    public void setIvypattern(String string) {
        this.ivypattern = string;
    }

    public boolean isSync() {
        return this.sync;
    }

    public void setSync(boolean bl) {
        this.sync = bl;
    }

    public void setSymlink(boolean bl) {
        this.symlink = bl;
    }

    public void setSymlinkmass(boolean bl) {
        this.symlinkmass = bl;
    }

    public void setOverwriteMode(String string) {
        if (!OVERWRITEMODE_VALUES.contains(string)) {
            throw new IllegalArgumentException("invalid overwriteMode value '" + string + "'. " + "Valid values are " + OVERWRITEMODE_VALUES);
        }
        this.overwriteMode = string;
    }

    public String getOverwriteMode() {
        return this.overwriteMode;
    }

    public void addMapper(Mapper mapper) {
        if (this.mapper != null) {
            throw new IllegalArgumentException("Cannot define more than one mapper");
        }
        this.mapper = mapper;
    }

    public void add(FileNameMapper fileNameMapper) {
        Mapper mapper = new Mapper(this.getProject());
        mapper.add(fileNameMapper);
        this.addMapper(mapper);
    }

    private String getPath(File file, File file2) {
        String string = file.getAbsolutePath();
        int n = string.length();
        if (!string.endsWith(File.separator)) {
            ++n;
        }
        return file2.getAbsolutePath().substring(n);
    }
}

