/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.ant;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.ivy.ant.IvyPostResolveTask;
import org.apache.ivy.core.module.descriptor.Configuration;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.tools.ant.BuildException;

public class IvyDependencyUpdateChecker
extends IvyPostResolveTask {
    private String revisionToCheck = "latest.integration";
    private boolean download = false;
    private boolean checkIfChanged = false;
    private boolean showTransitive = false;

    @Override
    public void doExecute() throws BuildException {
        Object object;
        int n;
        this.prepareAndCheck();
        ModuleDescriptor moduleDescriptor = this.getResolvedReport().getModuleDescriptor();
        DefaultModuleDescriptor defaultModuleDescriptor = new DefaultModuleDescriptor(moduleDescriptor.getModuleRevisionId(), moduleDescriptor.getStatus(), moduleDescriptor.getPublicationDate());
        for (n = 0; n < moduleDescriptor.getConfigurations().length; ++n) {
            object = moduleDescriptor.getConfigurations()[n];
            defaultModuleDescriptor.addConfiguration((Configuration)object);
        }
        for (n = 0; n < moduleDescriptor.getDependencies().length; ++n) {
            object = moduleDescriptor.getDependencies()[n];
            ModuleRevisionId moduleRevisionId = ModuleRevisionId.newInstance(object.getDependencyRevisionId(), this.revisionToCheck);
            defaultModuleDescriptor.addDependency(object.clone(moduleRevisionId));
        }
        ResolveOptions resolveOptions = new ResolveOptions();
        resolveOptions.setDownload(this.isDownload());
        resolveOptions.setLog(this.getLog());
        resolveOptions.setConfs(this.splitConfs(this.getConf()));
        resolveOptions.setCheckIfChanged(this.checkIfChanged);
        try {
            object = this.getIvyInstance().getResolveEngine().resolve(defaultModuleDescriptor, resolveOptions);
            this.displayDependencyUpdates(this.getResolvedReport(), (ResolveReport)object);
            if (this.showTransitive) {
                this.displayNewDependencyOnLatest(this.getResolvedReport(), (ResolveReport)object);
                this.displayMissingDependencyOnLatest(this.getResolvedReport(), (ResolveReport)object);
            }
        }
        catch (ParseException parseException) {
            throw new BuildException("impossible to resolve dependencies:\n\t" + parseException, (Throwable)parseException);
        }
        catch (IOException iOException) {
            throw new BuildException("impossible to resolve dependencies:\n\t" + iOException, (Throwable)iOException);
        }
    }

    private void displayDependencyUpdates(ResolveReport resolveReport, ResolveReport resolveReport2) {
        this.log("Dependencies updates available :");
        boolean bl = false;
        for (IvyNode ivyNode : resolveReport2.getDependencies()) {
            for (IvyNode ivyNode2 : resolveReport.getDependencies()) {
                boolean bl2;
                if (!ivyNode2.getModuleId().equals(ivyNode.getModuleId()) || ivyNode2.getResolvedId().getRevision().equals(ivyNode.getResolvedId().getRevision())) continue;
                boolean bl3 = bl2 = ivyNode.getDependencyDescriptor(ivyNode.getRoot()) == null;
                if (bl2 && (!bl2 || !this.showTransitive)) continue;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("\t").append(ivyNode2.getResolvedId().getOrganisation()).append('#').append(ivyNode2.getResolvedId().getName()).append(bl2 ? " (transitive)" : "").append("\t").append(ivyNode2.getResolvedId().getRevision()).append(" -> ").append(ivyNode.getResolvedId().getRevision());
                this.log(stringBuffer.toString());
                bl = true;
            }
        }
        if (!bl) {
            this.log("\tAll dependencies are up to date");
        }
    }

    private void displayMissingDependencyOnLatest(ResolveReport resolveReport, ResolveReport resolveReport2) {
        ArrayList<ModuleRevisionId> arrayList = new ArrayList<ModuleRevisionId>();
        for (IvyNode object : resolveReport.getDependencies()) {
            boolean bl = false;
            for (IvyNode ivyNode : resolveReport2.getDependencies()) {
                if (!object.getModuleId().equals(ivyNode.getModuleId())) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(object.getId());
        }
        if (arrayList.size() > 0) {
            this.log("List of missing dependency on latest resolve :");
            for (ModuleRevisionId moduleRevisionId : arrayList) {
                this.log("\t" + moduleRevisionId.toString());
            }
        }
    }

    private void displayNewDependencyOnLatest(ResolveReport resolveReport, ResolveReport resolveReport2) {
        ArrayList<ModuleRevisionId> arrayList = new ArrayList<ModuleRevisionId>();
        for (IvyNode object : resolveReport2.getDependencies()) {
            boolean bl = false;
            for (IvyNode ivyNode : resolveReport.getDependencies()) {
                if (!ivyNode.getModuleId().equals(object.getModuleId())) continue;
                bl = true;
            }
            if (bl) continue;
            arrayList.add(object.getId());
        }
        if (arrayList.size() > 0) {
            this.log("List of new dependency on latest resolve :");
            for (ModuleRevisionId moduleRevisionId : arrayList) {
                this.log("\t" + moduleRevisionId.toString());
            }
        }
    }

    public String getRevisionToCheck() {
        return this.revisionToCheck;
    }

    public void setRevisionToCheck(String string) {
        this.revisionToCheck = string;
    }

    public boolean isDownload() {
        return this.download;
    }

    public void setDownload(boolean bl) {
        this.download = bl;
    }

    public boolean isShowTransitive() {
        return this.showTransitive;
    }

    public void setShowTransitive(boolean bl) {
        this.showTransitive = bl;
    }
}

